/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateReplenishTSMView
extends SvrProcess {
    private int p_M_Warehouse_ID = 0;
    private int p_BPartner_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_BPartner_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String sqlDet = "SELECT M_Product_ID,C_BPartner_ID, qtytoorder,M_Warehouse_ID FROM RVOFB_ReplenishOFB  WHERE  AD_Client_ID = " + Env.getAD_Client_ID((Properties)this.getCtx()) + " ";
        if (this.p_BPartner_ID > 0) {
            sqlDet = String.valueOf(sqlDet) + " AND C_BPartner_ID = " + this.p_BPartner_ID;
        }
        if (this.p_M_Warehouse_ID > 0) {
            sqlDet = String.valueOf(sqlDet) + " AND M_Warehouse_ID = " + this.p_M_Warehouse_ID;
        }
        sqlDet = String.valueOf(sqlDet) + " Order By M_Warehouse_ID Desc ";
        CPreparedStatement pstmt = null;
        int cant = 0;
        try {
            pstmt = DB.prepareStatement((String)sqlDet, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int weareHouse_ID = 0;
            int LastWH = 0;
            MRequisition req = null;
            while (rs.next()) {
                weareHouse_ID = rs.getInt("M_Warehouse_ID");
                if (weareHouse_ID != LastWH) {
                    req = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                    req.setAD_Org_ID(Env.getAD_Org_ID((Properties)this.getCtx()));
                    req.setC_DocType_ID(1000018);
                    req.setAD_User_ID(Env.getAD_User_ID((Properties)this.getCtx()));
                    req.setDescription("Reabastecimiento Automatico");
                    req.setPriorityRule("5");
                    Calendar calendar = Calendar.getInstance();
                    Timestamp actual = new Timestamp(calendar.getTime().getTime());
                    req.setDateRequired(actual);
                    req.setDateDoc(actual);
                    req.setM_Warehouse_ID(rs.getInt("M_Warehouse_ID"));
                    req.setM_PriceList_ID(1000001);
                    req.save();
                    req.setDocStatus("IP");
                    ++cant;
                }
                MRequisitionLine line = new MRequisitionLine(req);
                line.setM_Product_ID(rs.getInt("M_Product_ID"));
                if (rs.getInt("C_BPartner_ID") > 0) {
                    line.setC_BPartner_ID(rs.getInt("C_BPartner_ID"));
                }
                line.setQty(rs.getBigDecimal("qtytoorder"));
                line.setPrice();
                line.save();
                LastWH = req.getM_Warehouse_ID();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return "Se han generado " + cant + " Solicitudes";
    }
}

