/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.X_TP_Refund;
import org.compiere.model.X_TP_RefundHeader;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateJournalRefund
extends SvrProcess {
    private int p_HR_Viatico_ID = 0;

    protected void prepare() {
        this.p_HR_Viatico_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_HR_Viatico_ID > 0) {
            X_TP_RefundHeader rHead = new X_TP_RefundHeader(this.getCtx(), this.p_HR_Viatico_ID, this.get_TrxName());
            MJournalBatch batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
            batch.setAD_Org_ID(rHead.getAD_Org_ID());
            batch.setDescription("VIATICOS AUTOMATICO " + rHead.getDocumentDate() + " a " + rHead.getDateEnd());
            batch.setPostingType("A");
            batch.setC_DocType_ID(MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"GLJ")[0].getC_DocType_ID());
            batch.setGL_Category_ID(MGLCategory.getDefault((Properties)this.getCtx(), (String)"M").getGL_Category_ID());
            batch.setDateAcct(new Timestamp(System.currentTimeMillis()));
            batch.setDateDoc(new Timestamp(System.currentTimeMillis()));
            batch.setC_Period_ID(MPeriod.getC_Period_ID(this.getCtx(), new Timestamp(System.currentTimeMillis()), rHead.getAD_Org_ID()));
            MClient client = MClient.get((Properties)this.getCtx(), (int)rHead.getAD_Client_ID());
            batch.setC_Currency_ID(client.getC_Currency_ID());
            batch.set_CustomColumn("TP_RefundHeader_ID", (Object)rHead.get_ID());
            if (batch.save(this.get_TrxName())) {
                rHead.set_CustomColumn("GL_JournalBatch_ID", batch.get_ID());
                rHead.save(this.get_TrxName());
            }
            int ID_Credito = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT tp_refundCredit_Acct FROM C_AcctSchema_Default WHERE C_AcctSchema_ID = 1000000");
            String sql = "SELECT TP_Refund_ID FROM TP_Refund WHERE TP_RefundHeader_ID = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, rHead.get_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal amtRefund;
                        X_TP_Refund refund = new X_TP_Refund(this.getCtx(), rs.getInt("TP_Refund_ID"), this.get_TrxName());
                        MJournal journal = new MJournal(batch);
                        journal.setDescription("VIATICO DE " + refund.getC_BPartner().getName().toUpperCase());
                        journal.setC_AcctSchema_ID(MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)Env.getAD_Client_ID((Properties)this.getCtx()))[0].getC_AcctSchema_ID());
                        journal.setGL_Category_ID(MGLCategory.getDefault((Properties)this.getCtx(), (String)"D").getGL_Category_ID());
                        journal.setC_ConversionType_ID(114);
                        journal.set_CustomColumn("TP_Refund_ID", refund.get_ID());
                        if (journal.save(this.get_TrxName())) {
                            refund.set_CustomColumn("GL_Journal_ID", journal.get_ID());
                            refund.save(this.get_TrxName());
                        }
                        if ((amtRefund = DB.getSQLValueBD((String)this.get_TrxName(), (String)"SELECT SUM(amt) FROM TP_RefundLine WHERE TP_Refund_ID = ?", (int)refund.get_ID())) == null) {
                            amtRefund = Env.ZERO;
                        }
                        String nameAccount = "";
                        nameAccount = refund.getType().compareTo("01") == 0 ? "tp_refundn_acct" : "tp_refunds_acct";
                        int ID_Debito = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT " + nameAccount + " FROM C_BP_Employee_Acct WHERE  C_BPartner_ID = ?"), (int)refund.getC_BPartner_ID());
                        MJournalLine line1 = new MJournalLine(journal);
                        line1.set_CustomColumn("C_Bpartner_ID", refund.getC_BPartner_ID());
                        line1.setAmtSourceDr(amtRefund);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(amtRefund, Env.ZERO);
                        line1.setC_ValidCombination_ID(ID_Debito);
                        line1.save();
                        MJournalLine line2 = new MJournalLine(journal);
                        line2.set_CustomColumn("C_Bpartner_ID", refund.getC_BPartner_ID());
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(amtRefund);
                        line2.setAmtAcct(Env.ZERO, amtRefund);
                        line2.setC_ValidCombination_ID(ID_Credito);
                        line2.save();
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sql);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "Procesado ";
    }
}

