/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateCashJournalFF
extends SvrProcess {
    private Timestamp p_DateTrxFrom;
    private Timestamp p_DateTrxTo;
    private int p_Org_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_DateTrxFrom = (Timestamp)para[i].getParameter();
                    this.p_DateTrxTo = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int canthead;
        int cantLine;
        block8: {
            cantLine = 0;
            canthead = 0;
            String sqlHR = "SELECT pm.M_Movement_ID,pm.C_BPartner_ID,pm.movementdate,pm.AD_Org_ID, TP_TollSpendingManual  FROM M_Movement pm  WHERE pm.M_Movement_ID NOT IN (SELECT cLine.M_Movement_ID FROM C_CashLine cLine  INNER JOIN C_Cash c ON (c.C_Cash_ID = cLine.C_Cash_ID)  WHERE c.DocStatus IN ('CO','DR','IP') AND cLine.M_Movement_ID IS NOT NULL)  AND pm.AD_Client_ID = " + Env.getAD_Client_ID((Properties)this.getCtx()) + " AND COALESCE((select MAX(mml.tp_inicialhr) from m_movementline mml where mml.m_movement_id =  pm.M_Movement_ID), pm.MovementDate) BETWEEN ? AND ? " + " AND pm.DocStatus IN ('CO','CL','DR')";
            if (this.p_Org_ID > 0) {
                sqlHR = String.valueOf(sqlHR) + " AND pm.AD_Org_ID = " + this.p_Org_ID;
            }
            sqlHR = String.valueOf(sqlHR) + " ORDER BY C_BPartner_ID, pm.movementdate";
            Statement pstmtHR = null;
            ResultSet rsHR = null;
            try {
                try {
                    this.p_DateTrxTo.setHours(23);
                    this.p_DateTrxTo.setMinutes(59);
                    this.p_DateTrxTo.setSeconds(59);
                    pstmtHR = DB.prepareStatement((String)sqlHR, (String)this.get_TrxName());
                    pstmtHR.setTimestamp(1, this.p_DateTrxFrom);
                    pstmtHR.setTimestamp(2, this.p_DateTrxTo);
                    rsHR = pstmtHR.executeQuery();
                    int ID_BPartner = 0;
                    int ID_Org = 0;
                    while (rsHR.next()) {
                        int ID_CashBook;
                        ID_BPartner = rsHR.getInt("C_BPartner_ID");
                        ID_Org = rsHR.getInt("AD_Org_ID");
                        if (ID_BPartner <= 0 || ID_Org <= 0 || (ID_CashBook = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(C_CashBook_ID) FROM C_CashBook  WHERE IsActive = 'Y' AND TypeBook = 'FF' AND C_BPartner_ID = " + ID_BPartner))) <= 0) continue;
                        int ID_Cash = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COALESCE(MAX(C_Cash_ID),0) FROM C_Cash WHERE DocStatus IN ('DR')  AND C_CashBook_ID = " + ID_CashBook));
                        if (ID_Cash > 0) {
                            MCashLine cLine = new MCashLine(this.getCtx(), 0, this.get_TrxName());
                            cLine.setC_Cash_ID(ID_Cash);
                            cLine.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                            cLine.setDescription("generado automaticamente");
                            cLine.setCashType("R");
                            cLine.setAmount(rsHR.getBigDecimal("TP_TollSpendingManual"));
                            cLine.set_CustomColumn("M_Movement_ID", rsHR.getInt("M_Movement_ID"));
                            cLine.saveEx();
                            ++cantLine;
                            continue;
                        }
                        MCash cash = new MCash(new MCashBook(this.getCtx(), ID_CashBook, this.get_TrxName()), this.p_DateTrxTo);
                        cash.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                        cash.setName("Generado automaticamente. Fondo Fijo");
                        cash.saveEx();
                        ++canthead;
                        MCashLine cLine = new MCashLine(this.getCtx(), 0, this.get_TrxName());
                        cLine.setC_Cash_ID(cash.get_ID());
                        cLine.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                        cLine.setDescription("generado automaticamente");
                        cLine.setCashType("R");
                        cLine.setAmount(rsHR.getBigDecimal("TP_TollSpendingManual"));
                        cLine.set_CustomColumn("M_Movement_ID", rsHR.getInt("M_Movement_ID"));
                        cLine.saveEx();
                        ++cantLine;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, String.valueOf(e.getMessage()) + " SQL:" + sqlHR, (Throwable)e);
                    rsHR.close();
                    pstmtHR.close();
                    pstmtHR = null;
                    rsHR = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                rsHR.close();
                pstmtHR.close();
                pstmtHR = null;
                rsHR = null;
                throw throwable;
            }
            rsHR.close();
            pstmtHR.close();
            pstmtHR = null;
            rsHR = null;
        }
        return "Se han generado " + canthead + " diario de fondo fijo. Se han agregado " + cantLine + " lineas";
    }
}

