/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.MRole;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_TP_Refund;
import org.compiere.model.X_TP_RefundHeader;
import org.compiere.model.X_TP_RefundLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMRefund
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMRefund.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("TP_Refund", (ModelValidator)this);
        engine.addModelChange("TP_RefundHeader", (ModelValidator)this);
        engine.addModelChange("TP_RefundLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        X_TP_Refund refund;
        X_TP_RefundHeader head;
        X_TP_RefundLine rLine;
        BigDecimal amt;
        X_TP_RefundHeader refundHead;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 2 && po.get_Table_ID() == X_TP_RefundHeader.Table_ID && po.is_ValueChanged("DocStatus") && (refundHead = (X_TP_RefundHeader)po).getDocStatus().compareTo("CO") == 0 && !refundHead.get_ValueAsBoolean("IsSalary") && (amt = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amt) FROM TP_RefundLine rl INNER JOIN TP_Refund rf ON (rl.TP_Refund_ID = rf.TP_Refund_ID)  WHERE rl.IsActive = 'Y' AND rf.TP_RefundHeader_ID =" + refundHead.get_ID()), (Object[])new Object[0])) != null && amt.compareTo(Env.ZERO) > 0) {
            X_DM_Document doc = new X_DM_Document(po.getCtx(), 0, po.get_TrxName());
            doc.setAD_Org_ID(refundHead.getAD_Org_ID());
            doc.set_CustomColumn("C_BPartner_ID", refundHead.getC_BPartner_ID());
            doc.setAmt(amt);
            doc.setDescription("Generado desde viatico " + refundHead.getDocumentNo());
            String desc = DB.getSQLValueString((String)po.get_TrxName(), (String)("SELECT rlt.name FROM AD_Ref_List rl  INNER JOIN AD_Ref_List_Trl rlt ON (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID AND AD_Language='es_CL')  WHERE AD_Reference_ID=1000092 AND rl.VALUE = '" + refundHead.getType() + "'"), (Object[])new Object[0]);
            if (desc != null && desc.trim().length() > 3) {
                doc.setDescription("Tipo: " + desc);
            }
            doc.set_CustomColumn("TP_RefundHeader_ID", refundHead.get_ID());
            doc.setDateTrx(refundHead.getDateEnd());
            doc.setDocStatus("CO");
            doc.setProcessed(true);
            doc.saveEx();
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_TP_RefundLine.Table_ID) {
            Timestamp MinDate;
            Timestamp MaxDate;
            MMovement mov;
            rLine = (X_TP_RefundLine)po;
            head = new X_TP_RefundHeader(po.getCtx(), rLine.getTP_Refund().getTP_RefundHeader_ID(), po.get_TrxName());
            if (head.getType().compareTo("01") == 0 && rLine.getM_Movement_ID() > 0) {
                mov = new MMovement(po.getCtx(), rLine.getM_Movement_ID(), po.get_TrxName());
                if (mov.getC_BPartner_ID() != rLine.getTP_Refund().getC_BPartner_ID()) {
                    return "ERROR: Conductor HR no coincide con viatico";
                }
                MaxDate = DB.getSQLValueTS((String)po.get_TrxName(), (String)("SELECT MAX(TP_InicialHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID()), (Object[])new Object[0]);
                MinDate = DB.getSQLValueTS((String)po.get_TrxName(), (String)("SELECT MIN(TP_FinalHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID()), (Object[])new Object[0]);
                MinDate.setHours(0);
                MinDate.setMinutes(0);
                MinDate.setSeconds(0);
                if (rLine.getDateTrx().compareTo(MaxDate) > 0 || rLine.getDateTrx().compareTo(MinDate) < 0) {
                    throw new AdempiereException("ERROR: Fecha de HR no coincide con fecha de viatico");
                }
            }
            if (head.getType().compareTo("02") == 0) {
                int cantRep;
                if (rLine.getM_Movement_ID() > 0) {
                    mov = new MMovement(po.getCtx(), rLine.getM_Movement_ID(), po.get_TrxName());
                    if (mov.getC_BPartner_ID() != rLine.getTP_Refund().getC_BPartner_ID()) {
                        return "ERROR: Conductor HR no coincide con viatico";
                    }
                    MaxDate = DB.getSQLValueTS((String)po.get_TrxName(), (String)("SELECT MAX(TP_InicialHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID()), (Object[])new Object[0]);
                    MinDate = DB.getSQLValueTS((String)po.get_TrxName(), (String)("SELECT MIN(TP_FinalHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID()), (Object[])new Object[0]);
                    MinDate.setHours(0);
                    MinDate.setMinutes(0);
                    MinDate.setSeconds(0);
                    if (rLine.getDateTrx().compareTo(MaxDate) > 0 || rLine.getDateTrx().compareTo(MinDate) < 0) {
                        throw new AdempiereException("ERROR: Fecha de HR no coincide con fecha de viatico");
                    }
                    int cantRepLine = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1) FROM TP_RefundLine rl INNER JOIN TP_Refund r ON (rl.TP_Refund_ID = r.TP_Refund_ID)  WHERE r.type = '" + head.getType() + "' AND Pre_M_Movement_ID > 0 AND r.C_BPartner_ID = " + rLine.getTP_Refund().getC_BPartner_ID() + " AND rl.DateTrx = ?"), (Object[])new Object[]{rLine.getDateTrx()});
                    if (cantRepLine > 0) {
                        throw new AdempiereException("ERROR: Ya existe un viatico por disponibilidad para la misma fecha y conductor:" + rLine.getTP_Refund().getC_BPartner().getName());
                    }
                }
                if (rLine.get_ValueAsInt("Pre_M_Movement_ID") > 0 && (cantRep = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1) FROM TP_RefundLine rl INNER JOIN TP_Refund r ON (rl.TP_Refund_ID = r.TP_Refund_ID)  WHERE r.type = '" + head.getType() + "' AND M_Movement_ID > 0 AND r.C_BPartner_ID = " + rLine.getTP_Refund().getC_BPartner_ID() + " AND rl.DateTrx = ?"), (Object[])new Object[]{rLine.getDateTrx()})) > 0) {
                    throw new AdempiereException("ERROR: Ya existe un viatico por hoja de ruta para la misma fecha y conductor:" + rLine.getTP_Refund().getC_BPartner().getName());
                }
                int cant = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1) FROM TP_RefundLine WHERE IsActive = 'Y' AND TP_RefundLine_ID <> " + rLine.get_ID() + " AND M_Movement_ID = " + rLine.getM_Movement_ID() + " AND TP_RefundAmt_ID = " + rLine.get_ValueAsInt("TP_RefundAmt_ID") + " AND DateTrx = ?"), (Object[])new Object[]{rLine.getDateTrx()});
                if (cant > 0) {
                    throw new AdempiereException("ERROR: Existe una HR y concepto repetido");
                }
                if (rLine.getM_Movement_ID() <= 0 && rLine.get_ValueAsInt("TP_RefundAmt_ID") > 0 && rLine.getTP_Refund().getAD_Org_ID() != 1000004 && rLine.getTP_Refund().getAD_Org_ID() != 1000017 && rLine.getTP_Refund().getAD_Org_ID() != 1000067) {
                    throw new AdempiereException("ERROR: Debe ingresar HR");
                }
            }
        }
        if (type == 3 && po.get_Table_ID() == X_TP_RefundLine.Table_ID) {
            rLine = (X_TP_RefundLine)po;
            head = new X_TP_RefundHeader(po.getCtx(), rLine.getTP_Refund().getTP_RefundHeader_ID(), po.get_TrxName());
            MRole role = new MRole(po.getCtx(), Env.getAD_Role_ID((Properties)Env.getCtx()), po.get_TrxName());
            boolean flag = role.get_ValueAsBoolean("RefundMod");
            if (head.isSignature1() && !flag) {
                return "ERROR: No se puede borrar linea de viatico";
            }
            if (head.isSignature2() && !flag) {
                return "ERROR: No se puede borrar linea de viatico";
            }
        }
        if (type == 3 && po.get_Table_ID() == X_TP_Refund.Table_ID) {
            refund = (X_TP_Refund)po;
            head = new X_TP_RefundHeader(po.getCtx(), refund.getTP_RefundHeader_ID(), po.get_TrxName());
            MRole role = new MRole(po.getCtx(), Env.getAD_Role_ID((Properties)Env.getCtx()), po.get_TrxName());
            boolean flag = role.get_ValueAsBoolean("RefundMod");
            if (head.isSignature1() && !flag) {
                return "ERROR: No se puede borrar linea de viatico";
            }
            if (head.isSignature2() && !flag) {
                return "ERROR: No se puede borrar linea de viatico";
            }
        }
        if (type == 3 && po.get_Table_ID() == X_TP_Refund.Table_ID) {
            refund = (X_TP_Refund)po;
            DB.executeUpdate((String)("DELETE FROM TP_RefundLine WHERE TP_Refund_ID = " + refund.get_ID()), (String)po.get_TrxName());
            head = new X_TP_RefundHeader(po.getCtx(), refund.getTP_RefundHeader_ID(), po.get_TrxName());
            BigDecimal amtrefund = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(rl.amt)  FROM tp_refund r  INNER JOIN tp_refundline rl ON (rl.tp_refund_id = r.tp_refund_id) WHERE r.tp_refundheader_id = " + head.get_ID()), (Object[])new Object[0]);
            if (amtrefund != null) {
                head.set_CustomColumn("GrandTotal", amtrefund);
                head.saveEx(po.get_TrxName());
            }
        }
        if (type == 3 && po.get_Table_ID() == X_TP_RefundHeader.Table_ID) {
            X_TP_RefundHeader head2 = (X_TP_RefundHeader)po;
            DB.executeUpdate((String)("DELETE FROM TP_RefundLine WHERE TP_Refund_ID IN (SELECT TP_Refund_ID FROM TP_Refund WHERE TP_RefundHeader_ID = " + head2.get_ID() + ") "), (String)po.get_TrxName());
            DB.executeUpdate((String)("DELETE FROM TP_Refund WHERE TP_RefundHeader_ID = " + head2.get_ID()), (String)po.get_TrxName());
        }
        if ((type == 5 || type == 4 || type == 6) && po.get_Table_ID() == X_TP_RefundLine.Table_ID) {
            rLine = (X_TP_RefundLine)po;
            head = new X_TP_RefundHeader(po.getCtx(), rLine.getTP_Refund().getTP_RefundHeader_ID(), po.get_TrxName());
            BigDecimal amtrefund = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(rl.amt)  FROM tp_refund r  INNER JOIN tp_refundline rl ON (rl.tp_refund_id = r.tp_refund_id) WHERE r.tp_refundheader_id = " + head.get_ID()), (Object[])new Object[0]);
            if (amtrefund != null) {
                head.set_CustomColumn("GrandTotal", amtrefund);
                head.saveEx(po.get_TrxName());
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    private boolean updateHeader(MCash cash) {
        String sql = "SELECT COALESCE(SUM(cl.Amount),0) FROM C_CashLine cl WHERE cl.IsActive='Y' AND cl.C_Cash_ID=" + cash.getC_Cash_ID();
        BigDecimal StatementDifference = DB.getSQLValueBD((String)cash.get_TrxName(), (String)sql, (Object[])new Object[0]);
        cash.setStatementDifference(StatementDifference);
        cash.setEndingBalance(cash.getBeginningBalance().add(StatementDifference));
        cash.saveEx();
        return true;
    }
}

