/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.model.X_DM_Document;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMFondoFijo
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMFondoFijo.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_PaymentRequestLine", (ModelValidator)this);
        engine.addDocValidate("C_Cash", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        X_C_PaymentRequestLine rLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4 || type == 6) && po.get_Table_ID() == X_C_PaymentRequestLine.Table_ID && (rLine = (X_C_PaymentRequestLine)po).get_ValueAsInt("DM_Document_ID") > 0) {
            X_DM_Document doc = new X_DM_Document(po.getCtx(), rLine.get_ValueAsInt("DM_Document_ID"), po.get_TrxName());
            BigDecimal allocatedAmt = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(Amt) FROM C_PaymentRequestLine WHERE DM_Document_ID=" + doc.get_ID()), (Object[])new Object[0]);
            if (allocatedAmt == null) {
                allocatedAmt = Env.ZERO;
            }
            doc.set_CustomColumn("AllocatedAmt", allocatedAmt);
            doc.saveEx();
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        BigDecimal amt;
        MCashBook cashBook;
        MCash cash;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MCash.Table_ID && (cash = (MCash)((Object)po)).getC_CashBook_ID() > 0 && (cashBook = new MCashBook(po.getCtx(), cash.getC_CashBook_ID(), po.get_TrxName())).get_ValueAsString("TypeBook").compareTo("FF") == 0 && (amt = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT SUM(amount) FROM C_CashLine WHERE IsActive = 'Y' AND C_Cash_ID =" + cash.get_ID()), (Object[])new Object[0])) != null && amt.compareTo(Env.ZERO) > 0) {
            X_DM_Document doc = new X_DM_Document(po.getCtx(), 0, po.get_TrxName());
            doc.setAD_Org_ID(cash.getAD_Org_ID());
            doc.set_CustomColumn("C_BPartner_ID", cashBook.get_ValueAsInt("C_BPartner_ID"));
            doc.setAmt(amt);
            doc.setDescription("Generado desde diario de efectivo " + cash.getDocumentNo());
            doc.set_CustomColumn("C_Cash_ID", cash.get_ID());
            doc.setDateTrx(cash.getStatementDate());
            doc.setDocStatus("CO");
            doc.setProcessed(true);
            doc.saveEx();
            cash.set_CustomColumn("DM_Document_ID", doc.get_ID());
            this.updateHeader(cash);
            cash.saveEx();
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    private boolean updateHeader(MCash cash) {
        String sql = "SELECT COALESCE(SUM(cl.Amount),0) FROM C_CashLine cl WHERE cl.IsActive='Y' AND cl.C_Cash_ID=" + cash.getC_Cash_ID();
        BigDecimal StatementDifference = DB.getSQLValueBD((String)cash.get_TrxName(), (String)sql, (Object[])new Object[0]);
        cash.setStatementDifference(StatementDifference);
        cash.setEndingBalance(cash.getBeginningBalance().add(StatementDifference));
        cash.saveEx();
        return true;
    }
}

