/*
 * Decompiled with CFR 0.152.
 */
package org.qdc.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.X_OFB_ProductCost;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessQDCGetCost
extends SvrProcess {
    private int p_Product_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_Product_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String sql = "SELECT m_product_id from m_product where isactive='Y' ";
        if (this.p_Product_ID > 0) {
            sql = sql.concat(" AND m_product_id = " + this.p_Product_ID);
        }
        this.log.config("sql producto = " + sql);
        CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            int product_id = rs.getInt(1);
            BigDecimal amount = Env.ZERO;
            int order_id = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT coalesce(max(c_order_id),0) from c_order where  docstatus='CO' and issotrx='N' and c_order_id in ( SELECT  c_order_id from c_orderline where m_product_id = " + product_id + " and c_orderline_id in (" + " SELECT c_orderline_id from m_inoutline where m_inout_id in (select m_inout_id from m_inout " + " where docstatus='CO' and isactive='Y')))"));
            if (order_id == 0) continue;
            int orderline_id = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT c_orderline_id from c_orderline where  C_Order_ID = " + order_id + " AND m_product_id = " + product_id));
            MOrder ord = new MOrder(this.getCtx(), order_id, this.get_TrxName());
            MOrderLine ordl = new MOrderLine(this.getCtx(), orderline_id, this.get_TrxName());
            BigDecimal priceentered = ordl.getPriceEntered();
            int currency_id = ord.getC_Currency_ID();
            if (currency_id == 0) continue;
            if (currency_id != 228) {
                Timestamp dateorder = null;
                dateorder = ord.getDateOrdered();
                String sqlobtainrate = "SELECT coalesce(max(c_conversion_rate_id),0) FROM c_conversion_rate  WHERE validfrom = (select dateordered from c_order where c_order_id = " + order_id + ") and isactive='Y' and c_currency_id = " + currency_id;
                String sqlobtainminout = "SELECT coalesce(max(m_inout_id),0) from m_inoutline where c_orderline_id = " + orderline_id;
                int minout_id = DB.getSQLValue((String)this.get_TrxName(), (String)sqlobtainminout);
                if (minout_id > 0) {
                    sqlobtainrate = "SELECT coalesce(max(c_conversion_rate_id),0) FROM c_conversion_rate  WHERE validfrom = (select movementdate from m_inout where m_inout_id = " + minout_id + ") and isactive='Y' and c_currency_id = " + currency_id;
                }
                this.log.config("obtain rate " + sqlobtainrate);
                int rate_id = DB.getSQLValue((String)this.get_TrxName(), (String)sqlobtainrate);
                if (rate_id == 0) continue;
                MConversionRate conv = new MConversionRate(this.getCtx(), rate_id, this.get_TrxName());
                amount = conv.getMultiplyRate().multiply(priceentered);
            } else {
                amount = priceentered;
            }
            String sqllanded = "SELECT coalesce(sum(amt/qty),0) from c_landedcostallocation where m_product_id = " + product_id + "and c_invoiceline_id in (select c_invoiceline_Id from c_landedcost" + " WHERE m_inout_id in (select m_inout_id from m_inoutline where c_orderline_id = ?))";
            BigDecimal amountlanded = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqllanded, (int)orderline_id);
            BigDecimal amountadd = amount.add(amountlanded);
            int last_id = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT coalesce(max(ofb_productcost_id),0) from ofb_productcost where m_product_id = " + product_id));
            X_OFB_ProductCost po = new X_OFB_ProductCost(this.getCtx(), last_id, this.get_TrxName());
            if (last_id == 0) {
                po.setM_Product_ID(product_id);
            }
            BigDecimal currentcost = DB.getSQLValueBD((String)this.get_TrxName(), (String)"SELECT max(currentcostprice) from m_cost where m_product_id = ?", (int)product_id);
            po.setDescription("Actualizado");
            po.setAmount(amount);
            po.setAmount2(amountlanded);
            po.setAmount3(amountadd);
            po.set_CustomColumn("C_Order_ID", order_id);
            po.set_CustomColumn("Amount4", currentcost);
            po.save();
        }
        return "Procesado";
    }
}

