/*
 * Decompiled with CFR 0.152.
 */
package org.prototipos.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPetroAmericaValidPay
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPetroAmericaValidPay.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MPayment.Table_ID) {
            MPayment pay = (MPayment)((Object)po);
            BigDecimal amtInvoice = null;
            BigDecimal amtOrder = null;
            if (pay.getC_Invoice_ID() > 0) {
                String sqlInvoice = "SELECT  SUM(abs(currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,228,i.dateacct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP)) as amt FROM c_invoice_v i WHERE C_Invoice_ID = " + pay.getC_Invoice_ID();
                amtInvoice = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlInvoice, (Object[])new Object[0]);
                if (pay.getC_Invoice_ID() > 0 && amtInvoice != null && pay.getPayAmt().compareTo(amtInvoice) > 0) {
                    return "Error: Monto de Pago supera Monto de Factura";
                }
            }
            if (pay.getC_Order_ID() > 0) {
                MOrder order = new MOrder(po.getCtx(), pay.getC_Order_ID(), po.get_TrxName());
                String sqlOrder = "select ABS(SUM(cp.PayAmt)) as amt FROM C_Payment cp WHERE IsActive = 'Y' AND DocStatus IN ('CO','CL','DR','IP') AND C_Order_ID = " + pay.getC_Order_ID();
                amtOrder = DB.getSQLValueBD((String)po.get_TrxName(), (String)sqlOrder, (Object[])new Object[0]);
                if (amtOrder == null) {
                    amtOrder = Env.ZERO;
                }
                amtOrder = order.getGrandTotal().subtract(amtOrder);
                if (pay.getC_Order_ID() > 0 && amtOrder != null && pay.getPayAmt().compareTo(amtOrder) > 0) {
                    return "Error: Monto de Pago supera Monto de Orden";
                }
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

