/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.model.MCharge;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class UpdateInvLinesNoTax
extends SvrProcess {
    private int ID_Invoice;

    protected void prepare() {
        this.ID_Invoice = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.getCtx(), this.ID_Invoice, this.get_TrxName());
        MCharge charAf = new MCharge(this.getCtx(), 1000173, this.get_TrxName());
        BigDecimal price = Env.ZERO;
        MInvoiceLine[] lines = inv.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceLine line = lines[i];
            price = line.getC_OrderLine().getPriceEntered();
            if (price == null) {
                price = Env.ZERO;
            }
            price = price.subtract(charAf.getChargeAmt());
            price = price.setScale(4, RoundingMode.HALF_EVEN);
            line.setPrice(price);
            if (line.getDescription() != null && line.getDescription().trim().length() > 0) {
                line.setDescription(String.valueOf(line.getDescription()) + " -FCIEN- ");
            } else {
                line.setDescription("-FCIEN-");
            }
            line.setC_Tax_ID(line.getC_OrderLine().getC_Tax_ID());
            line.saveEx(this.get_TrxName());
            ++i;
        }
        return "Se ha actualizado la factura " + inv.getDocumentNo();
    }
}

