/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAValidCreditBP
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAValidCreditBP.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)((Object)po);
            MBPartner bPart = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
            if (bPart.get_ValueAsString("SOCreditStatusOFB").compareTo("H") == 0) {
                return "Error: Cliente con credito retenido";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx()) {
            int flag = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1)  FROM C_DocType WHERE C_DocType_ID = " + order.getC_DocType_ID() + " AND C_DocType_ID IN ( SELECT dt.C_DocType_ID FROM C_DocType dt " + " INNER JOIN C_DocType dt2 ON (dt.C_DocTypeInvoice_ID = dt2.C_DocType_ID)" + " WHERE dt2.DocBaseType = 'ARC')"));
            if (!order.get_ValueAsBoolean("Override") && flag < 1) {
                MBPartner bp = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
                String SOCreditStatusOFB = bp.get_ValueAsString("SOCreditStatusOFB");
                if (SOCreditStatusOFB == null || SOCreditStatusOFB.trim() == "" || SOCreditStatusOFB.trim() == "") {
                    SOCreditStatusOFB = bp.getSOCreditStatus();
                }
                if (SOCreditStatusOFB == null || SOCreditStatusOFB.trim() == "" || SOCreditStatusOFB.trim() == "") {
                    SOCreditStatusOFB = "O";
                }
                if (SOCreditStatusOFB.compareToIgnoreCase("H") == 0) {
                    return "Error: Problema con cr\u00e9dito de cliente";
                }
                if (SOCreditStatusOFB.compareToIgnoreCase("S") == 0) {
                    return "Error: Problema con cr\u00e9dito de cliente";
                }
                if (SOCreditStatusOFB.compareToIgnoreCase("W") == 0) {
                    return "Error: Problema con cr\u00e9dito de cliente";
                }
                if (SOCreditStatusOFB.compareToIgnoreCase("O") == 0) {
                    BigDecimal amtcredit = (BigDecimal)bp.get_Value("TotalOpenBalanceOFB");
                    if (amtcredit == null || amtcredit.compareTo(Env.ZERO) == 0) {
                        BigDecimal amtUsed = (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
                        BigDecimal ownCredit = (BigDecimal)bp.get_Value("OwnCreditLimit");
                        BigDecimal extCredit = (BigDecimal)bp.get_Value("ExternalCreditLimit");
                        if (ownCredit != null) {
                            amtcredit = ownCredit;
                        }
                        if (extCredit != null) {
                            amtcredit = amtcredit.add(extCredit);
                        }
                        if (amtUsed != null) {
                            amtcredit = amtcredit.subtract(amtUsed);
                        }
                    }
                    if (amtcredit == null) {
                        amtcredit = (BigDecimal)bp.get_Value("OwnCreditLimit");
                    }
                    if (amtcredit == null) {
                        amtcredit = Env.ZERO;
                    }
                    MOrderLine[] olines = order.getLines();
                    BigDecimal newGrandTotal = order.getTotalLines();
                    BigDecimal taxNewLine = Env.ZERO;
                    int i = 0;
                    while (i < olines.length) {
                        MOrderLine oline = olines[i];
                        if ((BigDecimal)oline.get_Value("FixedTaxAmt") != null) {
                            taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("FixedTaxAmt"));
                        }
                        if ((BigDecimal)oline.get_Value("VariableTax") != null) {
                            taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("VariableTaxAmt"));
                        }
                        if ((BigDecimal)oline.get_Value("IVATaxAmt") != null) {
                            taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("IVATaxAmt"));
                        }
                        ++i;
                    }
                    if (taxNewLine != null) {
                        newGrandTotal = newGrandTotal.add(taxNewLine);
                        newGrandTotal = newGrandTotal.setScale(0, RoundingMode.HALF_EVEN);
                    }
                    if ((amtcredit = amtcredit.subtract(newGrandTotal)).compareTo(Env.ZERO) < 0) {
                        return "Error: Credito de cliente insuficiente";
                    }
                }
                Timestamp dateStartCredit = (Timestamp)bp.get_Value("StartDateCreditLimit");
                Timestamp dateEndCredit = (Timestamp)bp.get_Value("EndDateCreditLimit");
                Timestamp today = new Timestamp(Calendar.getInstance().getTimeInMillis());
                if (dateStartCredit != null && dateStartCredit.compareTo(today) > 0) {
                    return "Error: Credito no vigente";
                }
                if (dateEndCredit != null && dateEndCredit.compareTo(today) < 0) {
                    return "Error: Credito no vigente";
                }
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

