/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_PA_FuelAudit;
import org.compiere.model.X_TP_PumpFuel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAUpdateFuelAudit
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAUpdateFuelAudit.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("PA_FuelAudit", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        X_PA_FuelAudit fa;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_PA_FuelAudit.Table_ID) {
            X_TP_PumpFuel pFuel;
            fa = (X_PA_FuelAudit)po;
            if (fa.getType().compareToIgnoreCase("FI") == 0 && !fa.isProcessed() && fa.getTP_PumpFuel_ID() > 0 && fa.getAuditedAmount() != null && fa.getAuditedAmount().compareTo(Env.ZERO) > 0) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(fa.getDateTrx().getTime());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                Timestamp minDate = new Timestamp(calendar.getTimeInMillis());
                calendar.set(11, 23);
                calendar.set(12, 59);
                calendar.set(13, 59);
                Timestamp maxDate = new Timestamp(calendar.getTimeInMillis());
                BigDecimal amtAuditOld = DB.getSQLValueBD((String)po.get_TrxName(), (String)("SELECT MAX(auditedamount) FROM PA_FuelAudit  WHERE IsActive = 'Y' AND PA_FuelAudit_ID <> " + fa.get_ID() + " AND TP_PumpFuel_ID = " + fa.getTP_PumpFuel_ID() + " AND M_WareHouse_ID = " + fa.getM_Warehouse_ID() + " AND M_Locator_ID = " + fa.getM_Locator_ID() + " AND Type = 'IN' " + " AND DateTrx BETWEEN ? AND ?"), (Object[])new Object[]{minDate, maxDate});
                if (amtAuditOld != null && amtAuditOld.compareTo(Env.ZERO) > 0) {
                    BigDecimal dif = fa.getAuditedAmount().subtract(amtAuditOld);
                    DB.executeUpdate((String)("UPDATE PA_FuelAudit SET DifAuditedAmount = " + dif + " WHERE PA_FuelAudit_ID = " + fa.get_ID()), (String)po.get_TrxName());
                }
            }
            boolean isManual = false;
            isManual = fa.get_ValueAsBoolean("IsManual");
            if (!fa.isProcessed() && fa.getM_Locator_ID() > 0 && !isManual && fa.getTP_PumpFuel_ID() > 0 && (pFuel = new X_TP_PumpFuel(po.getCtx(), fa.getTP_PumpFuel_ID(), po.get_TrxName())).get_ValueAsBoolean("IsDefault")) {
                BigDecimal qtyOnHand = DB.getSQLValueBD((String)po.get_TrxName(), (String)"SELECT SUM(qtyonhand)  FROM M_Storage WHERE M_Locator_ID = ? AND IsActive = 'Y'", (int)fa.getM_Locator_ID());
                if (qtyOnHand == null) {
                    qtyOnHand = Env.ZERO;
                }
                DB.executeUpdate((String)("UPDATE PA_FuelAudit SET QtyOnHand = " + qtyOnHand + " WHERE PA_FuelAudit_ID = " + fa.get_ID()), (String)po.get_TrxName());
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_PA_FuelAudit.Table_ID && po.is_ValueChanged("Processed") && (fa = (X_PA_FuelAudit)po).getType().compareToIgnoreCase("FI") == 0 && fa.isActive() && fa.isProcessed()) {
            X_PA_FuelAudit faNew = new X_PA_FuelAudit(po.getCtx(), 0, po.get_TrxName());
            faNew.setAD_Org_ID(fa.getAD_Org_ID());
            faNew.setType("IN");
            faNew.setIsActive(true);
            faNew.setM_Warehouse_ID(fa.getM_Warehouse_ID());
            faNew.setM_Locator_ID(fa.getM_Locator_ID());
            faNew.setM_Product_ID(fa.getM_Product_ID());
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(fa.getDateTrx().getTime());
            calendar.add(6, 1);
            Timestamp newDate = new Timestamp(calendar.getTimeInMillis());
            faNew.setDateTrx(newDate);
            faNew.setTP_PumpFuel_ID(fa.getTP_PumpFuel_ID());
            faNew.setAuditedAmount(fa.getAuditedAmount());
            faNew.setDescription(fa.getDescription());
            faNew.set_CustomColumn("IsManual", false);
            faNew.setProcessed(false);
            faNew.save();
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

