/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankStatement;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAUpdateCreditBP
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAUpdateCreditBP.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("C_BankStatement", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        BigDecimal amtTotal;
        MBPartner bp;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == MBPartner.Table_ID) {
            bp = (MBPartner)((Object)po);
            amtTotal = Env.ZERO;
            BigDecimal ownCredit = (BigDecimal)bp.get_Value("OwnCreditLimit");
            BigDecimal extCredit = (BigDecimal)bp.get_Value("ExternalCreditLimit");
            BigDecimal creditUsed = (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
            if (ownCredit != null) {
                amtTotal = ownCredit;
            }
            if (extCredit != null) {
                amtTotal = amtTotal.add(extCredit);
            }
            if (amtTotal == null) {
                amtTotal = Env.ZERO;
            }
            if (creditUsed != null) {
                amtTotal = amtTotal.subtract(creditUsed);
            }
            bp.set_CustomColumn("TotalOpenBalanceOFB", amtTotal);
            bp.save();
        }
        if (type == 2 && po.get_Table_ID() == MBPartner.Table_ID && (po.is_ValueChanged("OwnCreditLimit") || po.is_ValueChanged("ExternalCreditLimit") || po.is_ValueChanged("SO_CreditUsedOFB"))) {
            bp = (MBPartner)((Object)po);
            amtTotal = Env.ZERO;
            BigDecimal amtUsed = (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
            BigDecimal ownCredit = (BigDecimal)bp.get_Value("OwnCreditLimit");
            BigDecimal extCredit = (BigDecimal)bp.get_Value("ExternalCreditLimit");
            if (ownCredit != null) {
                amtTotal = ownCredit;
            }
            if (extCredit != null) {
                amtTotal = amtTotal.add(extCredit);
            }
            if (amtTotal == null) {
                amtTotal = Env.ZERO;
            }
            if (amtUsed != null) {
                amtTotal = amtTotal.subtract(amtUsed);
            }
            bp.set_CustomColumn("TotalOpenBalanceOFB", amtTotal);
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        BigDecimal amtUsed;
        BigDecimal amtTotal;
        MInvoice inv;
        MBPartner bp;
        ResultSet rs;
        CPreparedStatement pstmt;
        MBankStatement sBank;
        BigDecimal amtUsed2;
        BigDecimal amtTotal2;
        MPayment pay;
        BigDecimal amtUsed3;
        BigDecimal amtTotal3;
        MBPartner bp2;
        int flag;
        MOrder order;
        block66: {
            log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
            if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID) {
                order = (MOrder)((Object)po);
                flag = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1)  FROM C_DocType WHERE C_DocType_ID = " + order.getC_DocType_ID() + " AND C_DocType_ID IN ( SELECT dt.C_DocType_ID FROM C_DocType dt " + " INNER JOIN C_DocType dt2 ON (dt.C_DocTypeInvoice_ID = dt2.C_DocType_ID)" + " WHERE dt2.DocBaseType = 'ARC')"));
                if (order.isSOTrx() && flag < 1) {
                    bp2 = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
                    MOrderLine[] olines = order.getLines();
                    BigDecimal newGrandTotal = order.getTotalLines();
                    BigDecimal taxNewLine = Env.ZERO;
                    int i = 0;
                    while (i < olines.length) {
                        MOrderLine oline = olines[i];
                        if ((BigDecimal)oline.get_Value("FixedTaxAmt") != null) {
                            taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("FixedTaxAmt"));
                        }
                        if ((BigDecimal)oline.get_Value("VariableTax") != null) {
                            taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("VariableTaxAmt"));
                        }
                        if ((BigDecimal)oline.get_Value("IVATaxAmt") != null) {
                            taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("IVATaxAmt"));
                        }
                        ++i;
                    }
                    if (taxNewLine != null) {
                        newGrandTotal = newGrandTotal.add(taxNewLine);
                    }
                    if ((amtTotal3 = (BigDecimal)bp2.get_Value("TotalOpenBalanceOFB")) == null) {
                        amtTotal3 = (BigDecimal)bp2.get_Value("OwnCreditLimit");
                    }
                    if (amtTotal3 == null) {
                        amtTotal3 = Env.ZERO;
                    }
                    amtTotal3 = amtTotal3.subtract(newGrandTotal);
                    bp2.set_CustomColumn("TotalOpenBalanceOFB", amtTotal3);
                    amtUsed3 = (BigDecimal)bp2.get_Value("SO_CreditUsedOFB");
                    if (amtUsed3 == null) {
                        amtUsed3 = Env.ZERO;
                    }
                    amtUsed3 = amtUsed3.add(newGrandTotal);
                    bp2.set_CustomColumn("SO_CreditUsedOFB", amtUsed3);
                    bp2.save();
                }
            }
            if (timing == 9 && po.get_Table_ID() == MPayment.Table_ID && (pay = (MPayment)((Object)po)).isReceipt() && pay.getTenderType().compareTo("K") != 0) {
                MBPartner bp3 = new MBPartner(po.getCtx(), pay.getC_BPartner_ID(), po.get_TrxName());
                amtTotal2 = (BigDecimal)bp3.get_Value("TotalOpenBalanceOFB");
                if (amtTotal2 == null) {
                    amtTotal2 = (BigDecimal)bp3.get_Value("OwnCreditLimit");
                }
                if (amtTotal2 == null) {
                    amtTotal2 = Env.ZERO;
                }
                amtTotal2 = amtTotal2.add(pay.getPayAmt());
                bp3.set_CustomColumn("TotalOpenBalanceOFB", amtTotal2);
                amtUsed2 = (BigDecimal)bp3.get_Value("SO_CreditUsedOFB");
                if (amtUsed2 == null) {
                    amtUsed2 = Env.ZERO;
                }
                amtUsed2 = amtUsed2.subtract(pay.getPayAmt());
                bp3.set_CustomColumn("SO_CreditUsedOFB", amtUsed2);
                bp3.save();
            }
            if (timing == 9 && po.get_Table_ID() == MBankStatement.Table_ID) {
                sBank = (MBankStatement)((Object)po);
                String sql = "SELECT cp.C_Payment_ID FROM C_BankStatement bs  INNER JOIN C_BankStatementLine bsLine ON (bs.C_BankStatement_ID = bsLine.C_BankStatement_ID)  INNER JOIN C_Payment cp ON (bsLine.C_Payment_ID = cp.C_Payment_ID)  WHERE cp.IsReceipt = 'Y' AND cp.TenderType = 'K' AND bs.C_BankStatement_ID = ?";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                        pstmt.setInt(1, sBank.get_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            MPayment pay2 = new MPayment(po.getCtx(), rs.getInt("C_Payment_ID"), po.get_TrxName());
                            if (!pay2.isReceipt() || pay2.getTenderType().compareTo("K") != 0) continue;
                            bp = new MBPartner(po.getCtx(), pay2.getC_BPartner_ID(), po.get_TrxName());
                            amtTotal3 = (BigDecimal)bp.get_Value("TotalOpenBalanceOFB");
                            if (amtTotal3 == null) {
                                amtTotal3 = (BigDecimal)bp.get_Value("OwnCreditLimit");
                            }
                            if (amtTotal3 == null) {
                                amtTotal3 = Env.ZERO;
                            }
                            amtTotal3 = amtTotal3.add(pay2.getPayAmt());
                            bp.set_CustomColumn("TotalOpenBalanceOFB", amtTotal3);
                            amtUsed3 = (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
                            if (amtUsed3 == null) {
                                amtUsed3 = Env.ZERO;
                            }
                            amtUsed3 = amtUsed3.subtract(pay2.getPayAmt());
                            bp.set_CustomColumn("SO_CreditUsedOFB", amtUsed3);
                            bp.save();
                        }
                    }
                    catch (Exception e) {
                        log.config("Error: " + e);
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        break block66;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)((Object)po)).getC_DocTypeTarget().getDocBaseType().equals("ARC") && inv.isSOTrx()) {
            MBPartner bp4 = new MBPartner(po.getCtx(), inv.getC_BPartner_ID(), po.get_TrxName());
            amtTotal2 = (BigDecimal)bp4.get_Value("TotalOpenBalanceOFB");
            if (amtTotal2 == null) {
                amtTotal2 = (BigDecimal)bp4.get_Value("OwnCreditLimit");
            }
            if (amtTotal2 == null) {
                amtTotal2 = Env.ZERO;
            }
            amtTotal2 = amtTotal2.add(inv.getGrandTotal());
            bp4.set_CustomColumn("TotalOpenBalanceOFB", amtTotal2);
            amtUsed2 = (BigDecimal)bp4.get_Value("SO_CreditUsedOFB");
            if (amtUsed2 == null) {
                amtUsed2 = Env.ZERO;
            }
            amtUsed2 = amtUsed2.subtract(inv.getGrandTotal());
            bp4.set_CustomColumn("SO_CreditUsedOFB", amtUsed2);
            bp4.save();
        }
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)((Object)po)).getC_DocTypeTarget_ID() == 1000077) {
            MBPartner bp5 = new MBPartner(po.getCtx(), inv.getC_BPartner_ID(), po.get_TrxName());
            amtTotal2 = (BigDecimal)bp5.get_Value("TotalOpenBalanceOFB");
            if (amtTotal2 == null) {
                amtTotal2 = (BigDecimal)bp5.get_Value("OwnCreditLimit");
            }
            if (amtTotal2 == null) {
                amtTotal2 = Env.ZERO;
            }
            amtTotal2 = amtTotal2.subtract(inv.getGrandTotal());
            bp5.set_CustomColumn("TotalOpenBalanceOFB", amtTotal2);
            amtUsed2 = (BigDecimal)bp5.get_Value("SO_CreditUsedOFB");
            if (amtUsed2 == null) {
                amtUsed2 = Env.ZERO;
            }
            amtUsed2 = amtUsed2.add(inv.getGrandTotal());
            bp5.set_CustomColumn("SO_CreditUsedOFB", amtUsed2);
            bp5.save();
        }
        if (timing == 12 && po.get_Table_ID() == MOrder.Table_ID) {
            order = (MOrder)((Object)po);
            flag = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1)  FROM C_DocType WHERE C_DocType_ID = " + order.getC_DocType_ID() + " AND C_DocType_ID IN ( SELECT dt.C_DocType_ID FROM C_DocType dt " + " INNER JOIN C_DocType dt2 ON (dt.C_DocTypeInvoice_ID = dt2.C_DocType_ID)" + " WHERE dt2.DocBaseType = 'ARC')"));
            if (order.isSOTrx() && flag < 1) {
                bp2 = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
                amtTotal = (BigDecimal)bp2.get_Value("TotalOpenBalanceOFB");
                if (amtTotal == null) {
                    amtTotal = (BigDecimal)bp2.get_Value("OwnCreditLimit");
                }
                if (amtTotal == null) {
                    amtTotal = Env.ZERO;
                }
                amtTotal = amtTotal.add(order.getGrandTotal());
                bp2.set_CustomColumn("TotalOpenBalanceOFB", amtTotal);
                amtUsed = (BigDecimal)bp2.get_Value("SO_CreditUsedOFB");
                if (amtUsed == null) {
                    amtUsed = Env.ZERO;
                }
                amtUsed = amtUsed.subtract(order.getGrandTotal());
                bp2.set_CustomColumn("SO_CreditUsedOFB", amtUsed);
                bp2.save();
            }
        }
        if (timing == 2 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).getDocStatus().compareTo("CO") == 0) {
            flag = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1)  FROM C_DocType WHERE C_DocType_ID = " + order.getC_DocType_ID() + " AND C_DocType_ID IN ( SELECT dt.C_DocType_ID FROM C_DocType dt " + " INNER JOIN C_DocType dt2 ON (dt.C_DocTypeInvoice_ID = dt2.C_DocType_ID)" + " WHERE dt2.DocBaseType = 'ARC')"));
            if (order.isSOTrx() && flag < 1) {
                bp2 = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
                amtTotal = (BigDecimal)bp2.get_Value("TotalOpenBalanceOFB");
                if (amtTotal == null) {
                    amtTotal = (BigDecimal)bp2.get_Value("OwnCreditLimit");
                }
                if (amtTotal == null) {
                    amtTotal = Env.ZERO;
                }
                amtTotal = amtTotal.add(order.getGrandTotal());
                bp2.set_CustomColumn("TotalOpenBalanceOFB", amtTotal);
                amtUsed = (BigDecimal)bp2.get_Value("SO_CreditUsedOFB");
                if (amtUsed == null) {
                    amtUsed = Env.ZERO;
                }
                amtUsed = amtUsed.subtract(order.getGrandTotal());
                bp2.set_CustomColumn("SO_CreditUsedOFB", amtUsed);
                bp2.save();
            }
        }
        if (timing == 3 && po.get_Table_ID() == MOrder.Table_ID) {
            order = (MOrder)((Object)po);
            flag = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1)  FROM C_DocType WHERE C_DocType_ID = " + order.getC_DocType_ID() + " AND C_DocType_ID IN ( SELECT dt.C_DocType_ID FROM C_DocType dt " + " INNER JOIN C_DocType dt2 ON (dt.C_DocTypeInvoice_ID = dt2.C_DocType_ID)" + " WHERE dt2.DocBaseType = 'ARC')"));
            if (order.isSOTrx() && flag < 1) {
                BigDecimal amtGrandTotal = Env.ZERO;
                MOrderLine[] oLines = order.getLines(true, null);
                int i = 0;
                while (i < oLines.length) {
                    MOrderLine oLine = oLines[i];
                    BigDecimal amtLine = Env.ZERO;
                    amtLine = oLine.getPriceEntered().multiply(oLine.getQtyEntered().subtract(oLine.getQtyDelivered()));
                    amtLine = amtLine.setScale(order.getC_Currency().getStdPrecision(), RoundingMode.HALF_EVEN);
                    BigDecimal amtTaxTemp = Env.ZERO;
                    if ((BigDecimal)oLine.get_Value("IVATaxAmt") != null) {
                        amtTaxTemp = amtLine.multiply(oLine.getC_Tax().getRate().divide(Env.ONEHUNDRED));
                        amtLine = amtLine.add(amtTaxTemp);
                    }
                    if ((BigDecimal)oLine.get_Value("FixedTax") != null) {
                        amtTaxTemp = (BigDecimal)oLine.get_Value("FixedTax");
                        amtTaxTemp = amtTaxTemp.multiply(oLine.getQtyEntered().subtract(oLine.getQtyDelivered()));
                        amtLine = amtLine.add(amtTaxTemp);
                    }
                    if ((BigDecimal)oLine.get_Value("VariableTax") != null) {
                        amtTaxTemp = (BigDecimal)oLine.get_Value("VariableTax");
                        amtTaxTemp = amtTaxTemp.multiply(oLine.getQtyEntered().subtract(oLine.getQtyDelivered()));
                        amtLine = amtLine.add(amtTaxTemp);
                    }
                    amtGrandTotal = amtGrandTotal.add(amtLine);
                    amtGrandTotal = amtGrandTotal.setScale(0, RoundingMode.HALF_EVEN);
                    ++i;
                }
                if (amtGrandTotal != null && amtGrandTotal.compareTo(Env.ZERO) > 0) {
                    MBPartner bp6 = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
                    BigDecimal amtTotal4 = (BigDecimal)bp6.get_Value("TotalOpenBalanceOFB");
                    if (amtTotal4 == null) {
                        amtTotal4 = (BigDecimal)bp6.get_Value("OwnCreditLimit");
                    }
                    if (amtTotal4 == null) {
                        amtTotal4 = Env.ZERO;
                    }
                    amtTotal4 = amtTotal4.add(amtGrandTotal);
                    bp6.set_CustomColumn("TotalOpenBalanceOFB", amtTotal4);
                    BigDecimal amtUsed4 = (BigDecimal)bp6.get_Value("SO_CreditUsedOFB");
                    if (amtUsed4 == null) {
                        amtUsed4 = Env.ZERO;
                    }
                    amtUsed4 = amtUsed4.subtract(amtGrandTotal);
                    bp6.set_CustomColumn("SO_CreditUsedOFB", amtUsed4);
                    bp6.save();
                }
            }
        }
        if (timing == 10 && po.get_Table_ID() == MPayment.Table_ID && (pay = (MPayment)((Object)po)).isReceipt() && pay.getTenderType().compareTo("K") != 0) {
            MBPartner bp7 = new MBPartner(po.getCtx(), pay.getC_BPartner_ID(), po.get_TrxName());
            amtTotal2 = (BigDecimal)bp7.get_Value("TotalOpenBalanceOFB");
            if (amtTotal2 == null) {
                amtTotal2 = (BigDecimal)bp7.get_Value("OwnCreditLimit");
            }
            if (amtTotal2 == null) {
                amtTotal2 = Env.ZERO;
            }
            amtTotal2 = amtTotal2.add(pay.getPayAmt());
            bp7.set_CustomColumn("TotalOpenBalanceOFB", amtTotal2);
            amtUsed2 = (BigDecimal)bp7.get_Value("SO_CreditUsedOFB");
            if (amtUsed2 == null) {
                amtUsed2 = Env.ZERO;
            }
            amtUsed2 = amtUsed2.add(pay.getPayAmt());
            bp7.set_CustomColumn("SO_CreditUsedOFB", amtUsed2);
            bp7.save();
        }
        if (timing == 2 && po.get_Table_ID() == MBankStatement.Table_ID) {
            sBank = (MBankStatement)((Object)po);
            String sql = "SELECT cp.C_Payment_ID FROM C_BankStatement bs  INNER JOIN C_BankStatementLine bsLine ON (bs.C_BankStatement_ID = bsLine.C_BankStatement_ID)  INNER JOIN C_Payment cp ON (bsLine.C_Payment_ID = cp.C_Payment_ID)  WHERE cp.IsReceipt = 'Y' AND cp.TenderType = 'K' AND bs.C_BankStatement_ID = ?";
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
                    pstmt.setInt(1, sBank.get_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPayment pay3 = new MPayment(po.getCtx(), rs.getInt("C_Payment_ID"), po.get_TrxName());
                        if (!pay3.isReceipt() || pay3.getTenderType().compareTo("K") != 0) continue;
                        bp = new MBPartner(po.getCtx(), pay3.getC_BPartner_ID(), po.get_TrxName());
                        amtTotal3 = (BigDecimal)bp.get_Value("TotalOpenBalanceOFB");
                        if (amtTotal3 == null) {
                            amtTotal3 = (BigDecimal)bp.get_Value("OwnCreditLimit");
                        }
                        if (amtTotal3 == null) {
                            amtTotal3 = Env.ZERO;
                        }
                        amtTotal3 = amtTotal3.add(pay3.getPayAmt());
                        bp.set_CustomColumn("TotalOpenBalanceOFB", amtTotal3);
                        amtUsed3 = (BigDecimal)bp.get_Value("SO_CreditUsedOFB");
                        if (amtUsed3 == null) {
                            amtUsed3 = Env.ZERO;
                        }
                        amtUsed3 = amtUsed3.add(pay3.getPayAmt());
                        bp.set_CustomColumn("SO_CreditUsedOFB", amtUsed3);
                        bp.save();
                    }
                }
                catch (Exception e) {
                    log.config("Error: " + e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            finally {
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

