/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPricing;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAUpdateAfterOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAUpdateAfterOrder.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID) {
            String sql;
            MOrder order = (MOrder)((Object)po);
            MOrderLine[] olines = order.getLines();
            MBPartnerLocation loc = new MBPartnerLocation(po.getCtx(), order.getC_BPartner_Location_ID(), po.get_TrxName());
            BigDecimal cost = (BigDecimal)loc.get_Value("Cost");
            int M_PriceList_Version_ID = 0;
            if (M_PriceList_Version_ID == 0 && order.getM_PriceList_ID() > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, (String)(sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC"), (Object[])new Object[]{order.getM_PriceList_ID(), order.getDateOrdered()})) > 0) {
                order.set_CustomColumn("M_PriceList_Version_ID", M_PriceList_Version_ID);
                order.save();
            }
            BigDecimal taxNewLine = Env.ZERO;
            int i = 0;
            while (i < olines.length) {
                MOrderLine oline = olines[i];
                MProductPricing pp = new MProductPricing(oline.getM_Product_ID(), order.getC_BPartner_ID(), oline.getQtyOrdered(), order.isSOTrx());
                pp.setM_PriceList_ID(order.getM_PriceList_ID());
                pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                pp.setPriceDate(order.getDateOrdered());
                BigDecimal priceStd = pp.getPriceStd();
                if (cost != null) {
                    priceStd = priceStd.add(cost);
                }
                if (priceStd != null && priceStd.compareTo(Env.ZERO) > 0) {
                    oline.setPrice(priceStd);
                    oline.setTax();
                    oline.setLineNetAmt();
                    oline.save();
                }
                if ((BigDecimal)oline.get_Value("FixedTaxAmt") != null) {
                    taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("FixedTaxAmt"));
                }
                if ((BigDecimal)oline.get_Value("VariableTax") != null) {
                    taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("VariableTaxAmt"));
                }
                if ((BigDecimal)oline.get_Value("IVATaxAmt") != null) {
                    taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("IVATaxAmt"));
                }
                ++i;
            }
            if (taxNewLine != null) {
                taxNewLine = taxNewLine.setScale(10, 6);
                DB.executeUpdate((String)("UPDATE C_Order SET GrandTotal = " + order.getTotalLines().add(taxNewLine) + " " + " WHERE C_Order_ID = " + order.get_ID()), (String)po.get_TrxName());
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

