/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import java.math.BigDecimal;
import org.compiere.acct.FactLine;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPDVAcctPagare
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVAcctPagare.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("Fact_Acct", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == FactLine.Table_ID) {
            MInvoice inv;
            FactLine fLine = (FactLine)po;
            if (fLine.getAD_Table_ID() == MInvoice.Table_ID && (inv = new MInvoice(po.getCtx(), fLine.getRecord_ID(), po.get_TrxName())).getC_DocType_ID() == 1000070) {
                BigDecimal debito = fLine.getAmtAcctDr();
                BigDecimal credito = fLine.getAmtAcctCr();
                DB.executeUpdateEx((String)("UPDATE Fact_Acct SET amtsourcedr = " + credito + ", amtsourcecr = " + debito + ", " + " amtacctdr = " + credito + ", amtacctcr = " + debito + "WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
            }
            if (fLine.getAD_Table_ID() == MAllocationHdr.Table_ID) {
                MAllocationHdr allo = new MAllocationHdr(po.getCtx(), fLine.getRecord_ID(), po.get_TrxName());
                Boolean isPagare = false;
                MAllocationLine[] lines = allo.getLines(false);
                int id_Invoice = 0;
                int i = 0;
                while (i < lines.length) {
                    if (lines[i].getC_Invoice_ID() > 0) {
                        MInvoice inv2 = new MInvoice(po.getCtx(), lines[i].getC_Invoice_ID(), po.get_TrxName());
                        if (inv2.getC_DocType_ID() == 1000070) {
                            isPagare = true;
                        }
                        id_Invoice = lines[i].getC_Invoice_ID();
                    }
                    ++i;
                }
                if (isPagare.booleanValue() && fLine.getAmtAcctCr().compareTo(Env.ZERO) != 0 && id_Invoice > 0) {
                    int id_charge = 0;
                    id_charge = DB.getSQLValue((String)po.get_TrxName(), (String)("Select MAX(C_Charge_ID) as C_Charge_ID FROM C_InvoiceLine WHERE C_invoicefac_id > 0 AND C_Invoice_ID = " + id_Invoice));
                    if (id_charge <= 0) {
                        id_charge = DB.getSQLValue((String)po.get_TrxName(), (String)("Select MAX(C_Charge_ID) as C_Charge_ID FROM C_InvoiceLine WHERE C_Invoice_ID = " + id_Invoice));
                    }
                    String sqlAcctCharge = "";
                    sqlAcctCharge = fLine.getAmtAcctCr().compareTo(Env.ZERO) > 0 ? "SELECT MAX(Ch_Expense_Acct) FROM C_Charge_Acct WHERE C_Charge_ID = " + id_charge : "SELECT MAX(Ch_Revenue_Acct) FROM C_Charge_Acct WHERE C_Charge_ID = " + id_charge;
                    int id_vCombination = DB.getSQLValue((String)po.get_TrxName(), (String)sqlAcctCharge);
                    int id_acct = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT account_id FROM c_validcombination where c_validcombination_id = " + id_vCombination));
                    DB.executeUpdateEx((String)("UPDATE Fact_Acct SET account_id = " + id_acct + " WHERE fact_acct_id = " + fLine.get_ID()), (String)po.get_TrxName());
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

