/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process.rpl.imp;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.xpath.XPathExpressionException;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.ofb.process.rpl.imp.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportHelper {
    private CLogger log = CLogger.getCLogger(ImportHelper.class);
    private static CLogger s_log = CLogger.getCLogger(ImportHelper.class);
    private SimpleDateFormat m_dateTimeFormat = null;
    private SimpleDateFormat m_dateFormat = null;
    private SimpleDateFormat m_customDateFormat = null;
    private Properties ctx = null;

    public ImportHelper(Properties ctx) {
        this.ctx = ctx;
        this.m_dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)Env.getLanguage((Properties)ctx));
        this.m_dateFormat = DisplayType.getDateFormat((int)15, (Language)Env.getLanguage((Properties)ctx));
    }

    public void importXMLDocument(StringBuffer result, Document documentToBeImported, String trxName) throws Exception, SQLException, XPathExpressionException {
        Element rootElement = documentToBeImported.getDocumentElement();
        String AD_Client_Value = null;
        AD_Client_Value = rootElement.getAttribute("AD_Client_Value");
        this.log.info("AD_Client_Value = " + AD_Client_Value);
        if (AD_Client_Value == null || "".equals(AD_Client_Value)) {
            throw new Exception(Msg.getMsg((Properties)this.ctx, (String)"XMLClientValueMandatory"));
        }
        String version = null;
        version = rootElement.getAttribute("Version");
        this.log.info("Version = " + version);
        if (version == null || "".equals(version)) {
            throw new Exception(Msg.getMsg((Properties)this.ctx, (String)"XMLVersionAttributeMandatory"));
        }
        int ReplicationMode = new Integer(rootElement.getAttribute("ReplicationMode"));
        String ReplicationType = rootElement.getAttribute("ReplicationType");
        int ReplicationEvent = new Integer(rootElement.getAttribute("ReplicationEvent"));
        MClient client = null;
        client = ImportHelper.getAD_ClientByValue(this.ctx, AD_Client_Value, trxName);
        if (client == null) {
            throw new Exception(Msg.getMsg((Properties)this.ctx, (String)"XMLClientNotFound"));
        }
        this.log.info(client.toString());
        String EXP_Format_Value = null;
        EXP_Format_Value = rootElement.getNodeName();
        this.log.info("EXP_Format_Value = " + EXP_Format_Value);
        MEXPFormat expFormat = null;
        expFormat = MEXPFormat.getFormatByValueAD_Client_IDAndVersion((Properties)this.ctx, (String)EXP_Format_Value, (int)client.getAD_Client_ID(), (String)version, (String)trxName);
        if (expFormat == null || expFormat.getEXP_Format_ID() == 0) {
            MClient systemClient = null;
            systemClient = MClient.get((Properties)this.ctx, (int)0);
            if (systemClient == null) {
                throw new Exception(Msg.getMsg((Properties)this.ctx, (String)"XMLClientNotFound"));
            }
            this.log.info(systemClient.toString());
            expFormat = MEXPFormat.getFormatByValueAD_Client_IDAndVersion((Properties)this.ctx, (String)EXP_Format_Value, (int)systemClient.getAD_Client_ID(), (String)version, (String)trxName);
        }
        if (expFormat == null || expFormat.getEXP_Format_ID() == 0) {
            throw new Exception(Msg.getMsg((Properties)this.ctx, (String)"EXPFormatNotFound"));
        }
        this.log.info("expFormat = " + expFormat.toString());
        PO po = this.importElement(this.ctx, result, rootElement, expFormat, trxName);
        boolean resultSave = false;
        if (ReplicationEvent == 3 || ReplicationEvent == 9 || ReplicationEvent == 3) {
            resultSave = po.delete(true);
        } else if (ReplicationType.equals("M")) {
            po.saveReplica(true);
        } else {
            po.saveReplica(true);
        }
        result.append("ResultSave=").append(resultSave).append("; ");
    }

    private PO importElement(Properties ctx, StringBuffer result, Element rootElement, MEXPFormat expFormat, String trxName) throws Exception, XPathExpressionException {
        int AD_Table_ID = expFormat.getAD_Table_ID();
        MTable table2 = MTable.get((Properties)ctx, (int)AD_Table_ID);
        this.log.info("Table = " + table2);
        int record_ID = 0;
        String whereClause = "";
        if (table2.getKeyColumns().length == 1) {
            record_ID = this.getID(ctx, expFormat, rootElement, rootElement.getNodeName(), trxName);
            this.log.info("record_ID = " + record_ID);
        } else {
            whereClause = this.getID(ctx, expFormat, rootElement, rootElement.getNodeName(), trxName, true);
            this.log.info("WHERE = " + whereClause);
        }
        PO po = null;
        po = record_ID > 0 ? table2.getPO(record_ID, trxName) : (whereClause.length() > 0 ? table2.getPO(whereClause, trxName) : table2.getPO(record_ID, trxName));
        if (po == null) {
            throw new Exception(Msg.getMsg((Properties)ctx, (String)"Can't Load PO Object"));
        }
        this.log.info("PO.toString() = " + po.toString());
        if (po.get_KeyColumns().length < 1) {
            throw new Exception(Msg.getMsg((Properties)ctx, (String)"EDIMultiColumnNotSupported"));
        }
        StringBuffer orderBy = new StringBuffer("IsMandatory").append(" DESC ").append(", ").append("Position");
        List formatLinesTemp = expFormat.getFormatLinesOrderedBy(orderBy.toString());
        MEXPFormatLine[] formatLines = new MEXPFormatLine[formatLinesTemp.size()];
        formatLinesTemp.toArray(formatLines);
        if (formatLines == null || formatLines.length < 1) {
            throw new Exception(Msg.getMsg((Properties)ctx, (String)"EXPFormatNoLines"));
        }
        Object value = null;
        int i = 0;
        while (i < formatLines.length) {
            this.log.info("=================== Beginnig of Format Line ===============================");
            this.log.info("formatLines[" + i + "]=[" + formatLines[i].toString() + "]");
            if ("E".equals(formatLines[i].getType())) {
                value = XMLHelper.getString(formatLines[i].getValue(), rootElement);
                this.log.info("value=[" + value + "]");
            } else if ("R".equals(formatLines[i].getType())) {
                MEXPFormat referencedExpFormat = new MEXPFormat(ctx, formatLines[i].getEXP_EmbeddedFormat_ID(), trxName);
                this.log.info("referencedExpFormat = " + referencedExpFormat);
                int refRecord_ID = 0;
                String xPath = null;
                xPath = formatLines[i].getValue();
                this.log.info("SEARCH FOR XML Element = " + xPath);
                Element referencedNode = XMLHelper.getElement(xPath, rootElement);
                this.log.info("referencedNode = " + referencedNode);
                if (referencedNode != null) {
                    refRecord_ID = this.getID(ctx, referencedExpFormat, referencedNode, formatLines[i].getValue(), trxName);
                    this.log.info("refRecord_ID = " + refRecord_ID);
                    value = new Integer(refRecord_ID);
                } else {
                    this.log.info("NULL VALUE FOR " + xPath.toString());
                    value = null;
                }
                this.log.info("value=[" + value + "]");
            } else if ("M".equals(formatLines[i].getType())) {
                boolean resSave = false;
                if (po.get_ID() == 0) {
                    po.saveReplica(true);
                    resSave = true;
                    result.append("ResultSave-MasterPO=").append(resSave).append("; ");
                    this.log.info("ResultSave-MasterPO = " + resSave);
                } else {
                    resSave = true;
                }
                if (!resSave) {
                    throw new Exception("Failed to save Master PO");
                }
                MEXPFormat referencedExpFormat = new MEXPFormat(ctx, formatLines[i].getEXP_EmbeddedFormat_ID(), trxName);
                this.log.info("embeddedExpFormat = " + referencedExpFormat);
                NodeList nodeList = XMLHelper.getNodeList("/" + rootElement.getNodeName() + "/" + formatLines[i].getValue(), rootElement);
                int j = 0;
                while (j < nodeList.getLength()) {
                    Element referencedElement = (Element)nodeList.item(j);
                    this.log.info("EmbeddedEXPFormat - referencedElement.getNodeName = " + referencedElement.getNodeName());
                    PO embeddedPo = null;
                    this.log.info("=== BEGIN RECURSION CALL ===");
                    embeddedPo = this.importElement(ctx, result, referencedElement, referencedExpFormat, trxName);
                    this.log.info("embeddedPo = " + embeddedPo);
                    embeddedPo.saveReplica(true);
                    boolean rSave = true;
                    result.append("ResultSave-EmbeddedPO=").append(rSave).append("; ");
                    ++j;
                }
            } else if ("A".equals(formatLines[i].getType())) {
                value = XMLHelper.getString("@" + formatLines[i].getValue(), rootElement);
                this.log.info("value=[" + value + "]");
            } else {
                throw new Exception(Msg.getMsg((Properties)ctx, (String)"EXPFormatLineNonValidType"));
            }
            if (value != null && !"M".equals(formatLines[i].getType())) {
                MColumn column = MColumn.get((Properties)ctx, (int)formatLines[i].getAD_Column_ID());
                this.log.info("column=[" + column + "]");
                Class clazz = DisplayType.getClass((int)column.getAD_Reference_ID(), (boolean)true);
                if (column.getColumnName().equalsIgnoreCase("Posted") || column.getColumnName().equalsIgnoreCase("Processed") || column.getColumnName().equalsIgnoreCase("Processing")) {
                    clazz = Boolean.class;
                } else if (column.getColumnName().equalsIgnoreCase("Record_ID")) {
                    clazz = Integer.class;
                } else if (column.getColumnName().equalsIgnoreCase("AD_Language") || column.getColumnName().equalsIgnoreCase("EntityType")) {
                    clazz = String.class;
                }
                this.log.info("clazz = " + clazz.getName());
                value = this.handleDateTime(value, column, formatLines[i]);
                this.log.info("formatLinesType = " + formatLines[i].getType());
                if ("M".equals(formatLines[i].getType())) {
                    throw new Exception("We can't be here!!!");
                }
                if (column.getAD_Reference_ID() == 16 || column.getAD_Reference_ID() == 15) {
                    po.set_ValueOfColumn(formatLines[i].getAD_Column_ID(), value);
                    this.log.info("Set value of column [" + column.getColumnName() + "]=[" + value + "]");
                } else if (column.getAD_Reference_ID() == 13 || column.getAD_Reference_ID() == 11 || column.getAD_Reference_ID() == 30 || column.getAD_Reference_ID() == 19 || column.getAD_Reference_ID() == 18) {
                    if (!Util.isEmpty((String)value.toString())) {
                        int intValue = Integer.parseInt(value.toString());
                        value = new Integer(intValue);
                    } else {
                        value = null;
                    }
                    this.log.info("Abut to set int value of column [" + column.getColumnName() + "]=[" + value + "]");
                    po.set_ValueOfColumn(formatLines[i].getAD_Column_ID(), value);
                    this.log.info("Set int value of column [" + column.getColumnName() + "]=[" + value + "]");
                } else if (column.getAD_Reference_ID() == 12 || column.getAD_Reference_ID() == 22 || column.getAD_Reference_ID() == 37 || column.getAD_Reference_ID() == 29) {
                    if (!Util.isEmpty((String)value.toString())) {
                        double doubleValue = Double.parseDouble(value.toString());
                        value = new BigDecimal(doubleValue);
                    } else {
                        value = null;
                    }
                    this.log.info("About to set BigDecimal value of column [" + column.getColumnName() + "]=[" + value + "]");
                    po.set_ValueOfColumn(formatLines[i].getAD_Column_ID(), value);
                    this.log.info("Set BigDecimal value of column [" + column.getColumnName() + "]=[" + value + "]");
                } else if (column.getAD_Reference_ID() == 20) {
                    po.set_ValueOfColumn(formatLines[i].getAD_Column_ID(), value);
                } else if (column.getAD_Reference_ID() == 35) {
                    if (!Util.isEmpty((String)value.toString())) {
                        int intValue = Integer.parseInt(value.toString());
                        value = new Integer(intValue);
                    } else {
                        value = null;
                    }
                    this.log.info("Abut to set int value of column [" + column.getColumnName() + "]=[" + value + "]");
                    po.set_ValueOfColumn(formatLines[i].getAD_Column_ID(), value);
                } else {
                    try {
                        this.log.info("About to set value of column [" + column.getColumnName() + "]=[" + value + "]");
                        if (clazz == Boolean.class) {
                            po.set_ValueOfColumn(formatLines[i].getAD_Column_ID(), value);
                        } else {
                            po.set_ValueOfColumn(formatLines[i].getAD_Column_ID(), clazz.cast(value));
                        }
                        this.log.info("Set value of column [" + column.getColumnName() + "]=[" + value + "]");
                    }
                    catch (ClassCastException ex) {
                        ex.printStackTrace();
                        throw new Exception(ex);
                    }
                }
                result.append(column.getColumnName()).append("=").append(value).append("; ");
            }
            ++i;
        }
        return po;
    }

    public static MClient getAD_ClientByValue(Properties ctx, String value, String trxName) throws SQLException {
        MClient result = null;
        StringBuffer sql = new StringBuffer("SELECT AD_Client_ID ").append(" FROM ").append("AD_Client").append(" WHERE ").append("Value").append(" = ?");
        s_log.info("Client_Value =[" + value + "]");
        CPreparedStatement pstmt = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
                pstmt.setString(1, value);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    int AD_Client_ID = rs.getInt(1);
                    s_log.info("AD_Client_ID = " + AD_Client_ID);
                    result = new MClient(ctx, AD_Client_ID, trxName);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                throw e;
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        return result;
    }

    private PreparedStatement getIDValues(Properties ctx, MEXPFormat expFormat, Element rootElement, String rootNodeName, String trxName) throws Exception {
        if (expFormat == null || rootElement == null || rootNodeName == null) {
            throw new IllegalArgumentException("expFormat, rootNode and RootnodeName can't be null!");
        }
        this.log.info("expFormat = " + expFormat);
        this.log.info("rootNode.getNodeName() = " + rootElement.getNodeName());
        this.log.info("rootNodeName = " + rootNodeName);
        if (rootElement.getParentNode() != null) {
            this.log.info("rootNode.ParentName = " + rootElement.getParentNode().getNodeName());
        }
        int AD_Table_ID = expFormat.getAD_Table_ID();
        MTable table2 = MTable.get((Properties)ctx, (int)AD_Table_ID);
        this.log.info("Table = " + table2);
        StringBuffer sql = new StringBuffer("SELECT * ").append(" FROM ").append(table2.getTableName()).append(" WHERE ");
        Collection uniqueFormatLinesTemp = expFormat.getUniqueColumns();
        MEXPFormatLine[] uniqueFormatLines = new MEXPFormatLine[uniqueFormatLinesTemp.size()];
        uniqueFormatLinesTemp.toArray(uniqueFormatLines);
        if (uniqueFormatLines == null || uniqueFormatLines.length < 1) {
            throw new Exception(Msg.getMsg((Properties)ctx, (String)"EXPFormatLineNoUniqueColumns"));
        }
        Object[] values = new Object[uniqueFormatLines.length];
        int i = 0;
        while (i < uniqueFormatLines.length) {
            this.log.info("--- iterate unique column with index = [" + i + "]");
            MColumn column = MColumn.get((Properties)ctx, (int)uniqueFormatLines[i].getAD_Column_ID());
            this.log.info("column = [" + column + "]");
            String valuecol = column.getColumnName();
            if (column.getAD_Reference_ID() == 12 || column.getAD_Reference_ID() == 22 || column.getAD_Reference_ID() == 37 || column.getAD_Reference_ID() == 29) {
                valuecol = "Round(" + valuecol + ",2)";
            }
            if ("E".equals(uniqueFormatLines[i].getType())) {
                String xPath = null;
                xPath = uniqueFormatLines[i].getValue();
                values[i] = XMLHelper.getString(xPath, rootElement);
                this.log.info("values[" + i + "]=" + values[i]);
            } else if ("R".equals(uniqueFormatLines[i].getType())) {
                this.log.info("referencedExpFormat.EXP_EmbeddedFormat_ID = " + uniqueFormatLines[i].getEXP_EmbeddedFormat_ID());
                MEXPFormat referencedExpFormat = new MEXPFormat(ctx, uniqueFormatLines[i].getEXP_EmbeddedFormat_ID(), trxName);
                this.log.info("referencedExpFormat = " + referencedExpFormat);
                int record_ID = 0;
                Element referencedNode = (Element)rootElement.getElementsByTagName(uniqueFormatLines[i].getValue()).item(0);
                this.log.info("referencedNode = " + referencedNode);
                record_ID = this.getID(ctx, referencedExpFormat, referencedNode, uniqueFormatLines[i].getValue(), trxName);
                this.log.info("record_ID = " + record_ID);
                values[i] = new Integer(record_ID);
            } else {
                throw new Exception(Msg.getMsg((Properties)ctx, (String)"EXPFormatLineNonValidType"));
            }
            if (i == 0) {
                sql.append(" ").append(valuecol).append(" = ? ");
            } else {
                sql.append(" AND ").append(valuecol).append(" = ? ");
            }
            ++i;
        }
        this.log.info("sql = " + sql.toString());
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);
            int i2 = 0;
            while (i2 < uniqueFormatLines.length) {
                Object value;
                MColumn col = MColumn.get((Properties)ctx, (int)uniqueFormatLines[i2].getAD_Column_ID());
                if (col.getAD_Reference_ID() == 16 || col.getAD_Reference_ID() == 15) {
                    value = (Timestamp)this.handleDateTime(values[i2], col, uniqueFormatLines[i2]);
                    pstmt.setTimestamp(i2 + 1, (Timestamp)value);
                } else if (col.getAD_Reference_ID() == 10) {
                    value = (String)values[i2];
                    pstmt.setString(i2 + 1, (String)value);
                } else if (col.getAD_Reference_ID() == 12 || col.getAD_Reference_ID() == 22 || col.getAD_Reference_ID() == 37 || col.getAD_Reference_ID() == 29) {
                    value = new BigDecimal((String)values[i2]);
                    pstmt.setBigDecimal(i2 + 1, ((BigDecimal)value).setScale(2, 4));
                } else if (col.getAD_Reference_ID() == 11 || col.getAD_Reference_ID() == 13 || col.getAD_Reference_ID() == 19 || col.getAD_Reference_ID() == 18) {
                    String stringValue = "" + values[i2];
                    int value2 = Integer.parseInt(stringValue);
                    pstmt.setInt(i2 + 1, value2);
                    this.log.info("pstmt.setInt[" + (i2 + 1) + "] = [" + value2 + "]");
                } else {
                    pstmt.setObject(i2 + 1, values[i2]);
                    this.log.info("pstmt.setObject[" + (i2 + 1) + "] = [" + values[i2] + "]");
                }
                ++i2;
            }
            return pstmt;
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql.toString(), (Throwable)e);
            throw e;
        }
    }

    public int getID(Properties ctx, MEXPFormat expFormat, Element rootElement, String rootNodeName, String trxName) throws Exception {
        int result = 0;
        PreparedStatement pstmt = this.getIDValues(ctx, expFormat, rootElement, rootNodeName, trxName);
        try {
            int AD_Table_ID = expFormat.getAD_Table_ID();
            MTable table2 = MTable.get((Properties)ctx, (int)AD_Table_ID);
            String[] columns = table2.getKeyColumns();
            if (columns == null || columns.length != 1) {
                throw new Exception(Msg.getMsg((Properties)ctx, (String)"EXPFormatLineNoUniqueColumns"));
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(rs.findColumn(columns[0]));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        this.log.info("result = " + result);
        return result;
    }

    public String getID(Properties ctx, MEXPFormat expFormat, Element rootElement, String rootNodeName, String trxName, boolean multikey) throws Exception {
        String result = "";
        PreparedStatement pstmt = this.getIDValues(ctx, expFormat, rootElement, rootNodeName, trxName);
        try {
            int AD_Table_ID = expFormat.getAD_Table_ID();
            MTable table2 = MTable.get((Properties)ctx, (int)AD_Table_ID);
            String[] columns = table2.getKeyColumns();
            if (columns == null || columns.length <= 0) {
                throw new Exception(Msg.getMsg((Properties)ctx, (String)"EXPFormatNoIDs"));
            }
            this.log.warning("Multiple columns ID. Table = " + table2.getTableName() + " Columns=" + columns);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String[] stringArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    result = String.valueOf(result) + " AND " + column + " = " + rs.getInt(rs.findColumn(column));
                    ++n2;
                }
            }
            if (result.length() > 0) {
                result = result.substring(4);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        return result;
    }

    private Object handleDateTime(Object value, MColumn column, MEXPFormatLine formatLine) throws ParseException {
        String valueString = null;
        valueString = value.toString();
        Object result = value;
        if (column.getAD_Reference_ID() == 15) {
            if (valueString != null) {
                if (formatLine.getDateFormat() != null && !"".equals(formatLine.getDateFormat())) {
                    this.m_customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                    result = new Timestamp(this.m_customDateFormat.parse(valueString).getTime());
                    this.log.info("Custom Date Format; Parsed value = " + result.toString());
                } else {
                    result = valueString == null || valueString.length() <= 0 ? null : Timestamp.valueOf(valueString);
                }
            }
        } else if (column.getAD_Reference_ID() == 16 && valueString != null) {
            if (formatLine.getDateFormat() != null && !"".equals(formatLine.getDateFormat())) {
                this.m_customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                result = new Timestamp(this.m_customDateFormat.parse(valueString).getTime());
                this.log.info("Custom Date Format; Parsed value = " + result.toString());
            } else {
                result = Timestamp.valueOf(valueString);
            }
        }
        return result;
    }
}

