/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process.rpl.exp;

import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderTax;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportHelper {
    private static CLogger log = CLogger.getCLogger(ExportHelper.class);
    private Document outDocument = null;
    private SimpleDateFormat m_dateTimeFormat = null;
    private SimpleDateFormat m_dateFormat = null;
    private SimpleDateFormat m_customDateFormat = null;
    private int m_AD_Client_ID = -1;
    MReplicationStrategy m_rplStrategy = null;

    public ExportHelper(MClient client, MReplicationStrategy rplStrategy) {
        this.m_AD_Client_ID = client.getAD_Client_ID();
        this.m_rplStrategy = rplStrategy;
        this.m_dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)Language.getLanguage(Env.getAD_Language((Properties)client.getCtx())));
        this.m_dateFormat = DisplayType.getDateFormat((int)15, (Language)Language.getLanguage(Env.getAD_Language((Properties)client.getCtx())));
    }

    public ExportHelper(Properties ctx, int AD_Client_ID) {
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_dateTimeFormat = DisplayType.getDateFormat((int)16, (Language)Language.getLanguage(Env.getAD_Language((Properties)ctx)));
        this.m_dateFormat = DisplayType.getDateFormat((int)15, (Language)Language.getLanguage(Env.getAD_Language((Properties)ctx)));
    }

    public String exportRecord(PO po, Integer ReplicationMode, String ReplicationType, Integer ReplicationEvent) throws Exception {
        MClient client = MClient.get((Properties)po.getCtx(), (int)this.m_AD_Client_ID);
        log.info("Client = " + client.toString());
        log.info("po.getAD_Org_ID() = " + po.getAD_Org_ID());
        log.info("po.get_TrxName() = " + po.get_TrxName());
        if (po.get_TrxName() == null || po.get_TrxName().equals("")) {
            po.set_TrxName("exportRecord");
        }
        log.info("Table = " + po.get_TableName());
        if (po.get_KeyColumns().length < 1) {
            throw new Exception(Msg.getMsg((Properties)po.getCtx(), (String)"ExportNoneColumnKeyNotSupported"));
        }
        String version = "3.2.0";
        MEXPFormat exportFormat = null;
        exportFormat = MEXPFormat.getFormatByAD_Client_IDAD_Table_IDAndVersion((Properties)po.getCtx(), (int)this.m_AD_Client_ID, (int)po.get_Table_ID(), (String)version, (String)po.get_TrxName());
        log.fine("exportFormat = " + exportFormat);
        if (exportFormat == null || exportFormat.getEXP_Format_ID() == 0) {
            MClient systemClient = MClient.get((Properties)po.getCtx(), (int)0);
            log.info(systemClient.toString());
            exportFormat = MEXPFormat.getFormatByAD_Client_IDAD_Table_IDAndVersion((Properties)po.getCtx(), (int)0, (int)po.get_Table_ID(), (String)version, (String)po.get_TrxName());
            if (exportFormat == null || exportFormat.getEXP_Format_ID() == 0) {
                throw new Exception(Msg.getMsg((Properties)po.getCtx(), (String)"EXPFormatNotFound"));
            }
        }
        this.outDocument = this.createNewDocument();
        StringBuffer sql = new StringBuffer("SELECT * ").append("FROM ").append(po.get_TableName()).append(" ").append("WHERE ").append(po.get_KeyColumns()[0]).append("=?");
        if (exportFormat.getWhereClause() != null & !"".equals(exportFormat.getWhereClause())) {
            sql.append(" AND ").append(exportFormat.getWhereClause());
        }
        boolean found = false;
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)po.get_TrxName());
            pstmt.setInt(1, po.get_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
                Element rootElement = this.outDocument.createElement(exportFormat.getValue());
                if (exportFormat.getDescription() != null && !"".equals(exportFormat.getDescription())) {
                    rootElement.appendChild(this.outDocument.createComment(exportFormat.getDescription()));
                }
                rootElement.setAttribute("AD_Client_Value", client.getValue());
                rootElement.setAttribute("Version", exportFormat.getVersion());
                rootElement.setAttribute("ReplicationMode", ReplicationMode.toString());
                rootElement.setAttribute("ReplicationType", ReplicationType);
                rootElement.setAttribute("ReplicationEvent", ReplicationEvent.toString());
                this.outDocument.appendChild(rootElement);
                this.generateExportFormat(rootElement, exportFormat, rs, po, po.get_ID(), variableMap);
                found = true;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sQLException) {}
            rs = null;
            pstmt = null;
        }
        try {
            if (found) {
                this.process(po, this.outDocument, (String)client.get_Value("Host"));
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            throw e;
        }
        try {
            int m_AD_ReplicationStrategy_ID;
            Object[] lines;
            if (po.get_TableName().equals("C_Invoice") && found) {
                MInvoice inv = MInvoice.get(po.getCtx(), po.get_ID());
                lines = inv.getLines(false);
                m_AD_ReplicationStrategy_ID = client.getAD_ReplicationStrategy_ID();
                int i = 0;
                while (i < lines.length) {
                    this.exportRecord(lines[i], 0, MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)m_AD_ReplicationStrategy_ID, (int)po.get_Table_ID()).getReplicationType(), 2);
                    ++i;
                }
                MInvoiceTax[] tlines = inv.getTaxes(true);
                int i2 = 0;
                while (i2 < tlines.length) {
                    this.exportRecord((PO)((Object)tlines[i2]), 0, MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)m_AD_ReplicationStrategy_ID, (int)po.get_Table_ID()).getReplicationType(), 2);
                    ++i2;
                }
                if (inv.getPaymentRule().equals("B")) {
                    MCashLine cline = new MCashLine(po.getCtx(), inv.getC_CashLine_ID(), po.get_TrxName());
                    this.exportRecord((PO)((Object)cline), 0, MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)m_AD_ReplicationStrategy_ID, (int)po.get_Table_ID()).getReplicationType(), 2);
                }
            }
            if (po.get_TableName().equals("C_Order") && found) {
                MOrder ord = new MOrder(po.getCtx(), po.get_ID(), po.get_TrxName());
                lines = ord.getLines();
                m_AD_ReplicationStrategy_ID = client.getAD_ReplicationStrategy_ID();
                int i = 0;
                while (i < lines.length) {
                    this.exportRecord(lines[i], 0, MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)m_AD_ReplicationStrategy_ID, (int)po.get_Table_ID()).getReplicationType(), 2);
                    ++i;
                }
                MOrderTax[] tlines = ord.getTaxes(true);
                int i3 = 0;
                while (i3 < lines.length) {
                    this.exportRecord((PO)tlines[i3], 0, MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)m_AD_ReplicationStrategy_ID, (int)po.get_Table_ID()).getReplicationType(), 2);
                    ++i3;
                }
            }
        }
        catch (Exception e) {
            log.severe(e.toString());
            throw e;
        }
        return this.outDocument.toString();
    }

    public Document exportRecord(MEXPFormat exportFormat, String where, Integer ReplicationMode, String ReplicationType, Integer ReplicationEvent) throws Exception {
        int[] ids;
        MClient client = MClient.get((Properties)exportFormat.getCtx(), (int)this.m_AD_Client_ID);
        MTable table2 = MTable.get((Properties)exportFormat.getCtx(), (int)exportFormat.getAD_Table_ID());
        log.info("Table = " + table2);
        int[] nArray = ids = MTable.getAllIDs((String)table2.getTableName(), (String)where, null);
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            PO po = table2.getPO(id, null);
            log.info("Client = " + client.toString());
            log.finest("po.getAD_Org_ID() = " + po.getAD_Org_ID());
            log.finest("po.get_TrxName() = " + po.get_TrxName());
            if (po.get_TrxName() == null || po.get_TrxName().equals("")) {
                po.set_TrxName("exportRecord");
            }
            if (po.get_KeyColumns().length > 1 || po.get_KeyColumns().length < 1) {
                throw new Exception(Msg.getMsg((Properties)po.getCtx(), (String)"ExportMultiColumnNotSupported"));
            }
            String version = "3.2.0";
            this.outDocument = this.createNewDocument();
            StringBuffer sql = new StringBuffer("SELECT * ").append("FROM ").append(table2.getTableName()).append(" ").append("WHERE ").append(po.get_KeyColumns()[0]).append("=?");
            if (exportFormat.getWhereClause() != null & !"".equals(exportFormat.getWhereClause())) {
                sql.append(" AND ").append(exportFormat.getWhereClause());
            }
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)po.get_TrxName());
                pstmt.setInt(1, po.get_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
                    Element rootElement = this.outDocument.createElement(exportFormat.getValue());
                    if (exportFormat.getDescription() != null && !"".equals(exportFormat.getDescription())) {
                        rootElement.appendChild(this.outDocument.createComment(exportFormat.getDescription()));
                    }
                    rootElement.setAttribute("AD_Client_Value", client.getValue());
                    rootElement.setAttribute("Version", exportFormat.getVersion());
                    rootElement.setAttribute("ReplicationMode", ReplicationMode.toString());
                    rootElement.setAttribute("ReplicationType", ReplicationType);
                    rootElement.setAttribute("ReplicationEvent", ReplicationEvent.toString());
                    this.outDocument.appendChild(rootElement);
                    this.generateExportFormat(rootElement, exportFormat, rs, po, po.get_ID(), variableMap);
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (SQLException sQLException) {}
                rs = null;
                pstmt = null;
            }
            ++n2;
        }
        return this.outDocument;
    }

    private void generateExportFormat(Element rootElement, MEXPFormat exportFormat, ResultSet rs, PO masterPO, int masterID, HashMap<String, Integer> variableMap) throws SQLException, Exception {
        List formatLinesTemp = exportFormat.getFormatLines();
        MEXPFormatLine[] formatLines = new MEXPFormatLine[formatLinesTemp.size()];
        formatLinesTemp.toArray(formatLines);
        boolean elementHasValue = false;
        int i = 0;
        while (i < formatLines.length) {
            if (formatLines[i].getType().equals("E")) {
                Text newText;
                Element newElement = this.outDocument.createElement(formatLines[i].getValue());
                if (formatLines[i].getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                MColumn column = MColumn.get((Properties)masterPO.getCtx(), (int)formatLines[i].getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    log.info("This is Virtual Column!");
                }
                Object value = rs.getObject(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else {
                    formatLines[i].isMandatory();
                }
                if (column.getAD_Reference_ID() == 15) {
                    if (valueString != null) {
                        if (formatLines[i].getDateFormat() != null && !"".equals(formatLines[i].getDateFormat())) {
                            this.m_customDateFormat = new SimpleDateFormat(formatLines[i].getDateFormat());
                            valueString = this.m_customDateFormat.format(Timestamp.valueOf(valueString));
                            newElement.setAttribute("DateFormat", this.m_customDateFormat.toPattern());
                        } else {
                            newElement.setAttribute("DateFormat", valueString);
                        }
                    }
                } else if (column.getAD_Reference_ID() == 16 && valueString != null) {
                    if (formatLines[i].getDateFormat() != null && !"".equals(formatLines[i].getDateFormat())) {
                        this.m_customDateFormat = new SimpleDateFormat(formatLines[i].getDateFormat());
                        valueString = this.m_customDateFormat.format(Timestamp.valueOf(valueString));
                        newElement.setAttribute("DateFormat", this.m_customDateFormat.toPattern());
                    } else {
                        newElement.setAttribute("DateFormat", valueString);
                    }
                }
                log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + value);
                if (valueString != null && !"".equals(valueString) && !"null".equals(valueString)) {
                    newText = this.outDocument.createTextNode(valueString);
                    newElement.appendChild(newText);
                    rootElement.appendChild(newElement);
                    elementHasValue = true;
                } else if (formatLines[i].isMandatory()) {
                    newText = this.outDocument.createTextNode("");
                    newElement.appendChild(newText);
                    rootElement.appendChild(newElement);
                    elementHasValue = true;
                }
            } else if (formatLines[i].getType().equals("A")) {
                if (formatLines[i].getAD_Column_ID() == 0) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                MColumn column = MColumn.get((Properties)masterPO.getCtx(), (int)formatLines[i].getAD_Column_ID());
                if (column == null) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                }
                if (column.isVirtualColumn()) {
                    log.info("This is Virtual Column!");
                }
                Object value = rs.getObject(column.getColumnName());
                String valueString = null;
                if (value != null) {
                    valueString = value.toString();
                } else if (formatLines[i].isMandatory()) {
                    throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPFieldMandatory"));
                }
                log.info("EXP Field - column=[" + column.getColumnName() + "]; value=" + value);
                if (valueString != null && !"".equals(valueString) && !"null".equals(valueString)) {
                    rootElement.setAttribute(formatLines[i].getValue(), valueString);
                    elementHasValue = true;
                }
            } else {
                StringBuffer sql;
                MTable tableEmbedded;
                MEXPFormat embeddedFormat;
                if (formatLines[i].getType().equals("M")) {
                    int embeddedFormat_ID = formatLines[i].getEXP_EmbeddedFormat_ID();
                    embeddedFormat = new MEXPFormat(masterPO.getCtx(), embeddedFormat_ID, masterPO.get_TrxName());
                    tableEmbedded = MTable.get((Properties)masterPO.getCtx(), (int)embeddedFormat.getAD_Table_ID());
                    log.info("Table Embedded = " + tableEmbedded);
                    sql = new StringBuffer("SELECT * ").append("FROM ").append(tableEmbedded.getTableName()).append(" ").append("WHERE ").append(masterPO.get_KeyColumns()[0]).append("=?");
                    if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                        sql.append(" AND ").append(embeddedFormat.getWhereClause());
                    }
                    log.info("EmbeddedEXPFormat:" + sql.toString());
                    ResultSet rsEmbedded = null;
                    CPreparedStatement pstmt = null;
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)masterPO.get_TrxName());
                        pstmt.setInt(1, masterID);
                        rsEmbedded = pstmt.executeQuery();
                        while (rsEmbedded.next()) {
                            int embeddedID = rsEmbedded.getInt(String.valueOf(tableEmbedded.getTableName()) + "_ID");
                            PO poEmbedded = tableEmbedded.getPO(embeddedID, masterPO.get_TrxName());
                            Element embeddedElement = this.outDocument.createElement(formatLines[i].getValue());
                            if (formatLines[i].getDescription() != null && !"".equals(formatLines[i].getDescription())) {
                                embeddedElement.appendChild(this.outDocument.createComment(formatLines[i].getDescription()));
                            }
                            this.generateExportFormat(embeddedElement, embeddedFormat, rsEmbedded, poEmbedded, embeddedID, variableMap);
                            rootElement.appendChild(embeddedElement);
                        }
                    }
                    finally {
                        try {
                            if (rsEmbedded != null) {
                                rsEmbedded.close();
                            }
                            if (pstmt != null) {
                                pstmt.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                        rsEmbedded = null;
                        pstmt = null;
                    }
                }
                if (formatLines[i].getType().equals("R")) {
                    int embeddedFormat_ID = formatLines[i].getEXP_EmbeddedFormat_ID();
                    embeddedFormat = new MEXPFormat(masterPO.getCtx(), embeddedFormat_ID, masterPO.get_TrxName());
                    tableEmbedded = MTable.get((Properties)masterPO.getCtx(), (int)embeddedFormat.getAD_Table_ID());
                    log.info("Table Embedded = " + tableEmbedded);
                    sql = new StringBuffer("SELECT * ").append("FROM ").append(tableEmbedded.getTableName()).append(" ").append("WHERE ").append(String.valueOf(tableEmbedded.getTableName()) + "_ID").append("=?");
                    if (embeddedFormat.getWhereClause() != null & !"".equals(embeddedFormat.getWhereClause())) {
                        sql.append(" AND ").append(embeddedFormat.getWhereClause());
                    }
                    log.info(sql.toString());
                    if (formatLines[i].getAD_Column_ID() == 0) {
                        throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                    }
                    MColumn column = MColumn.get((Properties)masterPO.getCtx(), (int)formatLines[i].getAD_Column_ID());
                    if (column == null) {
                        throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPColumnMandatory"));
                    }
                    if (column.isVirtualColumn()) {
                        log.info("This is Virtual Column!");
                    }
                    Object value = rs.getObject(column.getColumnName());
                    log.info(sql.toString());
                    ResultSet rsEmbedded = null;
                    CPreparedStatement pstmt = null;
                    try {
                        pstmt = DB.prepareStatement((String)sql.toString(), (String)masterPO.get_TrxName());
                        pstmt.setObject(1, value);
                        rsEmbedded = pstmt.executeQuery();
                        while (rsEmbedded.next()) {
                            int embeddedID = rsEmbedded.getInt(String.valueOf(tableEmbedded.getTableName()) + "_ID");
                            PO poEmbedded = tableEmbedded.getPO(embeddedID, masterPO.get_TrxName());
                            Element embeddedElement = this.outDocument.createElement(formatLines[i].getValue());
                            if (formatLines[i].getDescription() != null && !"".equals(formatLines[i].getDescription())) {
                                embeddedElement.appendChild(this.outDocument.createComment(formatLines[i].getDescription()));
                            }
                            this.generateExportFormat(embeddedElement, embeddedFormat, rsEmbedded, poEmbedded, embeddedID, variableMap);
                            rootElement.appendChild(embeddedElement);
                        }
                    }
                    finally {
                        try {
                            if (rsEmbedded != null) {
                                rsEmbedded.close();
                            }
                            if (pstmt != null) {
                                pstmt.close();
                            }
                        }
                        catch (SQLException sQLException) {}
                        rsEmbedded = null;
                        pstmt = null;
                    }
                }
                throw new Exception(Msg.getMsg((Properties)masterPO.getCtx(), (String)"EXPUnknownLineType"));
            }
            ++i;
        }
    }

    private void increaseVariable(HashMap<String, Integer> variableMap, String variableName) {
        if (variableName != null && !"".equals(variableName)) {
            Integer var = variableMap.get(variableName);
            if (var == null) {
                var = new Integer(0);
            }
            int intValue = var;
            variableMap.put(variableName, new Integer(++intValue));
        }
    }

    Document createNewDocument() throws ParserConfigurationException {
        Document result = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        result = documentBuilder.newDocument();
        return result;
    }

    public void process(PO po, Document document, String hostname) throws Exception {
        CPreparedStatement pstmt = null;
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult dest2 = new StreamResult(writer);
        transformer.transform(src, dest2);
        log.fine(((Object)writer).toString());
        String sql = "insert into OFB_RplExp(AD_Client_ID,AD_Org_ID, isActive,TableName,Record_ID,XML,Created,serverhost)Values (?,?,'Y',?,?,?,?,?)";
        pstmt = DB.prepareStatement((String)sql, (String)po.get_TrxName());
        pstmt.setInt(1, po.getAD_Client_ID());
        pstmt.setInt(2, po.getAD_Org_ID());
        pstmt.setString(3, po.get_TableName());
        pstmt.setInt(4, po.get_ID());
        pstmt.setString(5, ((Object)writer).toString());
        Timestamp created = new Timestamp(TimeUtil.getToday().getTimeInMillis());
        pstmt.setTimestamp(6, created);
        pstmt.setString(7, hostname);
        pstmt.executeUpdate();
        try {
            DB.commit((boolean)false, (String)po.get_TrxName());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }
}

