/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class RequisitionConsolidateLines
extends SvrProcess {
    private int Record_ID;
    private int p_AD_User_ID = 0;
    private BigDecimal p_TotalLines_From = null;
    private BigDecimal p_TotalLines_To = null;
    private Timestamp p_DateDoc_From = null;
    private Timestamp p_DateDoc_To = null;

    protected void prepare() {
        this.Record_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_User_ID")) {
                this.p_AD_User_ID = para[i].getParameterAsInt();
            } else if (name.equals("TotalLines")) {
                this.p_TotalLines_From = (BigDecimal)para[i].getParameter();
                this.p_TotalLines_To = (BigDecimal)para[i].getParameter_To();
            } else if (name.equals("DateDoc")) {
                this.p_DateDoc_From = (Timestamp)para[i].getParameter();
                this.p_DateDoc_To = (Timestamp)para[i].getParameter_To();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int i;
        block14: {
            MRequisition rq = new MRequisition(this.getCtx(), this.Record_ID, this.get_TrxName());
            i = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "select rl.Description,rl.Qty,rl.M_Product_ID,rl.m_requisitionline_id,rl.C_Charge_ID  from adempiere.m_requisitionline rl inner join m_requisition r on (rl.m_requisition_id=r.m_requisition_id) inner join c_doctype d on (r.c_doctype_id=d.c_doctype_id) where rl.isactive='Y' and r.docstatus='CO' and d.docbasetype='PRT' and r.ad_org_id=?";
            if (this.p_AD_User_ID > 0) {
                sql = String.valueOf(sql) + " and ad_user_id = ? ";
            }
            if (this.p_DateDoc_To != null && this.p_DateDoc_From != null) {
                sql = String.valueOf(sql) + " and datedoc between ? and ?";
            }
            if (this.p_TotalLines_From.compareTo(Env.ZERO) > 0 && this.p_TotalLines_To.compareTo(Env.ZERO) > 0) {
                sql = String.valueOf(sql) + " and totallines between ? and ?";
            }
            sql = String.valueOf(sql) + " and rl.m_requisitionline_ID NOT IN (SELECT coalesce(rl2.m_requisitionparent_id,0) FROM m_requisitionline rl2  where rl2.isactive='Y' )";
            boolean validUser = false;
            boolean validDate = false;
            int index = 2;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, rq.getAD_Org_ID());
                    if (this.p_AD_User_ID > 0) {
                        pstmt.setInt(index, this.p_AD_User_ID);
                        ++index;
                    }
                    if (this.p_DateDoc_To != null && this.p_DateDoc_From != null) {
                        pstmt.setTimestamp(index, this.p_DateDoc_From);
                        pstmt.setTimestamp(index + 1, this.p_DateDoc_To);
                        index += 2;
                    }
                    if (this.p_TotalLines_From.compareTo(Env.ZERO) > 0 && this.p_TotalLines_To.compareTo(Env.ZERO) > 0) {
                        pstmt.setBigDecimal(index, this.p_TotalLines_From);
                        pstmt.setBigDecimal(index + 1, this.p_TotalLines_To);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MRequisitionLine line = new MRequisitionLine(rq);
                        line.setDescription(rs.getString("Description"));
                        line.setQty(rs.getBigDecimal("Qty"));
                        line.setM_Product_ID(rs.getInt("M_Product_ID"));
                        line.setC_Charge_ID(rs.getInt("C_Charge_ID"));
                        try {
                            line.set_CustomColumn("M_RequisitionParent_ID", rs.getInt("m_requisitionline_id"));
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                        }
                        line.save();
                        ++i;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    rs.close();
                    pstmt.close();
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                rs.close();
                pstmt.close();
                rs = null;
                pstmt = null;
                throw throwable;
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        return "Copiadas " + i;
    }
}

