/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_PM_Approval;
import org.compiere.model.X_PM_Proposal;
import org.compiere.model.X_PM_Scoring;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessPMApproval
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        X_PM_Approval App = new X_PM_Approval(Env.getCtx(), this.Record_ID, this.get_TrxName());
        if (this.P_DocAction.equals("CO") && !App.isProcessed()) {
            if (this.getPending(App.getPM_Tender_ID()) > 0) {
                return "Aun quedan proyectos pendientes sin aprobar o rechazar";
            }
            if (this.getApproved(App.getPM_Tender_ID()) > 0) {
                X_PM_Proposal Pro = this.getProposal();
                if (Pro == null) {
                    Pro = new X_PM_Proposal(Env.getCtx(), 0, this.get_TrxName());
                    Pro.setAD_Org_ID(App.getAD_Org_ID());
                    Pro.setDateTrx(App.getDateTrx());
                    Pro.setPM_Approval_ID(App.getPM_Approval_ID());
                    Pro.setPM_Tender_ID(App.getPM_Tender_ID());
                    Pro.setDocStatus("DR");
                    Pro.save();
                } else {
                    Pro.setDocStatus("DR");
                    Pro.save();
                }
            }
            App.setProcessed(true);
            App.setDocStatus("CO");
            App.save();
            DB.executeUpdate((String)("update c_project set  CommittedAmt=PlannedAmt   where isapproved='Y' and PM_Tender_ID=" + App.getPM_Tender_ID()), (String)this.get_TrxName());
            DB.executeUpdate((String)("update c_projectline set CommittedAmt=Plannedprice where c_project_id IN (select c_project_id from c_project where pm_tender_id = " + App.getPM_Tender_ID() + ")"), (String)this.get_TrxName());
            return "Confirmado";
        }
        if (this.P_DocAction.equals("RJ") && !App.isProcessed() && App.getDocStatus().equals("DR")) {
            X_PM_Scoring Score = new X_PM_Scoring(Env.getCtx(), App.getPM_Scoring_ID(), this.get_TrxName());
            Score.setDocStatus("NA");
            Score.setProcessed(false);
            Score.save();
            App.setProcessed(false);
            App.setDocStatus("WC");
            App.save();
            return "Evaluacion Rechazada";
        }
        return "No es posible Cumplir la Accion ";
    }

    public X_PM_Proposal getProposal() {
        CPreparedStatement pstmt = null;
        X_PM_Proposal Pro = null;
        String mysql = "SELECT * from PM_Proposal where PM_Approval_ID = ?";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, this.Record_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Pro = new X_PM_Proposal(Env.getCtx(), rs, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return Pro;
    }

    public int getApproved(int Tender_ID) {
        int count = 0;
        CPreparedStatement pstmt = null;
        String mysql = "SELECT count(1) from c_project where isapproved='Y' and pm_tender_id = ?";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, Tender_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return count;
    }

    public int getPending(int Tender_ID) {
        int count = 0;
        CPreparedStatement pstmt = null;
        String mysql = "SELECT count(1) from c_project where isapproved='N' and isrejected='N' and score>=60 and pm_tender_id = ?";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, Tender_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return count;
    }
}

