/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_RH_AdministrativeRequests;
import org.compiere.model.X_RH_HoursAvailable;
import org.compiere.model.X_RH_HoursUsedDetail;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessAdministrativeRequestsMINJU
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        X_RH_AdministrativeRequests doc = new X_RH_AdministrativeRequests(Env.getCtx(), this.Record_ID, this.get_TrxName());
        if (this.P_DocAction.equals("IP") && !doc.isProcessed()) {
            doc.setProcessed(true);
            doc.setDocStatus("IP");
            doc.save();
            return "Procesado";
        }
        if (this.P_DocAction.equals("CO") && !doc.isProcessed()) {
            BigDecimal afterQty;
            Timestamp dateRequestCalc = doc.getdateendrequest();
            if (doc.getRequestType().equals("TAH")) {
                X_RH_HoursAvailable ha = new X_RH_HoursAvailable(this.getCtx(), 0, this.get_TrxName());
                ha.setAD_Org_ID(doc.getAD_Org_ID());
                ha.setC_BPartner_ID(doc.getC_BPartner_ID());
                ha.sethours((BigDecimal)doc.get_Value("hours"));
                ha.setDateExpiration(doc.getdateendrequest());
                ha.setHoursAvailable((BigDecimal)doc.get_Value("hours"));
                ha.setHoursUsed(Env.ZERO);
                ha.setRH_AdministrativeRequests_ID(doc.get_ID());
                ha.save();
                Calendar startCal = Calendar.getInstance();
                startCal.setTime(dateRequestCalc);
                startCal.add(1, -2);
                dateRequestCalc.setTime(startCal.getTimeInMillis());
            }
            if (doc.getRequestType().equals("TMH")) {
                BigDecimal cantH = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT SUM(hoursavailable)  FROM RH_HoursAvailable WHERE HoursAvailable > 0 AND C_BPartner_ID = " + doc.getC_BPartner_ID() + " AND DateExpiration >= ? "), (Object[])new Object[]{doc.getdateendrequest()});
                BigDecimal hoursToDiscount = (BigDecimal)doc.get_Value("hours");
                if (hoursToDiscount.compareTo(cantH) > 0) {
                    throw new AdempiereException("No Existen Horas Disponibles Suficientes. Horas Disponibles: " + cantH);
                }
                String sql = "SELECT hoursavailable,dateexpiration, RH_HoursAvailable_ID  FROM RH_HoursAvailable  WHERE HoursAvailable > 0 AND C_BPartner_ID = ?  AND DateExpiration >= ? ORDER BY DateExpiration";
                CPreparedStatement pstmt = null;
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, doc.getC_BPartner_ID());
                    pstmt.setTimestamp(2, doc.getdateendrequest());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next() && hoursToDiscount.compareTo(Env.ZERO) > 0) {
                        X_RH_HoursUsedDetail uDet;
                        X_RH_HoursAvailable haTo = new X_RH_HoursAvailable(this.getCtx(), rs.getInt("RH_HoursAvailable_ID"), this.get_TrxName());
                        if (rs.getBigDecimal("hoursavailable").compareTo(hoursToDiscount) >= 0) {
                            haTo.setHoursUsed(haTo.getHoursUsed().add(hoursToDiscount));
                            haTo.setHoursAvailable(haTo.gethours().subtract(haTo.getHoursUsed()));
                            uDet = new X_RH_HoursUsedDetail(this.getCtx(), 0, this.get_TrxName());
                            uDet.setAD_Org_ID(doc.getAD_Org_ID());
                            uDet.setIsActive(true);
                            uDet.setRH_AdministrativeRequests_ID(doc.get_ID());
                            uDet.sethours(hoursToDiscount);
                            uDet.setRH_HoursAvailable_ID(haTo.get_ID());
                            uDet.setDescription("Generado Automaticamente");
                            uDet.save();
                            hoursToDiscount = Env.ZERO;
                        } else {
                            haTo.setHoursUsed(haTo.getHoursUsed().add(rs.getBigDecimal("hoursavailable")));
                            uDet = new X_RH_HoursUsedDetail(this.getCtx(), 0, this.get_TrxName());
                            uDet.setAD_Org_ID(doc.getAD_Org_ID());
                            uDet.setIsActive(true);
                            uDet.setRH_AdministrativeRequests_ID(doc.get_ID());
                            uDet.sethours(rs.getBigDecimal("hoursavailable"));
                            uDet.setRH_HoursAvailable_ID(haTo.get_ID());
                            uDet.setDescription("Generado Automaticamente");
                            uDet.save();
                            haTo.setHoursAvailable(haTo.gethours().subtract(haTo.getHoursUsed()));
                            hoursToDiscount = hoursToDiscount.subtract(rs.getBigDecimal("hoursavailable"));
                        }
                        haTo.save();
                    }
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
                dateRequestCalc = doc.getdateendrequest();
            }
            this.commitEx();
            if (dateRequestCalc == null) {
                dateRequestCalc = doc.getdateendrequest();
            }
            if ((afterQty = DB.getSQLValueBD((String)this.get_TrxName(), (String)("SELECT SUM(hoursavailable)  FROM RH_HoursAvailable WHERE C_BPartner_ID = " + doc.getC_BPartner_ID() + " AND DateExpiration >= ? "), (Object[])new Object[]{dateRequestCalc})) != null && afterQty.compareTo(Env.ZERO) > 0) {
                doc.set_CustomColumn("HoursAvailable", afterQty);
            }
            doc.setProcessed(true);
            doc.setDocStatus("CO");
            doc.save();
            return "Completado";
        }
        if (this.P_DocAction.equals("VO")) {
            doc.setProcessed(true);
            doc.setDocStatus("VO");
            doc.save();
            return "Anulado";
        }
        return "No es posible Cumplir la Accion ";
    }
}

