/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.X_RH_AdministrativeRequests;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ProcessAdministrativeRequests
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        X_RH_AdministrativeRequests doc = new X_RH_AdministrativeRequests(Env.getCtx(), this.Record_ID, this.get_TrxName());
        if (doc.getRequestType().equals("CMT") || doc.getRequestType().equals("JIN") || doc.getRequestType().equals("PFF") || doc.getRequestType().equals("PPM") || doc.getRequestType().equals("PFF") || doc.getRequestType().equals("PSS") || doc.getRequestType().equals("PSD") || doc.getRequestType().equals("SVC") || doc.getRequestType().equals("SHE")) {
            String sqlValidPeriod = "SELECT MAX(CPC.periodStatus) FROM C_Period CP INNER JOIN C_PeriodControl CPC ON (CP.C_Period_ID = CPC.C_Period_ID) WHERE ? between startdate and (endDate + '23 hour'::interval + '59 minutes'::interval +'59 seconds'::interval)::timestamp without time zone AND DocBaseType = 'SOO'";
            String periodStatus = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlValidPeriod, (Object[])new Object[]{doc.getdatestartrequest()});
            if (!periodStatus.equalsIgnoreCase("O")) {
                throw new AdempiereException("No se puede procesar la solicitud. Periodo Cerrado");
            }
        }
        String sqlValid = "SELECT COUNT(DISTINCT (ar.rh_administrativerequests_ID)) FROM rh_administrativerequests  ar LEFT JOIN RH_AdministrativeRequestsLine arl on (ar.rh_administrativerequests_ID = arl.rh_administrativerequests_ID ) WHERE ( \t( ? >= ar.datestartrequest \t  AND \t  ? <= ar.dateendrequest \t) \tOR \t( ? >= ar.datestartrequest \t  AND      ? <= ar.dateendrequest \t) ) AND ar.c_bpartner_id = ? AND ar.requesttype = 'CMT' AND ar.rh_administrativerequests_ID <> ? AND ar.IsActive = 'Y' AND ar.DocStatus not in ('VO') AND arl.C_City_ID IN \t(SELECT C_City_ID FROM RH_AdministrativeRequestsLine WHERE rh_administrativerequests_ID = ?)";
        int cantValid = DB.getSQLValue((String)this.get_TrxName(), (String)sqlValid, (Object[])new Object[]{doc.getdatestartrequest(), doc.getdatestartrequest(), doc.getdateendrequest(), doc.getdateendrequest(), doc.getC_BPartner_ID(), doc.get_ID(), doc.get_ID()});
        if (doc.getRequestType().equals("CMT") && cantValid > 0) {
            return "No se puede procesar el cometido, existen " + cantValid + " cometidos en conflicto";
        }
        if (this.P_DocAction.equals("IP") && !doc.isProcessed()) {
            doc.setProcessed(true);
            doc.setDocStatus("IP");
            doc.save();
            return "Procesado";
        }
        if (this.P_DocAction.equals("CO") && (!doc.isProcessed() || doc.getDocStatus().equals("IP"))) {
            BigDecimal dd;
            MBPartner bp;
            String TypeSHE;
            if (doc.getRequestType().equals("SHE") && (TypeSHE = doc.get_ValueAsString("TypeSHE")).equals("TC")) {
                BigDecimal hh25 = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select trunc( CAST((sum(extract('epoch' from (endtime - starttime))/60)/60) as numeric) ,1) from RH_AdministrativeRequestsLine  where  RH_AdministrativeRequests_ID=? and Percentage='25'", (int)doc.getAdministrativeRequests_ID());
                hh25 = hh25 != null && hh25.signum() > 0 ? hh25.multiply(new BigDecimal("1.25")) : Env.ZERO;
                BigDecimal hh50 = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select trunc( CAST((sum(extract('epoch' from (endtime - starttime))/60)/60) as numeric) ,1) from RH_AdministrativeRequestsLine  where  RH_AdministrativeRequests_ID=? and Percentage='50'", (int)doc.getAdministrativeRequests_ID());
                hh50 = hh50 != null && hh50.signum() > 0 ? hh50.multiply(new BigDecimal("1.5")) : Env.ZERO;
                BigDecimal hh = hh25.add(hh50);
                MBPartner bp2 = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                bp2.set_CustomColumn("numberhours", ((BigDecimal)bp2.get_Value("numberhours")).add(hh.setScale(1, 1)));
                bp2.save();
            }
            if (doc.getRequestType().equals("PEF")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select extract(days from(dateendrequest-datestartrequest)) from RH_AdministrativeRequests where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                bp.set_CustomColumn("RH_AcumulateDays", ((BigDecimal)bp.get_Value("RH_AcumulateDays")).subtract(dd));
                bp.save();
            }
            if (doc.getRequestType().equals("SVC")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select NumberDays from RH_AdministrativeRequests where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                BigDecimal SVCep = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select coalesce ((sum(NumberDays)),0) from RH_AdministrativeRequests ar where ar.requesttype like 'SVC' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y' and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantSVC = (BigDecimal)bp.get_Value("RH_AcumulateDays");
                if (dd.add(SVCep).compareTo(cantSVC) > 0) {
                    return "Dias Legales Disponibles Insuficientes";
                }
                bp.set_CustomColumn("RH_AcumulateDays", ((BigDecimal)bp.get_Value("RH_AcumulateDays")).subtract(dd));
                bp.save();
            }
            if (doc.getRequestType().equals("PFF") || doc.getRequestType().equals("PPM")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select extract(days from(dateendrequest-datestartrequest)) from RH_AdministrativeRequests where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                bp.set_CustomColumn("RH_AdicionalDays", ((BigDecimal)bp.get_Value("RH_AcumulateDays")).subtract(dd));
                bp.set_CustomColumn("RH_ExpirationAdD", TimeUtil.addDays(null, (int)7));
                bp.save();
            }
            if (doc.getRequestType().equals("SVP")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                bp.set_CustomColumn("RH_LegalyDays", doc.get_Value("NumberDays"));
                bp.save();
            }
            if (doc.getRequestType().equals("STV")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                bp.set_CustomColumn("RH_AcumulateDays", doc.get_Value("NumberDays"));
                bp.set_CustomColumn("RH_ExpirationAdD", doc.getdateendrequest());
                bp.save();
            }
            if (doc.getRequestType().equals("PAD")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select SUM( case when block = 'MDM' then 0.5 when block = 'MDT' then 0.5 when block = 'DIA' then 1 end) from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID=?", (int)doc.getAdministrativeRequests_ID());
                BigDecimal PADep = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select coalesce ((SUM(case when arl.block = 'MDM' then 0.5 when arl.block = 'MDT' then 0.5 when arl.block = 'DIA' then 1 end)),0) from RH_AdministrativeRequestsline arl inner join RH_AdministrativeRequests ar on (arl.RH_AdministrativeRequests_id = ar.RH_AdministrativeRequests_id) where ar.requesttype like 'PAD' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y' and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantPAD = (BigDecimal)bp.get_Value("RH_AdministrativeDays");
                if (dd.add(PADep).compareTo(cantPAD) > 0) {
                    return "Dias Administrativos Disponibles Insuficientes";
                }
                bp.set_CustomColumn("RH_AdministrativeDays", ((BigDecimal)bp.get_Value("RH_AdministrativeDays")).subtract(dd));
                bp.save();
            }
            if (doc.getRequestType().equals("PSD")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select SUM(numberhours) as qty from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                BigDecimal PSDep = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select coalesce ((SUM(numberhours)),0) as qty from RH_AdministrativeRequestsline arl inner join RH_AdministrativeRequests ar on (arl.RH_AdministrativeRequests_id = ar.RH_AdministrativeRequests_id) where ar.requesttype like 'PSD' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y' and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantPSD = (BigDecimal)bp.get_Value("RH_UnionHours");
                if (dd.add(PSDep).compareTo(cantPSD) > 0) {
                    return "Horas Sindicales Disponibles Insuficientes";
                }
                bp.set_CustomColumn("RH_UnionHours", ((BigDecimal)bp.get_Value("RH_UnionHours")).subtract(dd));
                bp.save();
            }
            if (doc.getRequestType().equals("TCP")) {
                bp = MBPartner.get(this.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select SUM(numberhours) as qty from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                int cantTCPD = DB.getSQLValue((String)this.get_TrxName(), (String)"select count(*) from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID=?", (int)doc.getAdministrativeRequests_ID());
                if (cantTCPD < 1) {
                    return "Solicitud Tiempo Compensado debe Tener Detalle";
                }
                BigDecimal TCPep = DB.getSQLValueBD((String)this.get_TrxName(), (String)"select coalesce ((SUM(numberhours)),0) as qty from RH_AdministrativeRequestsline arl inner join RH_AdministrativeRequests ar on (arl.RH_AdministrativeRequests_id = ar.RH_AdministrativeRequests_id) where ar.requesttype like 'TCP' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y'and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantTCP = (BigDecimal)bp.get_Value("numberhours");
                if (dd.add(TCPep).compareTo(cantTCP) > 0) {
                    return "Horas Acumuladas Disponibles Insuficientes";
                }
                bp.set_CustomColumn("numberhours", ((BigDecimal)bp.get_Value("numberhours")).subtract(dd));
                bp.save();
            }
            if (doc.getRequestType().equals("CMT")) {
                Date dateStar = new Date(doc.getdatestartrequest().getTime());
                Date dateEnd = new Date(doc.getdateendrequest().getTime());
                Timestamp dateStarTS = new Timestamp(dateStar.getTime());
                Timestamp dateEndTS = new Timestamp(dateEnd.getTime());
                String sqlCMT = "SELECT COUNT(*) FROM RH_MedicalLicenses WHERE datestartrequest between ? and  ?  AND C_BPartner_ID = ?";
                int cantLM = DB.getSQLValue((String)this.get_TrxName(), (String)sqlCMT, (Object[])new Object[]{dateStarTS, dateEndTS, doc.getC_BPartner_ID()});
                if (cantLM > 0) {
                    throw new AdempiereException("No se puede completar, existe una licencia medica en conflicto");
                }
            }
            doc.setProcessed(true);
            doc.setDocStatus("CO");
            doc.save();
            return "Completado";
        }
        if (this.P_DocAction.equals("VO")) {
            doc.setProcessed(true);
            doc.setDocStatus("VO");
            doc.save();
            return "Anulado";
        }
        return "No es posible Cumplir la Accion ";
    }
}

