/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MMovement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class PostCosteoBravoEnergyTSM
extends SvrProcess {
    private int p_ProjectOFB_ID = 0;
    private Timestamp p_MovementDateFrom = null;
    private Timestamp p_MovementDateTo = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_ProjectOFB_ID")) {
                    this.p_ProjectOFB_ID = para[i].getParameterAsInt();
                } else if (name.equals("MovementDate")) {
                    this.p_MovementDateFrom = (Timestamp)para[i].getParameter();
                    this.p_MovementDateTo = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws AdempiereSystemError {
        block9: {
            Object[] params = new Timestamp[]{this.p_MovementDateFrom, this.p_MovementDateTo};
            String sqlUpdatePreview1 = "UPDATE M_MovementLine SET Cost = 0 WHERE M_MovementLine_ID IN ( SELECT M_MovementLine_ID FROM M_MovementLine MML INNER JOIN M_Movement MM ON (MM.M_Movement_ID = MML.M_Movement_ID) WHERE MM.C_ProjectOFB_ID= " + this.p_ProjectOFB_ID + " AND MM.MovementDate between ? AND ? " + "AND (MMl.TP_LineNo > 0 OR MML.TP_LineNo is null))";
            DB.executeUpdateEx((String)sqlUpdatePreview1, (Object[])params, (String)this.get_TrxName());
            String sqlUpdatePreview2 = "UPDATE M_MovementLine MML2 SET KMValue = COALESCE ((SELECT KMValue FROM TP_Destination TPD WHERE TPD.TP_Destination_ID = MML2.TP_Destination_ID),0) WHERE M_MovementLine_ID IN ( SELECT M_MovementLine_ID FROM M_MovementLine MML INNER JOIN M_Movement MM ON (MM.M_Movement_ID = MML.M_Movement_ID) WHERE MM.C_ProjectOFB_ID= " + this.p_ProjectOFB_ID + " AND MM.MovementDate between ? AND ? AND MMl.Cost = 0) ";
            DB.executeUpdateEx((String)sqlUpdatePreview2, (Object[])params, (String)this.get_TrxName());
            String sqlPrincipal = "SELECT M_Movement_ID FROM M_Movement WHERE isactive = 'Y'";
            if (this.p_ProjectOFB_ID > 0) {
                sqlPrincipal = String.valueOf(sqlPrincipal) + " AND C_ProjectOFB_ID = " + this.p_ProjectOFB_ID;
            }
            if (this.p_MovementDateFrom != null && this.p_MovementDateTo != null) {
                sqlPrincipal = String.valueOf(sqlPrincipal) + " AND MovementDate between ? AND ?";
            }
            sqlPrincipal = String.valueOf(sqlPrincipal) + " ORDER BY MovementDate, M_Movement_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = null;
                    pstmt = DB.prepareStatement((String)sqlPrincipal, (String)this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_MovementDateFrom);
                    pstmt.setTimestamp(2, this.p_MovementDateTo);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MMovement mm = new MMovement(this.getCtx(), rs.getInt("M_Movement_ID"), this.get_TrxName());
                        String sqlCiclo = "SELECT TP_LineNo FROM M_MovementLine WHERE M_Movement_ID=? AND Cost = 0 AND TP_LineNo > 0 GROUP BY TP_LineNo ";
                        CPreparedStatement pstmt2 = null;
                        ResultSet rs2 = null;
                        pstmt2 = null;
                        pstmt2 = DB.prepareStatement((String)sqlCiclo, (String)this.get_TrxName());
                        pstmt2.setInt(1, mm.get_ID());
                        rs2 = pstmt2.executeQuery();
                        while (rs2.next()) {
                            String sqlMaxValue = "SELECT MAX (KMValue) FROM M_MovementLine WHERE M_Movement_ID= ? AND TP_LineNo = ?";
                            BigDecimal maxValue = DB.getSQLValueBD((String)this.get_TrxName(), (String)sqlMaxValue, (Object[])new Object[]{mm.get_ID(), rs2.getInt("TP_LineNo")});
                            String sqlUValue = "UPDATE M_MovementLine SET Cost = ( " + maxValue + " * (TP_InicialKM - TP_FinalKM)) " + "WHERE M_Movement_ID = " + mm.get_ID() + " AND TP_LineNo = " + rs2.getInt("TP_LineNo");
                            DB.executeUpdate((String)sqlUValue, (String)this.get_TrxName());
                        }
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "Hojas de Ruta Actualizadas: Flota " + this.p_ProjectOFB_ID + " entre fechas " + this.p_MovementDateFrom + " and " + this.p_MovementDateTo;
    }
}

