/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPartner;
import org.compiere.model.MCampaign;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_C_CampaignFollow;
import org.compiere.model.X_I_BPartner;
import org.compiere.model.X_R_ContactInterest;
import org.compiere.model.X_R_InterestArea;
import org.compiere.model.X_R_InterestAreaValues;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportBPartnerMetlifeV2
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private Timestamp m_DateValue = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        if (this.m_DateValue == null) {
            this.m_DateValue = new Timestamp(System.currentTimeMillis());
        }
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_BPartner WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_BPartner SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Reset=" + no);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        sql = new StringBuffer("UPDATE I_BPartner  SET Value = I_BPartner_ID WHERE Value IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Set Value Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner  SET name = COALESCE(IA_Nombre,N'') ||' '||COALESCE(IA_Paterno,N'')||' '||COALESCE(IA_Materno,N'')  WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Set Name Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET i.AD_User_ID = (SELECT MAX(AD_User_ID) FROM AD_User au WHERE upper(au.name) = upper(i.nameUser) AND au.AD_Client_ID=i.AD_Client_ID) WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Set Name Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET GroupValue=(SELECT MAX(Value) FROM C_BP_Group g WHERE g.IsDefault='Y' AND g.AD_Client_ID=i.AD_Client_ID) ");
        sql.append("WHERE GroupValue IS NULL AND C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BP_Group_ID=(SELECT C_BP_Group_ID FROM C_BP_Group g WHERE i.GroupValue=g.Value AND g.AD_Client_ID=i.AD_Client_ID) WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Group, ' WHERE C_BP_Group_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Invalid Group=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found BPartner=" + no);
        sql = new StringBuffer("UPDATE I_BPartner i SET R_InterestArea_ID=(SELECT R_InterestArea_ID FROM R_InterestArea ia WHERE i.InterestAreaName=ia.Name AND ia.AD_Client_ID=i.AD_Client_ID) WHERE R_InterestArea_ID IS NULL AND InterestAreaName IS NOT NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Interest Area=" + no);
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Value is mandatory, ' WHERE Value IS NULL  AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Value is mandatory=" + no);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT * FROM I_BPartner WHERE I_IsImported='N'").append(clientCheck);
        sql.append(" ORDER BY Value, I_BPartner_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String Old_BPValue = "";
                MBPartner bp = null;
                while (true) {
                    X_I_BPartner impBP;
                    block46: {
                        String New_BPValue;
                        block45: {
                            if (!rs.next()) {
                                this.commitEx();
                                this.asignBPartner();
                                DB.close((ResultSet)rs, (Statement)pstmt);
                                break;
                            }
                            New_BPValue = rs.getString("Value");
                            impBP = new X_I_BPartner(this.getCtx(), rs, this.get_TrxName());
                            this.log.fine("I_BPartner_ID=" + impBP.getI_BPartner_ID() + ", C_BPartner_ID=" + impBP.getC_BPartner_ID() + ", C_BPartner_Location_ID=" + impBP.getC_BPartner_Location_ID() + ", AD_User_ID=" + impBP.getAD_User_ID());
                            if (!New_BPValue.equals(Old_BPValue)) {
                                bp = null;
                                if (impBP.getC_BPartner_ID() == 0) {
                                    bp = new MBPartner(impBP);
                                    ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBP, (PO)((Object)bp), 40);
                                    this.setTypeOfBPartner(impBP, bp);
                                    if (bp.save()) {
                                        impBP.setC_BPartner_ID(bp.getC_BPartner_ID());
                                        this.log.finest("Insert BPartner - " + bp.getC_BPartner_ID());
                                        ++noInsert;
                                        break block45;
                                    } else {
                                        sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPartner, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                        DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                        continue;
                                    }
                                }
                                bp = new MBPartner(this.getCtx(), impBP.getC_BPartner_ID(), this.get_TrxName());
                                if (impBP.getName() != null) {
                                    bp.setName(impBP.getName());
                                    bp.setName2(impBP.getName2());
                                }
                                if (impBP.getDUNS() != null) {
                                    bp.setDUNS(impBP.getDUNS());
                                }
                                if (impBP.getTaxID() != null) {
                                    bp.setTaxID(impBP.getTaxID());
                                }
                                if (impBP.getNAICS() != null) {
                                    bp.setNAICS(impBP.getNAICS());
                                }
                                if (impBP.getDescription() != null) {
                                    bp.setDescription(impBP.getDescription());
                                }
                                if (impBP.getC_BP_Group_ID() != 0) {
                                    bp.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
                                }
                                ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBP, (PO)((Object)bp), 40);
                                this.setTypeOfBPartner(impBP, bp);
                                if (bp.save()) {
                                    this.log.finest("Update BPartner - " + bp.getC_BPartner_ID());
                                    ++noUpdate;
                                } else {
                                    sql = new StringBuffer("UPDATE I_BPartner i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BPartner, ' ").append("WHERE I_BPartner_ID=").append(impBP.getI_BPartner_ID());
                                    DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                    continue;
                                }
                            }
                        }
                        Old_BPValue = New_BPValue;
                        String[] namesAInterest = new String[]{"TelFijo", "Celular", "Direccion", "Comuna", "Ciudad", "Region", "Email", "MotivoContacto", "Origen", "Inmueble", "AreaFono", "TipoPropiedad", "ValorPropiedad", "MontoCredito", "Financ", "FechaNac", "Genero", "EstadoCivil", "RazonSocial", "RutEmpresa", "SolColab", "ProdInteres", "Corredora", "UrlOrigen", "Observacion"};
                        int i = 0;
                        while (true) {
                            if (i >= namesAInterest.length) {
                                if (impBP.get_ValueAsString("IA_TipoEtiqueta") != null && impBP.get_ValueAsString("IA_TipoEtiqueta") != " " && impBP.get_ValueAsString("IA_TipoEtiqueta") != "") break;
                                break block46;
                            }
                            X_R_InterestArea IArea = null;
                            String nameIA = namesAInterest[i];
                            String sqlIA1 = "Select R_InterestArea_ID from R_InterestArea WHERE name = '" + nameIA + "'";
                            int IA_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlIA1);
                            if (IA_ID > 0) {
                                IArea = new X_R_InterestArea(this.getCtx(), IA_ID, this.get_TrxName());
                            } else {
                                IArea = new X_R_InterestArea(this.getCtx(), 0, this.get_TrxName());
                                IArea.setName(nameIA);
                                IArea.setValue(nameIA);
                            }
                            IArea.save();
                            X_R_InterestAreaValues IAreaValue = null;
                            String sqlVIA1 = "SELECT R_InterestAreaValues_ID FROM R_InterestAreaValues WHERE R_InterestArea_ID = " + IArea.get_ID() + " AND value = '" + impBP.get_ValueAsString("IA_" + nameIA) + "'";
                            int IAV_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlVIA1);
                            if (IAV_ID > 0) {
                                IAreaValue = new X_R_InterestAreaValues(this.getCtx(), IAV_ID, this.get_TrxName());
                            } else if (impBP.get_ValueAsString("IA_" + nameIA) != null && impBP.get_ValueAsString("IA_" + nameIA) != "" && impBP.get_ValueAsString("IA_" + nameIA) != " ") {
                                IAreaValue = new X_R_InterestAreaValues(this.getCtx(), 0, this.get_TrxName());
                                IAreaValue.setR_InterestArea_ID(IArea.get_ID());
                                IAreaValue.setValue(impBP.get_ValueAsString("IA_" + nameIA));
                                IAreaValue.save();
                            }
                            if (impBP.get_ValueAsString("IA_" + nameIA) != null && impBP.get_ValueAsString("IA_" + nameIA) != "" && impBP.get_ValueAsString("IA_" + nameIA) != " ") {
                                X_R_ContactInterest cInterest;
                                if (IArea.get_ValueAsBoolean("IsEditable")) {
                                    cInterest = null;
                                    String sqlcInteret = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + "AND R_InterestArea_ID = " + IArea.get_ID();
                                    int CInterest_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcInteret);
                                    if (CInterest_ID > 0) {
                                        cInterest = new X_R_ContactInterest(this.getCtx(), CInterest_ID, this.get_TrxName());
                                        cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue.get_ID());
                                    } else {
                                        cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                        cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                        cInterest.setR_InterestArea_ID(IArea.get_ID());
                                        cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue.get_ID());
                                    }
                                    cInterest.save();
                                } else if (IArea.get_ID() > 0 && IAreaValue.get_ID() > 0) {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                    cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                    cInterest.setR_InterestArea_ID(IArea.get_ID());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue.get_ID());
                                    cInterest.save();
                                }
                            }
                            ++i;
                        }
                        X_R_InterestArea IArea2 = null;
                        String sqlIA2 = "Select R_InterestArea_ID from R_InterestArea WHERE name = '" + impBP.get_ValueAsString("IA_TipoEtiqueta") + "'";
                        int IA_ID2 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlIA2);
                        if (IA_ID2 > 0) {
                            IArea2 = new X_R_InterestArea(this.getCtx(), IA_ID2, this.get_TrxName());
                        } else {
                            IArea2 = new X_R_InterestArea(this.getCtx(), 0, this.get_TrxName());
                            IArea2.setName(impBP.get_ValueAsString("IA_TipoEtiqueta"));
                            IArea2.setValue(impBP.get_ValueAsString("IA_TipoEtiqueta"));
                        }
                        IArea2.save();
                        if (impBP.get_ValueAsString("IA_ValorEtiqueta") == null || impBP.get_ValueAsString("IA_ValorEtiqueta") == "" || impBP.get_ValueAsString("IA_ValorEtiqueta") == " ") {
                            String sqlcInteret2 = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + "AND R_InterestArea_ID = " + IArea2.get_ID();
                            int CInterest_ID2 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcInteret2);
                            if (CInterest_ID2 <= 0) {
                                X_R_ContactInterest cInterest2 = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                cInterest2.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                cInterest2.setR_InterestArea_ID(IArea2.get_ID());
                                cInterest2.save();
                            }
                        } else {
                            X_R_ContactInterest cInterest;
                            X_R_InterestAreaValues IAreaValue2 = null;
                            String sqlVIA2 = "SELECT R_InterestAreaValues_ID FROM R_InterestAreaValues WHERE R_InterestArea_ID = " + IArea2.get_ID() + " AND value = '" + impBP.get_ValueAsString("IA_ValorEtiqueta") + "'";
                            int IAV_ID2 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlVIA2);
                            if (IAV_ID2 > 0) {
                                IAreaValue2 = new X_R_InterestAreaValues(this.getCtx(), IAV_ID2, this.get_TrxName());
                            } else {
                                IAreaValue2 = new X_R_InterestAreaValues(this.getCtx(), 0, this.get_TrxName());
                                IAreaValue2.setR_InterestArea_ID(IArea2.get_ID());
                                IAreaValue2.setValue(impBP.get_ValueAsString("IA_ValorEtiqueta"));
                            }
                            IAreaValue2.save();
                            if (IArea2.get_ValueAsBoolean("IsEditable")) {
                                cInterest = null;
                                String sqlcInteret = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + "AND R_InterestArea_ID = " + IArea2.get_ID();
                                int CInterest_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcInteret);
                                if (CInterest_ID > 0) {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), CInterest_ID, this.get_TrxName());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue2.get_ID());
                                } else {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                    cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                    cInterest.setR_InterestArea_ID(IArea2.get_ID());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue2.get_ID());
                                }
                                cInterest.save();
                            } else if (IArea2.get_ID() > 0 && IAreaValue2.get_ID() > 0) {
                                cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                cInterest.setR_InterestArea_ID(IArea2.get_ID());
                                cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue2.get_ID());
                                cInterest.save();
                            }
                        }
                    }
                    impBP.setI_IsImported(true);
                    impBP.setProcessed(true);
                    impBP.setProcessing(false);
                    impBP.saveEx();
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(no), "@Errors@");
            this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
            this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
        return "";
    }

    public String getWhereClause() {
        return " AND AD_Client_ID=" + this.m_AD_Client_ID;
    }

    public String getImportTableName() {
        return "I_BPartner";
    }

    private void setTypeOfBPartner(X_I_BPartner impBP, MBPartner bp) {
        if (impBP.isVendor()) {
            bp.setIsVendor(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isEmployee()) {
            bp.setIsEmployee(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isCustomer()) {
            bp.setIsCustomer(true);
        }
    }

    public Boolean asignBPartner() throws SQLException {
        this.log.config("asignBPartner");
        String clientCheck = this.getWhereClause();
        StringBuffer sql = null;
        sql = new StringBuffer("SELECT C_Bpartner_ID, I_BPartner_ID FROM I_BPartner WHERE I_IsImported='Y' AND I_IsAsigned='N' AND C_Bpartner_ID IS NOT NULL ").append(clientCheck);
        sql.append("ORDER BY C_Bpartner_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MBPartner bp = new MBPartner(this.getCtx(), rs.getInt("C_Bpartner_ID"), this.get_TrxName());
                    this.log.config("entra while general BP - BP_ID:" + bp.get_ID());
                    X_I_BPartner ixml = new X_I_BPartner(this.getCtx(), rs.getInt("I_BPartner_ID"), this.get_TrxName());
                    CPreparedStatement pstmtEtiqueta = null;
                    ResultSet rsEtiqueta = null;
                    String sqlEtiqueta = "SELECT R_InterestArea_ID FROM r_contactinterest WHERE C_BPartner_ID =?";
                    pstmtEtiqueta = DB.prepareStatement((String)sqlEtiqueta, (String)this.get_TrxName());
                    pstmtEtiqueta.setInt(1, bp.get_ID());
                    rsEtiqueta = pstmtEtiqueta.executeQuery();
                    int existeCampa\u00f1a = 0;
                    while (rsEtiqueta.next()) {
                        int ID_EtiquetaURL = rsEtiqueta.getInt("R_InterestArea_ID");
                        this.log.config("entra while InterestArea BP - BP_ID:" + bp.get_ID() + " InterestArea_ID:" + ID_EtiquetaURL);
                        String sqlvalueIABP = "SELECT VALUE FROM R_ContactInterest CI INNER JOIN R_InterestAreaValues AV ON (CI.R_InterestAreaValues_ID = AV.R_InterestAreaValues_ID)WHERE CI.C_BPartner_ID = " + bp.get_ID() + " AND CI.R_InterestArea_ID = " + ID_EtiquetaURL;
                        String valueIABP = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlvalueIABP, (Object[])new Object[0]);
                        String sqlCadenasUrl = "SELECT iav.value, cc.C_Campaign_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) INNER JOIN R_InterestAreaValues iav ON(iav.R_InterestAreaValues_ID = ci.R_InterestAreaValues_ID)WHERE IsOnGoing = 'Y' AND iav.R_InterestArea_ID=?";
                        CPreparedStatement pstmtCadenas = null;
                        ResultSet rsCadenas = null;
                        pstmtCadenas = DB.prepareStatement((String)sqlCadenasUrl, (String)this.get_TrxName());
                        pstmtCadenas.setInt(1, ID_EtiquetaURL);
                        rsCadenas = pstmtCadenas.executeQuery();
                        while (rsCadenas.next()) {
                            this.log.config("entra while campa\u00f1as");
                            String valueUrl = rsCadenas.getString("value");
                            this.log.config("valor valueIABP :" + valueIABP);
                            this.log.config("valor valueUrl :" + valueUrl);
                            if (valueIABP == null || valueUrl == null) continue;
                            this.log.config("Pregunta if (valueIABP.contains(valueUrl)):" + (valueIABP.contains(valueUrl) ? "true" : "false"));
                            if (!valueIABP.contains(valueUrl)) continue;
                            existeCampa\u00f1a = 1;
                            MCampaign cam = new MCampaign(this.getCtx(), rsCadenas.getInt("C_Campaign_ID"), this.get_TrxName());
                            int ID_Campaign = cam.get_ID();
                            String countBPStr = "SELECT COUNT(1) FROM C_CampaignFollow WHERE C_BPartner_ID = " + bp.get_ID() + " AND C_Campaign_ID = " + ID_Campaign;
                            int countBP = DB.getSQLValue((String)this.get_TrxName(), (String)countBPStr);
                            this.log.config("countBP :" + countBP);
                            if (countBP > 0) {
                                ixml.set_CustomColumn("I_IsAsigned", (Object)true);
                                ixml.save();
                                continue;
                            }
                            X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), 0, this.get_TrxName());
                            cFollow.setAD_Org_ID(cam.getAD_Org_ID());
                            cFollow.setC_Campaign_ID(cam.get_ID());
                            cFollow.setIsActive(true);
                            cFollow.setC_BPartner_ID(bp.get_ID());
                            cFollow.setStatus("NC");
                            cFollow.setFinalStatus("IN");
                            if (ixml.getAD_User_ID() > 0) {
                                cFollow.setAD_User_ID(ixml.getAD_User_ID());
                            }
                            cFollow.save();
                            this.log.config("crea cFollow");
                            ixml.set_CustomColumn("I_IsAsigned", (Object)true);
                            ixml.save();
                            this.commitEx();
                        }
                        DB.close((ResultSet)rsCadenas, (Statement)pstmtCadenas);
                        rsCadenas = null;
                        pstmtCadenas = null;
                    }
                    DB.close((ResultSet)rsEtiqueta, (Statement)pstmtEtiqueta);
                    rsEtiqueta = null;
                    pstmtEtiqueta = null;
                    this.log.config("existeCampa\u00f1a:" + existeCampa\u00f1a);
                    if (existeCampa\u00f1a >= 1) continue;
                    int ID_CampaignDefault = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Campaign_ID) FROM C_Campaign WHERE IsCampaignDefault='Y'");
                    this.log.config("ID_CampaignDefault:" + ID_CampaignDefault);
                    if (ID_CampaignDefault <= 0) continue;
                    MCampaign cam = new MCampaign(this.getCtx(), ID_CampaignDefault, this.get_TrxName());
                    int ID_Campaign = cam.get_ID();
                    String countBPStr = "SELECT COUNT(1) FROM C_CampaignFollow WHERE C_BPartner_ID = " + bp.get_ID() + " AND C_Campaign_ID = " + ID_Campaign;
                    int countBP = DB.getSQLValue((String)this.get_TrxName(), (String)countBPStr);
                    this.log.config("countBP :" + countBP);
                    if (countBP > 0) {
                        ixml.set_CustomColumn("I_IsAsigned", (Object)true);
                        ixml.save();
                        continue;
                    }
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), 0, this.get_TrxName());
                    cFollow.setAD_Org_ID(cam.getAD_Org_ID());
                    cFollow.setC_Campaign_ID(cam.get_ID());
                    cFollow.setIsActive(true);
                    cFollow.setC_BPartner_ID(bp.get_ID());
                    cFollow.setStatus("NC");
                    cFollow.setFinalStatus("IN");
                    cFollow.save();
                    this.log.config("crea cFollow default");
                    ixml.set_CustomColumn("I_IsAsigned", (Object)true);
                    ixml.save();
                    String IDEBUserStr = "SELECT MAX(AD_User_ID) FROM AD_User WHERE IsDefaultEB = 'Y'";
                    int ID_EBUser = DB.getSQLValue((String)this.get_TrxName(), (String)IDEBUserStr);
                    if (ID_EBUser <= 0) continue;
                    cFollow.setAD_User_ID(ID_EBUser);
                    cFollow.save();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.commitEx();
        return true;
    }
}

