/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportDTEMInOutCGProvectis
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_InOut_ID = 0;

    protected void prepare() {
        this.p_M_InOut_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInOut inOut = new MInOut(this.m_ctx, this.p_M_InOut_ID, this.get_TrxName());
        String msg = this.CreateXMLCG(inOut);
        return msg;
    }

    public String CreateXMLCG(MInOut inOut) {
        MDocType doc = new MDocType(inOut.getCtx(), inOut.getC_DocType_ID(), inOut.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            Element Documento = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento);
            Documento.setAttribute("ID", "DTE-" + inOut.getDocumentNo());
            Element Encabezado = document.createElement("Encabezado");
            Documento.appendChild(Encabezado);
            Element IdDoc = document.createElement("IdDoc");
            Encabezado.appendChild(IdDoc);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(inOut.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(inOut.getMovementDate().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc.appendChild(FchEmis);
            Element TipoDespacho = document.createElement("TipoDespacho");
            Text TDespacho = document.createTextNode("2");
            TipoDespacho.appendChild(TDespacho);
            IdDoc.appendChild(TipoDespacho);
            String IndTrl = null;
            try {
                IndTrl = inOut.get_ValueAsString("IndTraslado");
            }
            catch (Exception e) {
                IndTrl = null;
            }
            if (IndTrl != null && IndTrl.length() > 0) {
                Element IndTraslado = document.createElement("IndTraslado");
                Text iTraslado = document.createTextNode(IndTrl);
                IndTraslado.appendChild(iTraslado);
                IdDoc.appendChild(IndTraslado);
            }
            if (inOut.getC_Order_ID() > 0) {
                MOrder order = new MOrder(inOut.getCtx(), inOut.getC_Order_ID(), inOut.get_TrxName());
                MPaymentTerm pterm = new MPaymentTerm(inOut.getCtx(), order.getC_PaymentTerm_ID(), inOut.get_TrxName());
                Element PayTerm = document.createElement("TermPagoGlosa");
                Text term = document.createTextNode(pterm.getName());
                PayTerm.appendChild(term);
                IdDoc.appendChild(PayTerm);
            }
            Element Emisor = document.createElement("Emisor");
            Encabezado.appendChild(Emisor);
            mylog = "Emisor";
            MOrg company = MOrg.get((Properties)inOut.getCtx(), (int)inOut.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(inOut.getCtx(), inOut.getC_BPartner_ID(), inOut.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(inOut.getCtx(), inOut.getC_BPartner_Location_ID(), inOut.get_TrxName());
            Element Receptor = document.createElement("Receptor");
            Encabezado.appendChild(Receptor);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(inOut.getAD_User_ID() > 0 ? inOut.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(inOut.getAD_User().getEMail() == null ? " " : inOut.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor.appendChild(DirRecep);
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(bloc.getLocation(true).getAddress3() == null ? " " : bloc.getLocation(true).getAddress3());
            CmnaRecep.appendChild(Cmna);
            Receptor.appendChild(CmnaRecep);
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(inOut.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor.appendChild(CiudadRecep);
            Element transporte = document.createElement("Transporte");
            Encabezado.appendChild(transporte);
            Element DirDest = document.createElement("DirDest");
            Text dirdest = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirDest.appendChild(dirdest);
            transporte.appendChild(DirDest);
            Element CmnaDest = document.createElement("CmnaDest");
            Text CmnaDestTxt = document.createTextNode(bloc.getLocation(true).getAddress3() == null ? " " : bloc.getLocation(true).getAddress3());
            CmnaDest.appendChild(CmnaDestTxt);
            transporte.appendChild(CmnaDest);
            Element CiudadDest = document.createElement("CiudadDest");
            Text regDest = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(inOut.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadDest.appendChild(regDest);
            transporte.appendChild(CiudadDest);
            mylog = "Totales";
            Element Totales = document.createElement("Totales");
            Encabezado.appendChild(Totales);
            BigDecimal amountGrandT = Env.ZERO;
            BigDecimal priceT = Env.ZERO;
            BigDecimal taxAmt = Env.ZERO;
            if (inOut.getC_Order_ID() > 0) {
                MInOutLine[] iLines2 = inOut.getLines();
                int a2 = 0;
                while (a2 < iLines2.length) {
                    priceT = Env.ZERO;
                    taxAmt = Env.ZERO;
                    MInOutLine iLine = iLines2[a2];
                    String nameCg = iLine.get_ValueAsString("ProductNameCG");
                    if (nameCg != null && nameCg.trim().length() > 0) {
                        priceT = (BigDecimal)iLine.get_Value("PriceEntered_CG");
                        BigDecimal qtyGC = (BigDecimal)iLine.get_Value("QtyGC");
                        priceT = priceT.multiply(qtyGC);
                        amountGrandT = amountGrandT.add(priceT);
                    }
                    ++a2;
                }
            }
            Element TasaIVA = document.createElement("TasaIVA");
            Text tiva = document.createTextNode("19");
            TasaIVA.appendChild(tiva);
            Totales.appendChild(TasaIVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(amountGrandT.setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales.appendChild(MntTotal);
            mylog = "detalle";
            MInOutLine[] iLines = inOut.getLines();
            int indLine = 1;
            int i = 0;
            while (i < iLines.length) {
                String nameCg;
                MInOutLine iLine = iLines[i];
                if ((iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) && (nameCg = iLine.get_ValueAsString("ProductNameCG")) != null && nameCg != "" && nameCg != " ") {
                    Element Detalle = document.createElement("Detalle");
                    Documento.appendChild(Detalle);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(indLine));
                    NroLinDet.appendChild(line);
                    Detalle.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = nameCg;
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle.appendChild(NmbItem);
                    String descCG = iLine.get_ValueAsString("DescriptionCG");
                    if (descCG == null) {
                        descCG = " ";
                    }
                    Element DscItem = document.createElement("DscItem");
                    Text desc = document.createTextNode(descCG == null ? " " : descCG);
                    DscItem.appendChild(desc);
                    Detalle.appendChild(DscItem);
                    BigDecimal mtoItem = Env.ZERO;
                    BigDecimal prcRefMnt = Env.ZERO;
                    BigDecimal qtyGC = Env.ZERO;
                    if (iLine.getC_OrderLine_ID() > 0) {
                        prcRefMnt = (BigDecimal)iLine.get_Value("PriceEntered_CG");
                        qtyGC = (BigDecimal)iLine.get_Value("QtyGC");
                        mtoItem = prcRefMnt.multiply(qtyGC);
                    }
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(qtyGC.setScale(0, 4).toString());
                    QtyItem.appendChild(qt);
                    Detalle.appendChild(QtyItem);
                    Element PrcRef = document.createElement("PrcItem");
                    Text PrcRefTxt = document.createTextNode(prcRefMnt.setScale(0, 4).toString());
                    PrcRef.appendChild(PrcRefTxt);
                    Detalle.appendChild(PrcRef);
                    Element MtoItem = document.createElement("MontoItem");
                    Text MtoTxt = document.createTextNode(mtoItem.setScale(0, 4).toString());
                    MtoItem.appendChild(MtoTxt);
                    Detalle.appendChild(MtoItem);
                    ++indLine;
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (inOut.getPOReference() != null && inOut.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = inOut.getPOReference();
                fechareferencia = inOut.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (tipo_Ref > 0) {
                Element Referencia = document.createElement("Referencia");
                Documento.appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                String CodRefTxt = null;
                try {
                    CodRefTxt = inOut.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(inOut.get_ValueAsString("CodRef") == null ? "0" : inOut.get_ValueAsString("CodRef"));
                    CodRef.appendChild(codref);
                    Referencia.appendChild(CodRef);
                }
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento.appendChild(Firma);
            Element Observacion = document.createElement("Observacion");
            Text ObservacionTxt = document.createTextNode(inOut.getDescription() == null ? " " : inOut.getDescription());
            Observacion.appendChild(ObservacionTxt);
            Documento.appendChild(Observacion);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, inOut.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG PROVECTIS Generated";
    }
}

