/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.process.DocAction;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportDTEInvoiceNBaskakow
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;

    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = this.CreateXML(inv);
        return msg;
    }

    public String CreateXML(MInvoice invoice) {
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocAction refdoc;
            String nomContacto;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Attr atr = document.createAttribute("xmlns");
            atr.setValue("http://www.sii.cl/SiiDte");
            Element Documento = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento);
            Documento.setAttribute("ID", "DTE-" + invoice.getDocumentNo());
            Element Encabezado = document.createElement("Encabezado");
            Documento.appendChild(Encabezado);
            Element IdDoc = document.createElement("IdDoc");
            Encabezado.appendChild(IdDoc);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc.appendChild(FchEmis);
            Element FchCancel = document.createElement("FchCancel");
            Text cancel = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchCancel.appendChild(cancel);
            IdDoc.appendChild(FchCancel);
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc.appendChild(FchVenc);
            String StrFmaPago = "";
            MPaymentTerm pterm = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
            StrFmaPago = pterm.getDescription().length() > 0 && pterm.getDescription() != null ? pterm.getDescription() : pterm.getName();
            Element PayTerm = document.createElement("FmaPago");
            Text term = document.createTextNode(StrFmaPago);
            PayTerm.appendChild(term);
            IdDoc.appendChild(PayTerm);
            MUser salesUser = new MUser(invoice.getCtx(), invoice.getSalesRep_ID(), invoice.get_TrxName());
            Element SalesRep = document.createElement("CdgVendedor");
            Text sales = document.createTextNode(salesUser.getName());
            SalesRep.appendChild(sales);
            IdDoc.appendChild(SalesRep);
            Element HDescription = document.createElement("HeaderDescription");
            Text Hdesc = document.createTextNode(invoice.getDescription() == null ? "-" : invoice.getDescription());
            HDescription.appendChild(Hdesc);
            IdDoc.appendChild(HDescription);
            Element Emisor = document.createElement("Emisor");
            Encabezado.appendChild(Emisor);
            mylog = "Emisor";
            MOrg company = MOrg.get((Properties)invoice.getCtx(), (int)invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation obra = null;
            if (invoice.getC_Order_ID() > 0) {
                MOrder SOrder = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
                obra = new MBPartnerLocation(invoice.getCtx(), SOrder.getC_BPartner_Location_ID(), invoice.get_TrxName());
            } else {
                obra = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            }
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor = document.createElement("Receptor");
            Encabezado.appendChild(Receptor);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor.appendChild(GiroRecep);
            String string = nomContacto = invoice.getAD_User_ID() > 0 ? invoice.getAD_User().getName() : " ";
            if (nomContacto == null) {
                nomContacto = " ";
            }
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(nomContacto);
            ContactoRecep.appendChild(contacto);
            Receptor.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(invoice.getAD_User().getEMail() == null ? " " : invoice.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor.appendChild(DirRecep);
            String CmnaRecepMsg = "";
            CmnaRecepMsg = bloc.getLocation(true).getAddress2() != null && bloc.getLocation(true).getAddress2().length() > 0 ? bloc.getLocation(true).getAddress2() : "Desconocida";
            Element CmnaRecep = document.createElement("CmnaRecep2");
            Text Cmna = document.createTextNode(CmnaRecepMsg);
            CmnaRecep.appendChild(Cmna);
            Receptor.appendChild(CmnaRecep);
            Element CiudadRecep = document.createElement("CmnaRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(invoice.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor.appendChild(CiudadRecep);
            Element ObraName = document.createElement("OName");
            Text oName = document.createTextNode(obra.getName());
            ObraName.appendChild(oName);
            Receptor.appendChild(ObraName);
            mylog = "Totales";
            Element Totales = document.createElement("Totales");
            Encabezado.appendChild(Totales);
            BigDecimal amountex = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)("select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID()), (Object[])new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales.appendChild(MntExe);
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if ((iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) && iLine.getLineNetAmt().compareTo(Env.ZERO) >= 0) {
                    Element Detalle = document.createElement("Detalle");
                    Documento.appendChild(Detalle);
                    MTax tax = new MTax(invoice.getCtx(), iLine.getC_Tax_ID(), invoice.get_TrxName());
                    if (tax.isTaxExempt()) {
                        Element IndEx = document.createElement("IndExe");
                        Text lineE = document.createTextNode("1");
                        IndEx.appendChild(lineE);
                        Detalle.appendChild(IndEx);
                    }
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(iLine.getLine() / 10));
                    NroLinDet.appendChild(line);
                    Detalle.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle.appendChild(NmbItem);
                    Element DscItem = document.createElement("DscItem");
                    Text desc = document.createTextNode(iLine.getDescription() == null ? " " : iLine.getDescription());
                    DscItem.appendChild(desc);
                    Detalle.appendChild(DscItem);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().toString());
                    QtyItem.appendChild(qt);
                    Detalle.appendChild(QtyItem);
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(iLine.getPriceActual().setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(iLine.getLineNetAmt().setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle.appendChild(MontoItem);
                }
                ++i;
            }
            try {
                String TpoMovStr = invoice.get_ValueAsString("TpoMov");
                String GlosaDRStr = invoice.get_ValueAsString("GlosaDR");
                String TpoValorStr = invoice.get_ValueAsString("TpoValor");
                BigDecimal AmtValorDR = DB.getSQLValueBD((String)invoice.get_TrxName(), (String)"SELECT SUM(LineNetAmt) FROM C_InvoiceLine  WHERE C_Invoice_ID = ? AND LineNetAmt < 0", (int)invoice.get_ID());
                if (TpoMovStr != null && TpoMovStr != "" && GlosaDRStr != null && GlosaDRStr != "" && TpoValorStr != null && TpoValorStr != "" && AmtValorDR != null && AmtValorDR.compareTo(Env.ZERO) < 0) {
                    mylog = "DscRcgGlobal";
                    Element DscRcgGlobal = document.createElement("DscRcgGlobal");
                    Documento.appendChild(DscRcgGlobal);
                    int correlativo = 1;
                    Element NroLinDR = document.createElement("NroLinDR");
                    Text NroLinDRTxt = document.createTextNode(Integer.toString(correlativo));
                    NroLinDR.appendChild(NroLinDRTxt);
                    DscRcgGlobal.appendChild(NroLinDR);
                    Element TpoMov = document.createElement("TpoMov");
                    Text TpoMovTxt = document.createTextNode(TpoMovStr);
                    TpoMov.appendChild(TpoMovTxt);
                    DscRcgGlobal.appendChild(TpoMov);
                    Element GlosaDR = document.createElement("GlosaDR");
                    Text GlosaDRTxt = document.createTextNode(GlosaDRStr);
                    GlosaDR.appendChild(GlosaDRTxt);
                    DscRcgGlobal.appendChild(GlosaDR);
                    Element TpoValor = document.createElement("TpoValor");
                    Text TpoValorTxt = document.createTextNode(TpoValorStr);
                    TpoValor.appendChild(TpoValorTxt);
                    DscRcgGlobal.appendChild(TpoValor);
                    Element ValorDR = document.createElement("ValorDR");
                    Text ValorDRTxt = document.createTextNode(AmtValorDR.abs().setScale(0, 4).toString());
                    ValorDR.appendChild(ValorDRTxt);
                    DscRcgGlobal.appendChild(ValorDR);
                }
            }
            catch (Exception e) {
                this.log.severe("Error nuevas variables: NroLinDR,TpoMov,GlosaDR,TpoValor,ValorDR  " + e.getMessage());
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (invoice.get_Value("C_RefDoc_ID") != null && (Integer)invoice.get_Value("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), refdoc.getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = refdoc.getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = refdoc.getDocumentNo();
                fechareferencia = refdoc.getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            if (tipo_Ref > 0) {
                Element Referencia = document.createElement("Referencia");
                Documento.appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("0001");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                String CodRefTxt = null;
                try {
                    CodRefTxt = invoice.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(invoice.get_ValueAsString("CodRef") == null ? "0" : invoice.get_ValueAsString("CodRef"));
                    CodRef.appendChild(codref);
                    Referencia.appendChild(CodRef);
                }
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento.appendChild(Firma);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, invoice.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("xmlns", "http://www.sii.cl/SiiDte");
            raiz.setAttribute("version", "1.0");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Baskakow Generated";
    }
}

