/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.X_DM_PerformanceBond;
import org.compiere.model.X_DM_PerformanceBondDet_Proc;
import org.compiere.model.X_DM_PerformanceBond_Proc;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CreatePerformanceBondDet
extends SvrProcess {
    private Timestamp p_DateTrx_From;
    private int p_Document_ID = 0;

    protected void prepare() {
        this.p_Document_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_DateTrx_From = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        X_DM_PerformanceBond_Proc pro = new X_DM_PerformanceBond_Proc(this.getCtx(), this.p_Document_ID, this.get_TrxName());
        int cant = 0;
        if (pro.getC_DocType().getDocBaseType().equals("PBV")) {
            CPreparedStatement pstmt = null;
            String sql = "SELECT dm.DM_PerformanceBond_ID FROM DM_PerformanceBond dm WHERE dm.dateend <= ? AND dm.Status like 'ENC' AND dm.DM_PerformanceBond_ID NOT IN (SELECT DM_PerformanceBond_ID FROM DM_PerformanceBondDet_Proc)";
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setTimestamp(1, this.p_DateTrx_From);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_DM_PerformanceBond boleta = new X_DM_PerformanceBond(this.getCtx(), rs.getInt(1), this.get_TrxName());
                    X_DM_PerformanceBondDet_Proc det = new X_DM_PerformanceBondDet_Proc(this.getCtx(), 0, this.get_TrxName());
                    det.setDM_PerformanceBond_Proc_ID(pro.get_ID());
                    det.setDM_PerformanceBond_ID(boleta.get_ID());
                    det.setAmt(boleta.getAmt());
                    det.set_CustomColumn("C_Bpartner_ID", boleta.getC_BPartner_ID());
                    det.set_CustomColumn("correlative", boleta.getcorrelative());
                    det.set_CustomColumn("status", boleta.getStatus());
                    det.set_CustomColumn("C_Bank_ID", boleta.getC_Bank_ID());
                    det.set_CustomColumn("C_Currency_ID", boleta.getC_Currency_ID());
                    det.setDescription(boleta.getDescription());
                    BigDecimal amtConvert = new BigDecimal("0.0");
                    String sqlSchema = "SELECT MAX(C_AcctSchema1_ID) FROM AD_ClientInfo WHERE AD_Client_ID = " + boleta.getAD_Client_ID();
                    int schema_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlSchema);
                    MAcctSchema as = new MAcctSchema(this.getCtx(), schema_ID, this.get_TrxName());
                    this.log.config("variables para la conversion:" + boleta.getAmt() + " , " + boleta.getC_Currency_ID() + " , " + boleta.getC_Currency_ID() + " , " + boleta.getDateAcct() + " , " + 114 + " , " + boleta.getAD_Client_ID() + " , " + boleta.getAD_Org_ID());
                    if (boleta.getC_Currency_ID() != as.getC_Currency_ID()) {
                        amtConvert = MConversionRate.convert(this.getCtx(), boleta.getAmt(), boleta.getC_Currency_ID(), as.getC_Currency_ID(), (Timestamp)boleta.get_Value("DateDoc"), 114, boleta.getAD_Client_ID(), boleta.getAD_Org_ID());
                        this.log.config("monto dentro de if: " + amtConvert);
                    } else {
                        amtConvert = boleta.getAmt();
                    }
                    if (amtConvert != null) {
                        det.set_CustomColumn("AmtRef", amtConvert);
                    }
                    det.save();
                    ++cant;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
        }
        return "Se han agregado " + cant + " Boletas de Honorarios";
    }
}

