/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class ChangeOrderCurrency
extends SvrProcess {
    private int Currency_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Currency_ID")) {
                    this.Currency_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MOrderLine[] lines;
        MOrder order = new MOrder(Env.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (order.getC_Currency_ID() == this.Currency_ID) {
            return "Ya tiene esta Moneda";
        }
        MOrderLine[] mOrderLineArray = lines = order.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLine line = mOrderLineArray[n2];
            BigDecimal amt = MConversionRate.convert(this.getCtx(), line.getPriceActual(), order.getC_Currency_ID(), this.Currency_ID, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            BigDecimal amtPriceList = MConversionRate.convert(this.getCtx(), line.getPriceList(), order.getC_Currency_ID(), this.Currency_ID, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
            if (amt == null) {
                return "No existe tasa de cambio, no se puede completar la operacion";
            }
            line.setPriceList(amtPriceList);
            line.setPrice(amt);
            line.save();
            ++n2;
        }
        order.setC_Currency_ID(this.Currency_ID);
        order.save();
        return "Moneda Actualizada";
    }
}

