/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModelOFBBlumosUpdateCredit
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBBlumosUpdateCredit.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addDocValidate("C_BankStatement", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        BigDecimal payAmt;
        BigDecimal balance;
        MBPartner bPartner;
        MPayment pay;
        MBankStatementLine line;
        MBankStatementLine[] lines;
        MBankStatement bStatement;
        BigDecimal payAmt2;
        MBPartner bPartner2;
        BigDecimal balance2;
        MPayment pay2;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MPayment.Table_ID) {
            pay2 = (MPayment)((Object)po);
            balance2 = pay2.getC_BPartner().getTotalOpenBalance();
            bPartner2 = new MBPartner(po.getCtx(), pay2.getC_BPartner_ID(), po.get_TrxName());
            payAmt2 = MConversionRate.convertBase(po.getCtx(), pay2.getPayAmt(), pay2.getC_Currency_ID(), pay2.getDateAcct(), pay2.getC_ConversionType_ID(), pay2.getAD_Client_ID(), pay2.getAD_Org_ID());
            if (payAmt2 == null) {
                payAmt2 = Env.ZERO;
            }
            if (balance2 == null) {
                balance2 = Env.ZERO;
            }
            balance2 = pay2.isReceipt() ? balance2.add(payAmt2) : balance2.subtract(payAmt2);
            bPartner2.setTotalOpenBalance(balance2);
            bPartner2.save();
        }
        if (timing == 10 && po.get_Table_ID() == MPayment.Table_ID) {
            pay2 = (MPayment)((Object)po);
            balance2 = pay2.getC_BPartner().getTotalOpenBalance();
            bPartner2 = new MBPartner(po.getCtx(), pay2.getC_BPartner_ID(), po.get_TrxName());
            payAmt2 = MConversionRate.convertBase(po.getCtx(), pay2.getPayAmt(), pay2.getC_Currency_ID(), pay2.getDateAcct(), pay2.getC_ConversionType_ID(), pay2.getAD_Client_ID(), pay2.getAD_Org_ID());
            if (payAmt2 == null) {
                payAmt2 = Env.ZERO;
            }
            if (balance2 == null) {
                balance2 = Env.ZERO;
            }
            balance2 = pay2.isReceipt() ? balance2.subtract(payAmt2) : balance2.add(payAmt2);
            bPartner2.setTotalOpenBalance(balance2);
            bPartner2.save();
        }
        if (timing == 9 && po.get_Table_ID() == MBankStatement.Table_ID) {
            bStatement = (MBankStatement)((Object)po);
            lines = bStatement.getLines(true);
            int i = 0;
            while (i < lines.length) {
                line = lines[i];
                if (line.getC_Payment_ID() > 0) {
                    pay = new MPayment(po.getCtx(), line.getC_Payment_ID(), po.get_TrxName());
                    bPartner = new MBPartner(po.getCtx(), pay.getC_BPartner_ID(), po.get_TrxName());
                    balance = pay.getC_BPartner().getTotalOpenBalance();
                    payAmt = MConversionRate.convertBase(po.getCtx(), line.getStmtAmt().abs(), pay.getC_Currency_ID(), pay.getDateAcct(), pay.getC_ConversionType_ID(), pay.getAD_Client_ID(), pay.getAD_Org_ID());
                    if (payAmt == null) {
                        payAmt = Env.ZERO;
                    }
                    if (balance == null) {
                        balance = Env.ZERO;
                    }
                    balance = pay.isReceipt() ? balance.subtract(payAmt) : balance.add(payAmt);
                    bPartner.setTotalOpenBalance(balance);
                    bPartner.save();
                }
                ++i;
            }
        }
        if (timing == 2 && po.get_Table_ID() == MBankStatement.Table_ID) {
            bStatement = (MBankStatement)((Object)po);
            lines = bStatement.getLines(true);
            int i = 0;
            while (i < lines.length) {
                line = lines[i];
                if (line.getC_Payment_ID() > 0) {
                    pay = new MPayment(po.getCtx(), line.getC_Payment_ID(), po.get_TrxName());
                    bPartner = new MBPartner(po.getCtx(), pay.getC_BPartner_ID(), po.get_TrxName());
                    balance = pay.getC_BPartner().getTotalOpenBalance();
                    payAmt = MConversionRate.convertBase(po.getCtx(), line.getStmtAmt().abs(), pay.getC_Currency_ID(), pay.getDateAcct(), pay.getC_ConversionType_ID(), pay.getAD_Client_ID(), pay.getAD_Org_ID());
                    if (payAmt == null) {
                        payAmt = Env.ZERO;
                    }
                    if (balance == null) {
                        balance = Env.ZERO;
                    }
                    balance = pay.isReceipt() ? balance.add(payAmt) : balance.subtract(payAmt);
                    bPartner.setTotalOpenBalance(balance);
                    bPartner.save();
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

