/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_Payment;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_MP_AssetMeter;
import org.compiere.model.X_MP_AssetMeter_Log;
import org.compiere.model.X_MP_Meter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFB
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFB.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("MP_AssetMeter_Log", (ModelValidator)this);
        engine.addModelChange("C_PaymentRequestLine", (ModelValidator)this);
        engine.addModelChange("C_Payment", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        X_C_PaymentRequest req;
        MInvoice inv;
        BigDecimal total1;
        boolean validation;
        X_MP_Meter met;
        X_MP_AssetMeter aMet;
        X_MP_AssetMeter_Log aMetLog;
        BigDecimal amtmeter2;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 1 && po.get_Table_ID() == 1000023) {
            amtmeter2 = (BigDecimal)po.get_Value("Amt");
            if (amtmeter2.signum() == 0) {
                return "no puede ingresar valor 0";
            }
            aMetLog = (X_MP_AssetMeter_Log)po;
            aMet = new X_MP_AssetMeter(po.getCtx(), aMetLog.getMP_AssetMeter_ID(), po.get_TrxName());
            met = new X_MP_Meter(po.getCtx(), aMet.get_ValueAsInt("MP_Meter_ID"), po.get_TrxName());
            validation = false;
            try {
                validation = met.get_ValueAsBoolean("NoValidationAMLog");
            }
            catch (Exception e) {
                validation = false;
                log.config("Error al leer campo NoValidationAMLog");
            }
            if (!validation) {
                if (amtmeter2.signum() > 0 && (total1 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("select MAX(amt) from MP_AssetMeter_Log where MP_AssetMeter_ID=" + po.get_ValueAsInt("MP_AssetMeter_ID")), (Object[])new Object[0])) != null && total1.compareTo(amtmeter2) >= 0) {
                    return "No puede ingresar " + amtmeter2 + ". ultimo registro " + total1;
                }
            } else {
                aMet.setAmt(amtmeter2);
                aMet.save();
            }
        }
        if (type == 2 && po.get_Table_ID() == 1000023 && po.is_ValueChanged("Amt")) {
            amtmeter2 = (BigDecimal)po.get_Value("Amt");
            if (amtmeter2.signum() == 0) {
                return "No puede ingresar valor 0";
            }
            aMetLog = (X_MP_AssetMeter_Log)po;
            aMet = new X_MP_AssetMeter(po.getCtx(), aMetLog.getMP_AssetMeter_ID(), po.get_TrxName());
            met = new X_MP_Meter(po.getCtx(), aMet.get_ValueAsInt("MP_Meter_ID"), po.get_TrxName());
            validation = false;
            try {
                validation = met.get_ValueAsBoolean("NoValidationAMLog");
            }
            catch (Exception e) {
                validation = false;
                log.config("Error al leer campo NoValidationAMLog");
            }
            if (!validation) {
                if (amtmeter2.signum() > 0 && (total1 = DB.getSQLValueBD((String)po.get_TrxName(), (String)("select MAX(amt) from MP_AssetMeter_Log where MP_AssetMeter_ID=" + po.get_ValueAsInt("MP_AssetMeter_ID")), (Object[])new Object[0])) != null && total1.compareTo(amtmeter2) >= 0) {
                    return "No puede ingresar " + amtmeter2 + ". ultimo registro " + total1;
                }
            } else {
                aMet.setAmt(amtmeter2);
                aMet.save();
            }
        }
        if ((type == 5 || type == 4 || type == 6) && po.get_Table_ID() == X_C_PaymentRequestLine.Table_ID) {
            X_C_PaymentRequestLine line = (X_C_PaymentRequestLine)po;
            BigDecimal total = DB.getSQLValueBD((String)po.get_TrxName(), (String)("select sum(amt) from C_PaymentRequestLine where isactive='Y' and C_PaymentRequest_ID=" + line.getC_PaymentRequest_ID()), (Object[])new Object[0]);
            X_C_PaymentRequest hr = new X_C_PaymentRequest(po.getCtx(), line.getC_PaymentRequest_ID(), po.get_TrxName());
            hr.setPayAmt(total == null ? Env.ZERO : total);
            hr.save();
        }
        if (type == 5 && po.get_Table_ID() == X_C_Payment.Table_ID) {
            ResultSet rs;
            X_C_Payment pay = (X_C_Payment)po;
            CPreparedStatement pstmt = null;
            String mySql = "select distinct C_AllocationHdr_ID FROM C_AllocationLine WHERE C_Payment_ID = ?";
            if (pay.getDocStatus() == DOCSTATUS_Completed) {
                try {
                    MAllocationHdr hdr;
                    pstmt = DB.prepareStatement((String)mySql, (String)po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next() && ((hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Drafted) == 0 || hdr.getDocStatus().compareTo(DOCSTATUS_InProgress) == 0)) {
                        hdr.setDocStatus(hdr.completeIt());
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Completed");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
            if (pay.getDocStatus().compareTo(DOCSTATUS_Voided) == 0) {
                try {
                    MAllocationHdr hdr;
                    pstmt = DB.prepareStatement((String)mySql, (String)po.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next() && (hdr = new MAllocationHdr(po.getCtx(), rs.getInt("C_AllocationHdr_ID"), po.get_TrxName())).getDocStatus().compareTo(DOCSTATUS_Completed) == 0 && hdr.voidIt()) {
                        hdr.save();
                        log.info("Allocation: " + hdr.get_ID() + " Voided");
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)((Object)po)).isSOTrx()) {
            int cant = 0;
            cant = DB.getSQLValue((String)po.get_TrxName(), (String)("SELECT COUNT(1) FROM C_Invoice WHERE C_DocTypeTarget_ID = " + inv.getC_DocTypeTarget_ID() + " " + "AND DocumentNo = '" + inv.getDocumentNo() + "' AND C_Invoice_ID <> " + inv.get_ID()));
            if (cant > 0) {
                return "Ya existe una factura con mismo Numero y Tipo de Documento";
            }
        }
        if (type == 5 && po.get_Table_ID() == X_C_PaymentRequest.Table_ID && po.is_ValueChanged("DocStatus") && (req = (X_C_PaymentRequest)po).getDocStatus().compareTo(DOCSTATUS_Voided) == 0) {
            X_C_PaymentRequestLine[] lines;
            X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines = req.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n2];
                if (line.get_ValueAsInt("DM_Document_ID") > 0) {
                    X_DM_Document doc = new X_DM_Document(po.getCtx(), line.get_ValueAsInt("DM_Document_ID"), po.get_TrxName());
                    BigDecimal dif = (BigDecimal)doc.get_Value("Allocatedamt");
                    dif = dif.subtract(line.getAmt());
                    doc.set_CustomColumn("Allocatedamt", dif);
                    doc.saveEx(po.get_TrxName());
                }
                ++n2;
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

