/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_OtherExpenses;
import org.compiere.util.CLogger;

public class ModANDESOtherExpenses
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModANDESOtherExpenses.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_OtherExpenses", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_C_OtherExpenses.Table_ID) {
            X_C_OtherExpenses oExpenses = (X_C_OtherExpenses)po;
            BigDecimal c20000 = new BigDecimal("20000.00");
            BigDecimal c10000 = new BigDecimal("10000.00");
            BigDecimal c5000 = new BigDecimal("5000.00");
            BigDecimal c2000 = new BigDecimal("2000.00");
            BigDecimal c1000 = new BigDecimal("1000.00");
            BigDecimal c500 = new BigDecimal("500.00");
            BigDecimal c100 = new BigDecimal("100.00");
            BigDecimal c50 = new BigDecimal("50.00");
            BigDecimal c10 = new BigDecimal("10.00");
            BigDecimal c5 = new BigDecimal("5.00");
            if (oExpenses.getcurrency_20000() != null && oExpenses.getcurrency_20000().doubleValue() % c20000.doubleValue() > 0.0) {
                return "Monto de 20.000 no concordante";
            }
            if (oExpenses.getcurrency_10000() != null && oExpenses.getcurrency_10000().doubleValue() % c10000.doubleValue() > 0.0) {
                return "Monto de 10.000 no concordante";
            }
            if (oExpenses.getcurrency_5000() != null && oExpenses.getcurrency_5000().doubleValue() % c5000.doubleValue() > 0.0) {
                return "Monto de 5.000 no concordante";
            }
            if (oExpenses.getcurrency_2000() != null && oExpenses.getcurrency_2000().doubleValue() % c2000.doubleValue() > 0.0) {
                return "Monto de 2.000 no concordante";
            }
            if (oExpenses.getcurrency_1000() != null && oExpenses.getcurrency_1000().doubleValue() % c1000.doubleValue() > 0.0) {
                return "Monto de 1.000 no concordante";
            }
            if (oExpenses.getcurrency_500() != null && oExpenses.getcurrency_500().doubleValue() % c500.doubleValue() > 0.0) {
                return "Monto de 500 no concordante";
            }
            if (oExpenses.getcurrency_100() != null && oExpenses.getcurrency_100().doubleValue() % c100.doubleValue() > 0.0) {
                return "Monto de 100 no concordante";
            }
            if (oExpenses.getcurrency_50() != null && oExpenses.getcurrency_50().doubleValue() % c50.doubleValue() > 0.0) {
                return "Monto de 50 no concordante";
            }
            if (oExpenses.getcurrency_10() != null && oExpenses.getcurrency_10().doubleValue() % c10.doubleValue() > 0.0) {
                return "Monto de 10 no concordante";
            }
            if (oExpenses.getcurrency_5() != null && oExpenses.getcurrency_5().doubleValue() % c5.doubleValue() > 0.0) {
                return "Monto de 5 no concordante";
            }
            if (oExpenses.getDocumentDate() != null || oExpenses.getDatePromised() != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                Timestamp today = new Timestamp(calendar.getTimeInMillis());
                Timestamp docDate = oExpenses.getDocumentDate();
                Timestamp proDate = oExpenses.getDatePromised();
                Calendar calendarAux = Calendar.getInstance();
                if (docDate != null) {
                    calendarAux.setTimeInMillis(docDate.getTime());
                    calendarAux.set(11, 0);
                    calendarAux.set(12, 0);
                    calendarAux.set(13, 0);
                    calendarAux.set(14, 0);
                    docDate = new Timestamp(calendarAux.getTimeInMillis());
                    if (docDate.compareTo(today) < 0) {
                        log.config("Fecha hoy: " + today + " Fecha Documento: " + docDate);
                        return "Fecha Incorrecta";
                    }
                }
                if (proDate != null) {
                    calendarAux.setTimeInMillis(proDate.getTime());
                    calendarAux.set(11, 0);
                    calendarAux.set(12, 0);
                    calendarAux.set(13, 0);
                    calendarAux.set(14, 0);
                    proDate = new Timestamp(calendarAux.getTimeInMillis());
                    if (proDate.compareTo(today) < 0) {
                        log.config("Fecha hoy: " + today + " Fecha Prometida: " + proDate);
                        return "Fecha Incorrecta";
                    }
                }
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

