/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_AD_ReplicationDocument;
import org.compiere.model.X_AD_ReplicationTable;
import org.compiere.util.CLogger;
import org.ofb.process.rpl.exp.ExportHelper;

public class ExportModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ExportModelValidator.class);
    private int m_AD_Client_ID = -1;
    private int m_AD_Org_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_ReplicationStrategy_ID = -1;
    ExportHelper expHelper = null;

    public void initialize(ModelValidationEngine engine, MClient client) {
        MTable table2;
        this.m_AD_Client_ID = client.getAD_Client_ID();
        log.info(client.toString());
        MReplicationStrategy rplStrategy = null;
        this.m_AD_ReplicationStrategy_ID = client.getAD_ReplicationStrategy_ID();
        log.info("client.getAD_ReplicationStrategy_ID() = " + this.m_AD_ReplicationStrategy_ID);
        if (this.m_AD_ReplicationStrategy_ID > 0) {
            rplStrategy = new MReplicationStrategy(client.getCtx(), this.m_AD_ReplicationStrategy_ID, null);
            this.expHelper = new ExportHelper(client, rplStrategy);
        }
        if (rplStrategy != null) {
            for (X_AD_ReplicationTable rplTable : rplStrategy.getReplicationTables()) {
                if (!"M".equals(rplTable.getReplicationType()) && !"R".equals(rplTable.getReplicationType())) continue;
                table2 = MTable.get((Properties)client.getCtx(), (int)rplTable.getAD_Table_ID());
                engine.addModelChange(table2.getTableName(), (ModelValidator)this);
            }
        }
        if (rplStrategy != null) {
            for (X_AD_ReplicationDocument rplDocument : rplStrategy.getReplicationDocuments()) {
                if (!"M".equals(rplDocument.getReplicationType()) && !"R".equals(rplDocument.getReplicationType())) continue;
                table2 = MTable.get((Properties)client.getCtx(), (int)rplDocument.getAD_Table_ID());
                engine.addDocValidate(table2.getTableName(), (ModelValidator)this);
            }
        }
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info("po.get_TableName() = " + po.get_TableName());
        if (this.expHelper != null && (type == 5 || type == 4 || type == 3)) {
            this.expHelper.exportRecord(po, 0, MReplicationStrategy.getReplicationTable((Properties)po.getCtx(), (int)this.m_AD_ReplicationStrategy_ID, (int)po.get_Table_ID()).getReplicationType(), type);
        }
        return null;
    }

    public String docValidate(PO po, int type) {
        log.info("po.get_TableName() = " + po.get_TableName());
        String result = null;
        if (this.expHelper != null) {
            try {
                if (type == 9 || type == 11 || type == 13 || type == 10 || type == 10 || type == 8) {
                    this.expHelper.exportRecord(po, 1, MReplicationStrategy.getReplicationDocument((Properties)po.getCtx(), (int)this.m_AD_ReplicationStrategy_ID, (int)po.get_Table_ID()).getReplicationType(), type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = e.toString();
            }
        }
        return result;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_AD_User_ID = AD_User_ID;
        log.info("AD_Org_ID  =" + this.m_AD_Org_ID);
        log.info("AD_Role_ID =" + this.m_AD_Role_ID);
        log.info("AD_User_ID =" + this.m_AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(ExportModelValidator.class.getName());
        return sb.toString();
    }
}

