/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.model.X_AD_User;
import org.compiere.model.X_RH_AdministrativeRequests;
import org.compiere.model.X_RH_AdministrativeRequestsLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutRHAdministrativeRequests
extends CalloutEngine {
    public String Authorizations(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        String sql = "select max(ad_user_id) from ad_user adu where password is not null and adu.C_BPartner_ID = ?";
        int userID = DB.getSQLValue(null, (String)sql, (Object[])new Object[]{mTab.getValue("C_Bpartner_ID")});
        String requestType = "";
        requestType = mTab.get_ValueAsString("RequestType");
        if (mField.getColumnName().equals("Signature3") && value.equals(true)) {
            String sqlUGP;
            int cantRH;
            int cantCMTD;
            BigDecimal dd;
            MBPartner bp;
            int Record_ID = (Integer)mTab.getValue("RH_AdministrativeRequests_ID");
            X_RH_AdministrativeRequests doc = new X_RH_AdministrativeRequests(Env.getCtx(), Record_ID, null);
            if (doc.getRequestType().equals("PAD")) {
                bp = MBPartner.get(Env.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD(null, (String)"select coalesce ((SUM( case when block = 'MDM' then 0.5 when block = 'MDT' then 0.5 when block = 'DIA' then 1 end)),0) from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID=?", (int)doc.getAdministrativeRequests_ID());
                BigDecimal PADep = DB.getSQLValueBD(null, (String)"select coalesce ((SUM(case when arl.block = 'MDM' then 0.5 when arl.block = 'MDT' then 0.5 when arl.block = 'DIA' then 1 end)),0) from RH_AdministrativeRequestsline arl inner join RH_AdministrativeRequests ar on (arl.RH_AdministrativeRequests_id = ar.RH_AdministrativeRequests_id) where ar.requesttype like 'PAD' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y' and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantPAD = (BigDecimal)bp.get_Value("RH_AdministrativeDays");
                if (dd.add(PADep).compareTo(cantPAD) > 0) {
                    mTab.setValue("Signature3", (Object)"N");
                    return "Dias Administrativos Disponibles Insuficientes";
                }
            }
            if (doc.getRequestType().equals("CMT") && (cantCMTD = DB.getSQLValue(null, (String)"select count(*) from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID=?", (int)doc.getAdministrativeRequests_ID())) < 1) {
                mTab.setValue("Signature3", (Object)"N");
                return "Solicitud de Cometido debe Tener Detalle(Comunas)";
            }
            if (doc.getRequestType().equals("TCP")) {
                bp = MBPartner.get(Env.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD(null, (String)"select coalesce ((SUM(numberhours)),0) as qty from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                int cantTCPD = DB.getSQLValue(null, (String)"select count(*) from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID=?", (int)doc.getAdministrativeRequests_ID());
                if (cantTCPD < 1) {
                    mTab.setValue("Signature3", (Object)"N");
                    return "Solicitud Tiempo Compensado debe Tener Detalle";
                }
                BigDecimal TCPep = DB.getSQLValueBD(null, (String)"select coalesce ((SUM(numberhours)),0) as qty from RH_AdministrativeRequestsline arl inner join RH_AdministrativeRequests ar on (arl.RH_AdministrativeRequests_id = ar.RH_AdministrativeRequests_id) where ar.requesttype like 'TCP' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y'and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantTCP = (BigDecimal)bp.get_Value("numberhours");
                if (dd.add(TCPep).compareTo(cantTCP) > 0) {
                    mTab.setValue("Signature3", (Object)"N");
                    return "Horas Acumuladas Disponibles Insuficientes";
                }
            }
            if (doc.getRequestType().equals("SVC")) {
                bp = MBPartner.get(Env.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD(null, (String)"select NumberDays from RH_AdministrativeRequests where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                BigDecimal SVCep = DB.getSQLValueBD(null, (String)"select coalesce ((sum(NumberDays)),0) from RH_AdministrativeRequests ar where ar.requesttype like 'SVC' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y' and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantSVC = (BigDecimal)bp.get_Value("RH_AcumulateDays");
                if (dd.add(SVCep).compareTo(cantSVC) > 0) {
                    mTab.setValue("Signature3", (Object)"N");
                    return "Dias Legales Disponibles Insuficientes";
                }
            }
            if (doc.getRequestType().equals("PSD")) {
                bp = MBPartner.get(Env.getCtx(), doc.getC_BPartner_ID());
                dd = DB.getSQLValueBD(null, (String)"select coalesce ((SUM(numberhours)),0) as qty from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID = ?", (int)doc.getAdministrativeRequests_ID());
                BigDecimal PSDep = DB.getSQLValueBD(null, (String)"select coalesce ((SUM(numberhours)),0) as qty from RH_AdministrativeRequestsline arl inner join RH_AdministrativeRequests ar on (arl.RH_AdministrativeRequests_id = ar.RH_AdministrativeRequests_id) where ar.requesttype like 'PSD' and (ar.docstatus = 'DR' OR ar.docstatus = 'IP') and ar.isactive = 'Y' and ar.Signature3 = 'Y' and ar.c_bpartner_id = ? and ar.RH_AdministrativeRequests_ID not in (?)", (Object[])new Object[]{bp.get_ID(), doc.getAdministrativeRequests_ID()});
                BigDecimal cantPSD = (BigDecimal)bp.get_Value("RH_UnionHours");
                if (dd.add(PSDep).compareTo(cantPSD) > 0) {
                    mTab.setValue("Signature3", (Object)"N");
                    return "Horas Sindicales Disponibles Insuficientes";
                }
            }
            if (doc.getRequestType().equals("SHE")) {
                CPreparedStatement pstmt = null;
                String sqlVL = "SELECT RH_AdministrativeRequestsLine_ID FROM RH_AdministrativeRequestsLine WHERE RH_AdministrativeRequests_ID = ? ";
                try {
                    pstmt = DB.prepareStatement((String)sqlVL, (String)doc.get_TrxName());
                    pstmt.setInt(1, doc.get_ID());
                    ResultSet rs = pstmt.executeQuery();
                    String sqlDY = "select Coalesce((upper(substring(Feriado from 1 for 1))),'N') from dateofyear where trunc(date2) = ?";
                    Date dateStar = new Date(doc.getdatestartrequest().getTime());
                    Timestamp dateStarTS = new Timestamp(dateStar.getTime());
                    String feriado = DB.getSQLValueString(null, (String)sqlDY, (Object[])new Object[]{dateStarTS});
                    if (feriado == null) {
                        feriado = "N";
                    }
                    if (feriado.equals("N")) {
                        Calendar startCal = Calendar.getInstance();
                        startCal.setTime((Timestamp)doc.get_Value("datestartrequest"));
                        if (startCal.get(7) == 7 || startCal.get(7) == 1) {
                            feriado = "Y";
                        }
                    }
                    while (rs.next()) {
                        X_RH_AdministrativeRequestsLine RL = new X_RH_AdministrativeRequestsLine(Env.getCtx(), rs.getInt(1), null);
                        String typeHExtra = RL.get_ValueAsString("Percentage");
                        if (typeHExtra == null) {
                            mTab.setValue("Signature3", (Object)false);
                            return "Detalle de Hora sin Porcentaje: " + RL.get_ID();
                        }
                        if (feriado.equals("Y") && typeHExtra.equalsIgnoreCase("25")) {
                            mTab.setValue("Signature3", (Object)false);
                            return "Intervalo no v\u00e1lido, revise Hora inicio/Hora fin : " + RL.get_ID();
                        }
                        if (!feriado.equalsIgnoreCase("N")) continue;
                        Timestamp st = (Timestamp)RL.get_Value("StartTime");
                        Timestamp et = (Timestamp)RL.get_Value("EndTime");
                        Time StartTime = new Time(st.getTime());
                        Time EndTime = new Time(et.getTime());
                        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss");
                        String rango1 = "17:15:00";
                        String rango2 = "21:00:00";
                        String rango3 = "23:59:00";
                        String rango4 = "00:00:00";
                        String rango5 = "06:59:00";
                        String rango6 = "16:15:00";
                        Date hora1 = dateFormat.parse(rango1);
                        Date hora2 = dateFormat.parse(rango2);
                        Date hora3 = dateFormat.parse(rango3);
                        Date hora4 = dateFormat.parse(rango4);
                        Date hora5 = dateFormat.parse(rango5);
                        Date hora6 = dateFormat.parse(rango6);
                        Date horai = dateFormat.parse(((Date)StartTime).toString());
                        Date horaf = dateFormat.parse(((Date)EndTime).toString());
                        if (typeHExtra.equalsIgnoreCase("25")) {
                            Calendar startCalF = Calendar.getInstance();
                            startCalF.setTime((Timestamp)doc.get_Value("datestartrequest"));
                            if (startCalF.get(7) == 6) {
                                if (horai.compareTo(hora6) <= 0 || horaf.compareTo(hora2) > 0) {
                                    mTab.setValue("Signature3", (Object)false);
                                    return "Intervalo no v\u00e1lido, revise Hora inicio/Hora fin : " + RL.get_ID();
                                }
                            } else if (horai.compareTo(hora1) <= 0 || horaf.compareTo(hora2) > 0) {
                                mTab.setValue("Signature3", (Object)false);
                                return "Intervalo no v\u00e1lido, revise Hora inicio/Hora fin : " + RL.get_ID();
                            }
                        }
                        if (!typeHExtra.equalsIgnoreCase("50") || horai.compareTo(hora2) > 0 && horaf.compareTo(hora3) <= 0 || horai.compareTo(hora4) > 0 && horaf.compareTo(hora5) <= 0) continue;
                        mTab.setValue("Signature3", (Object)false);
                        return "Intervalo no v\u00e1lido, revise Hora inicio/Hora fin : " + RL.get_ID();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                }
            }
            if ((doc.getRequestType().equals("PAD") || doc.getRequestType().equals("TCP") || doc.getRequestType().equals("SHE") || doc.getRequestType().equals("PA") || doc.getRequestType().equals("PSD") || doc.getRequestType().equals("CMT")) && (cantRH = DB.getSQLValue(null, (String)"select count(*) from RH_AdministrativeRequestsline where RH_AdministrativeRequests_ID=?", (int)doc.getAdministrativeRequests_ID())) < 1) {
                mTab.setValue("Signature3", (Object)"N");
                return "Solicitud debe Tener Lineas de Detalle";
            }
            if (requestType.equals("PAD") || requestType.equals("PEH") || requestType.equals("PSS") || requestType.equals("SVC") || requestType.equals("TCP") || requestType.equals("CMT") || requestType.equals("STV") || requestType.equals("SHE")) {
                X_AD_User user = new X_AD_User(Env.getCtx(), userID, null);
                mTab.setValue("Supervisor_ID", (Object)user.getSupervisor_ID());
            } else if (requestType.equals("JIN") || requestType.equals("PEF") || requestType.equals("PFF") || requestType.equals("PPM") || requestType.equals("PSD") || requestType.equals("SVP")) {
                if (requestType.equals("PSD")) {
                    mTab.setValue("Signature1", (Object)"Y");
                    mTab.setValue("Supervisor_ID", (Object)1000000);
                }
                sqlUGP = "select MAX(AD_Role_ID) from AD_Role where ugp = 'Y'";
                int roleUGP = DB.getSQLValue(null, (String)sqlUGP);
                mTab.setValue("AD_Role_UGP", (Object)roleUGP);
            } else {
                sqlUGP = "select MAX(AD_Role_ID) from AD_Role where ugp = 'Y'";
                int roleUGP = DB.getSQLValue(null, (String)sqlUGP);
                mTab.setValue("AD_Role_UGP", (Object)roleUGP);
                X_AD_User user = new X_AD_User(Env.getCtx(), userID, null);
                mTab.setValue("Supervisor_ID", (Object)user.getSupervisor_ID());
            }
            mTab.setValue("dateSignature3", (Object)new Timestamp(System.currentTimeMillis()));
        }
        if (mField.getColumnName().equals("Signature1") && value.equals(true)) {
            if (requestType.equals("PAD") || requestType.equals("PEH") || requestType.equals("PSS") || requestType.equals("SVC") || requestType.equals("TCP") || requestType.equals("CMT")) {
                mTab.setValue("Signature2", (Object)"Y");
                mTab.setValue("JDAFBy", (Object)1000000);
            } else if (requestType.equals("SHE")) {
                String sqlJDAF = "select MAX(AD_Role_ID) from AD_Role where jdaf = 'Y'";
                int roleJDAF = DB.getSQLValue(null, (String)sqlJDAF);
                mTab.setValue("AD_Role_JDAF", (Object)roleJDAF);
            }
            if (mTab.getValue("dateSignature3") != null) {
                mTab.setValue("difSupervisor", (Object)CalloutRHAdministrativeRequests.fechasDiferenciaEnDias((Date)mTab.getValue("dateSignature3"), new Timestamp(System.currentTimeMillis())));
            }
        }
        if (mField.getColumnName().equals("SignatureRRHH") && value.equals(true)) {
            int idUGP = Env.getAD_User_ID((Properties)ctx);
            if (requestType.equals("JIN") || requestType.equals("PEF") || requestType.equals("PFF") || requestType.equals("PPM") || requestType.equals("PSD") || requestType.equals("STV")) {
                String sqlJDAF = "select MAX(AD_Role_ID) from AD_Role where jdaf = 'Y'";
                int roleJDAF = DB.getSQLValue(null, (String)sqlJDAF);
                mTab.setValue("AD_Role_JDAF", (Object)roleJDAF);
                mTab.setValue("UGPBy", (Object)idUGP);
            } else if (requestType.equals("SVP")) {
                mTab.setValue("UGPBy", (Object)idUGP);
                mTab.setValue("Signature2", (Object)"Y");
                mTab.setValue("JDAFBy", (Object)1000000);
            } else {
                mTab.setValue("UGPBy", (Object)idUGP);
            }
            if (mTab.getValue("dateSignature3") != null) {
                mTab.setValue("difUGP", (Object)CalloutRHAdministrativeRequests.fechasDiferenciaEnDias((Date)mTab.getValue("dateSignature3"), new Timestamp(System.currentTimeMillis())));
            }
        }
        if (mField.getColumnName().equals("Signature2") && value.equals(true)) {
            mTab.setValue("JDAFBy", (Object)Env.getAD_User_ID((Properties)ctx));
        }
        return "";
    }

    public String BpartnerDefault(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int IDUser = Env.getAD_User_ID((Properties)ctx);
        String sql = "SELECT C_Bpartner_ID FROM AD_User WHERE AD_User_ID = ?";
        int IDBPartner = DB.getSQLValue(null, (String)sql, (int)IDUser);
        mTab.setValue("C_Bpartner_ID", (Object)IDBPartner);
        return "";
    }

    public String EndDateSVC(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        if (mTab.get_ValueAsString("RequestType").equals("SVC")) {
            Date fi = (Date)mTab.getValue("datestartrequest");
            BigDecimal qtyDays = (BigDecimal)mTab.getValue("NumberDays");
            int qty = qtyDays.intValue();
            Date ff = CalloutRHAdministrativeRequests.calculateEndDateFeriados(fi, qty);
            Timestamp cff = new Timestamp(ff.getTime());
            mTab.setValue("dateendrequest", (Object)cff);
        }
        return "";
    }

    public static Date calculateEndDate(Date startDate, int duration) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int i = 1;
        while (i < duration) {
            startCal.add(5, 1);
            while (startCal.get(7) == 7 || startCal.get(7) == 1) {
                startCal.add(5, 1);
            }
            ++i;
        }
        return startCal.getTime();
    }

    public static Date calculateEndDateFeriados(Date startDate, int duration) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int i = 1;
        while (i < duration) {
            startCal.add(5, 1);
            while (startCal.get(7) == 7 || startCal.get(7) == 1) {
                startCal.add(5, 1);
            }
            if (startCal.get(7) != 7 && startCal.get(7) != 1) {
                startCal.set(11, 0);
                startCal.set(12, 0);
                startCal.set(13, 0);
                Timestamp Hactual = new Timestamp(startCal.getTimeInMillis());
                String sqlDY = "select Coalesce((upper(substring(feriado from 1 for 1))),'N') from dateofyear where trunc(date2) = ?";
                String feriado = DB.getSQLValueString(null, (String)sqlDY, (Object[])new Object[]{Hactual});
                if (feriado != null && feriado.equals("Y")) {
                    --i;
                }
            }
            ++i;
        }
        return startCal.getTime();
    }

    public String EndTimeSHE(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        int IDAdmReq = (Integer)mTab.getValue("RH_AdministrativeRequests_ID");
        X_RH_AdministrativeRequests AdmRequest = new X_RH_AdministrativeRequests(Env.getCtx(), IDAdmReq, null);
        if (AdmRequest.getRequestType().equals("SHE") && mTab.getValue("StartTime") != null && mTab.getValue("EndTime") != null) {
            Timestamp startTime = (Timestamp)mTab.getValue("StartTime");
            Timestamp endTime = (Timestamp)mTab.getValue("EndTime");
            if (endTime.compareTo(startTime) < 1) {
                if (mField.getColumnName().equals("StartTime")) {
                    mTab.setValue("StartTime", null);
                } else if (mField.getColumnName().equals("EndTime")) {
                    mTab.setValue("EndTime", null);
                }
                return "Hora Fin no puede ser mayor o igual a Hora Inicio";
            }
        }
        return "";
    }

    public static int fechasDiferenciaEnDias(Date fechaInicial, Date fechaFinal) {
        DateFormat df = DateFormat.getDateInstance(2);
        String fechaInicioString = df.format(fechaInicial);
        try {
            fechaInicial = df.parse(fechaInicioString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String fechaFinalString = df.format(fechaFinal);
        try {
            fechaFinal = df.parse(fechaFinalString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        long fechaInicialMs = fechaInicial.getTime();
        long fechaFinalMs = fechaFinal.getTime();
        long diferencia = fechaFinalMs - fechaInicialMs;
        double dias = Math.floor(diferencia / 86400000L);
        return (int)dias;
    }
}

