/*
 * Decompiled with CFR 0.152.
 */
package org.mutual.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateInvoiceRequest
extends SvrProcess {
    private String p_DocStatus = null;
    private String p_DocStatusTo = null;
    private Timestamp p_DateInvoiced_From;
    private int created = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DocStatus")) {
                this.p_DocStatus = (String)para[i].getParameter();
                this.p_DocStatusTo = (String)para[i].getParameter_To();
            } else if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced_From = (Timestamp)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        block10: {
            StringBuffer sql = new StringBuffer("select i.C_Invoice_ID ").append("from C_Invoice i ").append("where C_DocTypeTarget_ID = 1000066 and ").append("docstatus IN ('" + this.p_DocStatus + "') ");
            String clientCheck = " AND i.AD_Client_ID=" + Env.getAD_Client_ID((Properties)this.getCtx());
            sql.append(clientCheck);
            if (this.p_DateInvoiced_From != null) {
                sql.append(" and i.DateInvoiced <= '" + this.p_DateInvoiced_From + "'");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInvoice inv = new MInvoice(this.getCtx(), rs.getInt(1), this.get_TrxName());
                        if (this.p_DocStatusTo.compareToIgnoreCase("IP") == 0) {
                            inv.setDocStatus(this.p_DocStatusTo);
                            this.insertSAPTemp(inv.get_ID());
                        } else if (this.p_DocStatusTo.compareToIgnoreCase("CO") == 0) {
                            inv.processIt(this.p_DocStatusTo);
                            this.insertSAPTemp(inv.get_ID());
                        }
                        inv.save();
                        ++this.created;
                    }
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "Actualizadas " + this.created;
    }

    public void insertSAPTemp(int Invoice_ID) {
        this.log.info("Invoice_ID=" + Invoice_ID);
        String sqlInsert = "INSERT INTO i_solpesap (ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby,c_invreqnumber,doc_type_id,c_distribution, org_value,c_bpartnervalue,c_bparnername,c_bparnername2,c_orderreference,referencetype,invoicereference, c_dateinvreq,c_dateref,address1,address2,city,productvalue,m_productacct,qty,totallines,orderorg, ceconamecust,ceconamemut,ad_username,isinmediate,c_creditmemoinfo,referencereason,currency, headerdescription) SELECT ad_client_id,ad_org_id,isactive,created,createdby,updated,updatedby,c_invreqnumber,doc_type_id,c_distribution, org_value,c_bpartnervalue,c_bparnername,c_bparnername2,c_orderreference,referencetype,invoicereference, c_dateinvreq,c_dateref,address1,address2,city,productvalue,m_productacct,qty,totallines,orderorg, ceconamecust,ceconamemut,ad_username,isinmediate,c_creditmemoinfo,referencereason,currency, headerdescription FROM RVOFB_solpesapview WHERE C_Invoice_ID = " + Invoice_ID;
        DB.executeUpdate((String)sqlInsert, (String)this.get_TrxName());
        this.log.info(sqlInsert);
    }
}

