/*
 * Decompiled with CFR 0.152.
 */
package org.mutual.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.PO;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class SeparateInvoices
extends SvrProcess {
    private int m_C_Invoice_ID = 0;
    private Timestamp p_DateInvoiced_From;
    private int created = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_Invoice_ID")) {
                this.m_C_Invoice_ID = para[i].getParameterAsInt();
            } else if (name.equals("DateInvoiced")) {
                this.p_DateInvoiced_From = (Timestamp)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        block9: {
            StringBuffer sql = new StringBuffer("select i.C_Invoice_ID, i.DocumentNo, i.C_BPartner_ID ").append(" from C_Invoice i ").append(" where C_DocType_ID=1000002 AND").append(" not exists (select * from C_Invoice where ref_invoice_id = i.C_Invoice_ID AND DocStatus IN ('CO','DR','IP','CL')) ");
            String clientCheck = " AND i.AD_Client_ID=" + Env.getAD_Client_ID((Properties)this.getCtx());
            sql.append(clientCheck);
            if (this.m_C_Invoice_ID > 0) {
                sql.append(" and i.C_Invoice_ID=" + this.m_C_Invoice_ID);
            }
            if (this.p_DateInvoiced_From != null) {
                sql.append(" and i.DateInvoiced <= '" + this.p_DateInvoiced_From + "'");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String goTemp;
                        MBPartner bp = MBPartner.get(this.getCtx(), rs.getInt(3));
                        String groupOrder = "01";
                        if (bp.get_ValueAsInt("T_TradeAgreements_ID") > 0 && (goTemp = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT GroupOrder FROM T_TradeAgreements WHERE T_TradeAgreements_ID = ? ", (int)bp.get_ValueAsInt("T_TradeAgreements_ID"))) != null) {
                            groupOrder = goTemp;
                        }
                        this.createHeaders(rs.getInt(1), groupOrder);
                    }
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "Generadas " + this.created;
    }

    private int createHeaders(int C_Invoice_ID, String groupOrder) {
        block16: {
            String cAgrupado = "o.C_Order_ID";
            cAgrupado = groupOrder.compareToIgnoreCase("03") == 0 ? "o.C_BPartner_Location_ID" : (groupOrder.compareToIgnoreCase("02") == 0 ? "o.AD_User_ID" : (groupOrder.compareToIgnoreCase("04") == 0 ? "il.POReference" : (groupOrder.compareToIgnoreCase("01") == 0 ? "il.C_Invoice_ID" : "il.C_Invoice_ID")));
            StringBuffer sqlHeader = new StringBuffer("select " + cAgrupado + ", count(1) ").append("from C_InvoiceLine il ").append("inner join C_OrderLine ol on (il.C_OrderLine_ID=ol.C_OrderLine_ID) ").append("inner join C_Order o on (ol.C_Order_ID=o.C_Order_ID) ").append("where il.C_Invoice_ID=? ").append(" AND il.AD_Client_ID=" + Env.getAD_Client_ID((Properties)this.getCtx())).append(" group by " + cAgrupado);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlHeader.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInvoice original = MInvoice.get(this.getCtx(), C_Invoice_ID);
                        MInvoice newinvoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
                        newinvoice.setBPartner(MBPartner.get(this.getCtx(), original.getC_BPartner_ID()));
                        if (DB.isPostgreSQL()) {
                            newinvoice.setC_DocTypeTarget_ID(1000061);
                        } else if (DB.isOracle()) {
                            newinvoice.setC_DocTypeTarget_ID(1000066);
                        } else {
                            newinvoice.setC_DocTypeTarget_ID(1000066);
                        }
                        newinvoice.setRef_Invoice_ID(C_Invoice_ID);
                        newinvoice.setAD_Org_ID(original.getAD_Org_ID());
                        if (groupOrder.compareToIgnoreCase("03") == 0) {
                            newinvoice.setC_BPartner_Location_ID(rs.getInt(1));
                        } else {
                            newinvoice.setC_BPartner_Location_ID(original.getC_BPartner_Location_ID());
                        }
                        if (groupOrder.compareToIgnoreCase("02") == 0) {
                            newinvoice.setAD_User_ID(rs.getInt(1));
                        }
                        if (groupOrder.compareToIgnoreCase("04") == 0) {
                            newinvoice.setPOReference(rs.getString(1));
                        } else {
                            newinvoice.setPOReference(original.getPOReference());
                        }
                        newinvoice.set_CustomColumn("GroupOrder", groupOrder);
                        newinvoice.save();
                        ++this.created;
                        if (groupOrder.compareToIgnoreCase("03") == 0 || groupOrder.compareToIgnoreCase("02") == 0 || groupOrder.compareToIgnoreCase("01") == 0) {
                            this.createLines(newinvoice, C_Invoice_ID, cAgrupado, rs.getInt(1));
                            continue;
                        }
                        if (groupOrder.compareToIgnoreCase("04") != 0) continue;
                        this.createLinesPORef(newinvoice, C_Invoice_ID, cAgrupado, rs.getString(1));
                    }
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return 0;
    }

    private void createLines(MInvoice newinvoice, int C_Invoice_ID, String cAgrupado, int valueCAgrupado) {
        block7: {
            StringBuffer sqlsinDroga = new StringBuffer("select il.M_Product_ID,p.Name,d.Name as Servicio, il.QtyInvoiced, il.C_InvoiceLine_ID, il.PriceActual ").append("from C_InvoiceLine il ").append("inner join C_OrderLine ol on (il.C_OrderLine_ID=ol.C_OrderLine_ID) ").append("inner join C_Order o on (ol.C_Order_ID=o.C_Order_ID) ").append("inner join C_DocType d on (o.C_DocType_ID=d.C_DocType_ID) ").append("inner join M_Product p on (il.M_Product_ID=p.M_Product_ID) ").append("where il.C_Invoice_ID = ? and " + cAgrupado + " = " + valueCAgrupado + " ").append(" AND il.AD_Client_ID=" + Env.getAD_Client_ID((Properties)this.getCtx()));
            sqlsinDroga.append(" Order by d.Name,p.Name");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlsinDroga.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    PO line = null;
                    while (rs.next()) {
                        MInvoiceLine oldLine = new MInvoiceLine(this.getCtx(), rs.getInt(5), this.get_TrxName());
                        new MInvoiceLine(newinvoice);
                        line = new MInvoiceLine(newinvoice);
                        ((MInvoiceLine)line).setM_Product_ID(rs.getInt(1), true);
                        ((MInvoiceLine)line).setPrice(rs.getBigDecimal(6));
                        ((MInvoiceLine)line).setQty(rs.getBigDecimal(4));
                        line.set_CustomColumn("Ref_InvoiceLine_ID", rs.getInt(5));
                        ((X_C_InvoiceLine)line).setC_Tax_ID(oldLine.getC_Tax_ID());
                        ((MInvoiceLine)line).setM_AttributeSetInstance_ID(oldLine.getM_AttributeSetInstance_ID());
                        ((MInvoiceLine)line).setLineNetAmt();
                        line.save();
                    }
                    if (line != null) {
                        line.save();
                    }
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void createLinesPORef(MInvoice newinvoice, int C_Invoice_ID, String cAgrupado, String valueCAgrupado) {
        block7: {
            StringBuffer sqlsinDroga = new StringBuffer("select il.M_Product_ID,p.Name,d.Name as Servicio, il.QtyInvoiced, il.C_InvoiceLine_ID, il.PriceActual ").append("from C_InvoiceLine il ").append("inner join C_OrderLine ol on (il.C_OrderLine_ID=ol.C_OrderLine_ID) ").append("inner join C_Order o on (ol.C_Order_ID=o.C_Order_ID) ").append("inner join C_DocType d on (o.C_DocType_ID=d.C_DocType_ID) ").append("inner join M_Product p on (il.M_Product_ID=p.M_Product_ID) ").append("where il.C_Invoice_ID = ? and " + cAgrupado + " = '" + valueCAgrupado + "' ").append(" AND il.AD_Client_ID=" + Env.getAD_Client_ID((Properties)this.getCtx()));
            sqlsinDroga.append(" Order by d.Name,p.Name");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlsinDroga.toString(), (String)this.get_TrxName());
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    PO line = null;
                    while (rs.next()) {
                        MInvoiceLine oldLine = new MInvoiceLine(this.getCtx(), rs.getInt(5), this.get_TrxName());
                        new MInvoiceLine(newinvoice);
                        line = new MInvoiceLine(newinvoice);
                        ((MInvoiceLine)line).setM_Product_ID(rs.getInt(1), true);
                        ((MInvoiceLine)line).setPrice(rs.getBigDecimal(6));
                        ((MInvoiceLine)line).setQty(rs.getBigDecimal(4));
                        line.set_CustomColumn("Ref_InvoiceLine_ID", rs.getInt(5));
                        ((X_C_InvoiceLine)line).setC_Tax_ID(oldLine.getC_Tax_ID());
                        ((MInvoiceLine)line).setM_AttributeSetInstance_ID(oldLine.getM_AttributeSetInstance_ID());
                        ((MInvoiceLine)line).setLineNetAmt();
                        line.save();
                    }
                    if (line != null) {
                        line.save();
                    }
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

