/*
 * Decompiled with CFR 0.152.
 */
package org.metlife.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCampaign;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_C_Campaign;
import org.compiere.model.X_C_CampaignFollow;
import org.compiere.model.X_I_BPartnerXML;
import org.compiere.model.X_R_ContactInterest;
import org.compiere.model.X_R_InterestArea;
import org.compiere.model.X_R_InterestAreaValues;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.metlife.process.CXFConnector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateBPMetlife
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private int ID_EtiquetaUrlGL = 0;

    protected void prepare() {
        this.m_AD_Client_ID = Env.getAD_Client_ID((Properties)this.getCtx());
    }

    protected String doIt() throws Exception {
        if (this.insertBPartner().booleanValue() && this.asignBPartner().booleanValue()) {
            String sqlC = "SELECT DISTINCT(cc.C_Campaign_ID) as C_Campaign_ID FROM C_Campaign cc  INNER JOIN c_campaignfollow ccf ON (cc.c_campaign_id = ccf.c_campaign_id)  WHERE cc.IsOnGoing = 'Y' AND cc.IsActive = 'Y' AND IsCampaignDefault = 'N' AND ccf.FinalStatus IN ('IN')";
            CPreparedStatement pstmtC = null;
            ResultSet rsC = null;
            try {
                try {
                    pstmtC = DB.prepareStatement((String)sqlC, (String)this.get_TrxName());
                    rsC = pstmtC.executeQuery();
                    while (rsC.next()) {
                        MCampaign camp = new MCampaign(this.getCtx(), rsC.getInt("C_Campaign_ID"), this.get_TrxName());
                        if (camp.getName().toLowerCase().contains("mutuaria")) {
                            this.asignUserMutuaria(camp.get_ID());
                        }
                        if (camp.getName().toLowerCase().contains("rentas vitalicias")) {
                            this.asignUserRVitalicias(camp.get_ID());
                        }
                        if (camp.getName().toLowerCase().contains("seguros colectivos")) {
                            this.asignUserSColectivos(camp.get_ID());
                        }
                        if (camp.getName().toLowerCase().contains("dtc")) {
                            this.asignUserDMDTC(camp.get_ID());
                        }
                        if (camp.getName().toLowerCase().contains("agencia")) {
                            this.asignUserAgencia(camp.get_ID());
                            this.SubAsignUserAgencia(camp.get_ID());
                        }
                        if (!camp.getName().toLowerCase().contains("consumo")) continue;
                        this.asignUserCConsumo(camp.get_ID());
                    }
                }
                catch (SQLException e) {
                    this.rollback();
                    throw new DBException(e, sqlC.toString());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsC, pstmtC);
                rsC = null;
                pstmtC = null;
                throw throwable;
            }
            DB.close((ResultSet)rsC, (Statement)pstmtC);
            rsC = null;
            Object var2_2 = null;
        }
        return "OK";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean insertBPartner() throws SQLException {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        sql = new StringBuffer("UPDATE I_BPartnerXML SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND I_IsAsigned<>'Y' ");
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Reset=" + no);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 10);
        sql = new StringBuffer("UPDATE I_BPartnerXML  SET Value = I_BPartnerXML_ID WHERE Value IS NULL AND I_IsImported<>'Y' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Set Value Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML  SET name = COALESCE(IA_Nombre,n'') ||' '||COALESCE(IA_Paterno,n'')||' '||COALESCE(IA_Materno,n'')  WHERE I_IsImported<>'Y' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Set Name Default=" + no);
        sql = new StringBuffer("UPDATE i_bpartnerxml set IA_REGION = replace(ia_region,'''','')  WHERE I_IsImported<>'Y' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("replace apostrofe: " + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported='N' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Found BPartner=" + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML set C_BP_Group_ID =  (SELECT MIN(C_BP_Group_ID) FROM C_BP_Group WHERE IsDefault = 'Y' AND AD_Client_ID = 1000000) WHERE I_IsImported<>'Y' AND I_IsAsigned<>'Y' ").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Group Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Value is mandatory, ' WHERE Value IS NULL  AND I_IsImported<>'Y' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.log.config("Value is mandatory=" + no);
        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, null, null, 20);
        this.commitEx();
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT * FROM I_BPartnerXML WHERE I_IsImported='N' AND I_IsAsigned='N'").append(clientCheck);
        sql.append(" ORDER BY Value, I_BPartnerXML_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                String Old_BPValue = "";
                MBPartner bp = null;
                MBPartnerLocation bpl = null;
                while (true) {
                    X_I_BPartnerXML impBP;
                    block50: {
                        String New_BPValue;
                        block51: {
                            block54: {
                                block55: {
                                    block53: {
                                        MLocation location;
                                        block52: {
                                            block49: {
                                                if (!rs.next()) {
                                                    DB.close((ResultSet)rs, (Statement)pstmt);
                                                    break;
                                                }
                                                New_BPValue = rs.getString("Value");
                                                impBP = new X_I_BPartnerXML(this.getCtx(), rs, this.get_TrxName());
                                                this.log.fine("I_BPartner_ID=" + impBP.getI_BPartnerXML_ID() + ", C_BPartner_ID=" + impBP.getC_BPartner_ID() + ", C_BPartner_Location_ID=" + impBP.getC_BPartner_Location_ID() + ", AD_User_ID=" + impBP.getAD_User_ID());
                                                if (New_BPValue.equals(Old_BPValue)) break block51;
                                                bp = null;
                                                if (impBP.getC_BPartner_ID() == 0) {
                                                    this.log.config("Inserta BP");
                                                    bp = new MBPartner(impBP);
                                                    ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBP, (PO)((Object)bp), 40);
                                                    this.setTypeOfBPartner(impBP, bp);
                                                    if (bp.save()) {
                                                        impBP.setC_BPartner_ID(bp.getC_BPartner_ID());
                                                        this.log.finest("Insert BPartner - " + bp.getC_BPartner_ID());
                                                        ++noInsert;
                                                        break block49;
                                                    } else {
                                                        sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPartner, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                                                        DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                                        continue;
                                                    }
                                                }
                                                this.log.config("Actualiza BP");
                                                bp = new MBPartner(this.getCtx(), impBP.getC_BPartner_ID(), this.get_TrxName());
                                                if (impBP.getName() != null) {
                                                    bp.setName(impBP.getName());
                                                    bp.setName2(impBP.getName2());
                                                }
                                                if (impBP.getDUNS() != null) {
                                                    bp.setDUNS(impBP.getDUNS());
                                                }
                                                if (impBP.getTaxID() != null) {
                                                    bp.setTaxID(impBP.getTaxID());
                                                }
                                                if (impBP.getNAICS() != null) {
                                                    bp.setNAICS(impBP.getNAICS());
                                                }
                                                if (impBP.getDescription() != null) {
                                                    bp.setDescription(impBP.getDescription());
                                                }
                                                if (impBP.getC_BP_Group_ID() != 0) {
                                                    bp.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
                                                }
                                                ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBP, (PO)((Object)bp), 40);
                                                this.setTypeOfBPartner(impBP, bp);
                                                if (bp.save()) {
                                                    this.log.finest("Update BPartner - " + bp.getC_BPartner_ID());
                                                    ++noUpdate;
                                                } else {
                                                    sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BPartner, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                                                    DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                                    continue;
                                                }
                                            }
                                            bpl = null;
                                            if (impBP.getC_BPartner_Location_ID() == 0) break block52;
                                            this.log.config("actualiza BP loc");
                                            bpl = new MBPartnerLocation(this.getCtx(), impBP.getC_BPartner_Location_ID(), this.get_TrxName());
                                            location = new MLocation(this.getCtx(), bpl.getC_Location_ID(), this.get_TrxName());
                                            location.setC_Country_ID(impBP.getC_Country_ID());
                                            location.setC_Region_ID(impBP.getC_Region_ID());
                                            location.setCity(impBP.getCity());
                                            location.setAddress1(impBP.getAddress1());
                                            location.setAddress2(impBP.getAddress2());
                                            location.setPostal(impBP.getPostal());
                                            location.setPostal_Add(impBP.getPostal_Add());
                                            if (!location.save()) {
                                                this.log.warning("Location not updated");
                                            } else {
                                                bpl.setC_Location_ID(location.getC_Location_ID());
                                            }
                                            if (impBP.getPhone() != null) {
                                                bpl.setPhone(impBP.getPhone());
                                            }
                                            if (impBP.getPhone2() != null) {
                                                bpl.setPhone2(impBP.getPhone2());
                                            }
                                            if (impBP.getFax() != null) {
                                                bpl.setFax(impBP.getFax());
                                            }
                                            ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBP, (PO)((Object)bpl), 40);
                                            bpl.save();
                                            break block51;
                                        }
                                        if (impBP.getC_Country_ID() == 0 || impBP.getAddress1() == null || impBP.getCity() == null) break block51;
                                        this.log.config("crea BP loc");
                                        location = new MLocation(this.getCtx(), impBP.getC_Country_ID(), impBP.getC_Region_ID(), impBP.getCity(), this.get_TrxName());
                                        location.setAddress1(impBP.getAddress1());
                                        location.setAddress2(impBP.getAddress2());
                                        location.setPostal(impBP.getPostal());
                                        location.setPostal_Add(impBP.getPostal_Add());
                                        if (!location.save()) break block53;
                                        this.log.finest("Insert Location - " + location.getC_Location_ID());
                                        bpl = new MBPartnerLocation(bp);
                                        bpl.setC_Location_ID(location.getC_Location_ID());
                                        bpl.setPhone(impBP.getPhone());
                                        bpl.setPhone2(impBP.getPhone2());
                                        bpl.setFax(impBP.getFax());
                                        ModelValidationEngine.get().fireImportValidate((ImportProcess)this, (PO)impBP, (PO)((Object)bpl), 40);
                                        if (!bpl.save()) break block54;
                                        break block55;
                                    }
                                    this.rollback();
                                    --noInsert;
                                    sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert Location, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                                    DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                                    continue;
                                }
                                this.log.finest("Insert BP Location - " + bpl.getC_BPartner_Location_ID());
                                impBP.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                                break block51;
                            }
                            this.rollback();
                            --noInsert;
                            sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPLocation, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                            DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
                            continue;
                        }
                        Old_BPValue = New_BPValue;
                        String[] namesAInterest = new String[]{"TelFijo", "Celular", "Direccion", "Comuna", "Ciudad", "Region", "Email", "MotivoContacto", "Origen", "Inmueble", "AreaFono", "TipoPropiedad", "ValorPropiedad", "MontoCredito", "Financ", "FechaNac", "Genero", "EstadoCivil", "RazonSocial", "RutEmpresa", "SolColab", "ProdInteres", "Corredora", "UrlOrigen", "Observacion"};
                        int i = 0;
                        while (true) {
                            if (i >= namesAInterest.length) {
                                if (impBP.get_ValueAsString("IA_TipoEtiqueta") != null && impBP.get_ValueAsString("IA_TipoEtiqueta") != " " && impBP.get_ValueAsString("IA_TipoEtiqueta") != "") break;
                                break block50;
                            }
                            X_R_InterestArea IArea = null;
                            String nameIA = namesAInterest[i];
                            String sqlIA1 = "Select R_InterestArea_ID from R_InterestArea WHERE name = '" + nameIA + "'";
                            int IA_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlIA1);
                            if (IA_ID > 0) {
                                IArea = new X_R_InterestArea(this.getCtx(), IA_ID, this.get_TrxName());
                            } else {
                                IArea = new X_R_InterestArea(this.getCtx(), 0, this.get_TrxName());
                                IArea.setName(nameIA);
                                IArea.setValue(nameIA);
                            }
                            IArea.save();
                            X_R_InterestAreaValues IAreaValue = null;
                            String sqlVIA1 = "SELECT R_InterestAreaValues_ID FROM R_InterestAreaValues WHERE R_InterestArea_ID = " + IArea.get_ID() + " AND value = '" + impBP.get_ValueAsString("IA_" + nameIA).replace("'", "") + "'";
                            int IAV_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlVIA1);
                            if (IAV_ID > 0) {
                                IAreaValue = new X_R_InterestAreaValues(this.getCtx(), IAV_ID, this.get_TrxName());
                            } else if (impBP.get_ValueAsString("IA_" + nameIA) != null && impBP.get_ValueAsString("IA_" + nameIA) != "" && impBP.get_ValueAsString("IA_" + nameIA) != " ") {
                                IAreaValue = new X_R_InterestAreaValues(this.getCtx(), 0, this.get_TrxName());
                                IAreaValue.setR_InterestArea_ID(IArea.get_ID());
                                IAreaValue.setValue(impBP.get_ValueAsString("IA_" + nameIA));
                                String valueEtiquetaRM = impBP.get_ValueAsString("IA_" + nameIA).toLowerCase();
                                if ((IArea.getValue().toLowerCase().contains("regi\u00ef\u00bf\u00bdn") || IArea.getValue().toLowerCase().contains("region")) && valueEtiquetaRM.contains("metropo")) {
                                    IAreaValue.set_CustomColumn("IsValueRM", true);
                                }
                                IAreaValue.save();
                            }
                            if (impBP.get_ValueAsString("IA_" + nameIA) != null && impBP.get_ValueAsString("IA_" + nameIA) != "" && impBP.get_ValueAsString("IA_" + nameIA) != " ") {
                                X_R_ContactInterest cInterest;
                                if (IArea.get_ValueAsBoolean("IsEditable")) {
                                    cInterest = null;
                                    String sqlcInteret = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + " AND R_InterestArea_ID = " + IArea.get_ID();
                                    int CInterest_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcInteret);
                                    if (CInterest_ID > 0) {
                                        cInterest = new X_R_ContactInterest(this.getCtx(), CInterest_ID, this.get_TrxName());
                                        cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue.get_ID());
                                    } else {
                                        cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                        cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                        cInterest.setR_InterestArea_ID(IArea.get_ID());
                                        cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue.get_ID());
                                    }
                                    cInterest.save();
                                } else if (IArea.get_ID() > 0 && IAreaValue.get_ID() > 0) {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                    cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                    cInterest.setR_InterestArea_ID(IArea.get_ID());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue.get_ID());
                                    cInterest.save();
                                }
                            }
                            ++i;
                        }
                        X_R_InterestArea IArea2 = null;
                        String sqlIA2 = "Select R_InterestArea_ID from R_InterestArea WHERE name = '" + impBP.get_ValueAsString("IA_TipoEtiqueta").replace("'", "") + "'";
                        int IA_ID2 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlIA2);
                        if (IA_ID2 > 0) {
                            IArea2 = new X_R_InterestArea(this.getCtx(), IA_ID2, this.get_TrxName());
                        } else {
                            IArea2 = new X_R_InterestArea(this.getCtx(), 0, this.get_TrxName());
                            IArea2.setName(impBP.get_ValueAsString("IA_TipoEtiqueta"));
                            IArea2.setValue(impBP.get_ValueAsString("IA_TipoEtiqueta"));
                        }
                        IArea2.save();
                        if (impBP.get_ValueAsString("IA_ValorEtiqueta") == null || impBP.get_ValueAsString("IA_ValorEtiqueta") == "" || impBP.get_ValueAsString("IA_ValorEtiqueta") == " ") {
                            String sqlcInteret2 = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + "AND R_InterestArea_ID = " + IArea2.get_ID();
                            int CInterest_ID2 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcInteret2);
                            if (CInterest_ID2 <= 0) {
                                X_R_ContactInterest cInterest2 = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                cInterest2.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                cInterest2.setR_InterestArea_ID(IArea2.get_ID());
                                cInterest2.save();
                            }
                        } else {
                            X_R_ContactInterest cInterest;
                            X_R_InterestAreaValues IAreaValue2 = null;
                            String sqlVIA2 = "SELECT R_InterestAreaValues_ID FROM R_InterestAreaValues WHERE R_InterestArea_ID = " + IArea2.get_ID() + " AND value = '" + impBP.get_ValueAsString("IA_ValorEtiqueta") + "'";
                            int IAV_ID2 = DB.getSQLValue((String)this.get_TrxName(), (String)sqlVIA2);
                            if (IAV_ID2 > 0) {
                                IAreaValue2 = new X_R_InterestAreaValues(this.getCtx(), IAV_ID2, this.get_TrxName());
                            } else {
                                IAreaValue2 = new X_R_InterestAreaValues(this.getCtx(), 0, this.get_TrxName());
                                IAreaValue2.setR_InterestArea_ID(IArea2.get_ID());
                                IAreaValue2.setValue(impBP.get_ValueAsString("IA_ValorEtiqueta"));
                            }
                            IAreaValue2.save();
                            if (IArea2.get_ValueAsBoolean("IsEditable")) {
                                cInterest = null;
                                String sqlcInteret = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + "AND R_InterestArea_ID = " + IArea2.get_ID();
                                int CInterest_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlcInteret);
                                if (CInterest_ID > 0) {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), CInterest_ID, this.get_TrxName());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue2.get_ID());
                                } else {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                    cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                    cInterest.setR_InterestArea_ID(IArea2.get_ID());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue2.get_ID());
                                }
                                cInterest.save();
                            } else if (IArea2.get_ID() > 0 && IAreaValue2.get_ID() > 0) {
                                cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                cInterest.set_CustomColumn("C_BPartner_ID", (Object)bp.get_ID());
                                cInterest.setR_InterestArea_ID(IArea2.get_ID());
                                cInterest.set_CustomColumn("R_InterestAreaValues_ID", (Object)IAreaValue2.get_ID());
                                cInterest.save();
                            }
                        }
                    }
                    impBP.setI_IsImported(true);
                    impBP.setProcessed(true);
                    impBP.setProcessing(false);
                    impBP.saveEx();
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            sql = new StringBuffer("UPDATE I_BPartnerXML SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(no), "@Errors@");
            this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
            this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuffer("UPDATE I_BPartnerXML SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
        this.commitEx();
        return true;
    }

    public String getWhereClause() {
        return " AND AD_Client_ID=" + this.m_AD_Client_ID;
    }

    public String getImportTableName() {
        return "I_BPartnerXML";
    }

    private void setTypeOfBPartner(X_I_BPartnerXML impBP, MBPartner bp) {
        if (impBP.isVendor()) {
            bp.setIsVendor(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isEmployee()) {
            bp.setIsEmployee(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isCustomer()) {
            bp.setIsCustomer(true);
        }
    }

    public Boolean asignBPartner() throws SQLException {
        this.log.config("asignBPartner");
        String clientCheck = this.getWhereClause();
        StringBuffer sql = null;
        sql = new StringBuffer("SELECT C_Bpartner_ID, I_BPartnerXML_ID FROM I_BPartnerXML WHERE I_IsImported='Y' AND I_IsAsigned='N' AND C_Bpartner_ID IS NOT NULL ").append(clientCheck);
        sql.append("ORDER BY C_Bpartner_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int ID_CampaignDefault;
                    MBPartner bp = new MBPartner(this.getCtx(), rs.getInt("C_Bpartner_ID"), this.get_TrxName());
                    X_I_BPartnerXML ixml = new X_I_BPartnerXML(this.getCtx(), rs.getInt("I_BPartnerXML_ID"), this.get_TrxName());
                    CPreparedStatement pstmtEtiqueta = null;
                    ResultSet rsEtiqueta = null;
                    String sqlEtiqueta = "SELECT R_InterestArea_ID FROM r_contactinterest WHERE C_BPartner_ID =?";
                    pstmtEtiqueta = DB.prepareStatement((String)sqlEtiqueta, (String)this.get_TrxName());
                    pstmtEtiqueta.setInt(1, bp.get_ID());
                    rsEtiqueta = pstmtEtiqueta.executeQuery();
                    boolean existeCampa\u00f1a = false;
                    boolean flag = false;
                    while (rsEtiqueta.next()) {
                        int ID_EtiquetaURL = rsEtiqueta.getInt("R_InterestArea_ID");
                        if (ID_EtiquetaURL > 0) {
                            this.ID_EtiquetaUrlGL = ID_EtiquetaURL;
                        }
                        this.log.config("entra while InterestArea BP - BP_ID:" + bp.get_ID() + " InterestArea_ID:" + ID_EtiquetaURL);
                        String sqlvalueIABP = "SELECT VALUE FROM R_ContactInterest CI INNER JOIN R_InterestAreaValues AV ON (CI.R_InterestAreaValues_ID = AV.R_InterestAreaValues_ID)WHERE CI.C_BPartner_ID = " + bp.get_ID() + " AND CI.R_InterestArea_ID = " + ID_EtiquetaURL;
                        String valueIABP = DB.getSQLValueString((String)this.get_TrxName(), (String)sqlvalueIABP, (Object[])new Object[0]);
                        String sqlCadenasUrl = "SELECT iav.value, cc.C_Campaign_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) INNER JOIN R_InterestAreaValues iav ON(iav.R_InterestAreaValues_ID = ci.R_InterestAreaValues_ID)WHERE IsOnGoing = 'Y' AND ci.IsCapaignFilter = 'Y' AND iav.R_InterestArea_ID=?";
                        CPreparedStatement pstmtCadenas = null;
                        ResultSet rsCadenas = null;
                        pstmtCadenas = DB.prepareStatement((String)sqlCadenasUrl, (String)this.get_TrxName());
                        pstmtCadenas.setInt(1, ID_EtiquetaURL);
                        rsCadenas = pstmtCadenas.executeQuery();
                        while (rsCadenas.next()) {
                            this.log.config("entra while campa\u00ef\u00bf\u00bdas");
                            String valueUrl = rsCadenas.getString("value");
                            this.log.config("valor valueIABP :" + valueIABP);
                            this.log.config("valor valueUrl :" + valueUrl);
                            if (valueIABP == null || valueUrl == null) continue;
                            this.log.config("Pregunta if (valueIABP.contains(valueUrl)):" + (valueIABP.contains(valueUrl) ? "true" : "false"));
                            if (!valueIABP.contains(valueUrl)) continue;
                            existeCampa\u00f1a = true;
                            MCampaign cam = new MCampaign(this.getCtx(), rsCadenas.getInt("C_Campaign_ID"), this.get_TrxName());
                            if (flag) continue;
                            X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), 0, this.get_TrxName());
                            cFollow.setAD_Org_ID(cam.getAD_Org_ID());
                            cFollow.setC_Campaign_ID(cam.get_ID());
                            cFollow.setIsActive(true);
                            cFollow.setC_BPartner_ID(bp.get_ID());
                            cFollow.setStatus("NC");
                            cFollow.setFinalStatus("IN");
                            cFollow.save();
                            flag = true;
                            this.log.config("crea cFollow");
                            ixml.set_CustomColumn("I_IsAsigned", true);
                            ixml.save();
                            this.commitEx();
                        }
                        DB.close((ResultSet)rsCadenas, (Statement)pstmtCadenas);
                        rsCadenas = null;
                        pstmtCadenas = null;
                    }
                    DB.close((ResultSet)rsEtiqueta, (Statement)pstmtEtiqueta);
                    rsEtiqueta = null;
                    pstmtEtiqueta = null;
                    if (existeCampa\u00f1a >= true || (ID_CampaignDefault = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Campaign_ID) FROM C_Campaign WHERE IsCampaignDefault='Y'")) <= 0) continue;
                    MCampaign cam = new MCampaign(this.getCtx(), ID_CampaignDefault, this.get_TrxName());
                    int ID_Campaign = cam.get_ID();
                    String countBPStr = "SELECT COUNT(1) FROM C_CampaignFollow WHERE C_BPartner_ID = " + bp.get_ID() + " AND C_Campaign_ID = " + ID_Campaign;
                    int countBP = DB.getSQLValue((String)this.get_TrxName(), (String)countBPStr);
                    this.log.config("countBP :" + countBP);
                    if (countBP > 0) {
                        ixml.set_CustomColumn("I_IsAsigned", true);
                        ixml.save();
                        continue;
                    }
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), 0, this.get_TrxName());
                    cFollow.setAD_Org_ID(cam.getAD_Org_ID());
                    cFollow.setC_Campaign_ID(cam.get_ID());
                    cFollow.setIsActive(true);
                    cFollow.setC_BPartner_ID(bp.get_ID());
                    cFollow.setStatus("NC");
                    cFollow.setFinalStatus("IN");
                    cFollow.save();
                    this.log.config("crea cFollow default");
                    ixml.set_CustomColumn("I_IsAsigned", true);
                    ixml.save();
                    String IDEBUserStr = "SELECT MAX(AD_User_ID) FROM AD_User WHERE IsDefaultEB = 'Y'";
                    int ID_EBUser = DB.getSQLValue((String)this.get_TrxName(), (String)IDEBUserStr);
                    if (ID_EBUser <= 0) continue;
                    cFollow.setAD_User_ID(ID_EBUser);
                    cFollow.setFinalStatus("AS");
                    cFollow.save();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        this.commitEx();
        return true;
    }

    public Boolean asignUserMutuaria(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID and FinalStatus = cf.FinalStatus),0)  as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement((String)sqlEje.toString(), (String)this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close((ResultSet)rsEje, (Statement)pstmtEje);
        rsEje = null;
        pstmtEje = null;
        this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? AND ci.R_InterestArea_ID <> ? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
        this.log.config("Etiqueta: " + this.ID_EtiquetaUrlGL);
        int ID_EtiquetaURL = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE value like 'UrlOrigen'");
        if (ID_EtiquetaURL > 0) {
            this.ID_EtiquetaUrlGL = ID_EtiquetaURL;
        }
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement((String)sqlEtiquetas, (String)this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        pstmtEt.setInt(2, this.ID_EtiquetaUrlGL);
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea1 : " + InterestArea1_ID);
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea2 : " + InterestArea2_ID);
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
            this.log.config("interestarea3: " + InterestArea3_ID);
        }
        DB.close((ResultSet)rsEt, (Statement)pstmtEt);
        rsEt = null;
        pstmtEt = null;
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement((String)sqlCLines, (String)this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement((String)sqlEtBP, (String)this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    this.log.config("sqlEtBP: " + sqlEtBP);
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                        this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                    }
                    DB.close((ResultSet)rsEtBP, (Statement)pstmtEtBP);
                    rsEtBP = null;
                    pstmtEtBP = null;
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    this.log.config("id_IaBPsql: " + id_IaBPsql);
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    this.log.config("id_iavbpsql: " + id_IaVBPsql);
                    int ID_IsRM = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(rci.R_InterestArea_ID) FROM R_ContactInterest rci INNER JOIN R_InterestAreaValues riaV ON (rci.R_InterestAreaValues_ID = riaV.R_InterestAreaValues_ID) WHERE rci.C_Bpartner_ID = " + cFollow.getC_BPartner_ID() + " AND riaV.ISVALUERM = 'Y' GROUP BY rci.R_InterestArea_ID "));
                    this.log.config("ID_IsRM: " + ID_IsRM);
                    if (ID_IsRM <= 0) {
                        id_IaBPsql = "0";
                        id_IaVBPsql = "0";
                        int ID_EtiquetaFiltro = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y'");
                        if (ID_EtiquetaFiltro > 0) {
                            id_IaBPsql = String.valueOf(id_IaBPsql) + "," + ID_EtiquetaFiltro;
                            int ID_ValEF = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT R_InterestAreaValues_ID FROM R_ContactInterest  WHERE C_Bpartner_ID = " + cFollow.getC_BPartner_ID() + " AND R_InterestArea_ID IN (" + ID_EtiquetaFiltro + ")"));
                            if (ID_ValEF > 0) {
                                id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + ID_ValEF;
                            }
                        }
                        InterestAreaBP2_ID = 0;
                        InterestAreaBP3_ID = 0;
                    }
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + " AND FinalStatus = 'AS' AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID) " + " WHERE adu.IsActive = 'Y' AND adu.ActivePool = 'N' AND ui.IsActive = 'Y' " + " AND R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                    this.log.config("sqlEtUser: " + sqlEtUser);
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement((String)sqlEtUser, (String)this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    int minCantidad = 100000;
                    int CantLeadEje = 0;
                    int ID_EjecutivoM = 0;
                    while (rsEtUser.next()) {
                        if (ArrayIDUsuario != null) {
                            if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                int indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                            } else {
                                CantLeadEje = 0;
                            }
                        }
                        if (CantLeadEje >= minCantidad) continue;
                        minCantidad = CantLeadEje;
                        ID_EjecutivoM = rsEtUser.getInt(1);
                    }
                    DB.close((ResultSet)rsEtUser, (Statement)pstmtEtUser);
                    rsEtUser = null;
                    pstmtEtUser = null;
                    if (ID_EjecutivoM <= 0) continue;
                    cFollow.setAD_User_ID(ID_EjecutivoM);
                    cFollow.setFinalStatus("AS");
                    try {
                        cFollow.set_CustomColumn("SendAssignMail", true);
                    }
                    catch (Exception e) {
                        this.log.config("No se pudo setear variable AsignMail");
                    }
                    cFollow.save();
                    if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                        int indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                        int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                        ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                    } else {
                        ArrayIDUsuario.add(ID_EjecutivoM);
                        ArrayCantLeads.add(1);
                    }
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLines, (Statement)pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        this.commitEx();
        return true;
    }

    public Boolean asignUserRVitalicias(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement((String)sqlEje.toString(), (String)this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close((ResultSet)rsEje, (Statement)pstmtEje);
        rsEje = null;
        pstmtEje = null;
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement((String)sqlEtiquetas, (String)this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
        }
        DB.close((ResultSet)rsEt, (Statement)pstmtEt);
        rsEt = null;
        pstmtEt = null;
        String sqlCLinesP1 = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow cf INNER JOIN R_ContactInterest ci ON (cf.C_Bpartner_ID = ci.C_Bpartner_ID) INNER JOIN R_InterestArea ia ON (ci.R_InterestArea_ID = ia.R_InterestArea_ID) INNER JOIN R_InterestAreaValues iav ON (ci.R_InterestAreaValues_ID = iav.R_InterestAreaValues_ID) WHERE C_Campaign_ID = ? AND (upper(ia.name) like 'REGION' OR upper(ia.name) like 'REGI\u00ef\u00bf\u00bdN') AND NOT (upper(iav.value) like 'II %' OR (iav.value) like 'VII %' OR (iav.value) like 'VIII %') AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLinesP1 = null;
        ResultSet rsCLinesP1 = null;
        try {
            try {
                pstmtCLinesP1 = DB.prepareStatement((String)sqlCLinesP1, (String)this.get_TrxName());
                pstmtCLinesP1.setInt(1, cam.get_ID());
                rsCLinesP1 = pstmtCLinesP1.executeQuery();
                while (rsCLinesP1.next()) {
                    int cantIndUser2;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLinesP1.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement((String)sqlEtBP, (String)this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                    }
                    DB.close((ResultSet)rsEtBP, (Statement)pstmtEtBP);
                    rsEtBP = null;
                    pstmtEtBP = null;
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID) as AD_User_ID, adu.qtyLead  FROM R_UserInterest ui  INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID)  WHERE ui.IsActive = 'Y' AND adu.UseAgencia = 'N' AND adu.qtyLead > 0 AND ui.R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + this.getValidUserCampaign(cam.get_ID());
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY adu.qtyLead desc";
                    int cantIndUser1 = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_User WHERE EXISTS (" + sqlEtUser.replace("ORDER BY adu.qtyLead desc", " ") + ")"));
                    if (cantIndUser1 < 1) {
                        String sql1 = "UPDATE AD_User SET UseAgencia = 'N' WHERE EXISTS (" + sqlEtUser.replace("AND adu.UseAgencia = 'N' AND adu.qtyLead > 0", " ") + ")";
                        DB.executeUpdate((String)sql1.replace("ORDER BY adu.qtyLead desc", " "), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    if ((cantIndUser2 = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_User WHERE EXISTS (" + sqlEtUser.replace("ORDER BY adu.qtyLead desc", " ") + ")"))) < 1) {
                        String sql2 = "UPDATE AD_User SET qtyLead = qtyLeadBase WHERE EXISTS (" + sqlEtUser.replace("AND adu.UseAgencia = 'N' AND adu.qtyLead > 0", " ") + ")";
                        DB.executeUpdate((String)sql2.replace("ORDER BY adu.qtyLead desc", " "), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement((String)sqlEtUser, (String)this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    if (rsEtUser.next() && rsEtUser.getInt("AD_User_ID") > 0) {
                        cFollow.set_CustomColumn("AD_User_ID", rsEtUser.getInt("AD_User_ID"));
                        cFollow.setFinalStatus("AS");
                        try {
                            cFollow.set_CustomColumn("SendAssignMail", true);
                        }
                        catch (Exception e) {
                            this.log.config("No se pudo setear variable AsignMail");
                        }
                        cFollow.save();
                        DB.executeUpdate((String)("UPDATE AD_User SET UseAgencia = 'Y', qtyLead = qtyLead-1 WHERE AD_User_ID = " + rsEtUser.getString("AD_User_ID")), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    this.commitEx();
                    rsEtUser.close();
                    pstmtEtUser.close();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLinesP1.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLinesP1, pstmtCLinesP1);
            rsCLinesP1 = null;
            pstmtCLinesP1 = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLinesP1, (Statement)pstmtCLinesP1);
        rsCLinesP1 = null;
        pstmtCLinesP1 = null;
        String sqlCLinesP2 = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow cf INNER JOIN R_ContactInterest ci ON (cf.C_Bpartner_ID = ci.C_Bpartner_ID) INNER JOIN R_InterestArea ia ON (ci.R_InterestArea_ID = ia.R_InterestArea_ID) INNER JOIN R_InterestAreaValues iav ON (ci.R_InterestAreaValues_ID = iav.R_InterestAreaValues_ID) WHERE C_Campaign_ID = ? AND (upper(ia.name) like 'REGION' OR upper(ia.name) like 'REGI\u00ef\u00bf\u00bdN') AND (upper(iav.value) like 'II %' OR (iav.value) like 'VII %' OR (iav.value) like 'VIII %') AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLinesP2 = null;
        ResultSet rsCLinesP2 = null;
        try {
            try {
                pstmtCLinesP2 = DB.prepareStatement((String)sqlCLinesP2, (String)this.get_TrxName());
                pstmtCLinesP2.setInt(1, cam.get_ID());
                rsCLinesP2 = pstmtCLinesP2.executeQuery();
                while (rsCLinesP2.next()) {
                    int cantIndUser2;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLinesP2.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    InterestArea3_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE UPPER(value) like 'CIUDAD'");
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement((String)sqlEtBP, (String)this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                    }
                    DB.close((ResultSet)rsEtBP, (Statement)pstmtEtBP);
                    rsEtBP = null;
                    pstmtEtBP = null;
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID) as AD_User_ID, adu.qtyLead   FROM R_UserInterest ui  INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID)  WHERE ui.IsActive = 'Y' AND adu.UseAgencia = 'N' AND adu.qtyLead > 0 AND ui.R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + this.getValidUserCampaign(cam.get_ID());
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY adu.qtyLead desc";
                    int cantIndUser1 = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_User WHERE EXISTS (" + sqlEtUser.replace("ORDER BY adu.qtyLead desc", " ") + ")"));
                    if (cantIndUser1 < 1) {
                        String sql1 = "UPDATE AD_User SET UseAgencia = 'N' WHERE EXISTS (" + sqlEtUser.replace("AND adu.UseAgencia = 'N' AND adu.qtyLead > 0", " ") + ")";
                        DB.executeUpdate((String)sql1.replace("ORDER BY adu.qtyLead desc", " "), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    if ((cantIndUser2 = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_User WHERE EXISTS (" + sqlEtUser.replace("ORDER BY adu.qtyLead desc", " ") + ")"))) < 1) {
                        String sql2 = "UPDATE AD_User SET qtyLead = qtyLeadBase WHERE EXISTS (" + sqlEtUser.replace("AND adu.UseAgencia = 'N' AND adu.qtyLead > 0", " ") + ")";
                        DB.executeUpdate((String)sql2.replace("ORDER BY adu.qtyLead desc", " "), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement((String)sqlEtUser, (String)this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    if (rsEtUser.next() && rsEtUser.getInt("AD_User_ID") > 0) {
                        cFollow.set_CustomColumn("AD_User_ID", rsEtUser.getInt("AD_User_ID"));
                        cFollow.setFinalStatus("AS");
                        try {
                            cFollow.set_CustomColumn("SendAssignMail", true);
                        }
                        catch (Exception e) {
                            this.log.config("No se pudo setear variable AsignMail");
                        }
                        cFollow.save();
                        DB.executeUpdate((String)("UPDATE AD_User SET UseAgencia = 'Y', qtyLead = qtyLead-1 WHERE AD_User_ID = " + rsEtUser.getString("AD_User_ID")), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    this.commitEx();
                    rsEtUser.close();
                    pstmtEtUser.close();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLinesP2.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLinesP2, pstmtCLinesP2);
            rsCLinesP1 = null;
            pstmtCLinesP1 = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLinesP2, (Statement)pstmtCLinesP2);
        rsCLinesP1 = null;
        pstmtCLinesP1 = null;
        return true;
    }

    public Boolean asignUserSColectivos(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement((String)sqlCLines, (String)this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    String IDEBUserStr = "SELECT MAX(AD_User_ID) FROM AD_User WHERE IsDefaultSC = 'Y'";
                    int ID_EBUser = DB.getSQLValue((String)this.get_TrxName(), (String)IDEBUserStr);
                    if (ID_EBUser <= 0) continue;
                    cFollow.setAD_User_ID(ID_EBUser);
                    cFollow.setFinalStatus("AS");
                    try {
                        cFollow.set_CustomColumn("SendAssignMail", true);
                    }
                    catch (Exception e) {
                        this.log.config("No se pudo setear variable AsignMail");
                    }
                    cFollow.save();
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLines, (Statement)pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public Boolean asignUserDMDTC(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement((String)sqlEje.toString(), (String)this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close((ResultSet)rsEje, (Statement)pstmtEje);
        rsEje = null;
        pstmtEje = null;
        this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? GROUP BY ci.R_InterestArea_ID ";
        this.log.config("Etiqueta: " + this.ID_EtiquetaUrlGL);
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement((String)sqlEtiquetas, (String)this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea1 : " + InterestArea1_ID);
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea2 : " + InterestArea2_ID);
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
            this.log.config("interestarea3: " + InterestArea3_ID);
        }
        DB.close((ResultSet)rsEt, (Statement)pstmtEt);
        rsEt = null;
        pstmtEt = null;
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement((String)sqlCLines, (String)this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement((String)sqlEtBP, (String)this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    this.log.config("sqlEtBP: " + sqlEtBP);
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                        this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                    }
                    DB.close((ResultSet)rsEtBP, (Statement)pstmtEtBP);
                    rsEtBP = null;
                    pstmtEtBP = null;
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    this.log.config("id_IaBPsql: " + id_IaBPsql);
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    this.log.config("id_iavbpsql: " + id_IaVBPsql);
                    String sqlEtUser = "SELECT DISTINCT(AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + "AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " WHERE IsActive = 'Y' AND R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + this.getValidUserCampaign(cam.get_ID());
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                    this.log.config("sqlEtUser: " + sqlEtUser);
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement((String)sqlEtUser, (String)this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    int minCantidad = 100000;
                    int CantLeadEje = 0;
                    int ID_EjecutivoM = 0;
                    while (rsEtUser.next()) {
                        if (ArrayIDUsuario != null) {
                            if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                int indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                            } else {
                                CantLeadEje = 0;
                            }
                        }
                        if (CantLeadEje >= minCantidad) continue;
                        minCantidad = CantLeadEje;
                        ID_EjecutivoM = rsEtUser.getInt(1);
                    }
                    DB.close((ResultSet)rsEtUser, (Statement)pstmtEtUser);
                    rsEtUser = null;
                    pstmtEtUser = null;
                    if (ID_EjecutivoM <= 0) continue;
                    cFollow.setAD_User_ID(ID_EjecutivoM);
                    cFollow.setFinalStatus("AS");
                    try {
                        cFollow.set_CustomColumn("SendAssignMail", true);
                    }
                    catch (Exception e) {
                        this.log.config("No se pudo setear variable AsignMail");
                    }
                    cFollow.save();
                    if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                        int indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                        int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                        ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                    } else {
                        ArrayIDUsuario.add(ID_EjecutivoM);
                        ArrayCantLeads.add(1);
                    }
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLines, (Statement)pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public Boolean asignUserAgencia(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement((String)sqlEje.toString(), (String)this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close((ResultSet)rsEje, (Statement)pstmtEje);
        rsEje = null;
        pstmtEje = null;
        this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? AND ci.R_InterestArea_ID <> ? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
        this.log.config("Etiqueta: " + this.ID_EtiquetaUrlGL);
        int ID_EtiquetaURL = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE value like 'Lead Web'");
        if (ID_EtiquetaURL > 0) {
            this.ID_EtiquetaUrlGL = ID_EtiquetaURL;
        }
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement((String)sqlEtiquetas, (String)this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        pstmtEt.setInt(2, this.ID_EtiquetaUrlGL);
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea1 : " + InterestArea1_ID);
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea2 : " + InterestArea2_ID);
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
            this.log.config("interestarea3: " + InterestArea3_ID);
        }
        DB.close((ResultSet)rsEt, (Statement)pstmtEt);
        rsEt = null;
        pstmtEt = null;
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement((String)sqlCLines, (String)this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    int indexCant;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement((String)sqlEtBP, (String)this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    this.log.config("sqlEtBP: " + sqlEtBP);
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                        this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                    }
                    DB.close((ResultSet)rsEtBP, (Statement)pstmtEtBP);
                    rsEtBP = null;
                    pstmtEtBP = null;
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    this.log.config("id_IaBPsql: " + id_IaBPsql);
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    this.log.config("id_iavbpsql: " + id_IaVBPsql);
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + " AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID) " + " WHERE ui.IsActive = 'Y'  AND adu.ActivePool = 'Y' AND ui.R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + this.getValidUserCampaign(cam.get_ID());
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                    this.log.config("sqlEtUser: " + sqlEtUser);
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement((String)sqlEtUser, (String)this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    int minCantidad = 100000;
                    int CantLeadEje = 0;
                    int ID_EjecutivoM = 0;
                    while (rsEtUser.next()) {
                        if (ArrayIDUsuario != null) {
                            if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                            } else {
                                CantLeadEje = 0;
                            }
                        }
                        if (CantLeadEje >= minCantidad) continue;
                        minCantidad = CantLeadEje;
                        ID_EjecutivoM = rsEtUser.getInt(1);
                    }
                    DB.close((ResultSet)rsEtUser, (Statement)pstmtEtUser);
                    rsEtUser = null;
                    pstmtEtUser = null;
                    if (ID_EjecutivoM <= 0) continue;
                    cFollow.set_CustomColumn("Supervisor_ID", ID_EjecutivoM);
                    cFollow.setFinalStatus("AS");
                    cFollow.save();
                    if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                        indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                        int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                        ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                        continue;
                    }
                    ArrayIDUsuario.add(ID_EjecutivoM);
                    ArrayCantLeads.add(1);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLines, (Statement)pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public Boolean SubAsignUserAgencia(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND Supervisor_ID > 0 AND (AD_User_ID = 0 OR AD_User_ID is null) Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement((String)sqlCLines, (String)this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    int cantIndUser2;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    int cantIndUser1 = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtylead > 0 AND IsActive = 'Y'"));
                    if (cantIndUser1 < 1) {
                        DB.executeUpdate((String)("UPDATE AD_User SET UseAgencia = 'N' WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID")), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    if ((cantIndUser2 = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtylead > 0 AND IsActive = 'Y'"))) < 1) {
                        DB.executeUpdate((String)("UPDATE AD_User SET qtyLead = qtyLeadBase WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID")), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    String sqlPUser = "SELECT AD_User_ID FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtyLead > 0 AND IsActive = 'Y' ORDER BY qtyLead Desc";
                    CPreparedStatement pstmtSubUser = null;
                    ResultSet rsSubUser = null;
                    pstmtSubUser = DB.prepareStatement((String)sqlPUser, (String)this.get_TrxName());
                    rsSubUser = pstmtSubUser.executeQuery();
                    rsSubUser.next();
                    if (rsSubUser.getInt("AD_User_ID") > 0) {
                        cFollow.set_CustomColumn("AD_User_ID", rsSubUser.getInt("AD_User_ID"));
                        cFollow.setFinalStatus("AS");
                        try {
                            cFollow.set_CustomColumn("SendAssignMail", true);
                        }
                        catch (Exception e) {
                            this.log.config("No se pudo setear variable AsignMail");
                        }
                        cFollow.save();
                        DB.executeUpdate((String)("UPDATE AD_User SET UseAgencia = 'Y', qtyLead = qtyLead-1 WHERE AD_User_ID = " + rsSubUser.getString("AD_User_ID")), (String)this.get_TrxName());
                        this.commitEx();
                    }
                    this.commitEx();
                    rsSubUser.close();
                    pstmtSubUser.close();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLines, (Statement)pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        this.commitEx();
        return true;
    }

    public Boolean asignUserCConsumo(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement((String)sqlEje.toString(), (String)this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close((ResultSet)rsEje, (Statement)pstmtEje);
        rsEje = null;
        pstmtEje = null;
        this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? AND ci.R_InterestArea_ID <> ? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
        this.log.config("Etiqueta: " + this.ID_EtiquetaUrlGL);
        int ID_EtiquetaURL = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE value like 'LeadSitioPrivado'");
        if (ID_EtiquetaURL > 0) {
            this.ID_EtiquetaUrlGL = ID_EtiquetaURL;
        }
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement((String)sqlEtiquetas, (String)this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        pstmtEt.setInt(2, this.ID_EtiquetaUrlGL);
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea1 : " + InterestArea1_ID);
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea2 : " + InterestArea2_ID);
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
            this.log.config("interestarea3: " + InterestArea3_ID);
        }
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement((String)sqlCLines, (String)this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement((String)sqlEtBP, (String)this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    this.log.config("sqlEtBP: " + sqlEtBP);
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                        this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                    }
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    this.log.config("id_IaBPsql: " + id_IaBPsql);
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + " AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " INNER JOIN ad_user adu ON (ui.ad_user_ID = adu.ad_user_ID) " + " WHERE ui.IsActive = 'Y' AND adu.IsActive = 'Y' " + " AND R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + this.getValidUserCampaign(cam.get_ID());
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                    this.log.config("sqlEtUser: " + sqlEtUser);
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement((String)sqlEtUser, (String)this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    int minCantidad = 100000;
                    int CantLeadEje = 0;
                    int ID_EjecutivoM = 0;
                    while (rsEtUser.next()) {
                        if (ArrayIDUsuario != null) {
                            if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                int indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                            } else {
                                CantLeadEje = 0;
                            }
                        }
                        if (CantLeadEje >= minCantidad) continue;
                        minCantidad = CantLeadEje;
                        ID_EjecutivoM = rsEtUser.getInt(1);
                    }
                    if (ID_EjecutivoM <= 0) continue;
                    cFollow.setAD_User_ID(ID_EjecutivoM);
                    cFollow.setFinalStatus("AS");
                    try {
                        cFollow.set_CustomColumn("SendAssignMail", true);
                    }
                    catch (Exception e) {
                        this.log.config("No se pudo setear variable AsignMail");
                    }
                    cFollow.save();
                    if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                        int indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                        int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                        ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                    } else {
                        ArrayIDUsuario.add(ID_EjecutivoM);
                        ArrayCantLeads.add(1);
                    }
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close((ResultSet)rsCLines, (Statement)pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public String getValidUserCampaign(int ID_CampaignV) {
        String sqlUC = " AND ui.AD_User_ID IN (SELECT AD_USER_ID FROM ad_usercampaign WHERE IsActive = 'Y' AND C_Campaign_ID = " + ID_CampaignV + ") ";
        return sqlUC;
    }

    public void sendMailCFollow(int ID_CFollow) {
        X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), ID_CFollow, this.get_TrxName());
        if (cFollow.getAD_User_ID() > 0) {
            try {
                MUser user = new MUser(this.getCtx(), cFollow.getAD_User_ID(), this.get_TrxName());
                if (!user.getName().toUpperCase().contains("CLIENTE")) {
                    String pathTemp;
                    MBPartner bPart = new MBPartner(this.getCtx(), cFollow.getC_BPartner_ID(), this.get_TrxName());
                    String CustomerRUT = "99512160-3";
                    String CustomerMail = user.getEMail();
                    String comodin = "\\";
                    String DocumentFilePath = pathTemp = String.valueOf(comodin) + comodin + "mlfsoaqat01" + comodin + "templates" + comodin + "MFSMutuariaBienvenida" + comodin + "Muturia.jpg";
                    String NombreCliente = "Nombre:" + bPart.getName();
                    String msg = this.llamarMFSMutuariaAsignacion(CustomerRUT, CustomerMail, DocumentFilePath, NombreCliente);
                    this.log.config(msg);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "No se pudo ejecutar proceso de correo", (Throwable)e);
            }
        }
    }

    private String llamarMFSMutuariaAsignacion(String CustomerRUT, String CustomerMail, String DocumentFilePath, String NombreCliente) throws Exception {
        String msgRet = "";
        String request = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ws=\"http://ws.documentservice.metlife.cl/\"><soapenv:Header/> <soapenv:Body><ws:sendCustomDocuments><customDocumentsDescriptor><CustomDocumentDescriptor><CustomerRUT>" + CustomerRUT + "</CustomerRUT>" + "<CustomerMail>" + CustomerMail + "</CustomerMail>" + "<Template>MFSMutuariaNuevoLeads</Template>" + "<BusinessLine>mutuaria</BusinessLine>" + "<DocumentFilePath>" + DocumentFilePath + "</DocumentFilePath>" + "<Encryption>false</Encryption>" + "<CustomDocumentData>" + "<DataName>NombreCliente</DataName>" + "<DataValue>" + NombreCliente + "</DataValue>" + "</CustomDocumentData>" + "</CustomDocumentDescriptor>" + "</customDocumentsDescriptor>" + "<userDescriptor>" + "<UserRUT>1-9</UserRUT>" + "<UserPassword>bluePrintsIT1</UserPassword>" + "</userDescriptor>" + "</ws:sendCustomDocuments>" + "</soapenv:Body>" + "</soapenv:Envelope>";
        Source response = null;
        try {
            CXFConnector wsc = new CXFConnector();
            wsc.setSoapAction("http://ws.documentservice.metlife.cl/DocumentSenderService/getBusinessLinesResponse");
            wsc.setRequest(request);
            wsc.setBinding("http://schemas.xmlsoap.org/wsdl/soap/http");
            wsc.setEndpointAddress("http://10.77.208.94:9080/documentService/DocumentSenderService");
            wsc.setServiceName("DocumentSenderService");
            wsc.setPortName("DocumentSenderPort");
            wsc.setTargetNS("http://ws.documentservice.metlife.cl/");
            wsc.executeConnector();
            response = wsc.getResponse();
        }
        catch (Exception e) {
            throw new Exception("No se ha podido establecer conexion con el Servicio de correo. Llamada:" + request + e.toString(), e);
        }
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SAXSource output = (SAXSource)response;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            tf.transform(output, result);
            Document doc = (Document)result.getNode();
            Node datos = this.findReturn(doc.getChildNodes().item(0));
            if (datos != null) {
                NodeList att = datos.getChildNodes();
                int x = 0;
                while (x < att.getLength()) {
                    this.log.config(att.item(x).getLocalName());
                    if (att.item(x).getLocalName().equals("Description") || att.item(x).getNodeName().equals("Description")) {
                        msgRet = att.item(x).getFirstChild().getNodeValue();
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msgRet;
    }

    public Node findReturn(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("SendingStatus")) {
                value = childNode;
                break;
            }
            value = this.findReturn(childNode);
            ++i;
        }
        return value;
    }

    public String returnIaValue(int ID_BPartner, int ID_IArea) {
        String iAValue_ID = "";
        iAValue_ID = DB.getSQLValueString((String)this.get_TrxName(), (String)("SELECT MAX(ia.value)  FROM R_ContactInterest ci  INNER JOIN R_InterestAreaValues ia ON (ci.R_InterestAreaValues_ID = ia.R_InterestAreaValues_ID)  WHERE ci.C_Bpartner_ID = " + ID_BPartner + " AND ci.R_InterestArea_ID = " + ID_IArea), (Object[])new Object[0]);
        if (iAValue_ID != null && iAValue_ID != "" && iAValue_ID != " ") {
            return iAValue_ID;
        }
        return "";
    }
}

