/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.eevolution.model.I_HR_Concept;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRProcess;

public class HRActionNotice {
    protected static CLogger log = CLogger.getCLogger(HRActionNotice.class);
    public int m_WindowNo = 0;
    public static MHRProcess m_process = null;
    public static int m_HR_Process_ID = 0;
    public static int m_HR_Payroll_ID = 0;
    public static int m_HR_Concept_ID = 0;
    public static int m_C_BPartner_ID = 0;
    public static int sHR_Movement_ID = 0;
    public Timestamp m_dateStart = null;
    public static Timestamp m_dateEnd = null;
    public int m_qty = 0;
    public BigDecimal m_amount = Env.ZERO;
    public String m_text = null;
    public Timestamp m_date = null;

    public void dynInit() throws Exception {
        log.info("HRActionNotice");
    }

    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("HR_Movement_ID");
        miniTable.addColumn("AD_Org_ID");
        miniTable.addColumn("HR_Concept_ID");
        miniTable.addColumn("ValidFrom");
        miniTable.addColumn("ColumnType");
        miniTable.addColumn("Qty");
        miniTable.addColumn("Amount");
        miniTable.addColumn("ServiceDate");
        miniTable.addColumn("Text");
        miniTable.addColumn("Description");
        miniTable.setColumnClass(0, IDColumn.class, false, " ");
        miniTable.setColumnClass(1, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        miniTable.setColumnClass(2, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"HR_Concept_ID"));
        miniTable.setColumnClass(3, Timestamp.class, true, Msg.translate((Properties)Env.getCtx(), (String)"ValidFrom"));
        miniTable.setColumnClass(4, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"ColumnType"));
        miniTable.setColumnClass(5, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
        miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        miniTable.setColumnClass(7, Timestamp.class, true, Msg.translate((Properties)Env.getCtx(), (String)"ServiceDate"));
        miniTable.setColumnClass(8, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Text"));
        miniTable.setColumnClass(9, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        miniTable.autoSize();
    }

    public static void executeQuery(Properties ctx, IMiniTable miniTable) {
        block6: {
            StringBuffer sqlQuery = new StringBuffer("SELECT DISTINCT o.Name,hp.Name, bp.Name,hc.Name,hm.ValidFrom,(" + HRActionNotice.getSQL_ColumnType(ctx, "hc.ColumnType") + ") AS ColumnType," + " hm.Qty,hm.Amount,hm.ServiceDate,hm.TextMsg,er.Name,hm.Description " + " , HR_Movement_id, hm.AD_Org_ID,hp.HR_Process_ID,hm.HR_Concept_ID " + " FROM HR_Movement hm " + " INNER JOIN AD_Org o ON (hm.AD_Org_ID=o.AD_Org_ID)" + " INNER JOIN HR_Process hp ON (hm.HR_Process_ID=hp.HR_Process_ID)" + " INNER JOIN C_BPartner bp ON (hm.C_BPartner_ID=bp.C_BPartner_ID)" + " INNER JOIN HR_Employee e ON (e.C_BPartner_ID=bp.C_BPartner_ID)" + " INNER JOIN HR_Concept hc ON (hm.HR_Concept_ID=hc.HR_Concept_ID)" + " LEFT OUTER JOIN AD_Rule er ON (hm.AD_Rule_ID=er.AD_Rule_ID)" + " WHERE hm.Processed='N' AND hp.HR_Process_ID = " + m_HR_Process_ID + " AND hm.C_BPartner_ID = " + m_C_BPartner_ID);
            sqlQuery.append(" ORDER BY hm.AD_Org_ID,hp.HR_Process_ID,bp.Name,hm.ValidFrom,hm.HR_Concept_ID");
            int row = 0;
            miniTable.setRowCount(row);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlQuery.toString(), null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        miniTable.setRowCount(row + 1);
                        miniTable.setColumnClass(0, IDColumn.class, false, " ");
                        miniTable.setValueAt((Object)rs.getString(1), row, 1);
                        miniTable.setValueAt((Object)rs.getString(4), row, 2);
                        miniTable.setValueAt((Object)rs.getTimestamp(5), row, 3);
                        miniTable.setValueAt((Object)rs.getString(6), row, 4);
                        miniTable.setValueAt((Object)(rs.getObject(7) != null ? rs.getBigDecimal(7) : Env.ZERO), row, 5);
                        miniTable.setValueAt((Object)(rs.getObject(8) != null ? rs.getBigDecimal(8) : Env.ZERO), row, 6);
                        miniTable.setValueAt((Object)rs.getTimestamp(9), row, 7);
                        miniTable.setValueAt((Object)rs.getString(10), row, 8);
                        miniTable.setValueAt((Object)rs.getString(12), row, 9);
                        ++row;
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sqlQuery.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        miniTable.autoSize();
    }

    public static KeyNamePair[] getProcess() {
        String sql = String.valueOf(MRole.getDefault().addAccessSQL("SELECT hrp.HR_Process_ID,hrp.DocumentNo ||'-'|| hrp.Name,hrp.DocumentNo,hrp.Name FROM HR_Process hrp", "hrp", true, false)) + " AND hrp.IsActive = 'Y' ";
        sql = String.valueOf(sql) + " ORDER BY hrp.DocumentNo, hrp.Name";
        return DB.getKeyNamePairs((String)sql, (boolean)true);
    }

    public static List<KeyNamePair> getEmployeeValid(MHRProcess process) {
        ArrayList<KeyNamePair> arrayList;
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        if (process == null) {
            return list;
        }
        KeyNamePair pp = new KeyNamePair(0, "");
        list.add(pp);
        String sql = String.valueOf(MRole.getDefault().addAccessSQL("SELECT DISTINCT bp.C_BPartner_ID,bp.Name FROM HR_Employee hrpe INNER JOIN C_BPartner bp ON(bp.C_BPartner_ID=hrpe.C_BPartner_ID)", "hrpe", true, false)) + " AND hrpe.IsActive = 'Y' ";
        if (process.getHR_Payroll_ID() != 0) {
            sql = String.valueOf(sql) + " AND (hrpe.HR_Payroll_ID =" + process.getHR_Payroll_ID() + " OR hrpe.HR_Payroll_ID is NULL)";
            if (process.getHR_Department_ID() > 0) {
                sql = String.valueOf(sql) + " AND (hrpe.HR_Department_ID =" + process.getHR_Department_ID() + " OR hrpe.HR_Department_ID is NULL)";
            }
            if (process.getHR_Employee_ID() > 0) {
                sql = String.valueOf(sql) + " AND (hrpe.HR_Employee_ID =" + process.getHR_Employee_ID() + " OR hrpe.HR_Employee_ID is NULL)";
            }
        }
        sql = String.valueOf(sql) + " ORDER BY bp.Name ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                list.add(pp);
            }
            arrayList = list;
        }
        catch (SQLException e) {
            ArrayList<KeyNamePair> arrayList2;
            try {
                log.log(Level.SEVERE, sql, (Throwable)e);
                arrayList2 = list;
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return arrayList2;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return arrayList;
    }

    public ArrayList<ValueNamePair> getConcept(MHRProcess process, boolean isFieldProcessNull) {
        if (process == null) {
            return null;
        }
        ArrayList<ValueNamePair> data = new ArrayList<ValueNamePair>();
        String sql = "SELECT DISTINCT hrpc.HR_Concept_ID,hrpc.Name,hrpc.Value  FROM HR_Concept hrpc  INNER JOIN HR_Attribute hrpa ON (hrpa.HR_Concept_ID=hrpc.HR_Concept_ID) WHERE hrpc.AD_Client_ID = " + Env.getAD_Client_ID((Properties)Env.getCtx()) + " AND hrpc.IsActive = 'Y' AND hrpc.IsManual = 'Y' AND hrpc.Type != 'E'" + " AND (hrpa.HR_Payroll_ID = " + m_HR_Payroll_ID + " OR hrpa.HR_Payroll_ID IS NULL)";
        if (!isFieldProcessNull) {
            if (process.getHR_Payroll_ID() != 0) {
                sql = String.valueOf(sql) + " AND (hrpa.HR_Payroll_ID = " + process.getHR_Payroll_ID() + " OR hrpa.HR_Payroll_ID is NULL)";
            }
            if (process.getHR_Department_ID() != 0) {
                // empty if block
            }
            sql = String.valueOf(sql) + " AND (hrpa.HR_Department_ID = " + process.getHR_Department_ID() + " OR hrpa.HR_Department_ID is NULL)";
            if (process.getHR_Department_ID() != 0) {
                // empty if block
            }
            sql = String.valueOf(sql) + " AND (hrpa.HR_Employee_ID = " + process.getHR_Employee_ID() + " OR hrpa.HR_Employee_ID is NULL)";
        }
        sql = String.valueOf(sql) + " ORDER BY hrpc.Name";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            ValueNamePair vp = null;
            data.add(new ValueNamePair("", ""));
            while (rs.next()) {
                vp = new ValueNamePair(rs.getString(1), rs.getString(2));
                data.add(vp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return data;
    }

    public int seekMovement(Timestamp dt) {
        if (m_HR_Concept_ID <= 0) {
            return 0;
        }
        int HR_Movement_ID = 0;
        String date = DB.TO_DATE((Timestamp)dt);
        int Process_ID = m_HR_Process_ID;
        int Employee_ID = m_C_BPartner_ID;
        int Concept_ID = m_HR_Concept_ID;
        MHRConcept concept = MHRConcept.get((Properties)Env.getCtx(), (int)Concept_ID);
        if (Process_ID + Employee_ID + Concept_ID > 0) {
            HR_Movement_ID = DB.getSQLValue(null, (String)("SELECT HR_Movement_ID  FROM HR_Movement WHERE HR_Process_ID = " + Process_ID + " AND C_BPartner_ID =" + Employee_ID + " AND HR_Concept_ID = " + Concept_ID + " AND TRUNC(ValidFrom) = TRUNC(" + date + ")"));
        }
        return HR_Movement_ID;
    }

    public static String getSQL_ColumnType(Properties ctx, String sqlValue) {
        int columnType_Ref_ID = MTable.get((Properties)ctx, (int)I_HR_Concept.Table_ID).getColumn("ColumnType").getAD_Reference_Value_ID();
        String sql = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Ref_List") ? "SELECT zz.Name FROM AD_Ref_List zz WHERE zz.AD_Reference_ID=" + columnType_Ref_ID : "SELECT zz.Name FROM AD_Ref_List zz, AD_Ref_List_Trl zzt WHERE zz.AD_Reference_ID=" + columnType_Ref_ID + " AND zzt.AD_Ref_List_ID=zz.AD_Ref_List_ID" + " AND zzt.AD_Language=" + DB.TO_STRING((String)Env.getAD_Language((Properties)Env.getCtx()));
        sql = String.valueOf(sql) + " AND zz.Value = " + sqlValue;
        return sql;
    }
}

