/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Asset_Forecast;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CreateAssetForecastDPP
extends SvrProcess {
    int PGroup_ID = 0;
    int PGroupRef_ID = 0;
    String PPosession = "Y";
    int asset_ID = 0;
    int Org_ID = 0;
    Timestamp p_lastdate = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("A_Asset_Group_ID")) {
                    this.PGroup_ID = para[i].getParameterAsInt();
                } else if (name.equals("A_Asset_Group_Ref_ID")) {
                    this.PGroupRef_ID = para[i].getParameterAsInt();
                } else if (name.equals("A_Asset_ID")) {
                    this.asset_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String sql = "Select A.A_Asset_ID, C.A_Asset_Acct_ID  From A_Asset A  Inner join A_Asset_Acct C on (A.A_Asset_ID=C.A_Asset_ID) where 1=1 and A.IsInPosession = 'Y' and A.IsActive = 'Y' and C.IsActive = 'Y' ";
        if (this.Org_ID > 0) {
            sql = String.valueOf(sql) + " and A.AD_Org_ID=?";
        }
        if (this.asset_ID > 0) {
            sql = String.valueOf(sql) + " and A.A_Asset_ID = " + this.asset_ID;
        } else if (this.PGroup_ID > 0) {
            sql = String.valueOf(sql) + " and A.A_Asset_Group_ID = " + this.PGroup_ID;
        } else if (this.PGroupRef_ID > 0) {
            sql = String.valueOf(sql) + " and A.A_Asset_Group_Ref_ID = " + this.PGroupRef_ID;
        }
        int count = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            if (this.Org_ID > 0) {
                pstmt.setInt(1, this.Org_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_A_Asset asset = new X_A_Asset(this.getCtx(), rs.getInt(1), this.get_TrxName());
                MDepreciationWorkfile workfile = MAsset.getWorkFile(rs.getInt(1));
                MAssetAcct acct = new MAssetAcct(this.getCtx(), rs.getInt(2), this.get_TrxName());
                if (workfile == null || workfile.getA_Period_Posted() == acct.getA_Period_End()) continue;
                this.p_lastdate = DB.getSQLValueTS((String)this.get_TrxName(), (String)("select max(datedoc) from a_asset_forecast where processed='Y' and A_Asset_ID=" + rs.getInt(1)), (Object[])new Object[0]);
                this.replanningForecast(asset, workfile.getA_Asset_Cost().subtract(workfile.getA_Accumulated_Depr()), acct, workfile.getA_Period_Posted(), this.p_lastdate);
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return "Activo Replanificados :" + count;
    }

    public void replanningForecast(X_A_Asset asset, BigDecimal Amount, MAssetAcct acct, int Period, Timestamp lastdate) {
        BigDecimal SalvageAmt = acct.getA_Salvage_Value();
        BigDecimal Currentamt = Amount;
        Currentamt = Currentamt.divide(new BigDecimal(acct.getA_Period_End() - Period), 0, 1);
        DB.executeUpdate((String)("Update A_Asset_Forecast set amount=" + Currentamt + " Where Processed='N' AND A_Asset_ID=" + asset.getA_Asset_ID()), (String)this.get_TrxName());
        if (asset.isInPosession()) {
            DB.executeUpdate((String)("Delete from A_Asset_Forecast where Processed='N' and Corrected='N' and A_Asset_ID=" + asset.getA_Asset_ID()), (String)this.get_TrxName());
        } else {
            DB.executeUpdate((String)("Delete from A_Asset_Forecast where Processed='N' and A_Asset_ID=" + asset.getA_Asset_ID()), (String)this.get_TrxName());
        }
        int mes = 1;
        if (!acct.get_ValueAsBoolean("IsByYear")) {
            int i = Period + 1;
            while (i < acct.getA_Period_End() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(2, mes);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = Amount.subtract(Currentamt.multiply(new BigDecimal(mes - 1))).subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        } else {
            int i = Period + 1;
            while (i < asset.getUseLifeYears() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(1, mes);
                cal.set(2, 11);
                cal.set(5, 1);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = Amount.subtract(Currentamt.multiply(new BigDecimal(mes - 1))).subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        }
    }
}

