/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModDPPUpdateQtyReservedOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModDPPUpdateQtyReservedOrder.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public String docValidate(PO po, int timing) {
        MInOut receipt;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID && !(receipt = (MInOut)((Object)po)).isSOTrx()) {
            MInOutLine[] lines = receipt.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInOutLine line = lines[i];
                if (line.getC_Charge_ID() > 0 && line.getC_OrderLine_ID() > 0) {
                    MOrderLine oLine = new MOrderLine(po.getCtx(), line.getC_OrderLine_ID(), po.get_TrxName());
                    BigDecimal qtyDelivered = oLine.getQtyDelivered();
                    qtyDelivered = qtyDelivered.add(line.getMovementQty());
                    oLine.setQtyDelivered(qtyDelivered);
                    oLine.save();
                    DB.executeUpdate((String)("UPDATE C_Orderline SET QTYDELIVERED = " + qtyDelivered + " WHERE C_Orderline_ID = " + oLine.get_ID()), (String)po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

