/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateReservations
extends SvrProcess {
    private Properties m_ctx;
    private int p_Product_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_Product_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        int count = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)("select M_Product_ID from M_Product Where producttype='I' and isactive='Y' and ad_client_id=" + this.getAD_Client_ID() + (this.p_Product_ID > 0 ? "and m_product_id=" + this.p_Product_ID : "")), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.updatedReserved(rs.getInt(1));
                this.updatedOrdered(rs.getInt(1));
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "sql:", (Throwable)e);
        }
        this.commit();
        return "Actualizados " + count + " Productos";
    }

    public void updatedReserved(int Product_ID) {
        CPreparedStatement pstmt = null;
        String mysql = "select sum(ol.qtyreserved),ol.m_warehouse_id from c_orderline ol inner join c_order o on (ol.c_order_id=o.c_order_id) where o.docstatus IN ('CO','CL') and o.issotrx='Y' and ol.m_product_id=" + Product_ID + " and ol.qtyreserved>=0 group by ol.m_warehouse_id";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.OFBReserved(rs.getInt(2), Product_ID, rs.getBigDecimal(1));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
    }

    public void updatedOrdered(int Product_ID) {
        CPreparedStatement pstmt = null;
        String mysql = "select sum(ol.qtyreserved),ol.m_warehouse_id from c_orderline ol inner join c_order o on (ol.c_order_id=o.c_order_id) where o.docstatus IN ('CO','CL') and o.issotrx='N' and ol.m_product_id=" + Product_ID + " and ol.qtyreserved>=0 group by ol.m_warehouse_id";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.OFBOrdered(rs.getInt(2), Product_ID, rs.getBigDecimal(1));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, mysql, (Throwable)e);
        }
    }

    public void OFBReserved(int M_WareHouse_ID, int M_Product_ID, BigDecimal reserved) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), rs, this.get_TrxName());
                storage.setQtyReserved(reserved);
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), 0, this.get_TrxName());
                storage.setQtyReserved(reserved);
                storage.setQtyOrdered(Env.ZERO);
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
    }

    public void OFBOrdered(int M_WareHouse_ID, int M_Product_ID, BigDecimal ordered) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)this.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), rs, this.get_TrxName());
                storage.setQtyOrdered(ordered);
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(this.getCtx(), 0, this.get_TrxName());
                storage.setQtyOrdered(ordered);
                storage.setQtyReserved(Env.ZERO);
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
    }
}

