/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQResponse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class RfQClose
extends SvrProcess {
    private int p_C_RfQ_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        this.log.info("doIt - " + rfq);
        if (rfq.get_ValueAsString("TypeRfQ").equals("A")) {
            MRfQLine[] lines;
            MRfQLine[] mRfQLineArray = lines = rfq.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MRfQLine line = mRfQLineArray[n2];
                if (line.get_ValueAsInt("C_BPartner_ID") == 0 || line.get_ValueAsInt("C_BPartner_Location_ID") == 0) {
                    throw new IllegalArgumentException("No BPartner or Location for Line :" + line.getLine());
                }
                ++n2;
            }
        } else if (rfq.getC_BPartner_ID() == 0 || rfq.getC_BPartner_Location_ID() == 0) {
            throw new IllegalArgumentException("No BPartner or Location ");
        }
        int count = 0;
        String sql = "select C_RfQLine_ID from C_RfQLine where C_RfQ_ID=? order by C_BPartner_ID";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.p_C_RfQ_ID);
            ResultSet rs = pstmt.executeQuery();
            MOrder order = null;
            if (rfq.get_ValueAsString("TypeRfQ").equals("C")) {
                MBPartner bp = MBPartner.get(this.getCtx(), rfq.getC_BPartner_ID());
                order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                order.setIsSOTrx(false);
                order.setC_DocTypeTarget_ID();
                order.setBPartner(bp);
                order.setC_BPartner_Location_ID(rfq.getC_BPartner_Location_ID());
                order.setSalesRep_ID(rfq.getSalesRep_ID());
                order.saveEx();
                ++count;
            }
            while (rs.next()) {
                MRfQLine line = new MRfQLine(this.getCtx(), rs.getInt(1), this.get_TrxName());
                if (rfq.get_ValueAsString("TypeRfQ").equals("A")) {
                    MBPartner bp = MBPartner.get(this.getCtx(), line.get_ValueAsInt("C_BPartner_ID"));
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setIsSOTrx(false);
                    order.setC_DocTypeTarget_ID();
                    order.setBPartner(bp);
                    order.setC_BPartner_Location_ID(line.get_ValueAsInt("C_BPartner_Location_ID"));
                    order.setSalesRep_ID(rfq.getSalesRep_ID());
                    order.saveEx();
                    ++count;
                }
                MOrderLine ol = new MOrderLine(order);
                ol.setM_Product_ID(line.getM_Product_ID(), line.getM_Product().getC_UOM_ID());
                ol.setDescription(line.getDescription());
                ol.setQty((BigDecimal)line.get_Value("Qty"));
                BigDecimal price = (BigDecimal)line.get_Value("PriceActual");
                ol.setPrice(price);
                ol.setDescription(line.getDescription());
                ol.saveEx();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        rfq.setProcessed(true);
        rfq.saveEx();
        int counter = 0;
        MRfQResponse[] responses = rfq.getResponses(false, false);
        int i = 0;
        while (i < responses.length) {
            responses[i].setProcessed(true);
            responses[i].save();
            ++counter;
            ++i;
        }
        return "Generated " + count;
    }
}

