/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_T_Replenish;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ReplenishInterface;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

public class ReplenishReport
extends SvrProcess {
    private int p_M_Warehouse_ID = 0;
    private int p_C_BPartner_ID = 0;
    private String p_ReplenishmentCreate = null;
    private int p_C_DocType_ID = 0;
    private String m_info = "";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("ReplenishmentCreate")) {
                    this.p_ReplenishmentCreate = (String)para[i].getParameter();
                } else if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.log.info("M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + " - ReplenishmentCreate=" + this.p_ReplenishmentCreate + ", C_DocType_ID=" + this.p_C_DocType_ID);
        if (this.p_ReplenishmentCreate != null && this.p_C_DocType_ID == 0) {
            throw new AdempiereUserError("@FillMandatory@ @C_DocType_ID@");
        }
        MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)this.p_M_Warehouse_ID);
        if (wh.get_ID() == 0) {
            throw new AdempiereSystemError("@FillMandatory@ @M_Warehouse_ID@");
        }
        this.prepareTable();
        this.fillTable(wh);
        if (this.p_ReplenishmentCreate == null) {
            return "OK";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.p_C_DocType_ID);
        if (!dt.getDocBaseType().equals(this.p_ReplenishmentCreate)) {
            throw new AdempiereSystemError("@C_DocType_ID@=" + dt.getName() + " <> " + this.p_ReplenishmentCreate);
        }
        if (this.p_ReplenishmentCreate.equals("POO")) {
            this.createPO();
        } else if (this.p_ReplenishmentCreate.equals("POR")) {
            this.createRequisition();
        } else if (this.p_ReplenishmentCreate.equals("MMM")) {
            this.createMovements();
        } else if (this.p_ReplenishmentCreate.equals("DOO")) {
            this.createDO();
        }
        return this.m_info;
    }

    private void prepareTable() {
        String sql = "UPDATE M_Replenish SET Level_Max = Level_Min WHERE Level_Max < Level_Min";
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 0) {
            this.log.fine("Corrected Max_Level=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO SET Order_Min = 1 WHERE Order_Min IS NULL OR Order_Min < 1"), (String)this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Min=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO SET Order_Pack = 1 WHERE Order_Pack IS NULL OR Order_Pack < 1"), (String)this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Pack=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='Y' WHERE IsCurrentVendor<>'Y' AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID GROUP BY pp.M_Product_ID HAVING COUNT(*) = 1)"), (String)this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(Y)=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='N' WHERE IsCurrentVendor = 'Y' AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID AND pp.IsCurrentVendor='Y' GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1)"), (String)this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(N)=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "DELETE T_Replenish WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Delete Existing Temp=" + no);
        }
    }

    private void fillTable(MWarehouse wh) throws Exception {
        String className;
        String sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID," + " r.ReplenishType, r.Level_Min, r.Level_Max," + " po.C_BPartner_ID, po.Order_Min, po.Order_Pack, 0, ";
        sql = this.p_ReplenishmentCreate == null ? String.valueOf(sql) + "null" : String.valueOf(sql) + "'" + this.p_ReplenishmentCreate + "'";
        sql = String.valueOf(sql) + " FROM M_Replenish r INNER JOIN M_Product_PO po ON (r.M_Product_ID=po.M_Product_ID) WHERE po.IsCurrentVendor='Y' AND r.ReplenishType<>'0' AND po.IsActive='Y' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.p_M_Warehouse_ID;
        if (this.p_C_BPartner_ID != 0) {
            sql = String.valueOf(sql) + " AND po.C_BPartner_ID=" + this.p_C_BPartner_ID;
        }
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.log.finest(sql);
        this.log.fine("Insert (1) #" + no);
        if (this.p_C_BPartner_ID == 0) {
            sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID," + " r.ReplenishType, r.Level_Min, r.Level_Max," + " 0, 1, 1, 0, ";
            sql = this.p_ReplenishmentCreate == null ? String.valueOf(sql) + "null" : String.valueOf(sql) + "'" + this.p_ReplenishmentCreate + "'";
            sql = String.valueOf(sql) + " FROM M_Replenish r WHERE r.ReplenishType<>'0' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.p_M_Warehouse_ID + " AND NOT EXISTS (SELECT * FROM T_Replenish t " + "WHERE r.M_Product_ID=t.M_Product_ID" + " AND AD_PInstance_ID=" + this.getAD_PInstance_ID() + ")";
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Insert (BP) #" + no);
        }
        sql = "UPDATE T_Replenish t SET QtyOnHand = (SELECT COALESCE(SUM(QtyOnHand),0) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID),QtyReserved = (SELECT COALESCE(SUM(QtyReserved),0) FROM M_StorageReservation sr WHERE t.M_Product_ID=sr.M_Product_ID AND sr.M_Warehouse_ID=t.M_Warehouse_ID),QtyOrdered = (SELECT COALESCE(SUM(QtyOrdered),0) FROM M_StorageReservation sr WHERE t.M_Product_ID=sr.M_Product_ID AND sr.M_Warehouse_ID=t.M_Warehouse_ID)";
        if (this.p_C_DocType_ID != 0) {
            sql = String.valueOf(sql) + ", C_DocType_ID=" + this.p_C_DocType_ID;
        }
        if ((no = DB.executeUpdate((String)(sql = String.valueOf(sql) + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Update #" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "DELETE T_Replenish r WHERE (EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_ID=r.M_Product_ID AND p.IsActive='N') OR EXISTS (SELECT * FROM M_Replenish rr  WHERE rr.M_Product_ID=r.M_Product_ID AND rr.IsActive='N' AND rr.M_Warehouse_ID=" + this.p_M_Warehouse_ID + " ))" + " AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Delete Inactive=" + no);
        }
        sql = "UPDATE T_Replenish SET QtyOnHand = 0 WHERE QtyOnHand IS NULL";
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyReserved = 0 WHERE QtyReserved IS NULL";
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyOrdered = 0 WHERE QtyOrdered IS NULL";
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyToOrder = CASE WHEN QtyOnHand - QtyReserved + QtyOrdered <= Level_Min  THEN Level_Max - QtyOnHand + QtyReserved - QtyOrdered  ELSE 0 END WHERE ReplenishType='1' AND AD_PInstance_ID=" + this.getAD_PInstance_ID();
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 0) {
            this.log.fine("Update Type-1=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET QtyToOrder = Level_Max - QtyOnHand + QtyReserved - QtyOrdered WHERE ReplenishType='2' AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Update Type-2=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET QtyToOrder = Order_Min WHERE QtyToOrder < Order_Min AND QtyToOrder > 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set MinOrderQty=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET QtyToOrder = QtyToOrder - MOD(QtyToOrder, Order_Pack) + Order_Pack WHERE MOD(QtyToOrder, Order_Pack) <> 0 AND QtyToOrder > 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set OrderPackQty=" + no);
        }
        if (wh.getM_WarehouseSource_ID() != 0 && (no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID=" + wh.getM_WarehouseSource_ID() + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set Source Warehouse=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID = NULL WHERE M_Warehouse_ID=M_WarehouseSource_ID AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Set same Source Warehouse=" + no);
        }
        if ((className = wh.getReplenishmentClass()) != null && className.length() > 0) {
            ReplenishInterface custom = null;
            try {
                Class<?> clazz = Class.forName(className);
                custom = (ReplenishInterface)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AdempiereUserError("No custom Replenishment class " + className + " - " + e.toString());
            }
            X_T_Replenish[] replenishs = this.getReplenish("ReplenishType='9'");
            int i = 0;
            while (i < replenishs.length) {
                X_T_Replenish replenish = replenishs[i];
                if (replenish.getReplenishType().equals("9")) {
                    BigDecimal qto = null;
                    try {
                        qto = custom.getQtyToOrder(wh, replenish);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, custom.toString(), (Throwable)e);
                    }
                    if (qto == null) {
                        qto = Env.ZERO;
                    }
                    replenish.setQtyToOrder(qto);
                    replenish.save();
                }
                ++i;
            }
        }
        if ((no = DB.executeUpdate((String)(sql = "DELETE T_Replenish WHERE QtyToOrder < 1 AND AD_PInstance_ID=" + this.getAD_PInstance_ID()), (String)this.get_TrxName())) != 0) {
            this.log.fine("Delete No QtyToOrder=" + no);
        }
    }

    private void createPO() {
        int noOrders = 0;
        String info = "";
        MOrder order = null;
        MWarehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NULL");
        int i = 0;
        while (i < replenishs.length) {
            X_T_Replenish replenish = replenishs[i];
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (order == null || order.getC_BPartner_ID() != replenish.getC_BPartner_ID() || order.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                order.setIsSOTrx(false);
                order.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
                MBPartner bp = new MBPartner(this.getCtx(), replenish.getC_BPartner_ID(), this.get_TrxName());
                order.setBPartner(bp);
                order.setSalesRep_ID(this.getAD_User_ID());
                order.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment"));
                order.setAD_Org_ID(wh.getAD_Org_ID());
                order.setM_Warehouse_ID(wh.getM_Warehouse_ID());
                if (!order.save()) {
                    return;
                }
                this.log.fine(order.toString());
                ++noOrders;
                info = String.valueOf(info) + " - " + order.getDocumentNo();
            }
            MOrderLine line = new MOrderLine(order);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.save();
            ++i;
        }
        this.m_info = "#" + noOrders + info;
        this.log.info(this.m_info);
    }

    private void createRequisition() {
        int noReqs = 0;
        String info = "";
        MRequisition requisition = null;
        MWarehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NULL");
        int i = 0;
        while (i < replenishs.length) {
            X_T_Replenish replenish = replenishs[i];
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (requisition == null || requisition.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                requisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                requisition.setAD_User_ID(this.getAD_User_ID());
                requisition.setC_DocType_ID(this.p_C_DocType_ID);
                requisition.setDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment"));
                requisition.setAD_Org_ID(wh.getAD_Org_ID());
                requisition.setM_Warehouse_ID(wh.getM_Warehouse_ID());
                if (!requisition.save()) {
                    return;
                }
                this.log.fine(requisition.toString());
                ++noReqs;
                info = String.valueOf(info) + " - " + requisition.getDocumentNo();
            }
            MRequisitionLine line = new MRequisitionLine(requisition);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setC_BPartner_ID(replenish.getC_BPartner_ID());
            line.setQty(replenish.getQtyToOrder());
            line.setPrice();
            line.save();
            ++i;
        }
        this.m_info = "#" + noReqs + info;
        this.log.info(this.m_info);
    }

    private void createMovements() {
        int noMoves = 0;
        String info = "";
        MClient client = null;
        MMovement move = null;
        int M_Warehouse_ID = 0;
        int M_WarehouseSource_ID = 0;
        MWarehouse whSource = null;
        MWarehouse wh = null;
        X_T_Replenish[] replenishs = this.getReplenish("M_WarehouseSource_ID IS NOT NULL");
        int i = 0;
        while (i < replenishs.length) {
            X_T_Replenish replenish = replenishs[i];
            if (whSource == null || whSource.getM_WarehouseSource_ID() != replenish.getM_WarehouseSource_ID()) {
                whSource = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_WarehouseSource_ID());
            }
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (client == null || client.getAD_Client_ID() != whSource.getAD_Client_ID()) {
                client = MClient.get((Properties)this.getCtx(), (int)whSource.getAD_Client_ID());
            }
            if (move == null || M_WarehouseSource_ID != replenish.getM_WarehouseSource_ID() || M_Warehouse_ID != replenish.getM_Warehouse_ID()) {
                M_WarehouseSource_ID = replenish.getM_WarehouseSource_ID();
                M_Warehouse_ID = replenish.getM_Warehouse_ID();
                move = new MMovement(this.getCtx(), 0, this.get_TrxName());
                move.setC_DocType_ID(this.p_C_DocType_ID);
                move.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment")) + ": " + whSource.getName() + "->" + wh.getName());
                move.setAD_Org_ID(whSource.getAD_Org_ID());
                if (!move.save()) {
                    return;
                }
                this.log.fine(move.toString());
                ++noMoves;
                info = String.valueOf(info) + " - " + move.getDocumentNo();
            }
            int M_LocatorTo_ID = wh.getDefaultLocator().getM_Locator_ID();
            MProduct product = MProduct.get(this.getCtx(), replenish.getM_Product_ID());
            String MMPolicy = product.getMMPolicy();
            MStorage[] storages = MStorage.getWarehouse(this.getCtx(), whSource.getM_Warehouse_ID(), replenish.getM_Product_ID(), 0, 0, true, null, "F".equals(MMPolicy), this.get_TrxName());
            BigDecimal target = replenish.getQtyToOrder();
            int j = 0;
            while (j < storages.length) {
                MStorage storage = storages[j];
                if (storage.getQtyOnHand().signum() > 0) {
                    BigDecimal moveQty = target;
                    if (storage.getQtyOnHand().compareTo(moveQty) < 0) {
                        moveQty = storage.getQtyOnHand();
                    }
                    MMovementLine line = new MMovementLine(move);
                    line.setM_Product_ID(replenish.getM_Product_ID());
                    line.setMovementQty(moveQty);
                    if (replenish.getQtyToOrder().compareTo(moveQty) != 0) {
                        line.setDescription("Total: " + replenish.getQtyToOrder());
                    }
                    line.setM_Locator_ID(storage.getM_Locator_ID());
                    line.setM_AttributeSetInstance_ID(storage.getM_AttributeSetInstance_ID());
                    line.setM_LocatorTo_ID(M_LocatorTo_ID);
                    line.setM_AttributeSetInstanceTo_ID(storage.getM_AttributeSetInstance_ID());
                    line.save();
                    target = target.subtract(moveQty);
                    if (target.signum() == 0) break;
                }
                ++j;
            }
            ++i;
        }
        if (replenishs.length == 0) {
            this.m_info = "No Source Warehouse";
            this.log.warning(this.m_info);
        } else {
            this.m_info = "#" + noMoves + info;
            this.log.info(this.m_info);
        }
    }

    private void createDO() throws Exception {
        X_T_Replenish[] replenishs;
        int noMoves = 0;
        String info = "";
        MClient client = null;
        MDDOrder order = null;
        int M_Warehouse_ID = 0;
        int M_WarehouseSource_ID = 0;
        MWarehouse whSource = null;
        MWarehouse wh = null;
        X_T_Replenish[] x_T_ReplenishArray = replenishs = this.getReplenishDO("M_WarehouseSource_ID IS NOT NULL");
        int n = replenishs.length;
        int n2 = 0;
        while (n2 < n) {
            X_T_Replenish replenish = x_T_ReplenishArray[n2];
            if (whSource == null || whSource.getM_WarehouseSource_ID() != replenish.getM_WarehouseSource_ID()) {
                whSource = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_WarehouseSource_ID());
            }
            if (wh == null || wh.getM_Warehouse_ID() != replenish.getM_Warehouse_ID()) {
                wh = MWarehouse.get((Properties)this.getCtx(), (int)replenish.getM_Warehouse_ID());
            }
            if (client == null || client.getAD_Client_ID() != whSource.getAD_Client_ID()) {
                client = MClient.get((Properties)this.getCtx(), (int)whSource.getAD_Client_ID());
            }
            if (order == null || M_WarehouseSource_ID != replenish.getM_WarehouseSource_ID() || M_Warehouse_ID != replenish.getM_Warehouse_ID()) {
                MWarehouse[] whsInTransit;
                M_WarehouseSource_ID = replenish.getM_WarehouseSource_ID();
                M_Warehouse_ID = replenish.getM_Warehouse_ID();
                order = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                order.setC_DocType_ID(this.p_C_DocType_ID);
                order.setDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Replenishment")) + ": " + whSource.getName() + "->" + wh.getName());
                order.setAD_Org_ID(whSource.getAD_Org_ID());
                MOrg orgTrx = MOrg.get((Properties)this.getCtx(), (int)wh.getAD_Org_ID());
                order.setAD_OrgTrx_ID(orgTrx.getAD_Org_ID());
                int C_BPartner_ID = orgTrx.getLinkedC_BPartner_ID(this.get_TrxName());
                if (C_BPartner_ID == 0) {
                    throw new AdempiereUserError(String.valueOf(Msg.translate((Properties)this.getCtx(), (String)"C_BPartner_ID")) + " @FillMandatory@ ");
                }
                MBPartner bp = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
                order.setBPartner(bp);
                order.setDateOrdered(new Timestamp(System.currentTimeMillis()));
                order.setDeliveryRule("A");
                order.setDeliveryViaRule("D");
                order.setPriorityRule("5");
                order.setIsInDispute(false);
                order.setIsApproved(false);
                order.setIsDropShip(false);
                order.setIsDelivered(false);
                order.setIsInTransit(false);
                order.setIsPrinted(false);
                order.setIsSelected(false);
                order.setIsSOTrx(false);
                MWarehouse[] mWarehouseArray = whsInTransit = MWarehouse.getForOrg((Properties)this.getCtx(), (int)whSource.getAD_Org_ID());
                int n3 = whsInTransit.length;
                int n4 = 0;
                while (n4 < n3) {
                    MWarehouse whInTransit = mWarehouseArray[n4];
                    if (whInTransit.isInTransit()) {
                        order.setM_Warehouse_ID(whInTransit.getM_Warehouse_ID());
                    }
                    ++n4;
                }
                if (order.getM_Warehouse_ID() == 0) {
                    throw new AdempiereUserError("Warehouse inTransit is @FillMandatory@ ");
                }
                if (!order.save()) {
                    return;
                }
                this.log.fine(order.toString());
                ++noMoves;
                info = String.valueOf(info) + " - " + order.getDocumentNo();
            }
            int M_LocatorTo_ID = wh.getDefaultLocator().getM_Locator_ID();
            int M_Locator_ID = whSource.getDefaultLocator().getM_Locator_ID();
            if (M_LocatorTo_ID == 0 || M_Locator_ID == 0) {
                throw new AdempiereUserError(String.valueOf(Msg.translate((Properties)this.getCtx(), (String)"M_Locator_ID")) + " @FillMandatory@ ");
            }
            MDDOrderLine line = new MDDOrderLine(order);
            line.setM_Product_ID(replenish.getM_Product_ID());
            line.setQty(replenish.getQtyToOrder());
            if (replenish.getQtyToOrder().compareTo(replenish.getQtyToOrder()) != 0) {
                line.setDescription("Total: " + replenish.getQtyToOrder());
            }
            line.setM_Locator_ID(M_Locator_ID);
            line.setM_AttributeSetInstance_ID(0);
            line.setM_LocatorTo_ID(M_LocatorTo_ID);
            line.setM_AttributeSetInstanceTo_ID(0);
            line.setIsInvoiced(false);
            line.save();
            ++n2;
        }
        if (replenishs.length == 0) {
            this.m_info = "No Source Warehouse";
            this.log.warning(this.m_info);
        } else {
            this.m_info = "#" + noMoves + info;
            this.log.info(this.m_info);
        }
    }

    private X_T_Replenish[] getReplenish(String where) {
        String sql = "SELECT * FROM T_Replenish WHERE AD_PInstance_ID=? AND C_BPartner_ID > 0 ";
        if (where != null && where.length() > 0) {
            sql = String.valueOf(sql) + " AND " + where;
        }
        sql = String.valueOf(sql) + " ORDER BY M_Warehouse_ID, M_WarehouseSource_ID, C_BPartner_ID";
        ArrayList<X_T_Replenish> list = new ArrayList<X_T_Replenish>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new X_T_Replenish(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        X_T_Replenish[] retValue = new X_T_Replenish[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private X_T_Replenish[] getReplenishDO(String where) {
        String sql = "SELECT * FROM T_Replenish WHERE AD_PInstance_ID=? ";
        if (where != null && where.length() > 0) {
            sql = String.valueOf(sql) + " AND " + where;
        }
        sql = String.valueOf(sql) + " ORDER BY M_Warehouse_ID, M_WarehouseSource_ID, C_BPartner_ID";
        ArrayList<X_T_Replenish> list = new ArrayList<X_T_Replenish>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new X_T_Replenish(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        X_T_Replenish[] retValue = new X_T_Replenish[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

