/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OFBCostCreate
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        String sql = "SELECT p.M_Product_ID FROM M_Product p Inner Join M_CostDetail d on (p.M_Product_ID=d.M_product_ID) WHERE p.isactive='Y' And Not exists (select * from M_Cost c where c.M_product_ID=p.M_Product_ID)";
        if (this.p_M_Product_ID > 0) {
            sql = String.valueOf(sql) + " AND p.M_Product_ID=" + this.p_M_Product_ID;
        }
        if (this.p_M_Product_Category_ID > 0) {
            sql = String.valueOf(sql) + " AND p.M_Product_Category_ID=" + this.p_M_Product_Category_ID;
        }
        MAcctSchema as = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()))[0];
        MCostElement element = this.getStandarCostelement();
        int count = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MProduct product = MProduct.get(this.getCtx(), rs.getInt(1));
                int Org_ID = product.getCostingLevel(as).equals("C") ? 0 : product.getAD_Org_ID();
                MCost cost = new MCost(product, product.getM_AttributeSetInstance_ID(), as, Org_ID, element.getM_CostElement_ID());
                cost.save();
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            return "@OK@" + count;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return "@Error@";
        }
    }

    public MCostElement getStandarCostelement() {
        return (MCostElement)MCostElement.getByCostingMethod((Properties)Env.getCtx(), (String)"S").get(0);
    }
}

