/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MOrg;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class LibroCVxmlView
extends SvrProcess {
    int org_ID = 0;
    int period_ID = 0;
    boolean p_TipoOperacion;
    String p_TipoLibro = "";
    String p_TipoEnvio = "";
    String p_where = "";
    String p_where2 = "";
    String p_rut = "";
    String p_ExportDir = "";
    Timestamp datefrom = null;
    Timestamp dateto = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_Period_ID")) {
                    this.period_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("IsSOTrx")) {
                    this.p_TipoOperacion = "Y".equals(para[i].getParameter());
                } else if (name.equals("TipoLibro")) {
                    this.p_TipoLibro = (String)para[i].getParameter();
                } else if (name.equals("TipoEnvio")) {
                    this.p_TipoEnvio = (String)para[i].getParameter();
                } else if (name.equals("ExportDir")) {
                    this.p_ExportDir = (String)para[i].getParameter();
                } else if (name.equals("Rut")) {
                    this.p_rut = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String mylog = new String();
        try {
            MPeriod Pe = MPeriod.get(this.getCtx(), this.period_ID);
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(Pe.getEndDate().getTime());
            int mes = cal.get(2) + 1;
            String periodoTributario = String.valueOf(cal.get(1)) + "-" + (mes < 10 ? "0" + mes : Integer.valueOf(mes));
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "LibroCompraVenta", null);
            document.setXmlVersion("1.0");
            Element EnvioLibro = document.createElement("EnvioLibro");
            EnvioLibro.setAttribute("ID", "IEV-" + periodoTributario);
            document.getDocumentElement().appendChild(EnvioLibro);
            Element Caratula = document.createElement("Caratula");
            EnvioLibro.appendChild(Caratula);
            MOrg company = MOrg.get((Properties)this.getCtx(), (int)this.org_ID);
            Element RutEmisorLibro = document.createElement("RutEmisorLibro");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            RutEmisorLibro.appendChild(rut);
            Caratula.appendChild(RutEmisorLibro);
            Element RutEnvia = document.createElement("RutEnvia");
            Text rutE = document.createTextNode(this.p_rut);
            RutEnvia.appendChild(rutE);
            Caratula.appendChild(RutEnvia);
            Element PeriodoTributario = document.createElement("PeriodoTributario");
            Text periodo = document.createTextNode(periodoTributario);
            PeriodoTributario.appendChild(periodo);
            Caratula.appendChild(PeriodoTributario);
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Element FchResol = document.createElement("FchResol");
            Text fecha = document.createTextNode(company.get_ValueAsString("FchResol"));
            FchResol.appendChild(fecha);
            Caratula.appendChild(FchResol);
            Element NroResol = document.createElement("NroResol");
            Text nro = document.createTextNode(company.get_ValueAsString("NroResol"));
            NroResol.appendChild(nro);
            Caratula.appendChild(NroResol);
            Element TipoOperacion = document.createElement("TipoOperacion");
            Text tipo = document.createTextNode(this.p_TipoOperacion ? "VENTA" : "COMPRA");
            TipoOperacion.appendChild(tipo);
            Caratula.appendChild(TipoOperacion);
            Element TipoLibro = document.createElement("TipoLibro");
            Text tipoL = document.createTextNode(this.p_TipoLibro);
            TipoLibro.appendChild(tipoL);
            Caratula.appendChild(TipoLibro);
            Element TipoEnvio = document.createElement("TipoEnvio");
            Text tipoE = document.createTextNode(this.p_TipoEnvio);
            TipoEnvio.appendChild(tipoE);
            Caratula.appendChild(TipoEnvio);
            String whereDoc = "";
            if (this.p_TipoOperacion) {
                this.p_where = " and issotrx='Y' and ad_org_id=" + this.org_ID;
                this.p_where2 = " and i2.isSOTrx='Y' ";
                whereDoc = "'ARI','ARC'";
            } else {
                this.p_where = " and issotrx='N'  and ad_org_id=" + this.org_ID;
                this.p_where2 = " and i2.isSOTrx='N' ";
                whereDoc = "'API','APC'";
            }
            this.datefrom = Pe.getStartDate();
            this.dateto = Pe.getEndDate();
            if (this.p_TipoEnvio.equals("PARCIAL") || this.p_TipoEnvio.equals("AJUSTE")) {
                this.addResumenSegmento(this.period_ID, document, EnvioLibro, whereDoc);
            }
            if (this.p_TipoEnvio.equals("TOTAL") || this.p_TipoEnvio.equals("AJUSTE") || this.p_TipoEnvio.equals("FINAL")) {
                this.addResumenPeriodo(this.period_ID, document, EnvioLibro, whereDoc);
            }
            if (!this.p_TipoEnvio.equals("FINAL")) {
                this.addDetalle(this.period_ID, document, EnvioLibro, whereDoc);
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            EnvioLibro.appendChild(Firma);
            Element keycontainer = document.getDocumentElement();
            keycontainer.setAttribute("xmlns", "http://www.sii.cl/SiiDte");
            keycontainer.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            keycontainer.setAttribute("version", "1.0");
            keycontainer.setAttribute("xsi:schemaLocation", "http://www.sii.cl/SiiDte LibroCV_v10.xsd");
            mylog = "archivo";
            String ExportDir = this.p_ExportDir;
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, "libroCV" + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
        }
        return "";
    }

    public void addResumenSegmento(int C_Period_ID, Document document, Element EnvioLibro, String whereDoc) {
        String sql = "select doc.documentno,count(1),sum(i.totallines), (select coalesce(sum(round(tax.taxamt,0)),0) from c_invoicetax tax inner join c_invoice i2 on (i2.c_invoice_id=tax.c_invoice_id) inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id) inner join c_tax tt on (tax.c_tax_id=tt.c_tax_id and upper(tt.name) like '%IVA%') where i2.docstatus!='DR' and doc2.documentno=doc.documentno and i2.dateacct between ? and ?) as iva, (select coalesce(sum(round(tax.taxamt,0)),0) from c_invoicetax tax inner join c_invoice i2 on (i2.c_invoice_id=tax.c_invoice_id) inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id) inner join c_tax tt on (tax.c_tax_id=tt.c_tax_id and tt.istaxexempt='Y') where i2.docstatus!='DR' and doc2.documentno=doc.documentno and i2.dateacct between ? and ?) as exento , sum(i.grandtotal)  from c_invoice i  inner join c_doctype doc on (i.c_doctype_id=doc.c_doctype_id)  where i.docstatus!='DR'  and doc.docbasetype IN (" + whereDoc + ")" + " and i.dateacct between ? and ? " + this.p_where + " group by doc.documentno";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setTimestamp(1, this.datefrom);
            pstmt.setTimestamp(2, this.dateto);
            pstmt.setTimestamp(3, this.datefrom);
            pstmt.setTimestamp(4, this.dateto);
            pstmt.setTimestamp(5, this.datefrom);
            pstmt.setTimestamp(6, this.dateto);
            rs = pstmt.executeQuery();
            Element ResumenSegmento = document.createElement("ResumenSegmento");
            EnvioLibro.appendChild(ResumenSegmento);
            while (rs.next()) {
                Element TotalesSegmento = document.createElement("TotalesSegmento");
                ResumenSegmento.appendChild(TotalesSegmento);
                Element TpoDoc = document.createElement("TpoDoc");
                Text tipoD = document.createTextNode(rs.getString(1));
                TpoDoc.appendChild(tipoD);
                TotalesSegmento.appendChild(TpoDoc);
                Element TotDoc = document.createElement("TotDoc");
                Text totD = document.createTextNode(rs.getString(2));
                TotDoc.appendChild(totD);
                TotalesSegmento.appendChild(TotDoc);
                Element TotMntExe = document.createElement("TotMntExe");
                Text totE = document.createTextNode(rs.getString(5));
                TotMntExe.appendChild(totE);
                TotalesSegmento.appendChild(TotMntExe);
                Element TotMntNeto = document.createElement("TotMntNeto");
                Text totN = document.createTextNode(rs.getString(3));
                TotMntNeto.appendChild(totN);
                TotalesSegmento.appendChild(TotMntNeto);
                Element TotMntIVA = document.createElement("TotMntIVA");
                Text totI = document.createTextNode(rs.getString(4));
                TotMntIVA.appendChild(totI);
                TotalesSegmento.appendChild(TotMntIVA);
                Element TotMntTotal = document.createElement("TotMntTotal");
                Text tott = document.createTextNode(rs.getString(6));
                TotMntTotal.appendChild(tott);
                TotalesSegmento.appendChild(TotMntTotal);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
    }

    public void addResumenPeriodo(int C_Period_ID, Document document, Element EnvioLibro, String whereDoc) {
        String sql = "select doc.documentno,count(1),sum(currencyConvert(i.totallines,i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)), (select coalesce(round(sum(currencyConvert(tax.taxamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoicetax tax inner join c_invoice i2 on (i2.c_invoice_id=tax.c_invoice_id) inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id) inner join c_tax tt on (tax.c_tax_id=tt.c_tax_id and upper(tt.name) LIKE '%IVA%') where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as iva," + " (select coalesce(round(sum(currencyConvert(tax.taxbaseamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoicetax tax" + " inner join c_invoice i2 on (i2.c_invoice_id=tax.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " inner join c_tax tt on (tax.c_tax_id=tt.c_tax_id )" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno and tt.istaxexempt='Y' " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as exento" + ",( select coalesce(round(sum(currencyConvert(il.linenetamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il " + "inner join c_invoice i2 on (il.c_invoice_id=i2.c_invoice_id) " + "inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id) " + "where i2.dateacct between ? and ? and i2.isactive='Y'  and i2.ad_org_id=" + this.org_ID + this.p_where2 + " and il.c_charge_id=1000059 and doc2.documentno=doc.documentno and i2.docstatus not in ('DR','VO')) as especificoGasolina" + " , sum(i.grandtotal)," + " (select coalesce(round(sum(currencyConvert(tax.taxbaseamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoicetax tax" + " inner join c_invoice i2 on (i2.c_invoice_id=tax.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " inner join c_tax tt on (tax.c_tax_id=tt.c_tax_id and tt.istaxexempt='N')" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as neto" + ",( select coalesce(round(sum(currencyConvert(il.linenetamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il " + "inner join c_invoice i2 on (il.c_invoice_id=i2.c_invoice_id) " + "inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id) " + "where i2.dateacct between ? and ? and i2.isactive='Y'  and i2.ad_org_id=" + this.org_ID + this.p_where2 + " and il.c_charge_id=1000014 and doc2.documentno=doc.documentno and i2.docstatus not in ('DR','VO')) as especificoDiesel," + " (select coalesce(round(sum(currencyConvert(il.taxamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il" + " inner join c_invoice i2 on (i2.c_invoice_id=il.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno and il.c_tax_id=1000004 " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as rdiesel," + " (select coalesce(round(sum(currencyConvert(il.linenetamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il" + " inner join c_invoice i2 on (i2.c_invoice_id=il.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno and il.c_tax_id=1000006 " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as ndiesel," + " (select coalesce(round(sum(currencyConvert(il.taxamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il" + " inner join c_invoice i2 on (i2.c_invoice_id=il.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno and il.c_tax_id=1000008 " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as rgasolina," + " (select coalesce(round(sum(currencyConvert(il.linenetamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il" + " inner join c_invoice i2 on (i2.c_invoice_id=il.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno and il.c_tax_id=1000007 " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as ngasolina," + " (select coalesce(round(sum(currencyConvert(il.linenetamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il" + " inner join c_invoice i2 on (i2.c_invoice_id=il.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno and il.c_tax_id=1000004 " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as ndiesel2," + " (select coalesce(round(sum(currencyConvert(il.linenetamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),0) from c_invoiceline il" + " inner join c_invoice i2 on (i2.c_invoice_id=il.c_invoice_id)" + " inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id)" + " where i2.docstatus not in ('DR','VO') and doc2.documentno=doc.documentno and il.c_tax_id=1000008 " + this.p_where2 + " and i2.dateacct between ? and ? and i2.isactive='Y' and i2.ad_org_id=" + this.org_ID + ") as ngasolina2" + "  from c_invoice i" + "  inner join c_doctype doc on (i.c_doctype_id=doc.c_doctype_id)" + "  where i.docstatus not in ('DR','VO') and i.isactive='Y'  and doc.docbasetype IN (" + whereDoc + ")" + " and i.dateacct between ? and ? " + this.p_where + " and doc.documentno is not null";
        sql = String.valueOf(sql) + " group by doc.documentno";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Element TotalesPeriodo;
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setTimestamp(1, this.datefrom);
            pstmt.setTimestamp(2, this.dateto);
            pstmt.setTimestamp(3, this.datefrom);
            pstmt.setTimestamp(4, this.dateto);
            pstmt.setTimestamp(5, this.datefrom);
            pstmt.setTimestamp(6, this.dateto);
            pstmt.setTimestamp(7, this.datefrom);
            pstmt.setTimestamp(8, this.dateto);
            pstmt.setTimestamp(9, this.datefrom);
            pstmt.setTimestamp(10, this.dateto);
            pstmt.setTimestamp(11, this.datefrom);
            pstmt.setTimestamp(12, this.dateto);
            pstmt.setTimestamp(13, this.datefrom);
            pstmt.setTimestamp(14, this.dateto);
            pstmt.setTimestamp(15, this.datefrom);
            pstmt.setTimestamp(16, this.dateto);
            pstmt.setTimestamp(17, this.datefrom);
            pstmt.setTimestamp(18, this.dateto);
            pstmt.setTimestamp(19, this.datefrom);
            pstmt.setTimestamp(20, this.dateto);
            pstmt.setTimestamp(21, this.datefrom);
            pstmt.setTimestamp(22, this.dateto);
            pstmt.setTimestamp(23, this.datefrom);
            pstmt.setTimestamp(24, this.dateto);
            rs = pstmt.executeQuery();
            Element ResumenPeriodo = document.createElement("ResumenPeriodo");
            EnvioLibro.appendChild(ResumenPeriodo);
            boolean entro = false;
            while (rs.next()) {
                entro = true;
                TotalesPeriodo = document.createElement("TotalesPeriodo");
                ResumenPeriodo.appendChild(TotalesPeriodo);
                String tipoDoc = rs.getString(1);
                Element TpoDoc = document.createElement("TpoDoc");
                Text tipoD = document.createTextNode(tipoDoc);
                TpoDoc.appendChild(tipoD);
                TotalesPeriodo.appendChild(TpoDoc);
                String totaldocs = rs.getString(2);
                if (tipoDoc.trim().equals("919")) {
                    totaldocs = DB.getSQLValueString((String)this.get_TrxName(), (String)("select sum(il.qtyinvoiced) from c_invoiceline il inner join c_invoice i on (i.c_invoice_id=il.c_invoice_id) inner join c_doctype doc on (i.c_doctype_id=doc.c_doctype_id)  where i.docstatus not in ('DR','VO') and i.isactive='Y' and doc.documentno='919' and i.dateacct between ? and ? " + this.p_where), (Object[])new Object[]{this.datefrom, this.dateto});
                }
                Element TotDoc = document.createElement("TotDoc");
                Text totD = document.createTextNode(totaldocs);
                TotDoc.appendChild(totD);
                TotalesPeriodo.appendChild(TotDoc);
                BigDecimal exen = rs.getBigDecimal(5).setScale(0, 6);
                BigDecimal cargo_gasolina = rs.getBigDecimal(6).setScale(0, 6);
                BigDecimal cargo_diesel = rs.getBigDecimal(9).setScale(0, 6);
                BigDecimal r_diesel = rs.getBigDecimal(10).setScale(0, 6);
                BigDecimal n_diesel = rs.getBigDecimal(11).setScale(0, 6);
                BigDecimal r_gasolina = rs.getBigDecimal(12).setScale(0, 6);
                BigDecimal n_gasolina = rs.getBigDecimal(13).setScale(0, 6);
                BigDecimal n_diesel2 = rs.getBigDecimal(14).setScale(0, 6);
                BigDecimal n_gasolina2 = rs.getBigDecimal(15).setScale(0, 6);
                Element TotMntExe = document.createElement("TotMntExe");
                Text totE = document.createTextNode(exen.toString());
                TotMntExe.appendChild(totE);
                TotalesPeriodo.appendChild(TotMntExe);
                BigDecimal mntneto = rs.getBigDecimal(8);
                Element TotMntNeto = document.createElement("TotMntNeto");
                Text totN = document.createTextNode(mntneto.setScale(0, 6).toString());
                TotMntNeto.appendChild(totN);
                TotalesPeriodo.appendChild(TotMntNeto);
                BigDecimal mntiva = rs.getBigDecimal(4);
                Element TotMntIVA = document.createElement("TotMntIVA");
                Text totI = document.createTextNode(mntiva.setScale(0, 6).toString());
                TotMntIVA.appendChild(totI);
                TotalesPeriodo.appendChild(TotMntIVA);
                BigDecimal activoNeto = Env.ZERO;
                BigDecimal activoIva = Env.ZERO;
                if (!this.p_TipoOperacion) {
                    CPreparedStatement pstmt3 = null;
                    ResultSet rs3 = null;
                    String sql3 = " select count(1) , sum(invl.linenetamt) as total , trunc(sum (invl.taxamt)) as iva from C_InvoiceLine invl Inner join C_Invoice inv on (invl.c_invoice_id=inv.c_invoice_id) inner join C_DocType doc on (inv.C_Doctype_ID=doc.C_DocType_ID)  where inv.issotrx='N' and inv.docstatus in ('CO','CL') and invl.a_capvsexp = 'Cap'  and inv.dateacct between ? and ? and doc.Documentno=? and invl.a_createasset='Y' and inv.ad_org_id=" + this.org_ID;
                    try {
                        pstmt3 = DB.prepareStatement((String)sql3, (String)this.get_TrxName());
                        pstmt3.setTimestamp(1, this.datefrom);
                        pstmt3.setTimestamp(2, this.dateto);
                        pstmt3.setString(3, tipoDoc);
                        rs3 = pstmt3.executeQuery();
                        while (rs3.next()) {
                            if (rs3.getString(1) == null || rs3.getInt(1) == 0) continue;
                            Object[] param = new Object[]{this.datefrom, this.dateto, tipoDoc};
                            int countDocs = DB.getSQLValue((String)this.get_TrxName(), (String)("select count(1) from c_invoice i inner join c_doctype doc on (i.c_doctype_id=doc.c_doctype_id) where i.issotrx='N' and i.docstatus in ('CO','CL') and i.isactive='Y' and exists (select * from c_invoiceline il where il.c_invoice_id=i.c_invoice_id and il.a_capvsexp = 'Cap'  and il.a_createasset='Y') and i.dateacct between ? and ? and doc.Documentno=? and i.ad_Org_ID=" + this.org_ID), (Object[])param);
                            Element TotOpActivoFijo = document.createElement("TotOpActivoFijo");
                            Text totop = document.createTextNode(String.valueOf(countDocs));
                            TotOpActivoFijo.appendChild(totop);
                            TotalesPeriodo.appendChild(TotOpActivoFijo);
                            Element TotMntActivoFijo = document.createElement("TotMntActivoFijo");
                            Text totmaf = document.createTextNode(rs3.getBigDecimal(2).setScale(0, 6).toString());
                            TotMntActivoFijo.appendChild(totmaf);
                            TotalesPeriodo.appendChild(TotMntActivoFijo);
                            Element TotMntIVAActivoFijo = document.createElement("TotMntIVAActivoFijo");
                            Text totimaf = document.createTextNode(rs3.getBigDecimal(3).setScale(0, 6).toString());
                            TotMntIVAActivoFijo.appendChild(totimaf);
                            TotalesPeriodo.appendChild(TotMntIVAActivoFijo);
                            activoNeto = rs3.getBigDecimal(2);
                            activoIva = rs3.getBigDecimal(3);
                        }
                        rs3.close();
                        pstmt3.close();
                        pstmt3 = null;
                    }
                    catch (Exception e) {
                        this.log.severe(e.getMessage());
                    }
                }
                CPreparedStatement pstmt2 = null;
                ResultSet rs2 = null;
                String sql2 = "select coalesce(sum(currencyConvert(il.taxamt,i2.C_Currency_ID,228,i2.DateAcct,i2.C_ConversionType_ID,i2.AD_Client_ID,i2.AD_Org_ID)),0),il.CodIVANoRec, count(1) from c_invoicetax tax inner join c_invoice i2 on (i2.c_invoice_id=tax.c_invoice_id)  inner join c_invoiceline il on (i2.c_invoice_id=il.c_invoice_id)  inner join c_doctype doc2 on (i2.c_doctype_id=doc2.c_doctype_id) inner join c_tax tt on (tax.c_tax_id=tt.c_tax_id and upper(tt.name)='IVA NO RECUPERABLE') where i2.docstatus!='DR' and i2.dateacct between ? and ? and i2.isactive='Y'   and doc2.docbasetype IN (" + whereDoc + ") and i2.ad_org_id=" + this.org_ID;
                sql2 = String.valueOf(sql2) + " and doc2.documentno='" + tipoDoc + "'";
                sql2 = String.valueOf(sql2) + " group by il.CodIVANoRec";
                try {
                    pstmt2 = DB.prepareStatement((String)sql2, (String)this.get_TrxName());
                    boolean count = false;
                    pstmt2.setTimestamp(1, this.datefrom);
                    pstmt2.setTimestamp(2, this.dateto);
                    rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        if (rs2.getLong(1) == 0L) continue;
                        Element TotIVANoRec = document.createElement("TotIVANoRec");
                        TotalesPeriodo.appendChild(TotIVANoRec);
                        int countDocs = rs2.getInt(3);
                        if (rs2.getString(2) != null && rs2.getString(2).length() > 0) {
                            Object[] param = new Object[]{rs2.getString(2), this.datefrom, this.dateto, tipoDoc};
                            countDocs = DB.getSQLValue((String)this.get_TrxName(), (String)("select count(1) from c_invoice i inner join c_doctype doc on (i.c_doctype_id=doc.c_doctype_id) where exists (select * from c_invoiceline il  inner join c_tax t on (il.c_tax_id=t.c_tax_id) where upper(t.name)='IVA NO RECUPERABLE' and il.CodIVANoRec=? and il.c_invoice_id=i.c_invoice_id) and i.dateacct between ? and ? and i.isactive='Y' and i.docstatus!='DR' and doc.documentno=? and i.ad_org_id=" + this.org_ID), (Object[])param);
                            Element CodIVANoRec = document.createElement("CodIVANoRec");
                            Text codivano = document.createTextNode(rs2.getString(2));
                            CodIVANoRec.appendChild(codivano);
                            TotIVANoRec.appendChild(CodIVANoRec);
                        }
                        Element TotOpIVANoRec = document.createElement("TotOpIVANoRec");
                        Text totopiva = document.createTextNode(String.valueOf(countDocs));
                        TotOpIVANoRec.appendChild(totopiva);
                        TotIVANoRec.appendChild(TotOpIVANoRec);
                        Element MntIVANoRec = document.createElement("TotMntIVANoRec");
                        Text mntivanorec = document.createTextNode(rs2.getBigDecimal(1).setScale(0, 6).toString());
                        MntIVANoRec.appendChild(mntivanorec);
                        TotIVANoRec.appendChild(MntIVANoRec);
                    }
                    rs2.close();
                    pstmt2.close();
                    pstmt2 = null;
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                }
                if (!this.p_TipoOperacion) {
                    BigDecimal norec = Env.ZERO;
                    if (this.org_ID == 1000002 && (r_diesel.signum() > 0 || r_gasolina.signum() > 0)) {
                        Element TotOtrosImp = document.createElement("TotOtrosImp");
                        TotalesPeriodo.appendChild(TotOtrosImp);
                        if (r_diesel.signum() > 0) {
                            Element CodImp = document.createElement("CodImp");
                            Text codimp = document.createTextNode("29");
                            CodImp.appendChild(codimp);
                            TotOtrosImp.appendChild(CodImp);
                            Element TotMntImp = document.createElement("TotMntImp");
                            Text totopiva = document.createTextNode(r_diesel.setScale(0, 6).toString());
                            TotMntImp.appendChild(totopiva);
                            TotOtrosImp.appendChild(TotMntImp);
                        }
                        if (r_gasolina.signum() > 0) {
                            Element CodImp2 = document.createElement("CodImp");
                            Text codimp2 = document.createTextNode("35");
                            CodImp2.appendChild(codimp2);
                            TotOtrosImp.appendChild(CodImp2);
                            Element TotMntImp2 = document.createElement("TotMntImp");
                            Text totopiva2 = document.createTextNode(r_gasolina.setScale(0, 6).toString());
                            TotMntImp2.appendChild(totopiva2);
                            TotOtrosImp.appendChild(TotMntImp2);
                        }
                    }
                    if (norec.signum() > 0 || n_gasolina.signum() > 0 || n_diesel.signum() > 0 || n_gasolina2.signum() > 0 || n_diesel2.signum() > 0) {
                        norec = norec.add(n_gasolina);
                        norec = norec.add(n_diesel);
                        norec = norec.add(n_gasolina2);
                        norec = norec.add(n_diesel2);
                        norec = norec.subtract(r_gasolina);
                        norec = norec.subtract(r_diesel);
                        Element TotImpSinCredito = document.createElement("TotImpSinCredito");
                        Text totsc = document.createTextNode(norec.setScale(0, 6).toString());
                        TotImpSinCredito.appendChild(totsc);
                        TotalesPeriodo.appendChild(TotImpSinCredito);
                    }
                }
                Element TotMntTotal = document.createElement("TotMntTotal");
                Text tott = document.createTextNode(rs.getBigDecimal(7).setScale(0, 6).toString());
                TotMntTotal.appendChild(tott);
                TotalesPeriodo.appendChild(TotMntTotal);
            }
            if (!entro) {
                TotalesPeriodo = document.createElement("TotalesPeriodo");
                ResumenPeriodo.appendChild(TotalesPeriodo);
                Element TpoDoc = document.createElement("TpoDoc");
                Text tipoD = document.createTextNode(this.p_TipoOperacion ? "33" : "46");
                TpoDoc.appendChild(tipoD);
                TotalesPeriodo.appendChild(TpoDoc);
                Element TotDoc = document.createElement("TotDoc");
                Text totD = document.createTextNode("0");
                TotDoc.appendChild(totD);
                TotalesPeriodo.appendChild(TotDoc);
                Element TotMntExe = document.createElement("TotMntExe");
                Text totE = document.createTextNode("0");
                TotMntExe.appendChild(totE);
                TotalesPeriodo.appendChild(TotMntExe);
                Element TotMntNeto = document.createElement("TotMntNeto");
                Text totN = document.createTextNode("0");
                TotMntNeto.appendChild(totN);
                TotalesPeriodo.appendChild(TotMntNeto);
                Element TotMntIVA = document.createElement("TotMntIVA");
                Text totI = document.createTextNode("0");
                TotMntIVA.appendChild(totI);
                TotalesPeriodo.appendChild(TotMntIVA);
                Element TotMntTotal = document.createElement("TotMntTotal");
                Text tott = document.createTextNode("0");
                TotMntTotal.appendChild(tott);
                TotalesPeriodo.appendChild(TotMntTotal);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
    }

    public void addDetalle(int C_Period_ID, Document document, Element EnvioLibro, String whereDoc) {
        String sql = "select documentno,folio,tasa,dateinvoiced,rut,name,iva,grandtotal,docbasetype,documentname,exento,diesel,gasolina,c_invoice_id,rdiesel,rgasolina,ndiesel,ngasolina,ndiesel2, ngasolina2 from rvofb_detailcvxml where docbasetype IN (" + whereDoc + ")" + " and dateacct between ? and ? " + this.p_where;
        if (this.p_TipoOperacion) {
            sql = String.valueOf(sql) + " and documentno not in ('35','38','919','924') ";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setTimestamp(1, this.datefrom);
            pstmt.setTimestamp(2, this.dateto);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (this.p_TipoOperacion && (rs.getString(1).equals("35") || rs.getString(1).equals("38"))) continue;
                int invoice_id = rs.getInt(14);
                Element Detalle = document.createElement("Detalle");
                EnvioLibro.appendChild(Detalle);
                Element TpoDoc = document.createElement("TpoDoc");
                Text tipoD = document.createTextNode(rs.getString(1));
                TpoDoc.appendChild(tipoD);
                Detalle.appendChild(TpoDoc);
                if (rs.getString("docbasetype").equals("ARC")) {
                    Element Emisor = document.createElement("Emisor");
                    Text emi = document.createTextNode("1");
                    Emisor.appendChild(emi);
                    Detalle.appendChild(Emisor);
                }
                Element NroDoc = document.createElement("NroDoc");
                Text no = document.createTextNode(this.getNumbers(rs.getString("folio")));
                NroDoc.appendChild(no);
                Detalle.appendChild(NroDoc);
                Element TasaImp = document.createElement("TasaImp");
                Text tasa = document.createTextNode(rs.getString("tasa"));
                TasaImp.appendChild(tasa);
                Detalle.appendChild(TasaImp);
                Element FchDoc = document.createElement("FchDoc");
                Text fdoc = document.createTextNode(rs.getString("dateinvoiced").toString().substring(0, 10));
                FchDoc.appendChild(fdoc);
                Detalle.appendChild(FchDoc);
                Element RUTDoc = document.createElement("RUTDoc");
                Text rutdoc = document.createTextNode(rs.getString("rut"));
                RUTDoc.appendChild(rutdoc);
                Detalle.appendChild(RUTDoc);
                if (rs.getString("documentname").toUpperCase().indexOf("ELECTRO") > -1) {
                    Element RznSoc = document.createElement("RznSoc");
                    Text razon = document.createTextNode(rs.getString("name"));
                    RznSoc.appendChild(razon);
                    Detalle.appendChild(RznSoc);
                }
                BigDecimal cargo_diesel = rs.getBigDecimal(12).setScale(0, 6);
                BigDecimal cargo_gasolina = rs.getBigDecimal(13).setScale(0, 6);
                BigDecimal r_diesel = rs.getBigDecimal(15).setScale(0, 6);
                BigDecimal r_gasolina = rs.getBigDecimal(16).setScale(0, 6);
                BigDecimal n_diesel = rs.getBigDecimal(17).setScale(0, 6);
                BigDecimal n_gasolina = rs.getBigDecimal(18).setScale(0, 6);
                BigDecimal n_diesel2 = rs.getBigDecimal(19).setScale(0, 6);
                BigDecimal n_gasolina2 = rs.getBigDecimal(20).setScale(0, 6);
                BigDecimal mntexe = rs.getBigDecimal(11);
                Element MntExe = document.createElement("MntExe");
                Text exe = document.createTextNode(mntexe.setScale(0, 6).toString());
                MntExe.appendChild(exe);
                Detalle.appendChild(MntExe);
                BigDecimal mntneto = DB.getSQLValueBD((String)this.get_TrxName(), (String)("select COALESCE(SUM(currencyConvert(il.LineNetAmt,i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)),0) from C_InvoiceLine il  inner join c_invoice i on (il.c_invoice_id=i.c_invoice_id) inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) where t.istaxexempt='N' and i.C_Invoice_ID=" + rs.getInt("C_Invoice_ID")), (Object[])new Object[0]);
                Element MntNeto = document.createElement("MntNeto");
                Text neto = document.createTextNode(mntneto.setScale(0, 6).toString());
                MntNeto.appendChild(neto);
                Detalle.appendChild(MntNeto);
                BigDecimal mntiva = rs.getBigDecimal("iva");
                Element MntIVA = document.createElement("MntIVA");
                Text iva = document.createTextNode(mntiva.setScale(0, 6).toString());
                MntIVA.appendChild(iva);
                Detalle.appendChild(MntIVA);
                BigDecimal activoNeto = Env.ZERO;
                BigDecimal activoIva = Env.ZERO;
                if (!this.p_TipoOperacion) {
                    CPreparedStatement pstmt3 = null;
                    ResultSet rs3 = null;
                    String sql3 = " select  sum(currencyConvert(il.linenetamt,i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)) as neto , sum (currencyConvert(il.taxamt,i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)) as iva  from C_InvoiceLine il inner join c_invoice i on (il.c_invoice_id=i.c_invoice_id)  Where il.c_invoice_id = ? and il.a_capvsexp = 'Cap' and il.a_createasset='Y' ";
                    try {
                        pstmt3 = DB.prepareStatement((String)sql3, (String)this.get_TrxName());
                        pstmt3.setInt(1, invoice_id);
                        rs3 = pstmt3.executeQuery();
                        while (rs3.next()) {
                            if (rs3.getString(1) == null) continue;
                            Element MntActivoFijo = document.createElement("MntActivoFijo");
                            Text totmaf = document.createTextNode(rs3.getBigDecimal(1).setScale(0, 6).toString());
                            MntActivoFijo.appendChild(totmaf);
                            Detalle.appendChild(MntActivoFijo);
                            activoNeto = rs3.getBigDecimal(1);
                            activoIva = rs3.getBigDecimal(2);
                            Element MntIVAActivoFijo = document.createElement("MntIVAActivoFijo");
                            Text totimaf = document.createTextNode(rs3.getBigDecimal(2).setScale(0, 6).toString());
                            MntIVAActivoFijo.appendChild(totimaf);
                            Detalle.appendChild(MntIVAActivoFijo);
                        }
                        rs3.close();
                        pstmt3.close();
                        pstmt3 = null;
                    }
                    catch (Exception e) {
                        this.log.severe(e.getMessage());
                    }
                }
                CPreparedStatement pstmt2 = null;
                ResultSet rs2 = null;
                String sql2 = "select coalesce(sum(currencyConvert(il.taxamt,i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)),0),il.CodIVANoRec from  c_invoice i  inner join c_invoiceline il on (il.c_invoice_id=i.c_invoice_id) inner join c_tax tt on (il.c_tax_id=tt.c_tax_id and upper(tt.name)='IVA NO RECUPERABLE') where i.c_invoice_id=" + rs.getInt("c_invoice_id") + " group by il.CodIVANoRec";
                try {
                    pstmt2 = DB.prepareStatement((String)sql2, (String)this.get_TrxName());
                    int count = 0;
                    Element TotIVANoRec = null;
                    rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        if (count == 0) {
                            TotIVANoRec = document.createElement("IVANoRec");
                            Detalle.appendChild(TotIVANoRec);
                            ++count;
                        }
                        if (rs2.getString(2) != null && rs2.getString(2).length() > 0) {
                            Element CodIVANoRec = document.createElement("CodIVANoRec");
                            Text codivano = document.createTextNode(rs2.getString(2));
                            CodIVANoRec.appendChild(codivano);
                            TotIVANoRec.appendChild(CodIVANoRec);
                        }
                        Element MntIVANoRec = document.createElement("MntIVANoRec");
                        Text mntivanorec = document.createTextNode(rs2.getBigDecimal(1).setScale(0, 6).toString());
                        MntIVANoRec.appendChild(mntivanorec);
                        TotIVANoRec.appendChild(MntIVANoRec);
                    }
                    rs2.close();
                    pstmt2.close();
                    pstmt2 = null;
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                }
                if (!this.p_TipoOperacion) {
                    BigDecimal norec = Env.ZERO;
                    if (this.org_ID == 1000002 && (r_diesel.signum() > 0 || r_gasolina.signum() > 0)) {
                        Element TotOtrosImp = document.createElement("OtrosImp");
                        Detalle.appendChild(TotOtrosImp);
                        if (r_diesel.signum() > 0) {
                            Element CodImp = document.createElement("CodImp");
                            Text codimp = document.createTextNode("29");
                            CodImp.appendChild(codimp);
                            TotOtrosImp.appendChild(CodImp);
                            Element TasaImp2 = document.createElement("TasaImp");
                            Text tasa2 = document.createTextNode("29.65");
                            TasaImp2.appendChild(tasa2);
                            TotOtrosImp.appendChild(TasaImp2);
                            Element TotMntImp = document.createElement("MntImp");
                            Text totopiva = document.createTextNode(r_diesel.setScale(0, 6).toString());
                            TotMntImp.appendChild(totopiva);
                            TotOtrosImp.appendChild(TotMntImp);
                        }
                        if (r_gasolina.signum() > 0) {
                            Element CodImp2 = document.createElement("CodImp");
                            Text codimp2 = document.createTextNode("35");
                            CodImp2.appendChild(codimp2);
                            TotOtrosImp.appendChild(CodImp2);
                            Element TotMntImp2 = document.createElement("MntImp");
                            Text totopiva2 = document.createTextNode(r_gasolina.setScale(0, 6).toString());
                            TotMntImp2.appendChild(totopiva2);
                            TotOtrosImp.appendChild(TotMntImp2);
                        }
                    }
                    if (norec.signum() > 0 || n_gasolina.signum() > 0 || n_diesel.signum() > 0 || n_diesel2.signum() > 0 || n_gasolina2.signum() > 0) {
                        norec = norec.add(n_gasolina);
                        norec = norec.add(n_diesel);
                        norec = norec.add(n_diesel2);
                        norec = norec.add(n_gasolina2);
                        norec = norec.subtract(r_gasolina);
                        norec = norec.subtract(r_diesel);
                        Element TotImpSinCredito = document.createElement("MntSinCred");
                        Text totsc = document.createTextNode(norec.setScale(0, 6).toString());
                        TotImpSinCredito.appendChild(totsc);
                        Detalle.appendChild(TotImpSinCredito);
                    }
                }
                Element MntTotal = document.createElement("MntTotal");
                Text total = document.createTextNode(rs.getBigDecimal("grandtotal").setScale(0, 6).toString());
                MntTotal.appendChild(total);
                Detalle.appendChild(MntTotal);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
    }

    public String getNumbers(String in) {
        String salida = new String();
        try {
            char[] list = in.toCharArray();
            int i = 0;
            while (i < list.length) {
                salida = String.valueOf(salida) + Integer.parseInt(Character.toString(list[i]));
                ++i;
            }
        }
        catch (Exception e) {
            return salida;
        }
        return salida;
    }
}

