/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MForecastLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportForecast
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_M_Warehouse_ID = 0;
    private boolean p_deleteOldImported = false;
    private int M_Forecast_ID = 0;
    private Properties m_ctx;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DeleteOldImported")) {
                this.p_deleteOldImported = "Y".equals(para[i].getParameter());
            } else if (name.equals("M_Forecast_ID")) {
                this.M_Forecast_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = ((BigDecimal)para[i].getParameter()).intValue();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        StringBuffer sql;
        int no = 0;
        String clientCheck = this.getWhereClause();
        if (this.p_deleteOldImported) {
            sql = new StringBuffer("DELETE I_Forecast WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_Forecast o SET AD_Org_ID= " + this.p_AD_Org_ID + "WHERE  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("UPDATE I_Forecast o SET M_Warehouse_ID= " + this.p_M_Warehouse_ID + "WHERE  I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuffer("UPDATE I_Forecast o SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE o.ProductValue=p.Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_Forecast i SET C_Period_ID=(SELECT MAX(p.C_Period_ID) FROM C_Period p INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID) INNER JOIN AD_ClientInfo c ON (c.C_Calendar_ID=y.C_Calendar_ID) WHERE c.AD_Client_ID=i.AD_Client_ID AND i.DatePromised BETWEEN p.StartDate AND p.EndDate AND p.IsActive='Y') WHERE C_Period_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.log.fine("Set Period=" + no);
        sql = new StringBuffer("UPDATE I_Forecast i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Period, 'WHERE C_Period_ID IS NULL OR C_Period_ID NOT IN(SELECT C_Period_ID FROM C_Period p INNER JOIN C_Year y ON (y.C_Year_ID=p.C_Year_ID) INNER JOIN AD_ClientInfo c ON (c.C_Calendar_ID=y.C_Calendar_ID)  WHERE c.AD_Client_ID=i.AD_Client_ID AND i.DatePromised BETWEEN p.StartDate AND p.EndDate AND p.IsActive='Y' ) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Period=" + no);
        }
        if ((no = DB.executeUpdate((String)(sql = new StringBuffer("UPDATE I_Forecast o SET SalesRep_ID= " + Env.getAD_User_ID((Properties)this.m_ctx) + "WHERE  I_IsImported<>'Y'").append(clientCheck)).toString(), (String)this.get_TrxName())) != 0) {
            this.log.warning("Invalid user=" + no);
        }
        this.commitEx();
        sql = new StringBuffer("SELECT * FROM I_Forecast WHERE I_IsImported='N' and M_Product_ID is not null ORDER BY DatePromised");
        MForecastLine line = null;
        CPreparedStatement pstmt = null;
        int noInsert = 0;
        int noUpdated = 0;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int oldline_id = DB.getSQLValue((String)this.get_TrxName(), (String)"select m_forecastline_id from m_forecastline where m_forecast_ID=? and datepromised=? and m_product_id=?", (Object[])new Object[]{this.M_Forecast_ID, rs.getTimestamp("datepromised"), rs.getInt("M_Product_ID")});
                if (oldline_id > 0) {
                    line = new MForecastLine(Env.getCtx(), oldline_id, this.get_TrxName());
                    ++noUpdated;
                } else {
                    line = new MForecastLine(Env.getCtx(), 0, this.get_TrxName());
                    ++noInsert;
                }
                line.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                line.setC_Period_ID(rs.getInt("C_Period_ID"));
                line.setDatePromised(rs.getTimestamp("DatePromised"));
                line.setM_Forecast_ID(this.M_Forecast_ID);
                line.setQty(rs.getBigDecimal("Qty"));
                line.setSalesRep_ID(rs.getInt("SalesRep_ID"));
                line.setM_Warehouse_ID(rs.getInt("M_Warehouse_ID"));
                line.setM_Product_ID(rs.getInt("M_Product_ID"));
                line.saveEx();
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        sql = new StringBuffer("UPDATE I_Forecast SET I_IsImported='Y'  WHERE I_IsImported<>'Y' and SalesRep_ID=" + Env.getAD_User_ID((Properties)this.m_ctx));
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(noUpdated), "@Updated@");
        this.addLog(0, null, new BigDecimal(noInsert), "@Inserted@");
        return "";
    }

    public String getWhereClause() {
        return " AND AD_Client_ID=" + Env.getAD_Client_ID((Properties)this.m_ctx);
    }
}

