/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_BankMatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CotejacionAutomatica
extends SvrProcess {
    private int m_BankAccount_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BankAccount_ID")) {
                    this.m_BankAccount_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        sql = new StringBuffer("SELECT * FROM C_bankMatch i  WHERE i.C_BankAccount_ID>0 and ismatched='N' ");
        sql.append(" And i.createdby=" + Env.getAD_User_ID((Properties)this.getCtx()));
        if (this.m_BankAccount_ID > 0) {
            sql.append(" And i.C_BankAccount_ID=" + this.m_BankAccount_ID);
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_C_BankMatch cbank = new X_C_BankMatch(Env.getCtx(), rs, this.get_TrxName());
                int Payment_ID = this.getPayment(cbank.getAmt(), cbank.getSigno(), cbank.getDescription(), cbank.getC_BankAccount_ID());
                if (Payment_ID <= 0) continue;
                cbank.setC_Payment_ID(Payment_ID);
                cbank.setIsMatched(true);
                cbank.save();
                ++no;
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage());
        }
        this.commitEx();
        return String.valueOf(no) + " Cotejados";
    }

    private int getPayment(BigDecimal amt, String signo, String Descripcion, int Account_ID) {
        String sql = "select p.C_Payment_ID from C_Payment p where p.DocStatus IN ('CO','CL') and p.isReconciled='N' and p.PayAmt=? and p.isreceipt=? and p.C_BankAccount_ID=? And Not Exists (select * from C_bankMatch c where c.C_Payment_ID = p.C_Payment_ID) ";
        if (Descripcion.toUpperCase().indexOf("CHEQUE") > -1) {
            sql = String.valueOf(sql) + " and p.TenderType='K' ";
        }
        return DB.getSQLValue((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{amt, signo.equals("+") ? "Y" : "N", Account_ID});
    }
}

