/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.OFBProductCost;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CostCreateRecalc
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        this.log.info("M_Product_ID=" + this.p_M_Product_ID);
        if (this.p_M_Product_ID == 0 && this.p_M_Product_Category_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @M_Product_ID@ = " + this.p_M_Product_ID);
        }
        if (this.p_M_Product_ID > 0) {
            MProduct product = MProduct.get(this.getCtx(), this.p_M_Product_ID);
            if (product.get_ID() != this.p_M_Product_ID) {
                throw new AdempiereUserError("@NotFound@: @M_Product_ID@ = " + this.p_M_Product_ID);
            }
            MCostElement[] ces = MCostElement.getCostingMethods((PO)((Object)product));
            MAcctSchema as = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID())[0];
            int i = 0;
            while (i < ces.length) {
                MOrg[] orgs = MOrg.getOfClient((PO)((Object)product));
                int x = 0;
                while (x < orgs.length) {
                    MCostElement ce = ces[i];
                    MCost cost = OFBProductCost.getMCost(product.getM_Product_ID(), orgs[x].getAD_Org_ID(), ce.getM_CostElement_ID(), as.getC_AcctSchema_ID(), as.getM_CostType_ID(), this.get_TrxName(), this.getCtx());
                    cost.setCumulatedQty(Env.ZERO);
                    cost.setCurrentCostPrice(Env.ZERO);
                    cost.setCumulatedAmt(Env.ZERO);
                    cost.setCurrentQty(Env.ZERO);
                    cost.saveEx();
                    ++x;
                }
                ++i;
            }
            DB.executeUpdate((String)("update m_costdetail set processed='N', enabled='Y'  where m_product_id=" + this.p_M_Product_ID), (String)this.get_TrxName());
            OFBProductCost.processCost(product.getM_Product_ID(), this.get_TrxName(), this.getCtx());
            this.commitEx();
            return "@OK@";
        }
        if (this.p_M_Product_Category_ID > 0) {
            String sql = "SELECT p.M_Product_ID FROM M_Product p Inner Join M_Cost d on (p.M_Product_ID=d.M_product_ID) WHERE p.M_Product_Category_ID=? AND p.isactive='Y' ";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.p_M_Product_Category_ID);
                ResultSet rs = pstmt.executeQuery();
                MAcctSchema as = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID())[0];
                while (rs.next()) {
                    MProduct product = MProduct.get(this.getCtx(), rs.getInt(1));
                    MCostElement[] ces = MCostElement.getCostingMethods((PO)((Object)product));
                    int i = 0;
                    while (i < ces.length) {
                        MCostElement ce = ces[i];
                        MOrg[] orgs = MOrg.getOfClient((PO)((Object)product));
                        int x = 0;
                        while (x < orgs.length) {
                            MCost cost = OFBProductCost.getMCost(product.getM_Product_ID(), orgs[x].getAD_Org_ID(), ce.getM_CostElement_ID(), as.getC_AcctSchema_ID(), as.getM_CostType_ID(), this.get_TrxName(), this.getCtx());
                            cost.setCumulatedQty(Env.ZERO);
                            cost.setCurrentCostPrice(Env.ZERO);
                            cost.setCumulatedAmt(Env.ZERO);
                            cost.setCurrentQty(Env.ZERO);
                            cost.saveEx();
                            ++x;
                        }
                        ++i;
                    }
                    DB.executeUpdate((String)("update m_costdetail set processed='N', enabled='Y'  where m_product_id=" + this.p_M_Product_ID), (String)this.get_TrxName());
                    OFBProductCost.processCost(product.getM_Product_ID(), this.get_TrxName(), this.getCtx());
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                this.commitEx();
                return "@OK@";
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
        }
        return "@Error@";
    }
}

