/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MOrderLine;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubSalesRep
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = 840666209988831145L;
    private CLabel f_label = null;
    private CButton f_button = null;
    private CButton DiscountBtn;
    private VNumber f_discount;
    private BigDecimal discount;
    private static CLogger log = CLogger.getCLogger(SubSalesRep.class);

    public SubSalesRep(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate((Properties)Env.getCtx(), (String)"C_POS_ID"));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        this.f_label = new CLabel(this.p_pos.getName(), 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)this.f_label, gbc);
        this.DiscountBtn = new CButton("Descontar");
        this.DiscountBtn.addActionListener((ActionListener)this);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)this.DiscountBtn, gbc);
        this.f_discount = new VNumber("PriceActual", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"PriceActual"));
        this.f_discount.setColumns(8, 20);
        this.f_discount.setValue((Object)Env.ZERO);
        this.f_discount.addActionListener((ActionListener)this);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)this.f_discount, gbc);
        this.f_button = new CButton(Msg.getMsg((Properties)Env.getCtx(), (String)"Logout"));
        this.f_button.setActionCommand("LogOut");
        this.f_button.setFocusable(false);
        this.f_button.addActionListener((ActionListener)this);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        this.add((Component)this.f_button, gbc);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubSalesRep - actionPerformed: " + action);
        log.info("PosSubSalesRep - actionPerformed: " + action);
        if (action.equals("Descontar")) {
            JPasswordField pf = new JPasswordField();
            Object[] message = new Object[]{"Ingrese Password", pf};
            Object[] options = new String[]{"OK", "Cancel"};
            JOptionPane op = new JOptionPane(message, -1, 2, null, options);
            JDialog dialog = op.createDialog(null, "Password");
            dialog.setVisible(true);
            String seleccion = String.valueOf(pf.getPassword());
            if (this.p_pos.getPassword().equals(seleccion) && this.discount.signum() > 0) {
                BigDecimal appliedDiscount = this.discount.divide(new BigDecimal("1.19"), 0, 6);
                MOrderLine discountLine = new MOrderLine(this.p_posPanel.f_curLine.getOrder());
                discountLine.setC_Charge_ID(DB.getSQLValue(null, (String)"select C_Charge_ID from C_charge where name='DESCUENTO'"));
                discountLine.setQty(Env.ONE);
                discountLine.setPrice(appliedDiscount.negate());
                discountLine.save();
                this.p_posPanel.updateInfo();
                this.f_discount.setValue((Object)Env.ZERO);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Password invalida");
            }
        } else if (action.equals("VNumber")) {
            this.f_discount.setValue(this.f_discount.getValue());
            this.discount = (BigDecimal)this.f_discount.getValue();
        } else if (e.getSource() == this.f_button) {
            this.p_posPanel.dispose();
        }
    }
}

