/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Properties;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.print.ReportCtl;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubCheckout
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = 6359287546081954105L;
    private CButton f_register = null;
    private CButton f_summary = null;
    private CButton f_process = null;
    private CButton f_print = null;
    private CLabel f_lDocumentNo = null;
    private CTextField f_DocumentNo;
    private CLabel f_lcashGiven = null;
    private VNumber f_cashGiven;
    private CLabel f_lcashReturn = null;
    private VNumber f_cashReturn;
    private CButton f_cashPayment = null;
    private CButton f_cashRegisterFunctions;
    private static CLogger log = CLogger.getCLogger(SubCheckout.class);

    public SubCheckout(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS2;
        gbc.gridx = 0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.weightx = 0.1;
        CPanel cash = new CPanel((LayoutManager)new GridBagLayout());
        cash.setBackground(Color.lightGray);
        cash.setBorder((Border)new TitledBorder(Msg.getMsg((Properties)Env.getCtx(), (String)"Checkout")));
        gbc.gridy = 0;
        this.add((Component)cash, gbc);
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = INSETS2;
        this.f_lDocumentNo = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"DocumentNo"));
        cash.add((Component)this.f_lDocumentNo, (Object)gbc0);
        this.f_DocumentNo = new CTextField("");
        this.f_DocumentNo.setName("DocumentNo");
        cash.add((Component)this.f_DocumentNo, (Object)gbc0);
        this.f_lcashGiven = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"CashGiven"));
        cash.add((Component)this.f_lcashGiven, (Object)gbc0);
        this.f_cashGiven = new VNumber("CashGiven", false, false, true, 12, Msg.translate((Properties)Env.getCtx(), (String)"CashGiven"));
        this.f_cashGiven.setColumns(12, 25);
        cash.add((Component)this.f_cashGiven, (Object)gbc0);
        this.f_cashGiven.setValue((Object)Env.ZERO);
        this.f_cashGiven.addActionListener((ActionListener)this);
        this.f_lcashReturn = new CLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"CashReturn"));
        cash.add((Component)this.f_lcashReturn, (Object)gbc0);
        this.f_cashReturn = new VNumber("CashReturn", false, true, false, 12, "CashReturn");
        this.f_cashReturn.setColumns(8, 25);
        cash.add((Component)this.f_cashReturn, (Object)gbc0);
        this.f_cashReturn.setValue((Object)Env.ZERO);
        this.f_cashPayment = this.createButtonAction("Payment", null);
        this.f_cashPayment.setActionCommand("Cash");
        gbc0.weightx = 0.1;
        cash.add((Component)this.f_cashPayment, (Object)gbc0);
        CPanel utils = new CPanel((LayoutManager)new GridBagLayout());
        utils.setBorder((Border)new TitledBorder(Msg.getMsg((Properties)Env.getCtx(), (String)"Utils")));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.1;
        this.add((Component)utils, gbc);
        GridBagConstraints gbcU = new GridBagConstraints();
        gbcU.insets = INSETS2;
        gbcU.anchor = 13;
        this.f_cashRegisterFunctions = this.createButtonAction("CashRegisterFunction", null);
        this.f_cashRegisterFunctions.setText("Cash Functions");
        this.f_cashRegisterFunctions.setPreferredSize(new Dimension(130, 37));
        this.f_cashRegisterFunctions.setMaximumSize(new Dimension(130, 37));
        this.f_cashRegisterFunctions.setMinimumSize(new Dimension(130, 37));
        this.f_register = this.createButtonAction("Register", null);
        utils.add((Component)this.f_register, (Object)gbcU);
        this.f_summary = this.createButtonAction("Summary", null);
        utils.add((Component)this.f_summary, (Object)gbcU);
        this.f_process = this.createButtonAction("Process", null);
        utils.add((Component)this.f_process, (Object)gbcU);
        this.f_print = this.createButtonAction("Print", null);
        utils.add((Component)this.f_print, (Object)gbcU);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubCheckout - actionPerformed: " + action);
        if (action.equals("Register")) {
            this.p_posPanel.f_queryTicket.reset();
            this.p_posPanel.openQuery(this.p_posPanel.f_queryTicket);
        } else if (action.equals("Summary")) {
            this.displaySummary();
        } else if (action.equals("Process")) {
            if (this.isOrderFullyPay()) {
                this.displaySummary();
                if (this.processOrder()) {
                    this.printTicket();
                    this.openCashDrawer();
                    this.p_posPanel.newOrder();
                    this.f_cashGiven.setValue((Object)Env.ZERO);
                }
            } else {
                this.p_posPanel.f_status.setStatusLine("PAYMENT NOT FULL.");
            }
        } else if (action.equals("Print")) {
            if (this.isOrderFullyPay()) {
                this.displaySummary();
                this.printTicket();
                this.openCashDrawer();
            } else {
                this.p_posPanel.f_status.setStatusLine("Order not fully paid.");
            }
        } else if (action.equals("Cash")) {
            this.displayReturn();
            this.openCashDrawer();
        } else if (action.equals("CashRegisterFunction")) {
            this.p_posPanel.openQuery(this.p_posPanel.f_cashfunctions);
        } else if (e.getSource() == this.f_cashGiven) {
            this.displayReturn();
        }
        this.p_posPanel.updateInfo();
    }

    private void displaySummary() {
        this.p_posPanel.f_status.setStatusLine(this.p_posPanel.f_curLine.getOrder().getSummary());
        this.displayReturn();
    }

    public boolean processOrder() {
        boolean orderCompleted;
        block20: {
            orderCompleted = false;
            this.p_posPanel.setCursor(Cursor.getPredefinedCursor(3));
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            if (order != null && order.getDocStatus().equals("DR")) {
                order.setDocAction("CO");
                try {
                    try {
                        if (order.processIt("CO")) {
                            order.save();
                        } else {
                            log.info("SubCheckout - processOrder FAILED");
                            this.p_posPanel.f_status.setStatusLine("Order can not be completed, verifique el libro");
                        }
                    }
                    catch (Exception e) {
                        log.severe("Order can not be completed - " + e.getMessage());
                        this.p_posPanel.f_status.setStatusLine("Error when processing order, verifique el libro");
                        if (order.getDocStatus().equals("IN")) {
                            order.setDocStatus("DR");
                        } else if (order.getDocStatus().equals("CO")) {
                            order = null;
                            orderCompleted = true;
                            log.info("SubCheckout - processOrder OK");
                            this.p_posPanel.f_status.setStatusLine("Order completed.");
                        } else {
                            log.info("SubCheckout - processOrder - unrecognized DocStatus");
                            this.p_posPanel.f_status.setStatusLine("Orden was not completed correctly.");
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (order.getDocStatus().equals("IN")) {
                        order.setDocStatus("DR");
                    } else if (order.getDocStatus().equals("CO")) {
                        order = null;
                        orderCompleted = true;
                        log.info("SubCheckout - processOrder OK");
                        this.p_posPanel.f_status.setStatusLine("Order completed.");
                    } else {
                        log.info("SubCheckout - processOrder - unrecognized DocStatus");
                        this.p_posPanel.f_status.setStatusLine("Orden was not completed correctly.");
                    }
                    throw throwable;
                }
                if (order.getDocStatus().equals("IN")) {
                    order.setDocStatus("DR");
                } else if (order.getDocStatus().equals("CO")) {
                    order = null;
                    orderCompleted = true;
                    log.info("SubCheckout - processOrder OK");
                    this.p_posPanel.f_status.setStatusLine("Order completed.");
                } else {
                    log.info("SubCheckout - processOrder - unrecognized DocStatus");
                    this.p_posPanel.f_status.setStatusLine("Orden was not completed correctly.");
                }
            }
        }
        this.p_posPanel.setCursor(Cursor.getDefaultCursor());
        return orderCompleted;
    }

    public void printTicket() {
        MOrder order = this.p_posPanel.f_curLine.getOrder();
        if (order != null) {
            try {
                ReportCtl.startDocumentPrint((int)10, (int)order.getC_Order_ID(), null, (int)Env.getWindowNo((Container)((Object)this)), (boolean)true);
            }
            catch (Exception e) {
                log.severe("PrintTicket - Error Printing Ticket");
            }
        }
    }

    public void displayReturn() {
        BigDecimal given = new BigDecimal(this.f_cashGiven.getValue().toString());
        if (this.p_posPanel != null && this.p_posPanel.f_curLine != null) {
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            BigDecimal total = new BigDecimal(0);
            if (order != null) {
                this.f_DocumentNo.setText(order.getDocumentNo());
                total = order.getGrandTotal();
            }
            double cashReturn = given.doubleValue() - total.doubleValue();
            this.f_cashReturn.setValue((Object)new BigDecimal(cashReturn));
        }
    }

    public boolean isOrderFullyPay() {
        BigDecimal given = new BigDecimal(this.f_cashGiven.getValue().toString());
        boolean paid = false;
        if (this.p_posPanel != null && this.p_posPanel.f_curLine != null) {
            MOrder order = this.p_posPanel.f_curLine.getOrder();
            MDocType dt = MDocType.get((Properties)Env.getCtx(), (int)order.getC_DocTypeTarget_ID());
            if (dt.getDocSubTypeSO().equals("WP") || dt.getDocSubTypeSO().equals("RM")) {
                return true;
            }
            BigDecimal total = new BigDecimal(0);
            if (order != null) {
                total = order.getGrandTotal();
            }
            paid = given.doubleValue() >= total.doubleValue();
        }
        return paid;
    }

    public void openCashDrawer() {
        Object puerto = null;
    }
}

