/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Obscure;
import org.compiere.model.PO;
import org.compiere.model.PaymentProcessor;
import org.compiere.model.Query;
import org.compiere.model.X_C_Payment;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public final class MPayment
extends X_C_Payment
implements DocAction,
ProcessCall {
    private static final long serialVersionUID = 6200327948230438741L;
    private MPaymentProcessor[] m_mPaymentProcessors = null;
    private MPaymentProcessor m_mPaymentProcessor = null;
    private static CLogger s_log = CLogger.getCLogger(MPayment.class);
    private String m_errorMessage = null;
    public static String REVERSE_INDICATOR = "^";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MPayment[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        String whereClause = "C_BPartner_ID=?";
        List list = new Query(ctx, "C_Payment", "C_BPartner_ID=?", trxName).setParameters(new Object[]{C_BPartner_ID}).list();
        MPayment[] retValue = new MPayment[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPayment(Properties ctx, int C_Payment_ID, String trxName) {
        super(ctx, C_Payment_ID, trxName);
        if (C_Payment_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setTrxType("S");
            this.setR_AvsAddr("X");
            this.setR_AvsZip("X");
            this.setIsReceipt(true);
            this.setIsApproved(false);
            this.setIsReconciled(false);
            this.setIsAllocated(false);
            this.setIsOnline(false);
            this.setIsSelfService(false);
            this.setIsDelayedCapture(false);
            this.setIsPrepayment(false);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setTaxAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setIsOverUnderPayment(false);
            this.setOverUnderAmt(Env.ZERO);
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getDateTrx());
            this.setTenderType("K");
        }
    }

    public MPayment(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void resetNew() {
        this.setC_Payment_ID(0);
        this.set_ValueNoCheck("DocumentNo", null);
        this.setDocAction("PR");
        this.setDocStatus("DR");
        this.setProcessed(false);
        this.setPosted(false);
        this.setIsReconciled(false);
        this.setIsAllocated(false);
        this.setIsOnline(false);
        this.setIsDelayedCapture(false);
        this.setC_Invoice_ID(0);
        this.setC_Order_ID(0);
        this.setC_Charge_ID(0);
        this.setC_Project_ID(0);
        this.setIsPrepayment(false);
    }

    public boolean isCashTrx() {
        return "X".equals(this.getTenderType());
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, int creditCardExpMM, int creditCardExpYY) {
        this.setTenderType("C");
        this.setTrxType(TrxType);
        this.setCreditCardType(creditCardType);
        this.setCreditCardNumber(creditCardNumber);
        this.setCreditCardVV(creditCardVV);
        this.setCreditCardExpMM(creditCardExpMM);
        this.setCreditCardExpYY(creditCardExpYY);
        int check = MPaymentValidate.validateCreditCardNumber((String)creditCardNumber, (String)creditCardType).length() + MPaymentValidate.validateCreditCardExp((int)creditCardExpMM, (int)creditCardExpYY).length();
        if (creditCardVV.length() > 0) {
            check += MPaymentValidate.validateCreditCardVV((String)creditCardVV, (String)creditCardType).length();
        }
        return check == 0;
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, String creditCardExp) {
        return this.setCreditCard(TrxType, creditCardType, creditCardNumber, creditCardVV, MPaymentValidate.getCreditCardExpMM((String)creditCardExp), MPaymentValidate.getCreditCardExpYY((String)creditCardExp));
    }

    public boolean setBankACH(MPaySelectionCheck preparedPayment) {
        this.setC_BankAccount_ID(preparedPayment.getParent().getC_BankAccount_ID());
        int C_BP_BankAccount_ID = preparedPayment.getC_BP_BankAccount_ID();
        MBPBankAccount ba = new MBPBankAccount(preparedPayment.getCtx(), C_BP_BankAccount_ID, null);
        this.setRoutingNo(ba.getRoutingNo());
        this.setAccountNo(ba.getAccountNo());
        this.setIsReceipt("D".equals(preparedPayment.getPaymentRule()));
        if ("D".equals(preparedPayment.getPaymentRule())) {
            this.setTenderType("D");
        } else if ("T".equals(preparedPayment.getPaymentRule())) {
            this.setTenderType("A");
        }
        int check = MPaymentValidate.validateRoutingNo((String)this.getRoutingNo()).length() + MPaymentValidate.validateAccountNo((String)this.getAccountNo()).length();
        return check == 0;
    }

    public boolean setBankACH(int C_BankAccount_ID, boolean isReceipt, String tenderType, String routingNo, String accountNo) {
        this.setTenderType(tenderType);
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0 && (routingNo == null || routingNo.length() == 0 || accountNo == null || accountNo.length() == 0)) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
            this.setRoutingNo(routingNo);
            this.setAccountNo(accountNo);
        }
        this.setCheckNo("");
        int check = MPaymentValidate.validateRoutingNo((String)routingNo).length() + MPaymentValidate.validateAccountNo((String)accountNo).length();
        return check == 0;
    }

    public boolean setBankCash(int C_BankAccount_ID, boolean isReceipt, String tenderType) {
        this.setTenderType(tenderType);
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
        }
        return true;
    }

    public boolean setBankCheck(int C_BankAccount_ID, boolean isReceipt, String checkNo) {
        return this.setBankCheck(C_BankAccount_ID, isReceipt, null, null, checkNo);
    }

    public boolean setBankCheck(int C_BankAccount_ID, boolean isReceipt, String routingNo, String accountNo, String checkNo) {
        this.setTenderType("K");
        this.setIsReceipt(isReceipt);
        if (C_BankAccount_ID > 0 && (routingNo == null || routingNo.length() == 0 || accountNo == null || accountNo.length() == 0)) {
            this.setBankAccountDetails(C_BankAccount_ID);
        } else {
            this.setC_BankAccount_ID(C_BankAccount_ID);
            this.setRoutingNo(routingNo);
            this.setAccountNo(accountNo);
        }
        this.setCheckNo(checkNo);
        int check = MPaymentValidate.validateRoutingNo((String)routingNo).length() + MPaymentValidate.validateAccountNo((String)accountNo).length() + MPaymentValidate.validateCheckNo((String)checkNo).length();
        return check == 0;
    }

    public void setBankAccountDetails(int C_BankAccount_ID) {
        block7: {
            if (C_BankAccount_ID == 0) {
                return;
            }
            this.setC_BankAccount_ID(C_BankAccount_ID);
            String sql = "SELECT b.RoutingNo, ba.AccountNo FROM C_BankAccount ba INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) WHERE C_BankAccount_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, C_BankAccount_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.setRoutingNo(rs.getString(1));
                        this.setAccountNo(rs.getString(2));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public void setAccountAddress(String name, String street, String city, String state, String zip, String country) {
        this.setA_Name(name);
        this.setA_Street(street);
        this.setA_City(city);
        this.setA_State(state);
        this.setA_Zip(zip);
        this.setA_Country(country);
    }

    public boolean processOnline() {
        this.log.info("Amt=" + this.getPayAmt());
        this.setIsOnline(true);
        this.setErrorMessage(null);
        if (this.isApproved()) {
            this.log.info("Already processed - " + this.getR_Result() + " - " + this.getR_RespMsg());
            this.setErrorMessage("Payment already Processed");
            return true;
        }
        if (this.m_mPaymentProcessor == null) {
            this.setPaymentProcessor();
        }
        if (this.m_mPaymentProcessor == null) {
            this.log.log(Level.WARNING, "No Payment Processor Model");
            this.setErrorMessage("No Payment Processor Model");
            return false;
        }
        boolean approved = false;
        try {
            PaymentProcessor pp = PaymentProcessor.create((MPaymentProcessor)this.m_mPaymentProcessor, (MPayment)this);
            if (pp == null) {
                this.setErrorMessage("No Payment Processor");
            } else {
                String msg = pp.validate();
                if (msg != null && msg.trim().length() > 0) {
                    this.setErrorMessage(Msg.getMsg((Properties)this.getCtx(), (String)msg));
                } else {
                    approved = pp.processCC();
                    if (approved) {
                        this.setErrorMessage(null);
                    } else {
                        this.setErrorMessage("From " + this.getCreditCardName() + ": " + this.getR_RespMsg());
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processOnline", (Throwable)e);
            this.setErrorMessage("Payment Processor Error: " + e.getMessage());
        }
        this.setIsApproved(approved);
        return approved;
    }

    public boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        this.log.info("startProcess - " + pi.getRecord_ID());
        boolean retValue = false;
        if (pi.getRecord_ID() != this.get_ID()) {
            this.log.log(Level.SEVERE, "startProcess - Not same Payment - " + pi.getRecord_ID());
            return false;
        }
        retValue = this.processOnline();
        this.save();
        return retValue;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isCashTrx() && !MSysConfig.getBooleanValue((String)"CASH_AS_PAYMENT", (boolean)true, (int)this.getAD_Client_ID())) {
            if (this.getC_CashBook_ID() <= 0) {
                this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@Mandatory@: @C_CashBook_ID@"));
                return false;
            }
        } else if (this.getC_BankAccount_ID() <= 0) {
            this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@Mandatory@: @C_BankAccount_ID@"));
            return false;
        }
        if (this.getC_Charge_ID() != 0) {
            if (newRecord || this.is_ValueChanged("C_Charge_ID")) {
                this.setC_Order_ID(0);
                this.setC_Invoice_ID(0);
                this.setWriteOffAmt(Env.ZERO);
                this.setDiscountAmt(Env.ZERO);
                this.setIsOverUnderPayment(false);
                this.setOverUnderAmt(Env.ZERO);
                this.setIsPrepayment(false);
            }
        } else if (this.getC_BPartner_ID() == 0 && !this.isCashTrx() && this.getC_Invoice_ID() == 0 && this.getC_Order_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@NotFound@: @C_BPartner_ID@"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("C_Charge_ID") || this.is_ValueChanged("C_Invoice_ID") || this.is_ValueChanged("C_Order_ID") || this.is_ValueChanged("C_Project_ID")) {
            this.setIsPrepayment(this.getC_Charge_ID() == 0 && this.getC_BPartner_ID() != 0 && (this.getC_Order_ID() != 0 || this.getC_Project_ID() != 0 && this.getC_Invoice_ID() == 0));
        }
        if (this.isPrepayment() && (newRecord || this.is_ValueChanged("C_Order_ID") || this.is_ValueChanged("C_Project_ID"))) {
            this.setWriteOffAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsOverUnderPayment(false);
            this.setOverUnderAmt(Env.ZERO);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID();
        } else {
            MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            this.setIsReceipt(dt.isSOTrx());
        }
        this.setDocumentNo();
        if (!this.is_ValueChanged("IsAllocated") && !this.getDocStatus().equals("CO")) {
            int existe = 0;
            String mysql = new String();
            if (this.getTenderType().equals("K")) {
                if (this.isReceipt()) {
                    mysql = "select count(1) from c_payment where docstatus IN ('CO','DR') and isreceipt='Y' and c_bpartner_id=" + this.getC_BPartner_ID();
                    mysql = this.getCheckNo() == null ? String.valueOf(mysql) + " and CheckNo is null" : String.valueOf(mysql) + " and CheckNo='" + this.getCheckNo() + "'";
                    mysql = this.getAccountNo() == null ? String.valueOf(mysql) + " and\tAccountNo is null " : String.valueOf(mysql) + " and\tAccountNo='" + this.getAccountNo() + "'";
                    if (this.getA_Name() != null && this.getA_Name().length() > 0) {
                        mysql = String.valueOf(mysql) + " and A_name='" + this.getA_Name() + "'";
                    }
                    if ((existe = DB.getSQLValue(null, (String)(mysql = String.valueOf(mysql) + " and C_Payment_ID<>" + this.getC_Payment_ID()))) > 0) {
                        this.log.saveError("Error", "Ya existe un cheque para este cliente con el mismo NoCheque y NoCuenta");
                        this.m_processMsg = "Ya existe un cheque para este Cliente con el mismo NoCheque y NoCuenta";
                        return false;
                    }
                } else {
                    mysql = "select count(1) from c_payment where docstatus IN ('CO','DR') and isreceipt='N' and c_bpartner_id=" + this.getC_BPartner_ID() + " and C_BankAccount_ID=" + this.getC_BankAccount_ID() + " and C_Payment_ID<>" + this.getC_Payment_ID();
                    mysql = this.getCheckNo() == null ? String.valueOf(mysql) + " and CheckNo is null" : String.valueOf(mysql) + " and CheckNo='" + this.getCheckNo() + "'";
                    existe = DB.getSQLValue(null, (String)mysql);
                    if (existe > 0) {
                        this.log.saveError("Error", "Ya existe un cheque para este cliente con el mismo NoCheque y NoCuenta");
                        this.m_processMsg = "Ya existe un cheque para este Proveedor con el mismo NoCheque y NoCuenta";
                        return false;
                    }
                }
            } else if (this.getTenderType().equals("C")) {
                this.log.config("CreditCard no Validation");
            } else {
                mysql = "select count(1) from c_payment where docstatus IN ('CO','DR')  and DocumentNo='" + this.getDocumentNo() + "' and AD_Org_ID=" + this.getAD_Org_ID() + " and C_Payment_ID<>" + this.getC_Payment_ID();
                mysql = this.isReceipt() ? String.valueOf(mysql) + " and isreceipt='Y'" : String.valueOf(mysql) + " and isreceipt='N'";
                if (this.getA_Name() != null && this.getA_Name().length() > 0) {
                    mysql = String.valueOf(mysql) + " and A_name='" + this.getA_Name() + "'";
                }
                if ((existe = DB.getSQLValue(null, (String)mysql)) > 0) {
                    this.log.saveError("Error", "Ya existe un pago con este mismo numero de documento");
                    this.m_processMsg = "Ya esta Registrado este numero de documento, favor revisar";
                    return false;
                }
            }
        }
        if (this.getPayAmt().signum() < 0) {
            this.log.saveError("Error", "El valor no puede ser Negativo");
            return false;
        }
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateTrx());
        }
        if (!this.isOverUnderPayment()) {
            this.setOverUnderAmt(Env.ZERO);
        }
        if ((newRecord || this.is_ValueChanged("C_BankAccount_ID")) && this.getC_Charge_ID() == 0) {
            MBankAccount existe = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
        }
        if (this.getC_BPartner_ID() != 0 && (this.getC_Invoice_ID() != 0 || this.getC_Order_ID() != 0)) {
            MOrder ord;
            MInvoice inv;
            if (this.getC_Invoice_ID() != 0 && (inv = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName())).getC_BPartner_ID() != this.getC_BPartner_ID()) {
                this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"BP different from BP Invoice"));
                return false;
            }
            if (this.getC_Order_ID() != 0 && (ord = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getC_BPartner_ID() != this.getC_BPartner_ID()) {
                this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"BP different from BP Order"));
                return false;
            }
        }
        if (this.getPayAmt().signum() != 0) {
            int decimals = this.getC_Currency().getStdPrecision();
            this.setPayAmt(this.getPayAmt().setScale(decimals, 6));
        }
        return true;
    }

    public BigDecimal getAllocatedAmt() {
        BigDecimal retValue;
        block7: {
            retValue = null;
            if (this.getC_Charge_ID() != 0) {
                return this.getPayAmt();
            }
            String sql = "SELECT SUM(currencyConvert(al.Amount,ah.C_Currency_ID, p.C_Currency_ID,ah.DateTrx,p.C_ConversionType_ID, al.AD_Client_ID,al.AD_Org_ID)) FROM C_AllocationLine al INNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID)  INNER JOIN C_Payment p ON (al.C_Payment_ID=p.C_Payment_ID) WHERE al.C_Payment_ID=? AND ah.IsActive='Y' AND al.IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getC_Payment_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "getAllocatedAmt", (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public boolean testAllocation() {
        boolean test;
        boolean change;
        BigDecimal alloc = this.getAllocatedAmt();
        if (alloc == null) {
            alloc = Env.ZERO;
        }
        BigDecimal total = this.getPayAmt();
        if (!this.isReceipt()) {
            total = total.negate();
        }
        if (change = (test = total.compareTo(alloc) == 0) ^ this.isAllocated()) {
            this.setIsAllocated(test);
        }
        this.log.fine("Allocated=" + test + " (" + alloc + "=" + total + ")");
        return change;
    }

    public static void setIsAllocated(Properties ctx, int C_BPartner_ID, String trxName) {
        int counter;
        block7: {
            counter = 0;
            String sql = "SELECT * FROM C_Payment WHERE IsAllocated='N' AND DocStatus IN ('CO','CL')";
            sql = C_BPartner_ID > 1 ? String.valueOf(sql) + " AND C_BPartner_ID=?" : String.valueOf(sql) + " AND AD_Client_ID=" + Env.getAD_Client_ID((Properties)ctx);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)trxName);
                    if (C_BPartner_ID > 1) {
                        pstmt.setInt(1, C_BPartner_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPayment pay = new MPayment(ctx, rs, trxName);
                        if (!pay.testAllocation() || !pay.save()) continue;
                        ++counter;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        s_log.config("#" + counter);
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public void setC_BankAccount_ID(int C_BankAccount_ID) {
        if (C_BankAccount_ID == 0) {
            this.setPaymentProcessor();
            if (this.getC_BankAccount_ID() == 0) {
                throw new IllegalArgumentException("Can't find Bank Account");
            }
        } else {
            super.setC_BankAccount_ID(C_BankAccount_ID);
        }
    }

    public boolean setPaymentProcessor() {
        return this.setPaymentProcessor(this.getTenderType(), this.getCreditCardType());
    }

    public boolean setPaymentProcessor(String tender, String CCType) {
        this.m_mPaymentProcessor = null;
        if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
            this.m_mPaymentProcessors = MPaymentProcessor.find((Properties)this.getCtx(), (String)tender, (String)CCType, (int)this.getAD_Client_ID(), (int)this.getC_Currency_ID(), (BigDecimal)this.getPayAmt(), (String)this.get_TrxName());
        }
        if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
            this.m_mPaymentProcessors = MPaymentProcessor.find((Properties)this.getCtx(), (String)tender, (String)CCType, (int)this.getAD_Client_ID(), (int)this.getC_Currency_ID(), (BigDecimal)Env.ZERO, (String)this.get_TrxName());
        }
        if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
            return false;
        }
        int i = 0;
        while (i < this.m_mPaymentProcessors.length) {
            if (this.m_mPaymentProcessors[i].accepts(tender, CCType)) {
                this.m_mPaymentProcessor = this.m_mPaymentProcessors[i];
            }
            ++i;
        }
        if (this.m_mPaymentProcessor != null) {
            this.setC_BankAccount_ID(this.m_mPaymentProcessor.getC_BankAccount_ID());
        }
        return this.m_mPaymentProcessor != null;
    }

    public ValueNamePair[] getCreditCards() {
        return this.getCreditCards(this.getPayAmt());
    }

    public ValueNamePair[] getCreditCards(BigDecimal amt) {
        try {
            if (this.m_mPaymentProcessors == null || this.m_mPaymentProcessors.length == 0) {
                this.m_mPaymentProcessors = MPaymentProcessor.find((Properties)this.getCtx(), null, null, (int)this.getAD_Client_ID(), (int)this.getC_Currency_ID(), (BigDecimal)amt, (String)this.get_TrxName());
            }
            HashMap<String, ValueNamePair> map = new HashMap<String, ValueNamePair>();
            int i = 0;
            while (i < this.m_mPaymentProcessors.length) {
                if (this.m_mPaymentProcessors[i].isAcceptAMEX()) {
                    map.put("A", this.getCreditCardPair("A"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptDiners()) {
                    map.put("D", this.getCreditCardPair("D"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptDiscover()) {
                    map.put("N", this.getCreditCardPair("N"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptMC()) {
                    map.put("M", this.getCreditCardPair("M"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptCorporate()) {
                    map.put("P", this.getCreditCardPair("P"));
                }
                if (this.m_mPaymentProcessors[i].isAcceptVisa()) {
                    map.put("V", this.getCreditCardPair("V"));
                }
                ++i;
            }
            ValueNamePair[] retValue = new ValueNamePair[map.size()];
            map.values().toArray(retValue);
            this.log.fine("getCreditCards - #" + retValue.length + " - Processors=" + this.m_mPaymentProcessors.length);
            return retValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private ValueNamePair getCreditCardPair(String CreditCardType) {
        return new ValueNamePair(CreditCardType, this.getCreditCardName(CreditCardType));
    }

    public void setCreditCardNumber(String CreditCardNumber) {
        super.setCreditCardNumber(MPaymentValidate.checkNumeric((String)CreditCardNumber));
    }

    public void setCreditCardVV(String newCreditCardVV) {
        super.setCreditCardVV(MPaymentValidate.checkNumeric((String)newCreditCardVV));
    }

    public void setCreditCardExpMM(int CreditCardExpMM) {
        if (CreditCardExpMM >= 1 && CreditCardExpMM <= 12) {
            super.setCreditCardExpMM(CreditCardExpMM);
        }
    }

    public void setCreditCardExpYY(int newCreditCardExpYY) {
        int CreditCardExpYY = newCreditCardExpYY;
        if (newCreditCardExpYY > 1999) {
            CreditCardExpYY = newCreditCardExpYY - 2000;
        }
        super.setCreditCardExpYY(CreditCardExpYY);
    }

    public boolean setCreditCardExp(String mmyy) {
        if (MPaymentValidate.validateCreditCardExp((String)mmyy).length() != 0) {
            return false;
        }
        String exp = MPaymentValidate.checkNumeric((String)mmyy);
        String mmStr = exp.substring(0, 2);
        String yyStr = exp.substring(2, 4);
        this.setCreditCardExpMM(Integer.parseInt(mmStr));
        this.setCreditCardExpYY(Integer.parseInt(yyStr));
        return true;
    }

    public String getCreditCardExp(String delimiter) {
        String mm = String.valueOf(this.getCreditCardExpMM());
        String yy = String.valueOf(this.getCreditCardExpYY());
        StringBuffer retValue = new StringBuffer();
        if (mm.length() == 1) {
            retValue.append("0");
        }
        retValue.append(mm);
        if (delimiter != null) {
            retValue.append(delimiter);
        }
        if (yy.length() == 1) {
            retValue.append("0");
        }
        retValue.append(yy);
        return retValue.toString();
    }

    public void setMicr(String MICR) {
        super.setMicr(MPaymentValidate.checkNumeric((String)MICR));
    }

    public void setRoutingNo(String RoutingNo) {
        super.setRoutingNo(MPaymentValidate.checkNumeric((String)RoutingNo));
    }

    public void setAccountNo(String AccountNo) {
        super.setAccountNo(MPaymentValidate.checkNumeric((String)AccountNo));
    }

    public void setCheckNo(String CheckNo) {
        super.setCheckNo(MPaymentValidate.checkNumeric((String)CheckNo));
    }

    private void setDocumentNo() {
        if ("X".equals(this.getTenderType())) {
            return;
        }
        String documentNo = this.getDocumentNo();
        if (documentNo != null && documentNo.indexOf(REVERSE_INDICATOR) >= 0) {
            return;
        }
        if (this.getR_PnRef() != null && this.getR_PnRef().length() > 0) {
            if (!this.getR_PnRef().equals(documentNo)) {
                this.setDocumentNo(this.getR_PnRef());
            }
            return;
        }
        documentNo = "";
        if ("C".equals(this.getTenderType())) {
            if (MSysConfig.getBooleanValue((String)"PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CREDIT_CARD", (boolean)true, (int)this.getAD_Client_ID())) {
                documentNo = String.valueOf(this.getCreditCardType()) + " " + Obscure.obscure((String)this.getCreditCardNumber()) + " " + this.getCreditCardExpMM() + "/" + this.getCreditCardExpYY();
            }
        } else if ("K".equals(this.getTenderType()) && !this.isReceipt() && this.getCheckNo() != null && this.getCheckNo().length() > 0) {
            if (MSysConfig.getBooleanValue((String)"PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CHECK_ON_PAYMENT", (boolean)true, (int)this.getAD_Client_ID())) {
                documentNo = this.getCheckNo();
            }
        } else if ("K".equals(this.getTenderType()) && this.isReceipt() && MSysConfig.getBooleanValue((String)"PAYMENT_OVERWRITE_DOCUMENTNO_WITH_CHECK_ON_RECEIPT", (boolean)true, (int)this.getAD_Client_ID())) {
            if (this.getRoutingNo() != null) {
                documentNo = String.valueOf(this.getRoutingNo()) + ": ";
            }
            if (this.getAccountNo() != null) {
                documentNo = String.valueOf(documentNo) + this.getAccountNo();
            }
            if (this.getCheckNo() != null) {
                if (documentNo.length() > 0) {
                    documentNo = String.valueOf(documentNo) + " ";
                }
                documentNo = String.valueOf(documentNo) + "#" + this.getCheckNo();
            }
        }
        if ((documentNo = documentNo.trim()).length() > 0) {
            this.setDocumentNo(documentNo);
        }
    }

    public void setR_PnRef(String R_PnRef) {
        super.setR_PnRef(R_PnRef);
        if (R_PnRef != null) {
            this.setDocumentNo(R_PnRef);
        }
    }

    public void setPayAmt(BigDecimal PayAmt) {
        super.setPayAmt(PayAmt == null ? Env.ZERO : PayAmt);
    }

    public void setAmount(int C_Currency_ID, BigDecimal payAmt) {
        if (C_Currency_ID == 0) {
            C_Currency_ID = MClient.get((Properties)this.getCtx()).getC_Currency_ID();
        }
        this.setC_Currency_ID(C_Currency_ID);
        this.setPayAmt(payAmt);
    }

    public void setDiscountAmt(BigDecimal DiscountAmt) {
        super.setDiscountAmt(DiscountAmt == null ? Env.ZERO : DiscountAmt);
    }

    public void setWriteOffAmt(BigDecimal WriteOffAmt) {
        super.setWriteOffAmt(WriteOffAmt == null ? Env.ZERO : WriteOffAmt);
    }

    public void setOverUnderAmt(BigDecimal OverUnderAmt) {
        super.setOverUnderAmt(OverUnderAmt == null ? Env.ZERO : OverUnderAmt);
        this.setIsOverUnderPayment(this.getOverUnderAmt().compareTo(Env.ZERO) != 0);
    }

    public void setTaxAmt(BigDecimal TaxAmt) {
        super.setTaxAmt(TaxAmt == null ? Env.ZERO : TaxAmt);
    }

    public void setBP_BankAccount(MBPBankAccount ba) {
        this.log.fine("" + ba);
        if (ba == null) {
            return;
        }
        this.setC_BPartner_ID(ba.getC_BPartner_ID());
        this.setAccountAddress(ba.getA_Name(), ba.getA_Street(), ba.getA_City(), ba.getA_State(), ba.getA_Zip(), ba.getA_Country());
        this.setA_EMail(ba.getA_EMail());
        this.setA_Ident_DL(ba.getA_Ident_DL());
        this.setA_Ident_SSN(ba.getA_Ident_SSN());
        if (ba.getCreditCardType() != null) {
            this.setCreditCardType(ba.getCreditCardType());
        }
        if (ba.getCreditCardNumber() != null) {
            this.setCreditCardNumber(ba.getCreditCardNumber());
        }
        if (ba.getCreditCardExpMM() != 0) {
            this.setCreditCardExpMM(ba.getCreditCardExpMM());
        }
        if (ba.getCreditCardExpYY() != 0) {
            this.setCreditCardExpYY(ba.getCreditCardExpYY());
        }
        if (ba.getCreditCardVV() != null) {
            this.setCreditCardVV(ba.getCreditCardVV());
        }
        if (ba.getAccountNo() != null) {
            this.setAccountNo(ba.getAccountNo());
        }
        if (ba.getRoutingNo() != null) {
            this.setRoutingNo(ba.getRoutingNo());
        }
    }

    public boolean saveToBP_BankAccount(MBPBankAccount ba) {
        if (ba == null) {
            return false;
        }
        ba.setA_Name(this.getA_Name());
        ba.setA_Street(this.getA_Street());
        ba.setA_City(this.getA_City());
        ba.setA_State(this.getA_State());
        ba.setA_Zip(this.getA_Zip());
        ba.setA_Country(this.getA_Country());
        ba.setA_EMail(this.getA_EMail());
        ba.setA_Ident_DL(this.getA_Ident_DL());
        ba.setA_Ident_SSN(this.getA_Ident_SSN());
        ba.setCreditCardType(this.getCreditCardType());
        ba.setCreditCardNumber(this.getCreditCardNumber());
        ba.setCreditCardExpMM(this.getCreditCardExpMM());
        ba.setCreditCardExpYY(this.getCreditCardExpYY());
        ba.setCreditCardVV(this.getCreditCardVV());
        if (this.getAccountNo() != null) {
            ba.setAccountNo(this.getAccountNo());
        }
        if (this.getRoutingNo() != null) {
            ba.setRoutingNo(this.getRoutingNo());
        }
        ba.setR_AvsAddr(this.getR_AvsAddr());
        ba.setR_AvsZip(this.getR_AvsZip());
        boolean ok = ba.save(this.get_TrxName());
        this.log.fine("saveToBP_BankAccount - " + ba);
        return ok;
    }

    private void setC_DocType_ID() {
        this.setC_DocType_ID(this.isReceipt());
    }

    public void setC_DocType_ID(boolean isReceipt) {
        block9: {
            this.setIsReceipt(isReceipt);
            String sql = "SELECT C_DocType_ID FROM C_DocType WHERE IsActive='Y' AND AD_Client_ID=? AND DocBaseType=? ORDER BY IsDefault DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Client_ID());
                    if (isReceipt) {
                        pstmt.setString(2, "ARR");
                    } else {
                        pstmt.setString(2, "APP");
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.setC_DocType_ID(rs.getInt(1));
                    } else {
                        this.log.warning("setDocType - NOT found - isReceipt=" + isReceipt);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public void setC_DocType_ID(int C_DocType_ID) {
        super.setC_DocType_ID(C_DocType_ID);
    }

    /*
     * Unable to fully structure code
     */
    private boolean verifyDocType(MPaymentAllocate[] pAllocs) {
        block36: {
            block30: {
                if (this.getC_DocType_ID() == 0) {
                    return false;
                }
                documentSO = null;
                if (this.getC_Invoice_ID() > 0) {
                    sql = "SELECT idt.IsSOTrx FROM C_Invoice i INNER JOIN C_DocType idt ON (i.C_DocType_ID=idt.C_DocType_ID) WHERE i.C_Invoice_ID=?";
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                            pstmt.setInt(1, this.getC_Invoice_ID());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                documentSO = new Boolean("Y".equals(rs.getString(1)));
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql, (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block30;
                        }
                    }
                    catch (Throwable var7_15) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw var7_15;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                } else if (this.getC_Order_ID() > 0) {
                    sql = "SELECT odt.IsSOTrx FROM C_Order o INNER JOIN C_DocType odt ON (o.C_DocType_ID=odt.C_DocType_ID) WHERE o.C_Order_ID=?";
                    pstmt = null;
                    rs = null;
                    try {
                        try {
                            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                            pstmt.setInt(1, this.getC_Order_ID());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                documentSO = new Boolean("Y".equals(rs.getString(1)));
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql, (Throwable)e);
                            DB.close(rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                            break block30;
                        }
                    }
                    catch (Throwable var7_16) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw var7_16;
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                } else if (this.getC_Charge_ID() <= 0 && pAllocs.length > 0) {
                    e = pAllocs;
                    rs = pAllocs.length;
                    pstmt = 0;
                    while (pstmt < rs) {
                        block34: {
                            block32: {
                                block33: {
                                    pAlloc = e[pstmt];
                                    sql = "SELECT idt.IsSOTrx FROM C_Invoice i INNER JOIN C_DocType idt ON (i.C_DocType_ID=idt.C_DocType_ID) WHERE i.C_Invoice_ID=?";
                                    pstmt = null;
                                    rs = null;
                                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                                    pstmt.setInt(1, pAlloc.getC_Invoice_ID());
                                    rs = pstmt.executeQuery();
                                    if (!rs.next()) break block32;
                                    if (documentSO == null) break block33;
                                    ** if (documentSO.booleanValue() == "Y".equals((Object)rs.getString((int)1))) goto lbl-1000
lbl-1000:
                                    // 1 sources

                                    {
                                        DB.close((ResultSet)rs, (Statement)pstmt);
                                        rs = null;
                                        pstmt = null;
                                        return false;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                    }
                                }
                                try {
                                    try {
                                        documentSO = new Boolean("Y".equals(rs.getString(1)));
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, sql, (Throwable)e);
                                        DB.close(rs, (Statement)pstmt);
                                        rs = null;
                                        pstmt = null;
                                        break block34;
                                    }
                                }
                                catch (Throwable var11_23) {
                                    DB.close(rs, (Statement)pstmt);
                                    rs = null;
                                    pstmt = null;
                                    throw var11_23;
                                }
                            }
                            DB.close((ResultSet)rs, (Statement)pstmt);
                            rs = null;
                            pstmt = null;
                        }
                        ++pstmt;
                    }
                }
            }
            paymentSO = null;
            pstmt = null;
            rs = null;
            sql = "SELECT IsSOTrx FROM C_DocType WHERE C_DocType_ID=?";
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, this.getC_DocType_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        paymentSO = new Boolean("Y".equals(rs.getString(1)));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block36;
                }
            }
            catch (Throwable var8_20) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw var8_20;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (paymentSO == null) {
            return false;
        }
        this.setIsReceipt(paymentSO);
        return documentSO == null || documentSO.booleanValue() == paymentSO.booleanValue();
    }

    private boolean verifyPaymentAllocateVsHeader(MPaymentAllocate[] pAllocs) {
        return pAllocs.length <= 0 || this.getC_Charge_ID() <= 0 && this.getC_Invoice_ID() <= 0 && this.getC_Order_ID() <= 0;
    }

    private boolean verifyPaymentAllocateSum(MPaymentAllocate[] pAllocs) {
        BigDecimal sumPaymentAllocates = Env.ZERO;
        if (pAllocs.length > 0) {
            MPaymentAllocate[] mPaymentAllocateArray = pAllocs;
            int n = pAllocs.length;
            int n2 = 0;
            while (n2 < n) {
                MPaymentAllocate pAlloc = mPaymentAllocateArray[n2];
                sumPaymentAllocates = sumPaymentAllocates.add(pAlloc.getAmount());
                ++n2;
            }
            if (this.getPayAmt().compareTo(sumPaymentAllocates) != 0) {
                return false;
            }
        }
        return true;
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName((Properties)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public String getCreditCardName() {
        return this.getCreditCardName(this.getCreditCardType());
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public BigDecimal getPayAmt(boolean absolute) {
        if (this.isReceipt()) {
            return super.getPayAmt();
        }
        return super.getPayAmt().negate();
    }

    public int getPayAmtInCents() {
        BigDecimal bd = super.getPayAmt().multiply(Env.ONEHUNDRED);
        return bd.intValue();
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        MPaymentAllocate[] pAllocs;
        MOrder order;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPaySelectionCheck.deleteGeneratedDraft((Properties)this.getCtx(), (int)this.getC_Payment_ID(), (String)this.get_TrxName())) {
            this.m_processMsg = "Could not delete draft generated payment selection lines";
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), this.isReceipt() ? "ARR" : "APP", this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.getPayAmt().signum() == 0) {
            this.m_processMsg = "PayAmt=0";
            return "IN";
        }
        if (this.isOnline() && !this.isApproved()) {
            this.m_processMsg = this.getR_Result() != null ? "@OnlinePaymentFailed@" : "@PaymentNotProcessed@";
            return "IN";
        }
        if (this.getC_Order_ID() != 0 && this.getC_Invoice_ID() == 0 && "WP".equals((order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getDocStatus())) {
            order.setC_Payment_ID(this.getC_Payment_ID());
            order.setDocAction("WC");
            order.set_TrxName(this.get_TrxName());
            order.processIt("WC");
            this.m_processMsg = order.getProcessMsg();
            order.saveEx(this.get_TrxName());
            MInvoice[] invoices = order.getInvoices();
            int length = invoices.length;
            if (length > 0) {
                this.setC_Invoice_ID(invoices[length - 1].getC_Invoice_ID());
            }
            if (this.getC_Invoice_ID() == 0) {
                this.m_processMsg = "@NotFound@ @C_Invoice_ID@";
                return "IN";
            }
        }
        if (!this.verifyDocType(pAllocs = MPaymentAllocate.get((MPayment)this))) {
            this.m_processMsg = "@PaymentDocTypeInvoiceInconsistent@";
            return "IN";
        }
        if (!this.verifyPaymentAllocateVsHeader(pAllocs)) {
            this.m_processMsg = "@PaymentAllocateIgnored@";
            return "IN";
        }
        if (!this.verifyPaymentAllocateSum(pAllocs)) {
            this.m_processMsg = "@PaymentAllocateSumInconsistent@";
            return "IN";
        }
        if (!this.isReceipt()) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        MPayment counter;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        if (this.getTenderType().equals("I")) {
            this.setPayAmt((BigDecimal)this.get_Value("Amount"));
        }
        if (this.getC_Charge_ID() != 0) {
            this.setIsAllocated(true);
        } else if (this.isCompromisoIndirecto()) {
            this.setIsAllocated(false);
        } else {
            this.allocateIt();
            this.testAllocation();
        }
        this.getC_Project_ID();
        if (this.getC_BPartner_ID() != 0 && this.getC_Invoice_ID() == 0 && this.getC_Charge_ID() == 0) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            BigDecimal payAmt = MConversionRate.convertBase(this.getCtx(), this.getPayAmt(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
            if (payAmt == null) {
                this.m_processMsg = "Could not convert C_Currency_ID=" + this.getC_Currency_ID() + " to base C_Currency_ID=" + MClient.get((Properties)Env.getCtx()).getC_Currency_ID();
                return "IN";
            }
            BigDecimal newBalance = bp.getTotalOpenBalance(false);
            if (newBalance == null) {
                newBalance = Env.ZERO;
            }
            newBalance = this.isReceipt() ? newBalance.subtract(payAmt) : newBalance.add(payAmt);
            bp.setTotalOpenBalance(newBalance);
            bp.setSOCreditStatus();
            bp.saveEx();
        }
        if ((counter = this.createCounterDoc()) != null) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + " @CounterDoc@: @C_Payment_ID@=" + counter.getDocumentNo();
        }
        if (this.isCashTrx() && !MSysConfig.getBooleanValue((String)"CASH_AS_PAYMENT", (boolean)true, (int)this.getAD_Client_ID())) {
            if (this.getC_CashBook_ID() <= 0) {
                this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@Mandatory@: @C_CashBook_ID@"));
                this.m_processMsg = "@NoCashBook@";
                return "IN";
            }
            MCash cash = MCash.get(this.getCtx(), this.getAD_Org_ID(), this.getDateAcct(), this.getC_Currency_ID(), this.get_TrxName());
            if (cash == null || cash.get_ID() == 0) {
                this.m_processMsg = "@NoCashBook@";
                return "IN";
            }
            MCashLine cl = new MCashLine(cash);
            cl.setCashType("R");
            cl.setDescription("Generated From Payment #" + this.getDocumentNo());
            cl.setC_Currency_ID(this.getC_Currency_ID());
            cl.setC_Payment_ID(this.getC_Payment_ID());
            StringBuffer info = new StringBuffer();
            info.append("Cash journal ( ").append(cash.getDocumentNo()).append(" )");
            this.m_processMsg = info.toString();
            BigDecimal amt = this.getPayAmt();
            cl.setAmount(amt);
            cl.setDiscountAmt(Env.ZERO);
            cl.setWriteOffAmt(Env.ZERO);
            cl.setIsGenerated(true);
            if (!cl.save(this.get_TrxName())) {
                this.m_processMsg = "Could not save Cash Journal Line";
                return "IN";
            }
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)((Object)this))) != null) {
            this.setDocumentNo(value);
        }
    }

    private MPayment createCounterDoc() {
        if (this.getRef_Payment_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MPayment counter = new MPayment(this.getCtx(), 0, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setC_BPartner_ID(counterBP.getC_BPartner_ID());
        counter.setIsReceipt(!this.isReceipt());
        counter.setC_DocType_ID(C_DocTypeTarget_ID);
        counter.setTrxType(this.getTrxType());
        counter.setTenderType(this.getTenderType());
        counter.setPayAmt(this.getPayAmt());
        counter.setDiscountAmt(this.getDiscountAmt());
        counter.setTaxAmt(this.getTaxAmt());
        counter.setWriteOffAmt(this.getWriteOffAmt());
        counter.setIsOverUnderPayment(this.isOverUnderPayment());
        counter.setOverUnderAmt(this.getOverUnderAmt());
        counter.setC_Currency_ID(this.getC_Currency_ID());
        counter.setC_ConversionType_ID(this.getC_ConversionType_ID());
        counter.setDateTrx(this.getDateTrx());
        counter.setDateAcct(this.getDateAcct());
        counter.setRef_Payment_ID(this.getC_Payment_ID());
        String sql = "SELECT C_BankAccount_ID FROM C_BankAccount WHERE C_Currency_ID=? AND AD_Org_ID IN (0,?) AND IsActive='Y' ORDER BY IsDefault DESC";
        int C_BankAccount_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Currency_ID(), (int)counterAD_Org_ID);
        counter.setC_BankAccount_ID(C_BankAccount_ID);
        counter.setC_Activity_ID(this.getC_Activity_ID());
        counter.setC_Campaign_ID(this.getC_Campaign_ID());
        counter.setC_Project_ID(this.getC_Project_ID());
        counter.setUser1_ID(this.getUser1_ID());
        counter.setUser2_ID(this.getUser2_ID());
        counter.saveEx(this.get_TrxName());
        this.log.fine(counter.toString());
        this.setRef_Payment_ID(counter.getC_Payment_ID());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    public boolean allocateIt() {
        if (this.getC_Invoice_ID() != 0) {
            return this.allocateInvoice();
        }
        if (this.allocatePaySelection()) {
            return true;
        }
        if (this.getC_Order_ID() != 0) {
            return false;
        }
        MPaymentAllocate[] pAllocs = MPaymentAllocate.get((MPayment)this);
        if (pAllocs.length == 0) {
            return false;
        }
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), String.valueOf(Msg.translate((Properties)this.getCtx(), (String)"C_Payment_ID")) + ": " + this.getDocumentNo(), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        if (!alloc.save()) {
            this.log.severe("P.Allocations not created");
            return false;
        }
        int i = 0;
        while (i < pAllocs.length) {
            MPaymentAllocate pa = pAllocs[i];
            MAllocationLine aLine = null;
            aLine = this.isReceipt() ? new MAllocationLine(alloc, pa.getAmount(), pa.getDiscountAmt(), pa.getWriteOffAmt(), pa.getOverUnderAmt()) : new MAllocationLine(alloc, pa.getAmount().negate(), pa.getDiscountAmt().negate(), pa.getWriteOffAmt().negate(), pa.getOverUnderAmt().negate());
            aLine.setDocInfo(pa.getC_BPartner_ID(), 0, pa.getC_Invoice_ID());
            aLine.setPaymentInfo(this.getC_Payment_ID(), 0);
            if (!aLine.save(this.get_TrxName())) {
                this.log.warning("P.Allocations - line not saved");
            } else {
                pa.setC_AllocationLine_ID(aLine.getC_AllocationLine_ID());
                pa.saveEx();
            }
            ++i;
        }
        alloc.processIt("CO");
        this.m_processMsg = "@C_AllocationHdr_ID@: " + alloc.getDocumentNo();
        return alloc.save(this.get_TrxName());
    }

    private boolean allocateInvoice() {
        BigDecimal allocationAmt = this.getPayAmt();
        if (this.getOverUnderAmt().signum() < 0 && this.getPayAmt().signum() > 0) {
            allocationAmt = allocationAmt.add(this.getOverUnderAmt());
        }
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateTrx(), this.getC_Currency_ID(), String.valueOf(Msg.translate((Properties)this.getCtx(), (String)"C_Payment_ID")) + ": " + this.getDocumentNo() + " [1]", this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        alloc.setDateAcct(this.getDateAcct());
        alloc.saveEx();
        MAllocationLine aLine = null;
        aLine = this.isReceipt() ? new MAllocationLine(alloc, allocationAmt, this.getDiscountAmt(), this.getWriteOffAmt(), this.getOverUnderAmt()) : new MAllocationLine(alloc, allocationAmt.negate(), this.getDiscountAmt().negate(), this.getWriteOffAmt().negate(), this.getOverUnderAmt().negate());
        aLine.setDocInfo(this.getC_BPartner_ID(), 0, this.getC_Invoice_ID());
        aLine.setC_Payment_ID(this.getC_Payment_ID());
        aLine.saveEx(this.get_TrxName());
        alloc.processIt("CO");
        alloc.saveEx(this.get_TrxName());
        this.m_processMsg = "@C_AllocationHdr_ID@: " + alloc.getDocumentNo();
        int C_Project_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Project_ID) FROM C_Invoice WHERE C_Invoice_ID=?", (int)this.getC_Invoice_ID());
        if (C_Project_ID > 0 && this.getC_Project_ID() == 0) {
            this.setC_Project_ID(C_Project_ID);
        } else if (C_Project_ID > 0 && this.getC_Project_ID() > 0 && C_Project_ID != this.getC_Project_ID()) {
            this.log.warning("Invoice C_Project_ID=" + C_Project_ID + " <> Payment C_Project_ID=" + this.getC_Project_ID());
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean allocatePaySelection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deAllocate() {
        if (this.getC_Order_ID() != 0) {
            this.setC_Order_ID(0);
        }
        MAllocationHdr[] allocations = MAllocationHdr.getOfPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        this.log.fine("#" + allocations.length);
        int i = 0;
        while (i < allocations.length) {
            allocations[i].set_TrxName(this.get_TrxName());
            allocations[i].setDocAction("VO");
            if (!allocations[i].processIt("VO")) {
                throw new AdempiereException(allocations[i].getProcessMsg());
            }
            allocations[i].saveEx();
            ++i;
        }
        if (this.getC_Invoice_ID() != 0) {
            String sql = "UPDATE C_Invoice SET C_Payment_ID = NULL, IsPaid='N' WHERE C_Invoice_ID=" + this.getC_Invoice_ID() + " AND C_Payment_ID=" + this.getC_Payment_ID();
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            if (no != 0) {
                this.log.fine("Unlink Invoice #" + no);
            }
            if ((no = DB.executeUpdate((String)(sql = "UPDATE C_Order o SET C_Payment_ID = NULL WHERE EXISTS (SELECT * FROM C_Invoice i WHERE o.C_Order_ID=i.C_Order_ID AND i.C_Invoice_ID=" + this.getC_Invoice_ID() + ")" + " AND C_Payment_ID=" + this.getC_Payment_ID()), (String)this.get_TrxName())) != 0) {
                this.log.fine("Unlink Order #" + no);
            }
        }
        this.setC_Invoice_ID(0);
        this.setIsAllocated(false);
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (this.getC_BankStatementLine2_ID() > 0) {
            this.m_processMsg = "El pago se encuentra en un deposito, no puede ser anulado, revise sus depositos";
            return false;
        }
        if (!("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()))) {
            if (!this.voidCashBook()) {
                return false;
            }
            if (this.reverseCorrectIt()) {
                int i = this.resetPost(this.getC_Payment_ID(), X_C_Payment.Table_ID);
                this.log.config("reset post:" + i);
                return true;
            }
            return false;
        }
        this.addDescription(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Voided")) + " (" + this.getPayAmt() + ")");
        this.setPayAmt(Env.ZERO);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setOverUnderAmt(Env.ZERO);
        this.setIsAllocated(false);
        this.deAllocate();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
        Timestamp dateAcct = this.getDateAcct();
        if (!MPeriod.isOpen(this.getCtx(), dateAcct, this.isReceipt() ? "ARR" : "APP", this.getAD_Org_ID())) {
            dateAcct = new Timestamp(System.currentTimeMillis());
        }
        boolean reconciled = this.getC_BankStatementLine_ID() == 0;
        this.deAllocate();
        this.setIsReconciled(reconciled);
        this.setIsAllocated(true);
        this.addDescription("Amount: " + this.getPayAmt());
        this.setDocStatus("VO");
        this.setDocAction("--");
        this.setPayAmt(Env.ZERO);
        this.setProcessed(true);
        if (this.getC_BPartner_ID() != 0) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            bp.setTotalOpenBalance();
            bp.save(this.get_TrxName());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 13);
        return this.m_processMsg == null;
    }

    private int getC_BankStatementLine_ID() {
        String sql = "SELECT C_BankStatementLine_ID FROM C_BankStatementLine WHERE C_Payment_ID=?";
        int id = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Payment_ID());
        if (id < 0) {
            return 0;
        }
        return id;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverseCorrectIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 12);
        return this.m_processMsg == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPayment[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",Receipt=").append(this.isReceipt()).append(",PayAmt=").append(this.getPayAmt()).append(",Discount=").append(this.getDiscountAmt()).append(",WriteOff=").append(this.getWriteOffAmt()).append(",OverUnder=").append(this.getOverUnderAmt());
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"PayAmt")).append("=").append(this.getPayAmt()).append(",").append(Msg.translate((Properties)this.getCtx(), (String)"WriteOffAmt")).append("=").append(this.getWriteOffAmt());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        if (this.isReceipt()) {
            return this.getWriteOffAmt();
        }
        return this.getPayAmt();
    }

    public int getC_BankStatementLine2_ID() {
        String sql = "select C_BankStatementLine_ID from c_bankstatementline A  inner join c_bankstatement B on (A.c_bankstatement_ID=B.c_bankstatement_ID)  where A.c_payment_id=?  and B.docstatus IN ('CO','DR','CL','IN')";
        int id = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Payment_ID());
        if (id < 0) {
            return 0;
        }
        return id;
    }

    public boolean voidCashBook() {
        block8: {
            MCash mycash;
            block9: {
                int cash_id = DB.getSQLValue((String)this.get_TrxName(), (String)("select c_cash_id from c_cashline where c_payment_id=" + this.getC_Payment_ID()));
                if (cash_id <= 0) break block8;
                mycash = new MCash(this.getCtx(), cash_id, this.get_TrxName());
                if (!mycash.getDocStatus().equals("DR")) break block9;
                MCashLine[] lines = mycash.getLines(true);
                int i = 0;
                while (i < lines.length) {
                    if (lines[i].getC_Payment_ID() == this.getC_Payment_ID()) {
                        lines[i].setAmount(Env.ZERO);
                        lines[i].setDescription("**Anulada");
                        lines[i].save();
                    }
                    ++i;
                }
                break block8;
            }
            if (!mycash.getDocStatus().equals("CO")) break block8;
            MCash currentCash = MCash.getDefault(this.getCtx(), this.getAD_Client_ID(), mycash.getC_CashBook_ID(), this.get_TrxName());
            if (currentCash == null) {
                this.m_processMsg = "@No existe un libro de efectivo Activo Actualmente@";
                return false;
            }
            MCashLine[] lines = mycash.getLines(true);
            int i = 0;
            while (i < lines.length) {
                if (lines[i].getC_Payment_ID() == this.getC_Payment_ID()) {
                    MCashLine newline = new MCashLine(currentCash);
                    newline.setC_Payment_ID(lines[i].getC_Payment_ID());
                    newline.setDescription("Movimiento por Anulacion Pago:" + this.getDocumentNo());
                    if (!this.isReceipt()) {
                        newline.setCashType("E");
                    } else {
                        newline.setCashType("R");
                    }
                    newline.setAmount(lines[i].getAmount().negate());
                    if (!newline.save()) {
                        this.m_processMsg = "@No se puede descontar la Factura en la caja actual@";
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public int getT_Conciliaciones_ID() {
        int ReValue = 0;
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        int existe = DB.getSQLValue((String)this.get_TrxName(), (String)"select count(1) from AD_Table where upper(tablename)=upper('T_CONCILIACIONES')");
        if (existe <= 0) {
            return 0;
        }
        try {
            String sql = "select T_CONCILIACIONES_ID from T_CONCILIACIONES where C_Payment_ID=?";
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Payment_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ReValue = rs.getInt(1);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            rs = null;
            pstmt = null;
            return 0;
        }
        return ReValue;
    }

    public boolean isCompromisoIndirecto() {
        if (this.getC_Invoice_ID() > 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            MDocType doc = MDocType.get((Properties)this.getCtx(), (int)invoice.getC_DocType_ID());
            if (doc.getDocBaseType().equals("APA") && doc.getC_DocType_ID() == 1000063) {
                return true;
            }
        }
        return false;
    }

    public void voidConciliacion() {
        int existe = DB.getSQLValue((String)this.get_TrxName(), (String)"select count(1) from AD_Table where upper(tablename)=upper('T_CONCILIACIONES')");
        if (existe <= 0) {
            return;
        }
        int Conciliacion_ID = this.getT_Conciliaciones_ID();
        DB.executeUpdate((String)("Update T_CONCILIACIONES set Docstatus='VO', DocAction='--' where T_CONCILIACIONES_ID=" + Conciliacion_ID), (String)this.get_TrxName());
        DB.executeUpdate((String)("Update T_SOLICITUDES set ISRECONCILED='N'  where T_CONCILIACIONES_ID=" + Conciliacion_ID), (String)this.get_TrxName());
    }
}

