/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.OFBProductCost;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Inventory;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInventory
extends X_M_Inventory
implements DocAction {
    private static final long serialVersionUID = -7137974064086172763L;
    private static CCache<Integer, MInventory> s_cache = new CCache("M_Inventory", 5, 5);
    private MInventoryLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private boolean m_reversal = false;

    public static MInventory get(Properties ctx, int M_Inventory_ID) {
        Integer key = new Integer(M_Inventory_ID);
        MInventory retValue = (MInventory)s_cache.get((Object)key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInventory(ctx, M_Inventory_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MInventory(Properties ctx, int M_Inventory_ID, String trxName) {
        super(ctx, M_Inventory_ID, trxName);
        if (M_Inventory_ID == 0) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MInventory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventory(MWarehouse wh) {
        this(wh, wh.get_TrxName());
    }

    public MInventory(MWarehouse wh, String trxName) {
        this(wh.getCtx(), 0, trxName);
        this.setClientOrg((PO)wh);
        this.setM_Warehouse_ID(wh.getM_Warehouse_ID());
    }

    public MInventoryLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MInventory.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        List list = new Query(this.getCtx(), "M_InventoryLine", "M_Inventory_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("Line").list();
        this.m_lines = list.toArray(new MInventoryLine[list.size()]);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MInventory[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",M_Warehouse_ID=").append(this.getM_Warehouse_ID()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            MDocType[] types = MDocType.getOfDocBaseType((Properties)this.getCtx(), (String)"MMI");
            if (types.length > 0) {
                this.setC_DocType_ID(types[0].getC_DocType_ID());
            } else {
                this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@NotFound@ @C_DocType_ID@"));
                return false;
            }
        }
        return true;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_InventoryLine SET Processed=? WHERE M_Inventory_ID=?";
        int noLine = DB.executeUpdateEx((String)"UPDATE M_InventoryLine SET Processed=? WHERE M_Inventory_ID=?", (Object[])new Object[]{processed, this.getM_Inventory_ID()}, (String)this.get_TrxName());
        this.m_lines = null;
        this.log.fine("Processed=" + processed + " - Lines=" + noLine);
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        String validation;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MMI", this.getAD_Org_ID());
        MInventoryLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        MClient clientV = new MClient(this.getCtx(), this.get_TrxName());
        MInventoryLine[] mInventoryLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MInventoryLine line = mInventoryLineArray[n2];
            if (!this.isReversal()) {
                Boolean useNI = false;
                try {
                    useNI = clientV.get_ValueAsBoolean("UseNegativeInventory");
                }
                catch (Exception e) {
                    useNI = false;
                }
                if (!useNI.booleanValue() && line.getQtyCount().signum() < 0) {
                    this.m_processMsg = "Not Negative  line:" + line.getLine();
                    return "IN";
                }
            }
            if ("N".equals(DB.getSQLValueString((String)this.get_TrxName(), (String)("select StockNegative from AD_Client where AD_Client_ID=" + this.getAD_Client_ID()), (Object[])new Object[0])) && line.getQtyInternalUse().signum() > 0) {
                this.log.config("locator " + line.getM_Locator_ID());
                if (line.getM_Product().getProductType().compareToIgnoreCase("S") != 0) {
                    BigDecimal qf = this.getQtyOnHand(line.getM_AttributeSetInstance_ID(), line.getM_Product_ID(), line.getM_Locator_ID());
                    this.log.config(" qf: " + qf.longValue() + " QtyI: " + line.getQtyInternalUse().longValue());
                    if (qf.longValue() < line.getQtyInternalUse().longValue()) {
                        this.m_processMsg = "No se puede consumir la linea (no stock)  line:" + line.getLine();
                        return "IN";
                    }
                }
            }
            ++n2;
        }
        boolean esConsumo = false;
        MInventoryLine[] mInventoryLineArray2 = lines;
        int n3 = lines.length;
        n = 0;
        while (n < n3) {
            MInventoryLine line = mInventoryLineArray2[n];
            if (line.getQtyInternalUse().signum() != 0) {
                esConsumo = true;
            }
            ++n;
        }
        if (esConsumo) {
            mInventoryLineArray2 = lines;
            n3 = lines.length;
            n = 0;
            while (n < n3) {
                MInventoryLine line = mInventoryLineArray2[n];
                if (line.getQtyInternalUse().signum() == 0) {
                    this.m_processMsg = "no puede tener cantidad 0 en un consumo  line:" + line.getLine();
                    return "IN";
                }
                ++n;
            }
        }
        if ((validation = this.budgetValidation()).length() > 2) {
            DB.executeUpdate((String)("update m_inventory set help='" + validation + "' where m_inventory_id=" + this.getM_Inventory_ID()), (String)this.get_TrxName());
            try {
                DB.commit((boolean)false, (String)this.get_TrxName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_processMsg = validation;
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        MInventoryLine[] lines;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String msg = this.completeBudget();
        if (msg.length() > 2) {
            this.m_processMsg = msg;
            return "IN";
        }
        MInventoryLine[] mInventoryLineArray = lines = this.getLines(false);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MInventoryLine line = mInventoryLineArray[n2];
            if (line.isActive()) {
                MProduct product = line.getProduct();
                BigDecimal qtyDiff = line.getQtyInternalUse().negate();
                if (this.getC_DocType().getDocBaseType().compareToIgnoreCase("RPI") == 0) {
                    qtyDiff = qtyDiff.negate();
                }
                if (qtyDiff.signum() == 0) {
                    qtyDiff = line.getQtyCount().subtract(line.getQtyBook());
                }
                if (!this.isReversal()) {
                    this.checkMaterialPolicy(line, qtyDiff);
                }
                if (product != null && product.isStocked()) {
                    this.log.fine("Material Transaction");
                    MTransaction mtrx = null;
                    if (line.getM_AttributeSetInstance_ID() == 0 || qtyDiff.compareTo(Env.ZERO) == 0) {
                        MInventoryLineMA[] mas = MInventoryLineMA.get((Properties)this.getCtx(), (int)line.getM_InventoryLine_ID(), (String)this.get_TrxName());
                        int j = 0;
                        while (j < mas.length) {
                            String err;
                            MInventoryLineMA ma = mas[j];
                            BigDecimal QtyMA = ma.getMovementQty();
                            BigDecimal QtyNew = QtyMA.add(qtyDiff);
                            this.log.fine("Diff=" + qtyDiff + " - Instance OnHand=" + QtyMA + "->" + QtyNew);
                            if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), 0, QtyMA.negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                                this.m_processMsg = "Cannot correct Inventory (MA)";
                                return "IN";
                            }
                            if (line.getQtyInternalUse().compareTo(Env.ZERO) == 0) {
                                MStorage storage = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                                storage.setDateLastInventory(this.getMovementDate());
                                if (!storage.save(this.get_TrxName())) {
                                    this.m_processMsg = "Storage not updated(2)";
                                    return "IN";
                                }
                            }
                            String m_MovementType = null;
                            m_MovementType = QtyMA.negate().compareTo(Env.ZERO) > 0 ? "I+" : "I-";
                            mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), m_MovementType, line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA.negate(), this.getMovementDate(), this.get_TrxName());
                            mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                            if (!mtrx.save()) {
                                this.m_processMsg = "Transaction not inserted(2)";
                                return "IN";
                            }
                            if (QtyMA.signum() != 0 && (err = this.createCostDetail(line, ma.getM_AttributeSetInstance_ID(), QtyMA.negate())) != null && err.length() > 0) {
                                this.m_processMsg = err;
                                return "IN";
                            }
                            qtyDiff = QtyNew;
                            ++j;
                        }
                    }
                    if (mtrx == null) {
                        String err;
                        if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), 0, qtyDiff, Env.ZERO, Env.ZERO, this.get_TrxName())) {
                            this.m_processMsg = "Cannot correct Inventory (MA)";
                            return "IN";
                        }
                        if (line.getQtyInternalUse().compareTo(Env.ZERO) == 0) {
                            MStorage storage = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
                            storage.setDateLastInventory(this.getMovementDate());
                            if (!storage.save(this.get_TrxName())) {
                                this.m_processMsg = "Storage not updated(2)";
                                return "IN";
                            }
                        }
                        String m_MovementType = null;
                        m_MovementType = qtyDiff.compareTo(Env.ZERO) > 0 ? "I+" : "I-";
                        mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), m_MovementType, line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), qtyDiff, this.getMovementDate(), this.get_TrxName());
                        mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                        if (!mtrx.save()) {
                            this.m_processMsg = "Transaction not inserted(2)";
                            return "IN";
                        }
                        if (qtyDiff.signum() != 0 && (err = this.createCostDetail(line, line.getM_AttributeSetInstance_ID(), qtyDiff)) != null && err.length() > 0) {
                            this.m_processMsg = err;
                            return "IN";
                        }
                    }
                }
            }
            ++n2;
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)((Object)this))) != null) {
            this.setDocumentNo(value);
        }
    }

    private void checkMaterialPolicy(MInventoryLine line, BigDecimal qtyDiff) {
        int no = MInventoryLineMA.deleteInventoryLineMA((int)line.getM_InventoryLine_ID(), (String)this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        boolean needSave = false;
        if (line.getM_AttributeSetInstance_ID() == 0) {
            MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
            if (qtyDiff.signum() > 0) {
                MStorage[] storages;
                MAttributeSetInstance asi = null;
                MStorage[] mStorageArray = storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), false, line.getM_Locator_ID(), this.get_TrxName());
                int n = storages.length;
                int n2 = 0;
                while (n2 < n) {
                    MStorage storage = mStorageArray[n2];
                    if (storage.getQtyOnHand().signum() < 0) {
                        asi = new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName());
                        break;
                    }
                    ++n2;
                }
                if (asi == null) {
                    asi = MAttributeSetInstance.create((Properties)this.getCtx(), (MProduct)product, (String)this.get_TrxName());
                }
                line.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                needSave = true;
            } else {
                String MMPolicy = product.getMMPolicy();
                MStorage[] storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
                BigDecimal qtyToDeliver = qtyDiff.negate();
                MStorage[] mStorageArray = storages;
                int n = storages.length;
                int n3 = 0;
                while (n3 < n) {
                    MInventoryLineMA ma;
                    MStorage storage = mStorageArray[n3];
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                        ma.saveEx();
                        qtyToDeliver = Env.ZERO;
                        this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                    } else {
                        ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                        ma.saveEx();
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                    }
                    if (qtyToDeliver.signum() == 0) break;
                    ++n3;
                }
                if (qtyToDeliver.signum() != 0) {
                    MAttributeSetInstance asi = MAttributeSetInstance.create((Properties)this.getCtx(), (MProduct)product, (String)this.get_TrxName());
                    int M_AttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                    MInventoryLineMA ma = new MInventoryLineMA(line, M_AttributeSetInstance_ID, qtyToDeliver);
                    ma.saveEx();
                    this.log.fine("##: " + ma);
                }
            }
            if (needSave) {
                line.saveEx();
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInventoryLine[] lines = this.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInventoryLine line = lines[i];
                BigDecimal oldCount = line.getQtyCount();
                BigDecimal oldInternal = line.getQtyInternalUse();
                if (oldCount.compareTo(line.getQtyBook()) != 0 || oldInternal.signum() != 0) {
                    line.setQtyInternalUse(Env.ZERO);
                    line.setQtyCount(line.getQtyBook());
                    line.addDescription("Void (" + oldCount + "/" + oldInternal + ")");
                    line.save(this.get_TrxName());
                }
                ++i;
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType(), this.getAD_Org_ID());
        MInventory reversal = new MInventory(this.getCtx(), 0, this.get_TrxName());
        MInventory.copyValues((PO)((Object)this), (PO)((Object)reversal), (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setIsApproved(false);
        reversal.setPosted(false);
        reversal.setProcessed(false);
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getM_Inventory_ID());
        reversal.saveEx();
        reversal.setReversal(true);
        MInventoryLine[] oLines = this.getLines(true);
        int i = 0;
        while (i < oLines.length) {
            MInventoryLine oLine = oLines[i];
            MInventoryLine rLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
            MInventory.copyValues((PO)((Object)oLine), (PO)((Object)rLine), (int)oLine.getAD_Client_ID(), (int)oLine.getAD_Org_ID());
            rLine.setM_Inventory_ID(reversal.getM_Inventory_ID());
            rLine.setParent(reversal);
            rLine.setReversalLine_ID(oLine.getM_InventoryLine_ID());
            rLine.setQtyBook(oLine.getQtyCount());
            rLine.setQtyCount(oLine.getQtyBook());
            rLine.setQtyInternalUse(oLine.getQtyInternalUse().negate());
            rLine.saveEx();
            if (rLine.getM_AttributeSetInstance_ID() == 0) {
                MInventoryLineMA[] mas = MInventoryLineMA.get((Properties)this.getCtx(), (int)oLines[i].getM_InventoryLine_ID(), (String)this.get_TrxName());
                int j = 0;
                while (j < mas.length) {
                    MInventoryLineMA ma = new MInventoryLineMA(rLine, mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate());
                    ma.saveEx();
                    ++j;
                }
            }
            ++i;
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return false;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx();
        this.m_processMsg = reversal.getDocumentNo();
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setReversal_ID(reversal.getM_Inventory_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    private boolean isReversal() {
        return this.m_reversal;
    }

    private String createCostDetail(MInventoryLine line, int M_AttributeSetInstance_ID, BigDecimal qty) {
        return "";
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String budgetValidation() {
        MClient client = MClient.get((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        Boolean useBudget = false;
        try {
            useBudget = client.get_ValueAsBoolean("UseBudget");
            this.log.config("useBudget :" + useBudget);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (useBudget.booleanValue()) {
            MRole myrole = new MRole(this.getCtx(), Env.getAD_Role_ID((Properties)this.getCtx()), this.get_TrxName());
            MUser currentUser = new MUser(this.getCtx(), Env.getAD_User_ID((Properties)this.getCtx()), this.get_TrxName());
            String commenthelp = new String();
            if (this.get_ValueAsBoolean("Signature")) {
                return "";
            }
            String sql = "select sum(il.qtyInternalUse),c.m_product_category_id,il.ad_org_id,il.m_product_id,c.name from M_InventoryLine il inner join M_Product p on (il.m_product_id=p.m_product_id) inner join M_Product_Category c on (p.m_product_category_id=c.m_product_category_id) where il.m_inventory_id=? and il.qtyinternaluse!=0 group by c.m_product_category_id,il.ad_org_id,il.m_product_id,c.name order by c.m_product_category_id";
            CPreparedStatement pstmt = null;
            boolean sobrePresupuesto = false;
            boolean sobreanual = false;
            int last_category = 0;
            BigDecimal acumCost = Env.ZERO;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getM_Inventory_ID());
                ResultSet rs = pstmt.executeQuery();
                while (true) {
                    if (!rs.next()) {
                        rs.close();
                        pstmt.close();
                        return "";
                    }
                    if (rs.getInt(1) == 0) continue;
                    long ActualBudget = this.getBudget(rs.getInt(2), this.getMovementDate(), rs.getInt(3), 0);
                    long YearBudget = this.getBudgetYear(rs.getInt(2), MPeriod.get(this.getCtx(), this.getMovementDate()).getC_Year_ID(), rs.getInt(3), 0);
                    BigDecimal costo = OFBProductCost.getProductCost(rs.getInt(4), rs.getInt(3), rs.getBigDecimal(1), this.get_TrxName(), this.getCtx());
                    if (costo.longValue() == 0L) {
                        this.set_CustomColumn("Help", String.valueOf(MProduct.get(this.getCtx(), rs.getInt(4)).getName()) + " - No Cost ");
                        return "IN";
                    }
                    this.log.config(String.valueOf(MProduct.get(this.getCtx(), rs.getInt(4)).getName()) + "-" + costo);
                    this.log.config("ActualBudget :" + ActualBudget);
                    this.log.config("YearBudget :" + YearBudget);
                    if (last_category != rs.getInt(2)) {
                        last_category = rs.getInt(2);
                        acumCost = costo;
                    } else {
                        acumCost = acumCost.add(costo);
                    }
                    this.log.config("acumCost :" + acumCost);
                    if (ActualBudget >= acumCost.longValue()) continue;
                    this.log.config("rs.getDouble(1): " + rs.getDouble(1));
                    this.log.config("ActualBudget: " + ActualBudget);
                    this.log.config("valor: " + acumCost);
                    commenthelp = String.valueOf(commenthelp) + " | Categoria: " + rs.getString(5) + " Sobrepasado: " + acumCost + " Presupuesto: " + ActualBudget;
                    sobrePresupuesto = true;
                    if (YearBudget < acumCost.longValue()) {
                        sobreanual = true;
                    }
                    if (!sobrePresupuesto && !sobreanual) {
                        commenthelp = "VERDE " + commenthelp;
                    }
                    if (sobrePresupuesto && !sobreanual) {
                        commenthelp = "AMARILLO " + commenthelp;
                    }
                    if (sobreanual) {
                        commenthelp = "ROJO " + commenthelp;
                    }
                    if (sobrePresupuesto && !myrole.get_ValueAsBoolean("RequisitionSupervisor") && !myrole.get_ValueAsBoolean("RequisitionAdmin")) {
                        this.setProcessed(true);
                        this.set_CustomColumn("Help", commenthelp);
                        this.set_ValueOfColumn("Help", commenthelp);
                        return commenthelp;
                    }
                    if (sobrePresupuesto && !sobreanual && myrole.get_ValueAsBoolean("RequisitionAdmin")) {
                        commenthelp = "";
                        continue;
                    }
                    if (sobreanual && !myrole.get_ValueAsBoolean("RequisitionAdmin")) {
                        this.setProcessed(true);
                        this.set_CustomColumn("Help", commenthelp);
                        this.set_ValueOfColumn("Help", commenthelp);
                        return commenthelp;
                    }
                    if ((sobreanual || sobrePresupuesto) && myrole.get_ValueAsBoolean("RequisitionAdmin") && ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue() == 0.0) {
                        commenthelp = "";
                        continue;
                    }
                    if (sobrePresupuesto && myrole.get_ValueAsBoolean("RequisitionSupervisor") && acumCost.doubleValue() > ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue()) {
                        this.setProcessed(true);
                        this.set_CustomColumn("Help", commenthelp);
                        this.set_ValueOfColumn("Help", commenthelp);
                        return commenthelp;
                    }
                    if ((sobreanual || sobrePresupuesto) && !myrole.get_ValueAsBoolean("RequisitionAdmin") && acumCost.doubleValue() > ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue() && ((BigDecimal)currentUser.get_Value("AmtApproval")).doubleValue() != 0.0) break;
                }
                this.setProcessed(true);
                this.set_CustomColumn("Help", commenthelp);
                this.set_ValueOfColumn("Help", commenthelp);
                return commenthelp;
            }
            catch (Exception e) {
                this.log.severe(e.getMessage());
            }
        }
        return "";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String completeBudget() {
        String string;
        ResultSet rs;
        CPreparedStatement pstmt;
        block8: {
            boolean useBudget = "Y".equals(DB.getSQLValueString((String)this.get_TrxName(), (String)("select UseBudget from AD_Client where AD_Client_ID=" + this.getAD_Client_ID()), (Object[])new Object[0]));
            if (!useBudget) {
                return "";
            }
            String sql = "select il.m_product_id,il.qtyInternalUse,il.m_attributesetinstance_id,c.m_product_category_id,il.ad_org_id from M_InventoryLine il inner join M_Product p on (il.m_product_id=p.m_product_id) inner join M_Product_Category c on (p.m_product_category_id=c.m_product_category_id) where il.m_inventory_id=? and il.qtyinternaluse!=0";
            pstmt = null;
            rs = null;
            MPeriod period = MPeriod.get(this.getCtx(), this.getMovementDate());
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, this.getM_Inventory_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal costo = OFBProductCost.getProductCost(rs.getInt(1), rs.getInt(5), rs.getBigDecimal(2), this.get_TrxName(), this.getCtx());
                    this.log.config("costo :" + costo);
                    if (costo.longValue() == 0L) {
                        string = String.valueOf(MProduct.get(this.getCtx(), rs.getInt(1)).getName()) + " -Cost 0";
                        break block8;
                    }
                    DB.executeUpdate((String)("Update m_product_category_Budget set BudgetUsed=BudgetUsed+" + costo + " where m_product_category_id=" + rs.getInt(4) + " And AD_Org_ID=" + this.getAD_Org_ID() + " and c_period_ID=" + period.getC_Period_ID()), (String)this.get_TrxName());
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            {
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close(rs, (Statement)pstmt);
                    return "";
                    break;
                }
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            return "";
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        return string;
    }

    private BigDecimal getQtyOnHand(int M_AttributeSetInstance_ID, int M_Product_ID, int M_Locator_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block10: {
            BigDecimal bigDecimal;
            this.log.config("M_Locator_ID: " + M_Locator_ID + "M_Product_ID: " + M_Product_ID + " M_AttributeSetInstance_ID: " + M_AttributeSetInstance_ID);
            BigDecimal bd = null;
            String sql = "SELECT sum(QtyOnHand) FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID=?";
            if (M_AttributeSetInstance_ID == 0) {
                sql = "SELECT SUM(QtyOnHand) FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=?";
            }
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, M_Product_ID);
                pstmt.setInt(2, M_Locator_ID);
                this.log.config("sql " + sql);
                if (M_AttributeSetInstance_ID != 0) {
                    pstmt.setInt(3, M_AttributeSetInstance_ID);
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    bd = rs.getBigDecimal(1);
                    this.log.config("QtyOnHand: " + bd);
                    if (bd != null) {
                        BigDecimal bigDecimal2 = bd;
                        DB.close((ResultSet)rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        return bigDecimal2;
                    }
                    break block10;
                }
                bigDecimal = new BigDecimal(0);
                DB.close((ResultSet)rs, (Statement)pstmt);
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                BigDecimal bigDecimal3 = new BigDecimal(0);
                return bigDecimal3;
            }
            finally {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
            }
            rs = null;
            pstmt = null;
            return bigDecimal;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return new BigDecimal(0);
    }

    public long getBudget(int category_ID, Timestamp dateDoc, int Org_ID, int Product_ID) {
        ResultSet rs;
        MPeriod period;
        CPreparedStatement pstmt;
        String sql;
        long actualBudget = 0L;
        boolean found = false;
        if (Product_ID > 0) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and ?  and p.C_Year_ID=? and b.m_product_id=? and b.ad_org_id=?";
            pstmt = null;
            period = MPeriod.get(this.getCtx(), dateDoc);
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, period.getPeriodNo());
                pstmt.setInt(2, period.getC_Year_ID());
                pstmt.setInt(3, Product_ID);
                pstmt.setInt(4, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                    found = true;
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        if (Product_ID == 0 || !found) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and ?  and p.C_Year_ID=? and b.m_product_category_id=? and b.ad_org_id=?";
            pstmt = null;
            period = MPeriod.get(this.getCtx(), dateDoc);
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, period.getPeriodNo());
                pstmt.setInt(2, period.getC_Year_ID());
                pstmt.setInt(3, category_ID);
                pstmt.setInt(4, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        return actualBudget;
    }

    public long getBudgetYear(int category_ID, int Year_ID, int Org_ID, int Product_ID) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        long actualBudget = 0L;
        boolean found = false;
        if (Product_ID > 0) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and 12  and p.C_Year_ID=? and b.m_product_id=? and b.ad_org_id=?";
            pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, Year_ID);
                pstmt.setInt(2, Product_ID);
                pstmt.setInt(3, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                    found = true;
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        if (Product_ID == 0 || !found) {
            sql = "select SUM(b.Budget-b.BudgetUsed) from m_product_category_Budget b inner join C_Period p on (b.C_Period_ID=p.C_Period_ID) where p.periodno between 1 and 12  and p.C_Year_ID=? and b.m_product_category_id=? and b.ad_org_id=?";
            pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                pstmt.setInt(1, Year_ID);
                pstmt.setInt(2, category_ID);
                pstmt.setInt(3, Org_ID);
                rs = pstmt.executeQuery();
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    actualBudget = rs.getLong(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getBudget", (Throwable)e);
            }
        }
        return actualBudget;
    }
}

