/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_BankStatement;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBankStatement
extends X_C_BankStatement
implements DocAction {
    private static final long serialVersionUID = -859925588789443186L;
    private MBankStatementLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MBankStatement(Properties ctx, int C_BankStatement_ID, String trxName) {
        super(ctx, C_BankStatement_ID, trxName);
        if (C_BankStatement_ID == 0) {
            this.setStatementDate(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setBeginningBalance(Env.ZERO);
            this.setStatementDifference(Env.ZERO);
            this.setEndingBalance(Env.ZERO);
            this.setIsApproved(false);
            this.setIsManual(true);
            this.setPosted(false);
            super.setProcessed(false);
        }
    }

    public MBankStatement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatement(MBankAccount account, boolean isManual) {
        this(account.getCtx(), 0, account.get_TrxName());
        this.setClientOrg((PO)((Object)account));
        this.setC_BankAccount_ID(account.getC_BankAccount_ID());
        this.setStatementDate(new Timestamp(System.currentTimeMillis()));
        this.setBeginningBalance(account.getCurrentBalance());
        this.setName(this.getStatementDate().toString());
        this.setIsManual(isManual);
    }

    public MBankStatement(MBankAccount account) {
        this(account, false);
    }

    public MBankStatementLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MBankStatement.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "C_BankStatement_ID=?";
        List list = new Query(this.getCtx(), "C_BankStatementLine", "C_BankStatement_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getC_BankStatement_ID()}).setOrderBy("Line").list();
        MBankStatementLine[] retValue = new MBankStatementLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE C_BankStatementLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        int noLine = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.m_lines = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
    }

    public MBankAccount getBankAccount() {
        return MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
    }

    @Override
    public String getDocumentNo() {
        return this.getName();
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(this.getBankAccount().getName()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        boolean existe = false;
        String sql = "select * from C_BankStatement where docstatus IN ('DR')  and C_BANKACCOUNT_ID=" + this.getC_BankAccount_ID() + " and C_BankStatement_ID!=" + this.getC_BankStatement_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                existe = true;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (existe && !this.getDescription().equalsIgnoreCase("Reverso Protesto")) {
            this.log.saveError("Error", "Ya existe Un deposito en Borrador para esta cuenta y esta fecha, por favor completela antes de crear una nueva");
            this.m_processMsg = "Ya existe Un deposito en Borrador para esta cuenta y esta fecha, por favor completela antes de crear una nueva";
            return false;
        }
        if (!this.isProcessed() && this.getBeginningBalance().compareTo(Env.ZERO) == 0) {
            MBankAccount ba = this.getBankAccount();
            ba.load(this.get_TrxName());
            this.setBeginningBalance(ba.getCurrentBalance());
        }
        if (this.getDocStatus().compareToIgnoreCase("CO") != 0 && this.getDocStatus().compareToIgnoreCase("VO") != 0) {
            this.setBeginningBalance(DB.getSQLValueBD(null, (String)"select CURRENTBALANCE from C_BankAccount where C_BankAccount_ID=?", (int)this.getC_BankAccount_ID()));
            this.setEndingBalance(this.getBeginningBalance().add(this.getStatementDifference()));
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        Timestamp minDate;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getStatementDate(), "CMB", this.getAD_Org_ID());
        MBankStatementLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal total = Env.ZERO;
        Timestamp maxDate = minDate = this.getStatementDate();
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            total = total.add(line.getStmtAmt());
            if (line.getDateAcct().before(minDate)) {
                minDate = line.getDateAcct();
            }
            if (line.getDateAcct().after(maxDate)) {
                maxDate = line.getDateAcct();
            }
            ++i;
        }
        this.setStatementDifference(total);
        this.setEndingBalance(this.getBeginningBalance().add(total));
        MPeriod.testPeriodOpen(this.getCtx(), minDate, "CMB", 0);
        MPeriod.testPeriodOpen(this.getCtx(), maxDate, "CMB", 0);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        MBankStatementLine[] lines = this.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
                payment.setIsReconciled(true);
                payment.save(this.get_TrxName());
            }
            ++i;
        }
        MBankAccount ba = this.getBankAccount();
        ba.load(this.get_TrxName());
        ba.setCurrentBalance(ba.getCurrentBalance().add(this.getStatementDifference()));
        ba.save(this.get_TrxName());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (!("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()))) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getStatementDate(), "CMB", this.getAD_Org_ID());
            MFactAcct.deleteEx((int)Table_ID, (int)this.getC_BankStatement_ID(), (String)this.get_TrxName());
        }
        MBankAccount ba = this.getBankAccount();
        ba.load(this.get_TrxName());
        ba.setCurrentBalance(ba.getCurrentBalance().subtract(this.getStatementDifference()));
        ba.saveEx();
        MBankStatementLine[] lines = this.getLines(true);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            if (line.getStmtAmt().compareTo(Env.ZERO) != 0) {
                String description = String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Voided")) + " (" + Msg.translate((Properties)this.getCtx(), (String)"StmtAmt") + "=" + line.getStmtAmt();
                if (line.getTrxAmt().compareTo(Env.ZERO) != 0) {
                    description = String.valueOf(description) + ", " + Msg.translate((Properties)this.getCtx(), (String)"TrxAmt") + "=" + line.getTrxAmt();
                }
                if (line.getChargeAmt().compareTo(Env.ZERO) != 0) {
                    description = String.valueOf(description) + ", " + Msg.translate((Properties)this.getCtx(), (String)"ChargeAmt") + "=" + line.getChargeAmt();
                }
                if (line.getInterestAmt().compareTo(Env.ZERO) != 0) {
                    description = String.valueOf(description) + ", " + Msg.translate((Properties)this.getCtx(), (String)"InterestAmt") + "=" + line.getInterestAmt();
                }
                description = String.valueOf(description) + ")";
                line.addDescription(description);
                line.setStmtAmt(Env.ZERO);
                line.setTrxAmt(Env.ZERO);
                line.setChargeAmt(Env.ZERO);
                line.setInterestAmt(Env.ZERO);
                if (line.getC_Payment_ID() != 0) {
                    MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
                    payment.setIsReconciled(false);
                    payment.saveEx();
                    line.setC_Payment_ID(0);
                }
                line.saveEx();
            }
            ++i;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.setStatementDifference(Env.ZERO);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)((Object)this), 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"StatementDifference")).append("=").append(this.getStatementDifference()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getStatementDifference();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

