/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.CreateFromPaymentRequest;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.ofb.model.OFBForward;

public class VCreateFromPaymentRequestUI
extends CreateFromPaymentRequest
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = 1L;
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int Org_ID;
    private CLabel documentNoLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo"));
    protected CTextField documentNoField = new CTextField(10);
    protected CLabel BPartner_idLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"BPartner"));
    protected VLookup bPartnerLookup;
    protected CLabel Org_idLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
    protected VLookup OrgLookup;
    private CLabel dateFromLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"DateTrx"));
    protected VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    protected VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
    protected CLabel Null_NUllLabel = new CLabel(Msg.translate((Properties)Env.getCtx(), (String)"     "));
    private boolean m_actionActive = false;

    public VCreateFromPaymentRequestUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow((Window)Env.getWindow((int)this.p_WindowNo), (Window)((Object)this.dialog));
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.dialog.setTitle("Solicitud desde");
        CButton refreshButton = ConfirmPanel.createRefreshButton((boolean)false);
        refreshButton.setMargin(new Insets(1, 10, 0, 10));
        refreshButton.setDefaultCapable(true);
        refreshButton.addActionListener((ActionListener)this);
        this.dialog.getConfirmPanel().addButton((JButton)refreshButton);
        this.dialog.getRootPane().setDefaultButton((JButton)refreshButton);
        this.bPartnerLookup = new VLookup("C_BPartner_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)3499, (int)30));
        this.BPartner_idLabel.setLabelFor((Component)this.bPartnerLookup);
        Timestamp date = Env.getContextAsDate((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"DateTrx");
        this.dateFromField.setValue((Object)date);
        this.dateToField.setValue((Object)date);
        MRole rol = new MRole(Env.getCtx(), Env.getAD_Role_ID((Properties)Env.getCtx()), null);
        boolean modOrg = rol.get_ValueAsBoolean("ModifyOrgPR");
        if (modOrg) {
            this.OrgLookup = new VLookup("AD_Org_ID", false, true, false, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_PaymentRequest", (String)"AD_Org_ID"), (int)30));
            this.Org_idLabel.setLabelFor((Component)this.OrgLookup);
            this.Org_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"AD_Org_ID");
            this.OrgLookup.setValue((Object)this.Org_ID);
        } else {
            this.OrgLookup = new VLookup("AD_Org_ID", false, false, true, (Lookup)MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)MColumn.getColumn_ID((String)"C_PaymentRequest", (String)"AD_Org_ID"), (int)30));
            this.Org_idLabel.setLabelFor((Component)this.OrgLookup);
        }
        this.loadLines();
        return true;
    }

    private void jbInit() throws Exception {
        this.documentNoLabel.setLabelFor((Component)this.documentNoField);
        this.dateFromLabel.setLabelFor((Component)this.dateFromField);
        this.dateFromField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateToLabel.setLabelFor((Component)this.dateToField);
        this.dateToField.setToolTipText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout((LayoutManager)new BorderLayout());
        CPanel parameterBankPanel = new CPanel();
        parameterBankPanel.setLayout((LayoutManager)new GridBagLayout());
        parameterPanel.add((Component)parameterBankPanel, (Object)"Center");
        parameterBankPanel.add((Component)this.BPartner_idLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 200, 5, 5), 0, 0));
        if (this.bPartnerLookup != null) {
            parameterBankPanel.add((Component)this.bPartnerLookup, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.Org_idLabel, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 100, 5, 5), 0, 0));
        if (this.OrgLookup != null) {
            parameterBankPanel.add((Component)this.OrgLookup, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 200), 0, 0));
        }
        parameterBankPanel.add((Component)this.dateFromLabel, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 200, 5, 5), 0, 0));
        if (this.dateFromField != null) {
            parameterBankPanel.add((Component)this.dateFromField, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        parameterBankPanel.add((Component)this.dateToLabel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 100, 5, 5), 0, 0));
        if (this.dateToField != null) {
            parameterBankPanel.add((Component)this.dateToField, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 200), 0, 0));
        }
        parameterBankPanel.add((Component)this.documentNoLabel, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 200, 5, 5), 0, 0));
        parameterBankPanel.add((Component)this.documentNoField, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (e.getActionCommand().equals("Refresh")) {
            Cursor.getPredefinedCursor(3);
            this.loadLines();
            this.dialog.tableChanged(null);
            Cursor.getPredefinedCursor(0);
        }
        this.m_actionActive = false;
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
    }

    private void loadLines() {
        Timestamp to;
        Timestamp from;
        Vector data = new Vector();
        String type = Env.getContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"RequestType");
        type = this.getGridTab().get_ValueAsString("RequestType");
        type = Character.toString(type.charAt(0));
        StringBuffer sql = new StringBuffer("");
        if (type.equals("I")) {
            if (DB.isPostgreSQL()) {
                sql.append("select i.c_invoice_id,i.documentno,i.duedate,i.c_bpartner_id,bp.name, abs(currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,228,i.dateacct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP) as amt, i.description,i.C_InvoicePaySchedule_ID, coalesce(pter.name, ' ') as ptername  from c_invoice_v i inner join c_bpartner bp on (i.c_bpartner_id=bp.c_bpartner_id)  LEFT Join C_PaymentTerm pter ON (i.C_PaymentTerm_ID=pter.C_PaymentTerm_ID)  where i.issotrx='N' and i.docstatus in ('CO','CL') and ispaid = 'N' and docbaseType NOT IN ('APC','ARC')  and i.ad_client_id=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
            } else {
                sql.append("select i.c_invoice_id,i.documentno,i.duedate,i.c_bpartner_id,bp.name, abs(currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,228,i.dateacct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP) as amt, i.description,i.C_InvoicePaySchedule_ID, nvl(pter.name, ' ') as ptername  from c_invoice_v i inner join c_bpartner bp on (i.c_bpartner_id=bp.c_bpartner_id)  LEFT Join C_PaymentTerm pter ON (i.C_PaymentTerm_ID=pter.C_PaymentTerm_ID)  where i.issotrx='N' and i.docstatus in ('CO','CL') and ispaid = 'N' and docbaseType NOT IN ('APC','ARC')  and i.ad_client_id=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
            }
            if (OFBForward.usePaymentOncePR()) {
                sql.append(" AND i.C_Invoice_ID NOT IN(SELECT prl2.C_Invoice_ID  FROM C_PaymentRequestLine prl2 INNER JOIN C_PaymentRequest pr2 ON (prl2.C_PaymentRequest_ID = pr2.C_PaymentRequest_ID) WHERE DocStatus NOT IN ('VO'))");
            }
            if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
                sql.append(" And i.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
            }
            if (this.OrgLookup.getValue() != null && (Integer)this.OrgLookup.getValue() > 0) {
                sql.append(" And i.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(i.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(i.duedate) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(i.duedate) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(i.duedate) BETWEEN ? AND ?");
                }
            }
            if (OFBForward.PayRequestLineValidInvoice()) {
                sql.append(" And ( (i.C_InvoicePaySchedule_ID is null AND i.c_invoice_id Not IN (select rl.c_invoice_id from c_paymentrequestline rl inner join c_paymentrequest r on (rl.c_paymentrequest_id=r.c_paymentrequest_id) where r.docstatus IN ('DR','CL','WC','CO')and c_invoice_id is not null)) OR (i.C_InvoicePaySchedule_ID is not null AND i.C_InvoicePaySchedule_ID Not IN (select rl.C_InvoicePaySchedule_ID from c_paymentrequestline rl inner join c_paymentrequest r on (rl.c_paymentrequest_id=r.c_paymentrequest_id) where r.docstatus IN ('DR','CL','WC','CO')and C_InvoicePaySchedule_ID is not null)) )");
            } else {
                sql.append(" And (abs(currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,228,i.dateacct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP)) > 0");
            }
        } else if (type.equals("J")) {
            if (OFBForward.PayRequestUseJLineDate()) {
                sql.append("select gl.gl_journalline_id, j.documentno,gl.datetrx,gl.c_bpartner_id,bp.name,gl.amtacctdr,gl.amtacctcr,j.description  from gl_journal j inner join gl_journalline gl on (j.gl_journal_id=gl.gl_journal_id) inner join c_bpartner bp on (gl.c_bpartner_id=bp.c_bpartner_id)  where j.docstatus in ('CO','CL')");
            } else {
                sql.append("select gl.gl_journalline_id, j.documentno,j.dateacct,gl.c_bpartner_id,bp.name,gl.amtacctdr,gl.amtacctcr,j.description  from gl_journal j inner join gl_journalline gl on (j.gl_journal_id=gl.gl_journal_id) inner join c_bpartner bp on (gl.c_bpartner_id=bp.c_bpartner_id)  where j.docstatus in ('CO','CL')");
            }
            if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
                sql.append(" And gl.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
            }
            if (this.OrgLookup.getValue() != null) {
                sql.append(" And j.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(j.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (OFBForward.PayRequestFilterDateTrxLine()) {
                    if (from == null && to != null) {
                        sql.append(" AND TRUNC(gl.DateTrx) <= ?");
                    } else if (from != null && to == null) {
                        sql.append(" AND TRUNC(gl.DateTrx) >= ?");
                    } else if (from != null && to != null) {
                        sql.append(" AND TRUNC(gl.DateTrx) BETWEEN ? AND ?");
                    }
                } else if (from == null && to != null) {
                    sql.append(" AND TRUNC(j.DateAcct) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(j.DateAcct) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(j.DateAcct) BETWEEN ? AND ?");
                }
            }
            sql.append(" And gl.gl_journalline_id Not IN (select rl.gl_journalline_id from c_paymentrequestline rl inner join c_paymentrequest r on (rl.c_paymentrequest_id=r.c_paymentrequest_id) where r.docstatus IN ('DR','CL','WC','CO')and gl_journalline_id is not null ) ");
            if (OFBForward.PayRequestNotInCashLine()) {
                sql.append(" AND gl.gl_journalline_id Not IN (SELECT cl.GL_JournalLine_id FROM C_CashLine cl  inner join C_Cash cc on (cl.C_Cash_ID = cc.C_Cash_ID) where cc.docstatus IN ('DR','CL','WC','CO')and gl_journalline_id is not null) ");
            }
            if (OFBForward.PayRequestNotClosedJournal()) {
                sql.append(" AND j.DocStatus NOT IN ('CL','VO') ");
            }
            if (OFBForward.PayRequestSelectedAccount()) {
                sql.append(" AND gl.gl_journalline_id Not IN (SELECT GL_JournalLine_ID  FROM c_validcombination vc  INNER JOIN C_ElementValue ev ON (vc.Account_ID = ev.C_ElementValue_ID)  INNER JOIN GL_JournalLine jl ON (vc.c_validcombination_ID = jl.c_validcombination_ID)  where ev.NoPaymentRequest = 'Y') ");
            }
        } else if (type.equals("P")) {
            sql.append("select gl.gl_journalline_id, j.documentno,j.dateacct,gl.c_bpartner_id, bp.name,gl.amtacctdr,gl.amtacctcr,j.description, org.name,cpo.name,cvc.combination from gl_journal j inner join gl_journalline gl on (j.gl_journal_id=gl.gl_journal_id) inner join ad_org org on (j.ad_org_id = org.ad_org_id) left join c_bpartner bp on (gl.c_bpartner_id=bp.c_bpartner_id) left join c_projectOFB cpo on (j.c_projectOFB_id = cpo.c_projectOFB_id) left join C_ValidCombination cvc on (cvc.C_ValidCombination_ID = gl.C_ValidCombination_ID) where j.docstatus in ('CO','CL') and gl.amtacctcr > 0 and j.ad_client_id=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
                sql.append(" And gl.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
            }
            if (this.OrgLookup.getValue() != null) {
                sql.append(" And j.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(j.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(j.DateAcct) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(j.DateAcct) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(j.DateAcct) BETWEEN ? AND ?");
                }
            }
            sql.append(" And gl.gl_journalline_id Not IN (select rl.gl_journalline_id from c_paymentrequestline rl inner join c_paymentrequest r on (rl.c_paymentrequest_id=r.c_paymentrequest_id) where r.docstatus IN ('DR','CL','WC','CO')and gl_journalline_id is not null ) ");
        } else if (type.equals("R")) {
            sql.append("select dm.DM_Document_ID, dm.documentno,dm.datetrx, dm.c_bpartner_id, bp.name, dm.amt-dm.allocatedamt, dm.description,0,dm.AD_Org_ID, org.name from  DM_Document dm  left outer join c_bpartner bp on (dm.c_bpartner_id=bp.c_bpartner_id)  left outer join AD_Org org on (dm.AD_Org_ID = org.AD_Org_ID)  where dm.docstatus='CO' and (dm.amt-dm.allocatedamt)>0");
            if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
                sql.append(" And dm.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
            }
            if (this.OrgLookup.getValue() != null) {
                sql.append(" And dm.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(dm.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(dm.datetrx) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(dm.datetrx) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(dm.datetrx) BETWEEN ? AND ?");
                }
            }
        } else {
            sql.append(" select i.c_invoice_id,i.documentno,i.dateinvoiced,i.c_bpartner_id,bp.name,invoiceOpen(i.c_invoice_id,null), i.description,0 from c_invoice i inner join c_bpartner bp on (i.c_bpartner_id=bp.c_bpartner_id)  where i.issotrx='N' and i.docstatus in ('CO','CL')");
            if (this.bPartnerLookup.getValue() != null && (Integer)this.bPartnerLookup.getValue() > 0) {
                sql.append(" And i.c_bpartner_id=" + (Integer)this.bPartnerLookup.getValue());
            }
            if (this.OrgLookup.getValue() != null && (Integer)this.OrgLookup.getValue() > 0) {
                sql.append(" And i.AD_Org_ID=" + (Integer)this.OrgLookup.getValue());
            }
            if (this.documentNoField.getText().length() > 0) {
                sql.append(" AND UPPER(i.DocumentNo) LIKE '%" + this.documentNoField.getText() + "%'");
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(i.DateInvoiced) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(i.DateInvoiced) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(i.DateInvoiced) BETWEEN ? AND ?");
                }
            }
        }
        this.log.config("**" + sql);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            int index = 1;
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                Timestamp from2 = (Timestamp)this.dateFromField.getValue();
                Timestamp to2 = (Timestamp)this.dateToField.getValue();
                this.log.fine("Date From=" + from2 + ", To=" + to2);
                if (from2 == null && to2 != null) {
                    pstmt.setTimestamp(index++, to2);
                } else if (from2 != null && to2 == null) {
                    pstmt.setTimestamp(index++, from2);
                } else if (from2 != null && to2 != null) {
                    pstmt.setTimestamp(index++, from2);
                    pstmt.setTimestamp(index++, to2);
                }
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if ((type.equals("I") || type.equals("R")) && rs.getBigDecimal(6).signum() == 0) continue;
                Vector<Object> line = new Vector<Object>(10);
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(4), rs.getString(5));
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(3));
                if (rs.getInt(4) < 1 || rs.getString(5) == null) {
                    line.add(" ");
                } else {
                    line.add(pp2);
                }
                line.add(pp);
                if (type.equals("I")) {
                    line.add(rs.getBigDecimal(6));
                    line.add(rs.getString(7));
                    line.add(" ");
                    line.add(" ");
                    line.add(" ");
                    if (rs.getString(8) == null || rs.getInt(8) == 0) {
                        line.add(0);
                    } else {
                        line.add(rs.getInt(8));
                    }
                    if (type.equals("I")) {
                        line.add(rs.getString(9));
                    }
                }
                if (type.equals("R")) {
                    KeyNamePair pp3 = new KeyNamePair(rs.getInt(9), rs.getString(10));
                    line.add(rs.getBigDecimal(6));
                    line.add(rs.getString(7));
                    line.add(pp3);
                    line.add(" ");
                    line.add(" ");
                    if (rs.getString(8) == null || rs.getInt(8) == 0) {
                        line.add(0);
                    } else {
                        line.add(rs.getInt(8));
                    }
                }
                if (type.equals("J")) {
                    line.add(rs.getBigDecimal(6).signum() == 0 ? rs.getBigDecimal(7) : rs.getBigDecimal(6));
                    line.add(rs.getString(8));
                    line.add(" ");
                    line.add(" ");
                    line.add(" ");
                    line.add(0);
                }
                if (type.equals("P")) {
                    line.add(rs.getBigDecimal(7));
                    line.add(rs.getString(8));
                    line.add(rs.getString(9));
                    line.add(rs.getString(10));
                    line.add(rs.getString(11));
                    line.add(0);
                }
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        this.loadTableOIS(data);
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        this.dialog.tableChanged(null);
    }
}

